!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!	Module to   define D_SPMAT, structure   !!
!!      for sparse matrix.                      !!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

MODULE TYPESP
  ! D_SPMAT Contains Sparse Matrix
  TYPE D_SPMAT
    ! Rows & columns 
    INTEGER     :: M, K
    ! Identify the representation method. Es: CSR, JAD, ...
    CHARACTER(LEN=5) :: FIDA
    ! Describe some chacteristics of sparse matrix
    CHARACTER(LEN=11) :: DESCRA
    ! Contains some additional informations on sparse matrix
    INTEGER     :: INFOA(10)
    ! Contains sparse matrix coefficients
    REAL(KIND(1.D0)), POINTER :: ASPK(:)
    ! Contains indeces that describes sparse matrix structure
    INTEGER, POINTER :: IA1(:), IA2(:)
    ! Permutations matrix
    INTEGER, POINTER :: PL(:), PR(:)
  END TYPE D_SPMAT
  TYPE Z_SPMAT
    ! Rows & columns 
    INTEGER     :: M, K
    ! Identify the representation method. Es: CSR, JAD, ...
    CHARACTER(LEN=5) :: FIDA
    ! Describe some chacteristics of sparse matrix
    CHARACTER(LEN=11) :: DESCRA
    ! Contains some additional informations on sparse matrix
    INTEGER     :: INFOA(10)
    ! Contains sparse matrix coefficients
    COMPLEX(KIND(1.D0)), POINTER :: ASPK(:)
    ! Contains indeces that describes sparse matrix structure
    INTEGER, POINTER :: IA1(:), IA2(:)
    ! Permutations matrix
    INTEGER, POINTER :: PL(:), PR(:)
  END TYPE Z_SPMAT
  
  interface nullify_sp
    module procedure nullify_dsp, nullify_zsp
  end interface

contains 
  subroutine nullify_dsp(mat)
    type(d_spmat), intent(inout) :: mat
    
    nullify(mat%aspk,mat%ia1,mat%ia2,mat%pl,mat%pr)
  end subroutine nullify_dsp

  subroutine nullify_zsp(mat)    
    type(z_spmat), intent(inout) :: mat
    
    nullify(mat%aspk,mat%ia1,mat%ia2,mat%pl,mat%pr)
  end subroutine nullify_zsp

END MODULE TYPESP

