!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!	Module to   define DECOMP_DATA,         !!
!!      structure for coomunications.           !!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

MODULE TYPEDESC
  INTEGER, PARAMETER :: NORMAL=1, SQUARE_ROOT=2
  INTEGER, PARAMETER :: UPD_GLB=998, UPD_LOC=997

  ! Next parameters are used to identify the data stored in
  ! MATRIX_DATA
  INTEGER, PARAMETER :: DEC_TYPE_=1, M_=2, N_=3, N_ROW_=4, N_COL_=5,&
       & CTXT_=6, LOC_TO_GLOB_=7,OVR_CNT_=8
  INTEGER, PARAMETER :: SP_MAT_ASB=3099, SP_MAT_BLD=SP_MAT_ASB+1,&
       & SP_MAT_UPD=SP_MAT_BLD+1, SP_MAT_UPD_ASB=SP_MAT_UPD+1

  ! Enable an ugly workaround for a compiler bug. Use with VAST F90 V3.4N5. 
  LOGICAL, PARAMETER :: F90_FUNC_BUG=.FALSE.

  ! DECOMP_DATA_TYPE Contains data for communications.
  TYPE DECOMP_DATA_TYPE
     ! Contain decomposition informations
     INTEGER, POINTER :: MATRIX_DATA(:)
     ! Contain index of halo elements to send/receive
     INTEGER, POINTER :: HALO_INDEX(:)
     ! Contain indices of boundary  elements 
     INTEGER, POINTER :: BND_ELEM(:)
     ! Contain index of overlap elements to send/receive
     INTEGER, POINTER :: OVRLAP_ELEM(:)
     ! Contain for each local overlap element, the number of times
     ! that is duplicated
     INTEGER, POINTER :: OVRLAP_INDEX(:)
     ! Contain for each local element the corresponding global index
     INTEGER, POINTER :: LOC_TO_GLOB(:)
     ! Contain for each global element the corresponding local index,
     ! if exist.
     INTEGER, POINTER :: GLOB_TO_LOC (:)
     ! Local renumbering induced by sparse matrix storage. 
     INTEGER, POINTER :: LPRM(:)
     ! Index space in case it is not just the contiguous range 1:N
     integer, pointer :: IDX_SPACE(:)
  END TYPE DECOMP_DATA_TYPE
  
contains 

  subroutine nullify_desc(desc)
    type(decomp_data_type), intent(inout) :: desc
    
    nullify(desc%matrix_data,desc%loc_to_glob,desc%glob_to_loc,&
         &desc%halo_index,desc%bnd_elem,desc%ovrlap_elem,&
         &desc%ovrlap_index, desc%lprm, desc%idx_space)

  end subroutine nullify_desc

  logical function is_ok_dec(dectype)
    integer dectype
    
    is_ok_dec = ((dectype == SP_MAT_ASB).or.(dectype == SP_MAT_BLD).or.&
         &(dectype == SP_MAT_UPD).or.(dectype== SP_MAT_UPD_ASB))
    
  end function is_ok_dec

  logical function is_bld_dec(dectype)
    integer dectype

    is_bld_dec = (dectype == SP_MAT_BLD)
  end function is_bld_dec

  logical function is_upd_dec(dectype)          
    integer dectype

    is_upd_dec = (dectype == SP_MAT_UPD)

  end function is_upd_dec

  logical function is_asb_upd_dec(dectype)
    integer dectype

    is_asb_upd_dec = (dectype == SP_MAT_UPD_ASB)

  end function is_asb_upd_dec

  logical function is_asb_nil_dec(dectype)
    integer dectype

    is_asb_nil_dec = (dectype == SP_MAT_ASB)

  end function is_asb_nil_dec

  logical function is_asb_dec(dectype)
    integer dectype

    is_asb_dec = is_asb_nil_dec(dectype).or.&
         &is_asb_upd_dec(dectype)

  end function is_asb_dec

END MODULE TYPEDESC
