Module F90TOOLS
  INTERFACE PSGLOB_TO_LOC
     SUBROUTINE PSGLOB_TO_LOC2(X,Y,DESC_A,ACT)
       USE TYPEDESC
       TYPE(DECOMP_DATA_TYPE), INTENT(IN) ::  DESC_A
       CHARACTER,INTENT(IN),OPTIONAL      ::  ACT
       INTEGER,INTENT(IN)                 ::  X(:)  
       INTEGER,INTENT(OUT)                ::  Y(:)  
     END SUBROUTINE PSGLOB_TO_LOC2
     SUBROUTINE PSGLOB_TO_LOC(X,DESC_A,ACT)
       USE TYPEDESC
       TYPE(DECOMP_DATA_TYPE), INTENT(IN) ::  DESC_A
       CHARACTER,INTENT(IN),OPTIONAL      ::  ACT
       INTEGER,INTENT(INOUT)                 ::  X(:)  
     END SUBROUTINE PSGLOB_TO_LOC
  END INTERFACE

  INTERFACE PSLOC_TO_GLOB
     SUBROUTINE PSLOC_TO_GLOB2(X,Y,DESC_A,ACT)
       USE TYPEDESC
       TYPE(DECOMP_DATA_TYPE), INTENT(IN) ::  DESC_A
       CHARACTER,INTENT(IN),OPTIONAL      ::  ACT
       INTEGER,INTENT(IN)                 ::  X(:)  
       INTEGER,INTENT(OUT)                ::  Y(:)  
     END SUBROUTINE PSLOC_TO_GLOB2
     SUBROUTINE PSLOC_TO_GLOB(X,DESC_A,ACT)
       USE TYPEDESC
       TYPE(DECOMP_DATA_TYPE), INTENT(IN) ::  DESC_A
       CHARACTER,INTENT(IN),OPTIONAL      ::  ACT
       INTEGER,INTENT(INOUT)                 ::  X(:)  
     END SUBROUTINE PSLOC_TO_GLOB
  END INTERFACE

  INTERFACE F90_PSVERIFY
     SUBROUTINE F90_PSDVERIFY(D,A,DECOMP_DATA,CHECK_DESCR,&
          & CONVERT_DESCR,H,DECOMP_DATA_OUT,WORK,TRANS,UNITD)
       USE TYPEDESC
       USE TYPESP
       TYPE(D_SPMAT), INTENT(IN) :: A
       TYPE(D_SPMAT), INTENT(INOUT) :: H
       INTEGER, INTENT(IN)   :: WORK(:)
       INTEGER, INTENT(IN)   :: CHECK_DESCR
       INTEGER, INTENT(OUT)  ::  CONVERT_DESCR
       TYPE(DECOMP_DATA_TYPE), INTENT(IN)  :: DECOMP_DATA
       TYPE(DECOMP_DATA_TYPE), INTENT(INOUT) :: DECOMP_DATA_OUT
       REAL(KIND(1.D0)), INTENT(IN) :: D(:)
       CHARACTER, INTENT(in),OPTIONAL :: TRANS, UNITD
     END SUBROUTINE F90_PSDVERIFY
  END INTERFACE

  Interface F90_PSDSCALL
     Subroutine PSDDSCALLC(M,N,PARTS,ICONTXT,IERRV, DECOMP_DATA)
       Use TYPEDESC
       Use TYPESP
       include 'parts.f90'
       integer, intent(in)                 :: m,n,icontxt
       type(decomp_data_type), intent(inout) :: decomp_data
       integer                     :: ierrv(:)
     end subroutine PSDDSCALLC
  End Interface

  Interface F90_PSDSCCPY
     Subroutine PSDDSCCPY(DECOMP1,DECOMP_DATA)
       Use TYPEDESC
       Use TYPESP
       type(decomp_data_type), intent(out) :: decomp1
       type(decomp_data_type), intent(in)  :: decomp_data
     end subroutine PSDDSCCPY
  End Interface

  Interface F90_PSSPALL
     Subroutine PSDSPALLOC(A,IERRV,DECOMP_DATA,NNZ)
       Use TYPEDESC
       Use TYPESP
       Type(DECOMP_DATA_TYPE), intent(inout) :: DECOMP_DATA
       Type(D_SPMAT), intent(out)            :: A
       Integer                       :: IERRV(:)
       Integer, Optional, intent(in)         :: NNZ
     End Subroutine PSDSPALLOC
     Subroutine PSZSPALLOC(A,IERRV,DECOMP_DATA,NNZ)
       Use TYPEDESC
       Use TYPESP
       Type(DECOMP_DATA_TYPE), intent(inout) :: DECOMP_DATA
       Type(Z_SPMAT), intent(out)            :: A
       Integer                       :: IERRV(:)
       Integer, Optional, intent(in)         :: NNZ
     End Subroutine PSZSPALLOC
  End Interface

  Interface F90_PSSPREINIT
    Subroutine PSDSPREINIT(A,IERRV,DECOMP_DATA)
      Use TYPEDESC
      Use TYPESP
      Type(DECOMP_DATA_TYPE), intent(inout) :: DECOMP_DATA
      Type(D_SPMAT), intent(inout)          :: A
      Integer                       :: IERRV(:)
    End Subroutine PSDSPREINIT
    Subroutine PSZSPREINIT(A,IERRV,DECOMP_DATA)
      Use TYPEDESC
      Use TYPESP
      Type(DECOMP_DATA_TYPE), intent(inout) :: DECOMP_DATA
      Type(Z_SPMAT), intent(inout)          :: A
      Integer                       :: IERRV(:)
    End Subroutine PSZSPREINIT
  End Interface


  Interface F90_PSSPASB
    Subroutine PSDSPASB(A,IERRV,DECOMP_DATA,OVERLAP,AFMT,UP,DUP)
      Use TYPEDESC
      Use TYPESP
      Implicit None
      Type(D_SPMAT), intent (inout)         :: A
      Type(DECOMP_DATA_TYPE), intent(inout) :: DECOMP_DATA
      Integer  	             :: IERRV(:)
      Integer, optional, intent(in)         :: overlap,DUP
      character, optional, intent(in)       :: AFMT*5,UP
    End Subroutine PSDSPASB
    Subroutine PSZSPASB(A,IERRV,DECOMP_DATA,OVERLAP,AFMT,UP,DUP)
      Use TYPEDESC
      Use TYPESP
      Implicit None
      Type(Z_SPMAT), intent (inout)         :: A
      Type(DECOMP_DATA_TYPE), intent(inout) :: DECOMP_DATA
      Integer  	             :: IERRV(:)
      Integer, optional, intent(in)         :: overlap,DUP
      character, optional, intent(in)       :: AFMT*5,UP
    End Subroutine PSZSPASB
  End Interface

  Interface F90_PSSPCNV
    Subroutine PSDSPCNV(A,B,IERRV,DECOMP_DATA)
      Use TYPEDESC
      Use TYPESP
      Implicit None
      Type(D_SPMAT), intent(in)          :: A
      Type(D_SPMAT), intent(out)         :: B
      Type(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      Integer   	          :: IERRV(:)
    End Subroutine PSDSPCNV
    Subroutine PSZSPCNV(A,B,IERRV,DECOMP_DATA)
      Use TYPEDESC
      Use TYPESP
      Implicit None
      Type(Z_SPMAT), intent(in)          :: A
      Type(Z_SPMAT), intent(out)         :: B
      Type(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      Integer   	          :: IERRV(:)
    End Subroutine PSZSPCNV
  End Interface


  Interface F90_PSSPINS
    Subroutine PSDSPINS(A, IA, JA, BLCK&
         & ,IERRV,DECOMP_DATA, IX,JX)
      Use TYPEDESC
      Use TYPESP
      Type(DECOMP_DATA_TYPE), intent(inout) ::  DECOMP_DATA
      Type(D_SPMAT), intent(inout)          ::  A
      Integer, intent(in)                   ::  IA,JA
      Type(D_SPMAT), intent(in)             ::  BLCK
      Integer                      ::  IERRV(:)
      Integer, Optional, intent(in)         ::  IX,JX
    End Subroutine PSDSPINS
    Subroutine PSZSPINS(A, IA, JA, BLCK&
         & ,IERRV,DECOMP_DATA, IX,JX)
      Use TYPEDESC
      Use TYPESP
      Type(DECOMP_DATA_TYPE), intent(inout) ::  DECOMP_DATA
      Type(Z_SPMAT), intent(inout)          ::  A
      Integer, intent(in)                   ::  IA,JA
      Type(Z_SPMAT), intent(in)             ::  BLCK
      Integer                      ::  IERRV(:)
      Integer, Optional, intent(in)         ::  IX,JX
    End Subroutine PSZSPINS
  End Interface

  Interface F90_PSPTINS
    Subroutine PSDPTINS(IA, JA, BLCK,IERRV,DECOMP_DATA)
      Use TYPEDESC
      Use TYPESP
      Type(DECOMP_DATA_TYPE), intent(inout) ::  DECOMP_DATA
      Integer, intent(in)                   ::  IA,JA
      Type(D_SPMAT), intent(in)             ::  BLCK
      Integer                      ::  IERRV(:)
    End Subroutine PSDPTINS
  End Interface

  Interface F90_PSPTASB
    Subroutine PSPTASB(IERRV,DECOMP_DATA)
      Use TYPEDESC
      Use TYPESP
      Implicit None
      Type(DECOMP_DATA_TYPE), intent(inout) :: DECOMP_DATA
      Integer  	             :: IERRV(:)
    End Subroutine PSPTASB
  End Interface


  Interface F90_PSSPUPD
    Subroutine PSDSPUPDATE(A, IA, JA, BLCK,&
         & IERRV,DECOMP_DATA, IX,JX,UPDFLAG)
      Use TYPEDESC
      Use TYPESP
      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      Type(D_SPMAT), intent(inout)       ::  A
      Integer, intent(in)                ::  IA,JA
      Type(D_SPMAT), intent(in)          ::  BLCK
      Integer                   ::  IERRV(:)
      Integer, Optional, intent(in)      ::  IX,JX
      Integer, Optional, intent(in)      ::  UPDFLAG
    End Subroutine PSDSPUPDATE
    Subroutine PSZSPUPDATE(A, IA, JA, BLCK,&
         & IERRV,DECOMP_DATA, IX,JX,UPDFLAG)
      Use TYPEDESC
      Use TYPESP
      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      Type(Z_SPMAT), intent(inout)       ::  A
      Integer, intent(in)                ::  IA,JA
      Type(Z_SPMAT), intent(in)          ::  BLCK
      Integer                   ::  IERRV(:)
      Integer, Optional, intent(in)      ::  IX,JX
      Integer, Optional, intent(in)      ::  UPDFLAG
    End Subroutine PSZSPUPDATE
  End Interface

  Interface F90_PSSPFREE
    Subroutine PSDSPFREE(A,DECOMP_DATA)
      !...free sparse matrix structure...
      USE TYPEDESC
      USE TYPESP
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      TYPE(D_SPMAT), intent(inout)       :: A
    End Subroutine PSDSPFREE
    Subroutine PSZSPFREE(A,DECOMP_DATA)
      !...free sparse matrix structure...
      USE TYPEDESC
      USE TYPESP
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      TYPE(Z_SPMAT), intent(inout)       ::A
    End Subroutine PSZSPFREE
  End Interface

  Interface F90_PSDSCFREE
    Subroutine PSDSCFREE(DECOMP_DATA)
      !...free sparse matrix structure...
      USE TYPEDESC
      TYPE(DECOMP_DATA_TYPE), intent(inout) :: DECOMP_DATA
    End Subroutine PSDSCFREE
  End Interface

  Interface F90_PSDSCREN
    Subroutine PSDSCREN(TRANS,P,DECOMP_DATA)
      !...free sparse matrix structure...
      USE TYPEDESC
      INTEGER, intent(inout)                :: P(:)
      TYPE(DECOMP_DATA_TYPE), intent(inout) :: DECOMP_DATA
      character, intent(in)                 :: trans
    End Subroutine PSDSCREN
  End Interface

  Interface F90_PSCSRP
    Subroutine PSDCSRP(TRANS,P,A,DECOMP_DATA)
      !...free sparse matrix structure...
      USE TYPEDESC
      USE TYPESP
      INTEGER, intent(inout)             :: P(:)
      Type(D_SPMAT), intent(inout)       :: A
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      character, intent(in)              :: trans
    End Subroutine PSDCSRP
    Subroutine PSZCSRP(TRANS,P,A,DECOMP_DATA)
      !...free sparse matrix structure...
      USE TYPEDESC
      USE TYPESP
      INTEGER, intent(inout)             :: P(:)
      Type(Z_SPMAT), intent(inout)       :: A
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      character, intent(in)              :: trans
    End Subroutine PSZCSRP
  End Interface

  Interface F90_PSGELP
    Subroutine PSDGELP(TRANS,IPERM,X,DECOMP_DATA)
      !....Assembly dense matrix X .....
      Use TYPEDESC
      !  Implicit None
      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      Real(Kind(1.D0)), intent(inout)    ::  X(:,:)
      Integer, intent(inout)             ::  IPERM(:)
      character, intent(in)              :: trans
    end Subroutine PSDGELP
    Subroutine PSDGELPV(TRANS,IPERM,X,DECOMP_DATA)
      !....Assembly dense matrix X .....
      Use TYPEDESC
      !  Implicit None
      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      Real(Kind(1.D0)), intent(inout)    ::  X(:)
      Integer, intent(inout)             ::  IPERM(:)
      character, intent(in)              :: trans
    end Subroutine PSDGELPV
    Subroutine PSZGELP(TRANS,IPERM,X,DECOMP_DATA)
      !....Assembly dense matrix X .....
      Use TYPEDESC
      !  Implicit None
      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      Complex(Kind(1.D0)), intent(inout) ::  X(:,:)
      Integer, intent(in)                ::  IPERM(:)
      character, intent(in)              :: trans
    end Subroutine PSZGELP
    Subroutine PSZGELPV(TRANS,IPERM,X,DECOMP_DATA)
      !....Assembly dense matrix X .....
      Use TYPEDESC
      !  Implicit None
      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      Complex(Kind(1.D0)), intent(inout) ::  X(:)
      Integer, intent(in)                ::  IPERM(:)
      character, intent(in)              :: trans
    end Subroutine PSZGELPV
  End Interface


  Interface F90_PSDSALL
    !....Allocate dense matrix X .....
    Subroutine PSDALLOC(M, N, X, IERRV, DECOMP_DATA,JS)
      Use TYPEDESC
      Implicit None       
      Integer, intent(in)                :: M,N
      Real(Kind(1.D0)), Pointer          :: X(:,:)
      Type(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      Integer                   :: IERRV(:)
      Integer, Optional, intent(in)      :: JS
    End Subroutine PSDALLOC
    Subroutine PSDALLOCV(M, X, IERRV, DECOMP_DATA)
      Use TYPEDESC
      Implicit None       
      Integer, intent(in)                :: M
      Real(Kind(1.D0)), Pointer          :: X(:)
      Type(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      Integer                   :: IERRV(:)
    End Subroutine PSDALLOCV
    Subroutine PSZALLOC(M, N, X, IERRV, DECOMP_DATA,JS)
      Use TYPEDESC
      Implicit None       
      Integer, intent(in)                :: M,N
      complex(Kind(1.D0)), Pointer       :: X(:,:)
      Type(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      Integer                   :: IERRV(:)
      Integer, Optional, intent(in)      :: JS
    End Subroutine PSZALLOC
    Subroutine PSZALLOCV(M, X, IERRV, DECOMP_DATA)
      Use TYPEDESC
      Implicit None       
      Integer, intent(in)                :: M
      complex(Kind(1.D0)), Pointer       :: X(:)
      Type(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      Integer                   :: IERRV(:)
    End Subroutine PSZALLOCV
    Subroutine PSIALLOC(M, N, X, IERRV, DECOMP_DATA,JS)
      Use TYPEDESC
      Implicit None       
      Integer, intent(in)                :: M,N
      integer, Pointer                   :: X(:,:)
      Type(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      Integer                            :: IERRV(:)
      Integer, Optional, intent(in)      :: JS
    End Subroutine PSIALLOC
    Subroutine PSIALLOCV(M, X, IERRV, DECOMP_DATA)
      Use TYPEDESC
      Implicit None       
      Integer, intent(in)                :: M
      integer, Pointer                   :: X(:)
      Type(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      Integer                            :: IERRV(:)
    End Subroutine PSIALLOCV
  End Interface

  Interface F90_PSDSINS
    !....Insert dense block BLCK into dense matrix X .....
    Subroutine PSDINS(M, N, X, IX, JX, BLCK, IERRV, &
         & DECOMP_DATA, IBLCK, JBLCK)
      Use TYPEDESC
      Integer, intent(in)                ::  M,N
      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      Real(Kind(1.D0)),Pointer           ::  X(:,:)
      Integer, intent(in)                ::  IX,JX
      Real(Kind(1.d0)), intent(in)       ::  BLCK(:,:)
      Integer                   ::  IERRV(:)
      Integer, Optional, intent(in)      ::  IBLCK,JBLCK
    End Subroutine PSDINS
    Subroutine PSDINSVM(M, X, IX, JX, BLCK, IERRV, &
         & DECOMP_DATA, IBLCK)
      Use TYPEDESC
      Integer, intent(in)                ::  M
      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      Real(Kind(1.D0)),Pointer           ::  X(:,:)
      Integer, intent(in)                ::  IX,JX
      Real(Kind(1.d0)), intent(in)       ::  BLCK(:)
      Integer                   ::  IERRV(:)
      Integer, Optional, intent(in)      ::  IBLCK
    End Subroutine PSDINSVM
    Subroutine PSDINSVV(M, X, IX, BLCK, IERRV, &
         & DECOMP_DATA, IBLCK, INSFLAG)
      Use TYPEDESC
      Integer, intent(in)                ::  M
      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      Real(Kind(1.D0)),Pointer           ::  X(:)
      Integer, intent(in)                ::  IX
      Real(Kind(1.d0)), intent(in)       ::  BLCK(:)
      Integer                   ::  IERRV(:)
      Integer, Optional, intent(in)      ::  IBLCK
      Integer, Optional, intent(in)      ::  INSFLAG
    End Subroutine PSDINSVV
    Subroutine PSZINS(M, N, X, IX, JX, BLCK, IERRV, &
         & DECOMP_DATA, IBLCK, JBLCK)
      Use TYPEDESC
      Integer, intent(in)                ::  M,N
      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      Complex(Kind(1.D0)),Pointer        ::  X(:,:)
      Integer, intent(in)                ::  IX,JX
      Complex(Kind(1.d0)), intent(in)    ::  BLCK(:,:)
      Integer                   ::  IERRV(:)
      Integer, Optional, intent(in)      ::  IBLCK,JBLCK
    End Subroutine PSZINS
    Subroutine PSZINSVM(M, X, IX, JX, BLCK, IERRV, &
         & DECOMP_DATA, IBLCK)
      Use TYPEDESC
      Integer, intent(in)                ::  M
      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      Complex(Kind(1.D0)),Pointer        ::  X(:,:)
      Integer, intent(in)                ::  IX,JX
      Complex(Kind(1.d0)), intent(in)    ::  BLCK(:)
      Integer                   ::  IERRV(:)
      Integer, Optional, intent(in)      ::  IBLCK
    End Subroutine PSZINSVM
    Subroutine PSZINSVV(M, X, IX, BLCK, IERRV, &
         & DECOMP_DATA, IBLCK, INSFLAG)
      Use TYPEDESC
      Integer, intent(in)                ::  M
      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      Complex(Kind(1.D0)),Pointer        ::  X(:)
      Integer, intent(in)                ::  IX
      Complex(Kind(1.d0)), intent(in)    ::  BLCK(:)
      Integer                   ::  IERRV(:)
      Integer, Optional, intent(in)      ::  IBLCK
      Integer, Optional, intent(in)      ::  INSFLAG
    End Subroutine PSZINSVV
    Subroutine PSIINS(M, N, X, IX, JX, BLCK, IERRV, &
         & DECOMP_DATA, IBLCK, JBLCK)
      Use TYPEDESC
      Integer, intent(in)                ::  M,N
      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      integer,Pointer           ::  X(:,:)
      Integer, intent(in)                ::  IX,JX
      integer, intent(in)       ::  BLCK(:,:)
      Integer                            ::  IERRV(:)
      Integer, Optional, intent(in)      ::  IBLCK,JBLCK
    End Subroutine PSIINS
    Subroutine PSIINSVM(M, X, IX, JX, BLCK, IERRV, &
         & DECOMP_DATA, IBLCK)
      Use TYPEDESC
      Integer, intent(in)                ::  M
      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      integer, Pointer           ::  X(:,:)
      Integer, intent(in)                ::  IX,JX
      integer, intent(in)       ::  BLCK(:)
      Integer                            ::  IERRV(:)
      Integer, Optional, intent(in)      ::  IBLCK
    End Subroutine PSIINSVM
    Subroutine PSIINSVV(M, X, IX, BLCK, IERRV, &
         & DECOMP_DATA, IBLCK)
      Use TYPEDESC
      Integer, intent(in)                ::  M
      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      integer, Pointer           ::  X(:)
      Integer, intent(in)                ::  IX
      integer, intent(in)       ::  BLCK(:)
      Integer                            ::  IERRV(:)
      Integer, Optional, intent(in)      ::  IBLCK
    End Subroutine PSIINSVV
  End Interface

  Interface F90_PSDSASB
    !....Assembly dense matrix X .....
    Subroutine PSDASB(X, IERRV, DECOMP_DATA)
      Use TYPEDESC
      Implicit None

      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      Real(Kind(1.D0)),pointer           ::  X(:,:)
      Integer                   ::  IERRV(:)
    End Subroutine PSDASB
    Subroutine PSDASBV(X, IERRV,  DECOMP_DATA)
      Use TYPEDESC
      Implicit None

      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      Real(Kind(1.D0)),pointer           ::  X(:)
      Integer                   ::  IERRV(:)
    End Subroutine PSDASBV
    Subroutine PSZASB(X, IERRV, DECOMP_DATA)
      Use TYPEDESC
      Implicit None

      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      Complex(Kind(1.D0)),pointer        ::  X(:,:)
      Integer                   ::  IERRV(:)
    End Subroutine PSZASB
    Subroutine PSZASBV(X, IERRV,  DECOMP_DATA)
      Use TYPEDESC
      Implicit None

      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      Complex(Kind(1.D0)),pointer        ::  X(:)
      Integer                   ::  IERRV(:)
    End Subroutine PSZASBV
    Subroutine PSIASB(X, IERRV, DECOMP_DATA)
      Use TYPEDESC
      Implicit None

      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      integer,         pointer           ::  X(:,:)
      Integer                            ::  IERRV(:)
    End Subroutine PSIASB
    Subroutine PSIASBV(X, IERRV,  DECOMP_DATA)
      Use TYPEDESC
      Implicit None

      Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
      integer, pointer                   ::  X(:)
      Integer                            ::  IERRV(:)
    End Subroutine PSIASBV
  End Interface

  Interface F90_PSDSFREE
    !...free sparse matrix structure...
    Subroutine PSDFREE(X, DECOMP_DATA)
      USE TYPEDESC
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      REAL(kind(1.d0)),pointer          :: X(:,:)
    End Subroutine PSDFREE
    Subroutine PSDFREEV(X, DECOMP_DATA)
      USE TYPEDESC
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      REAL(kind(1.d0)),pointer           :: X(:)
    End Subroutine PSDFREEV
    Subroutine PSZFREE(X, DECOMP_DATA)
      USE TYPEDESC
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      COMPLEX(kind(1.d0)),pointer       :: X(:,:)
    End Subroutine PSZFREE
    Subroutine PSZFREEV(X, DECOMP_DATA)
      USE TYPEDESC
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      COMPLEX(kind(1.d0)),pointer        :: X(:)
    End Subroutine PSZFREEV
    Subroutine PSIFREE(X, DECOMP_DATA)
      USE TYPEDESC
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      integer, pointer           :: X(:,:)
    End Subroutine PSIFREE
    Subroutine PSIFREEV(X, DECOMP_DATA)
      USE TYPEDESC
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      integer, pointer           :: X(:)
    End Subroutine PSIFREEV
  End Interface

  Interface
    logical function is_owned(INDX,DECOMP_DATA)
      USE TYPEDESC
      INTEGER, intent(in)                :: INDX
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
    end function is_owned
  end Interface

End Module F90TOOLS









