MODULE F90PSBLAS

  INTERFACE F90_PSDOT
    FUNCTION F90_PSDDOTV(X, Y, DECOMP_DATA) 
      USE TYPEDESC
      REAL(KIND(1.D0))                   :: F90_PSDDOTV
      REAL(KIND(1.D0)), intent(in)       :: X(:), Y(:)
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
    END FUNCTION F90_PSDDOTV
    FUNCTION F90_PSDDOT(X, Y, DECOMP_DATA, JX, JY) 
      USE TYPEDESC
      REAL(KIND(1.D0))                   :: F90_PSDDOT
      REAL(KIND(1.d0)), intent(in)       :: X(:,:), Y(:,:)
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
      INTEGER, OPTIONAL, intent(in)      :: JX, JY
    END FUNCTION F90_PSDDOT
  END INTERFACE
  
  INTERFACE F90_DOT
    SUBROUTINE  F90_PSDDOTVS(RES,X, Y, DECOMP_DATA) 
      USE TYPEDESC
      REAL(KIND(1.D0)), intent(out)      :: RES
      REAL(KIND(1.D0)), intent(in)       :: X(:), Y(:)
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
    END SUBROUTINE F90_PSDDOTVS
    SUBROUTINE  F90_PSDMDOT(RES,X, Y, DECOMP_DATA) 
      USE TYPEDESC
      REAL(KIND(1.D0)), intent(out)      :: RES(:)
      REAL(KIND(1.D0)), intent(in)       :: X(:,:), Y(:,:)
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
    END SUBROUTINE F90_PSDMDOT
    SUBROUTINE  F90_PSZDOTCVS(RES,X, Y, DECOMP_DATA) 
      USE TYPEDESC
      COMPLEX(KIND(1.D0)), intent(out)   :: RES
      COMPLEX(KIND(1.D0)), intent(in)    :: X(:), Y(:)
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
    END SUBROUTINE F90_PSZDOTCVS
    SUBROUTINE  F90_PSZMDOTC(RES,X, Y, DECOMP_DATA) 
      USE TYPEDESC
      COMPLEX(KIND(1.D0)), intent(out)   :: RES(:)
      COMPLEX(KIND(1.D0)), intent(in)    :: X(:,:), Y(:,:)
      TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
    END SUBROUTINE F90_PSZMDOTC

  END INTERFACE

  INTERFACE F90_PSAXPBY
     SUBROUTINE F90_PSDAXPBYV(ALPHA, X, BETA, Y,&
	  & DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent (in)       ::  X(:)
       REAL(KIND(1.D0)), intent (inout)    ::  Y(:)
       REAL(KIND(1.D0)), intent (in)       :: ALPHA, BETA
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END SUBROUTINE F90_PSDAXPBYV
     SUBROUTINE F90_PSDAXPBY(ALPHA, X, BETA, Y,&
	  & DECOMP_DATA, N, JX, JY)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent (in)       ::  X(:,:)
       REAL(KIND(1.D0)), intent (inout)    ::  Y(:,:)
       REAL(KIND(1.D0)), intent (in)       ::  ALPHA, BETA
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
       INTEGER, OPTIONAL :: N, JX, JY
     END SUBROUTINE F90_PSDAXPBY
     SUBROUTINE F90_PSZAXPBYV(ALPHA, X, BETA, Y,&
	  & DECOMP_DATA)
       USE TYPEDESC
       COMPLEX(KIND(1.D0)), intent (in)    ::  X(:)
       COMPLEX(KIND(1.D0)), intent (inout) ::  Y(:)
       COMPLEX(KIND(1.D0)), intent (in)    ::  ALPHA, BETA
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END SUBROUTINE F90_PSZAXPBYV
     SUBROUTINE F90_PSZAXPBY(ALPHA, X, BETA, Y,&
	  & DECOMP_DATA, N, JX, JY)
       USE TYPEDESC
       COMPLEX(KIND(1.D0)), intent (in)    :: X(:,:)
       COMPLEX(KIND(1.D0)), intent (inout) :: Y(:,:)
       COMPLEX(KIND(1.D0)), intent (in)    :: ALPHA, BETA
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
       INTEGER, OPTIONAL :: N, JX, JY
     END SUBROUTINE F90_PSZAXPBY
  END INTERFACE

  INTERFACE F90_PSAMAX
     FUNCTION F90_PSDAMAX(X, DECOMP_DATA, JX)
       USE TYPEDESC
       REAL(KIND(1.D0))   F90_PSDAMAX
       REAL(KIND(1.D0)), intent (in)       :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
       INTEGER, OPTIONAL, intent (in)      :: JX
     END FUNCTION F90_PSDAMAX
     FUNCTION F90_PSDAMAXV(X, DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)) F90_PSDAMAXV
       REAL(KIND(1.D0)), intent (in)       :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END FUNCTION F90_PSDAMAXV
     FUNCTION F90_PSZAMAX(X, DECOMP_DATA, JX)
       USE TYPEDESC
       REAL(KIND(1.D0)) F90_PSZAMAX
       COMPLEX(KIND(1.D0)), intent (in)    :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
       INTEGER, OPTIONAL, intent (in)      :: JX
     END FUNCTION F90_PSZAMAX
     FUNCTION F90_PSZAMAXV(X, DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)) F90_PSZAMAXV
       COMPLEX(KIND(1.D0)), intent (in)    :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END FUNCTION F90_PSZAMAXV
   END INTERFACE

  INTERFACE F90_AMAX
     SUBROUTINE  F90_PSDAMAXVS(RES,X,DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent (out)      :: RES
       REAL(KIND(1.D0)), intent (in)       :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END SUBROUTINE F90_PSDAMAXVS
     SUBROUTINE  F90_PSDMAMAX(RES,X,DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent (out)      :: RES(:)
       REAL(KIND(1.D0)), intent (in)       :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END SUBROUTINE F90_PSDMAMAX
     SUBROUTINE  F90_PSZAMAXVS(RES,X,DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent (out)      :: RES
       COMPLEX(KIND(1.D0)), intent (in)    :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END SUBROUTINE F90_PSZAMAXVS
     SUBROUTINE  F90_PSZMAMAX(RES,X,DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent (out)      :: RES(:)
       COMPLEX(KIND(1.D0)), intent (in)    :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END SUBROUTINE F90_PSZMAMAX
  END INTERFACE

  INTERFACE F90_PSASUM
     FUNCTION F90_PSDASUM(X, DECOMP_DATA, JX)
       USE TYPEDESC
       REAL(KIND(1.D0))   F90_PSDASUM
       REAL(KIND(1.D0)), intent (in)       :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
       INTEGER, OPTIONAL, intent (in)      :: JX
     END FUNCTION F90_PSDASUM
     FUNCTION F90_PSDASUMV(X, DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)) F90_PSDASUMV
       REAL(KIND(1.D0)), intent (in)       :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END FUNCTION F90_PSDASUMV
     FUNCTION F90_PSZASUM(X, DECOMP_DATA, JX)
       USE TYPEDESC
       REAL(KIND(1.D0)) F90_PSZASUM
       COMPLEX(KIND(1.D0)), intent (in)    :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
       INTEGER, OPTIONAL, intent (in)      :: JX
     END FUNCTION F90_PSZASUM
     FUNCTION F90_PSZASUMV(X, DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)) F90_PSZASUMV
       COMPLEX(KIND(1.D0)), intent (in)    :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END FUNCTION F90_PSZASUMV
   END INTERFACE

  INTERFACE F90_ASUM
     SUBROUTINE  F90_PSDASUMVS(RES,X,DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent (out)      :: RES
       REAL(KIND(1.D0)), intent (in)       :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END SUBROUTINE F90_PSDASUMVS
     SUBROUTINE  F90_PSDMASUM(RES,X,DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent (out)      :: RES(:)
       REAL(KIND(1.D0)), intent (in)       :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END SUBROUTINE F90_PSDMASUM
     SUBROUTINE  F90_PSZASUMVS(RES,X,DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent (out)      :: RES
       COMPLEX(KIND(1.D0)), intent (in)    :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END SUBROUTINE F90_PSZASUMVS
     SUBROUTINE  F90_PSZMASUM(RES,X,DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent (out)      :: RES(:)
       COMPLEX(KIND(1.D0)), intent (in)    :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END SUBROUTINE F90_PSZMASUM
  END INTERFACE


  INTERFACE F90_PSNRM2
     FUNCTION F90_PSDNRM2(X, DECOMP_DATA, JX)
       USE TYPEDESC
       REAL(KIND(1.D0))   F90_PSDNRM2
       REAL(KIND(1.D0)), intent (in)       :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
       INTEGER, OPTIONAL, intent (in)      :: JX
     END FUNCTION F90_PSDNRM2
     FUNCTION F90_PSDNRM2V(X, DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)) F90_PSDNRM2V
       REAL(KIND(1.D0)), intent (in)       :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END FUNCTION F90_PSDNRM2V
     FUNCTION F90_PSZNRM2(X, DECOMP_DATA, JX)
       USE TYPEDESC
       REAL(KIND(1.D0)) F90_PSZNRM2
       COMPLEX(KIND(1.D0)), intent (in)    :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
       INTEGER, OPTIONAL, intent (in)      :: JX
     END FUNCTION F90_PSZNRM2
     FUNCTION F90_PSZNRM2V(X, DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)) F90_PSZNRM2V
       COMPLEX(KIND(1.D0)), intent (in)    :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END FUNCTION F90_PSZNRM2V
   END INTERFACE

  INTERFACE F90_NRM2
     SUBROUTINE  F90_PSDNRM2VS(RES,X,DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent (out)      :: RES
       REAL(KIND(1.D0)), intent (in)       :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END SUBROUTINE F90_PSDNRM2VS
     SUBROUTINE  F90_PSDMNRM2(RES,X,DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent (out)      :: RES(:)
       REAL(KIND(1.D0)), intent (in)       :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END SUBROUTINE F90_PSDMNRM2
     SUBROUTINE  F90_PSZNRM2VS(RES,X,DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent (out)      :: RES
       COMPLEX(KIND(1.D0)), intent (in)    :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END SUBROUTINE F90_PSZNRM2VS
     SUBROUTINE  F90_PSZMNRM2(RES,X,DECOMP_DATA)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent (out)      :: RES(:)
       COMPLEX(KIND(1.D0)), intent (in)    :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END SUBROUTINE F90_PSZMNRM2
  END INTERFACE
  

  INTERFACE F90_PSNRMI
     FUNCTION F90_PSDNRMI(A, DECOMP_DATA)
       USE TYPESP
       USE TYPEDESC
       REAL(KIND(1.D0))                    :: F90_PSDNRMI
       TYPE (D_SPMAT), intent (in)         :: A
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END FUNCTION F90_PSDNRMI
     FUNCTION F90_PSZNRMI(A, DECOMP_DATA)
       USE TYPESP
       USE TYPEDESC
       REAL(KIND(1.D0))                    :: F90_PSZNRMI
       TYPE (Z_SPMAT), intent (in)         :: A
       TYPE(DECOMP_DATA_TYPE), intent (in) :: DECOMP_DATA
     END FUNCTION F90_PSZNRMI
  END INTERFACE

  INTERFACE F90_PSOVRL
     SUBROUTINE F90_PSDOVRL(X, DECOMP_DATA,&
	  & UPDATE_TYPE, CHOICE, WORK)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent (inout) :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent (in)  :: DECOMP_DATA
       REAL(KIND(1.D0)), OPTIONAL, intent (inout)  :: WORK(:)
       LOGICAL, OPTIONAL, intent (in) :: CHOICE
       INTEGER, OPTIONAL, intent (in) :: UPDATE_TYPE
     END SUBROUTINE F90_PSDOVRL
     SUBROUTINE F90_PSDOVRLV(X, DECOMP_DATA,&
	  & UPDATE_TYPE, CHOICE, WORK)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent (inout) :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent (in)  :: DECOMP_DATA
       REAL(KIND(1.D0)), OPTIONAL, intent (inout)  :: WORK(:)
       LOGICAL, OPTIONAL, intent (in) :: CHOICE
       INTEGER, OPTIONAL, intent (in) :: UPDATE_TYPE
     END SUBROUTINE F90_PSDOVRLV
     SUBROUTINE F90_PSZOVRL(X, DECOMP_DATA,&
	  & UPDATE_TYPE, CHOICE, WORK)
       USE TYPEDESC
       COMPLEX(KIND(1.D0)), intent (inout) :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent (in)  :: DECOMP_DATA
       COMPLEX(KIND(1.D0)), OPTIONAL, intent (inout)  :: WORK(:)
       LOGICAL, OPTIONAL, intent (in) :: CHOICE
       INTEGER, OPTIONAL, intent (in) :: UPDATE_TYPE
     END SUBROUTINE F90_PSZOVRL
     SUBROUTINE F90_PSZOVRLV(X, DECOMP_DATA,&
	  & UPDATE_TYPE, CHOICE, WORK)
       USE TYPEDESC
       COMPLEX(KIND(1.D0)), intent (inout) :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent (in)  :: DECOMP_DATA
       COMPLEX(KIND(1.D0)), OPTIONAL, intent (inout)  :: WORK(:)
       LOGICAL, OPTIONAL, intent (in) :: CHOICE
       INTEGER, OPTIONAL, intent (in) :: UPDATE_TYPE
     END SUBROUTINE F90_PSZOVRLV
  END INTERFACE

  INTERFACE F90_PSHALO
     SUBROUTINE F90_PSDHALO(X, DECOMP_DATA, ALPHA, WORK, trans)
       USE TYPEDESC
       REAL(KIND(1.D0)), intent(inout)            :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent(in)         :: DECOMP_DATA
       REAL(KIND(1.D0)), OPTIONAL, intent(in)     :: ALPHA 
       character, intent(in), optional :: trans 
      REAL(KIND(1.D0)), OPTIONAL, intent(inout)  :: WORK(:)  
     END SUBROUTINE F90_PSDHALO
     SUBROUTINE F90_PSDHALOV(X, DECOMP_DATA, ALPHA,&
	  & WORK,trans) 
       USE TYPEDESC
       REAL(KIND(1.D0)), intent(inout)            :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent(in)         :: DECOMP_DATA
       REAL(KIND(1.D0)), OPTIONAL, intent(in)     :: ALPHA 
       character, intent(in), optional :: trans 
       REAL(KIND(1.D0)), OPTIONAL, intent(inout)  :: WORK(:)
     END SUBROUTINE F90_PSDHALOV
     SUBROUTINE F90_PSZHALO(X, DECOMP_DATA, ALPHA, WORK, TRANS)
       USE TYPEDESC
       COMPLEX(KIND(1.D0)), intent(inout)           :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent(in)           :: DECOMP_DATA
       COMPLEX(KIND(1.D0)), OPTIONAL, intent(in)    :: ALPHA 
       COMPLEX(KIND(1.D0)), OPTIONAL, intent(inout) :: WORK(:)
       character, intent(in), optional :: trans 
     END SUBROUTINE F90_PSZHALO
     SUBROUTINE F90_PSZHALOV(X, DECOMP_DATA, ALPHA,&
	  & WORK,TRANS) 
       USE TYPEDESC
       COMPLEX(KIND(1.D0)), intent(inout)           :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent(in)           :: DECOMP_DATA
       COMPLEX(KIND(1.D0)), OPTIONAL, intent(in)    :: ALPHA 
       COMPLEX(KIND(1.D0)), OPTIONAL, intent(inout) :: WORK(:)
       character, intent(in), optional              :: trans 
     END SUBROUTINE F90_PSZHALOV
     SUBROUTINE F90_PSIHALO(X, DECOMP_DATA, ALPHA, WORK, trans)
       USE TYPEDESC
       INTEGER, intent(inout)                     :: X(:,:)
       TYPE(DECOMP_DATA_TYPE), intent(in)         :: DECOMP_DATA
       REAL(KIND(1.D0)), OPTIONAL, intent(in)     :: ALPHA 
       character, intent(in), optional :: trans 
       INTEGER, OPTIONAL, intent(inout)           :: WORK(:)  
     END SUBROUTINE F90_PSIHALO
     SUBROUTINE F90_PSIHALOV(X, DECOMP_DATA, ALPHA,&
	  & WORK,TRANS) 
       USE TYPEDESC
       integer, intent(inout)                     :: X(:)
       TYPE(DECOMP_DATA_TYPE), intent(in)         :: DECOMP_DATA
       REAL(KIND(1.D0)), OPTIONAL, intent(in)     :: ALPHA 
       character, intent(in), optional :: trans 
       integer, OPTIONAL, intent(inout)           :: WORK(:)
     END SUBROUTINE F90_PSIHALOV
  END INTERFACE

  INTERFACE F90_PSSPMM
     SUBROUTINE F90_PSDSPMM(ALPHA, A, X, BETA, Y, DECOMP_DATA, &
          &TRANS, K, JX, JY,WORK)
       USE TYPESP
       USE TYPEDESC
       TYPE (D_SPMAT), intent(in)           :: A
       REAL(KIND(1.D0)), intent(in)         :: X(:,:)
       REAL(KIND(1.D0)), intent(inout)      :: Y(:,:)
       REAL(KIND(1.D0)), intent(in)         :: ALPHA, BETA
       TYPE(DECOMP_DATA_TYPE), intent(in)   :: DECOMP_DATA
       CHARACTER, OPTIONAL, intent(in)      :: TRANS
       REAL(KIND(1.D0)), OPTIONAL, intent(inout) :: WORK(:)
       INTEGER, OPTIONAL, intent(in)        :: K, JX, JY
     END SUBROUTINE F90_PSDSPMM
     SUBROUTINE F90_PSDSPMV(ALPHA, A, X, BETA, Y,&
	  & DECOMP_DATA, TRANS, WORK)
       USE TYPESP
       USE TYPEDESC
       TYPE (D_SPMAT), intent(in)           :: A
       REAL(KIND(1.D0)), intent(in)         :: X(:)
       REAL(KIND(1.D0)), intent(inout)      :: Y(:)
       REAL(KIND(1.D0)), intent(in)         :: ALPHA, BETA
       TYPE(DECOMP_DATA_TYPE), intent(in)   :: DECOMP_DATA
       CHARACTER, OPTIONAL, intent(in)      :: TRANS
       REAL(KIND(1.D0)), OPTIONAL, intent(inout) :: WORK(:)
     END SUBROUTINE F90_PSDSPMV
     SUBROUTINE F90_PSZSPMM(ALPHA, A, X, BETA, Y,&
	  & DECOMP_DATA, TRANS, K, JX, JY, WORK)
       USE TYPESP
       USE TYPEDESC
       TYPE (Z_SPMAT), intent(in)           :: A
       COMPLEX(KIND(1.D0)), intent(in)      :: X(:,:)
       COMPLEX(KIND(1.D0)), intent(inout)   :: Y(:,:)
       COMPLEX(KIND(1.D0)), intent(in)      :: ALPHA, BETA
       TYPE(DECOMP_DATA_TYPE), intent(in)   :: DECOMP_DATA
       CHARACTER, OPTIONAL, intent(in)      :: TRANS
       COMPLEX(KIND(1.D0)), OPTIONAL, intent(inout) :: WORK(:)
       INTEGER, OPTIONAL, intent(in)        :: K, JX, JY
     END SUBROUTINE F90_PSZSPMM
     SUBROUTINE F90_PSZSPMV(ALPHA, A, X, BETA, Y,&
	  & DECOMP_DATA, TRANS, WORK)
       USE TYPESP
       USE TYPEDESC
       TYPE (Z_SPMAT), intent(in)           :: A
       COMPLEX(KIND(1.D0)), intent(in)      :: X(:)
       COMPLEX(KIND(1.D0)), intent(inout)   :: Y(:)
       COMPLEX(KIND(1.D0)), intent(in)      :: ALPHA, BETA
       TYPE(DECOMP_DATA_TYPE), intent(in)   :: DECOMP_DATA
       CHARACTER, OPTIONAL, intent(in)      :: TRANS
       COMPLEX(KIND(1.D0)), OPTIONAL, intent(inout) :: WORK(:)
     END SUBROUTINE F90_PSZSPMV
  END INTERFACE

  INTERFACE F90_PSSPSM
     SUBROUTINE F90_PSDSPSM(ALPHA, T, X, BETA, Y,&
	  & DECOMP_DATA, TRANS, UNIT, CHOICE,& 
	  & DIAG, N, JX, JY, WORK)
       USE TYPESP
       USE TYPEDESC
       TYPE (D_SPMAT), intent(in)             :: T
       REAL(KIND(1.D0)), intent(in)           :: X(:,:)
       REAL(KIND(1.D0)), intent(inout)        :: Y(:,:)
       REAL(KIND(1.D0)), intent(in)           :: ALPHA, BETA
       TYPE(DECOMP_DATA_TYPE), intent(in)     :: DECOMP_DATA
       CHARACTER, OPTIONAL, intent(in)        :: TRANS, UNIT
       INTEGER, OPTIONAL, intent(in)          :: N, JX, JY
       LOGICAL, OPTIONAL, intent(in)          :: CHOICE
       REAL(KIND(1.D0)), OPTIONAL, intent(in) :: WORK(:), DIAG(:)
     END SUBROUTINE F90_PSDSPSM
     SUBROUTINE F90_PSDSPSV(ALPHA, T, X, BETA, Y,&
	  & DECOMP_DATA, TRANS, UNIT, CHOICE,& 
	  & DIAG, WORK)
       USE TYPESP
       USE TYPEDESC
       TYPE (D_SPMAT), intent(in)             :: T
       REAL(KIND(1.D0)), intent(in)           :: X(:)
       REAL(KIND(1.D0)), intent(inout)        :: Y(:)
       REAL(KIND(1.D0)), intent(in)           :: ALPHA, BETA
       TYPE(DECOMP_DATA_TYPE), intent(in)     :: DECOMP_DATA
       CHARACTER, OPTIONAL, intent(in)        :: TRANS, UNIT
       LOGICAL, OPTIONAL, intent(in)          :: CHOICE
       REAL(KIND(1.D0)), OPTIONAL, intent(in) :: WORK(:), DIAG(:)
     END SUBROUTINE F90_PSDSPSV
     SUBROUTINE F90_PSZSPSM(ALPHA, T, X, BETA, Y,&
	  & DECOMP_DATA, TRANS, UNIT, CHOICE,& 
	  & DIAG, N, JX, JY, WORK)
       USE TYPESP
       USE TYPEDESC
       TYPE (Z_SPMAT), intent(in)             :: T
       COMPLEX(KIND(1.D0)), intent(in)        :: X(:,:)
       COMPLEX(KIND(1.D0)), intent(inout)     :: Y(:,:)
       COMPLEX(KIND(1.D0)), intent(in)        :: ALPHA, BETA
       TYPE(DECOMP_DATA_TYPE), intent(in)     :: DECOMP_DATA
       CHARACTER, OPTIONAL, intent(in)        :: TRANS, UNIT
       INTEGER, OPTIONAL, intent(in)          :: N, JX, JY
       LOGICAL, OPTIONAL, intent(in)          :: CHOICE
       COMPLEX(KIND(1.D0)), OPTIONAL, intent(in) :: WORK(:), DIAG(:)
     END SUBROUTINE F90_PSZSPSM
     SUBROUTINE F90_PSZSPSV(ALPHA, T, X, BETA, Y,&
	  & DECOMP_DATA, TRANS, UNIT, CHOICE,& 
	  & DIAG, WORK)
       USE TYPESP
       USE TYPEDESC
       TYPE (Z_SPMAT), intent(in)             :: T
       COMPLEX(KIND(1.D0)), intent(in)        :: X(:)
       COMPLEX(KIND(1.D0)), intent(inout)     :: Y(:)
       COMPLEX(KIND(1.D0)), intent(in)        :: ALPHA, BETA
       TYPE(DECOMP_DATA_TYPE), intent(in)     :: DECOMP_DATA
       CHARACTER, OPTIONAL, intent(in)        :: TRANS, UNIT
       LOGICAL, OPTIONAL, intent(in)          :: CHOICE
       COMPLEX(KIND(1.D0)), OPTIONAL, intent(in) :: WORK(:), DIAG(:)
     END SUBROUTINE F90_PSZSPSV
  END INTERFACE

  INTERFACE F90_PSDSCATTERM
     SUBROUTINE  F90_PSDSCATTERM(GLOBX, LOCX, DECOMP_DATA, IROOT, &
          & IIGLOBX,  IJGLOBX, IILOCX, IJLOCX, WORK)
        USE TYPEDESC
        IMPLICIT NONE
        REAL(KIND(1.0D0)), intent(in)      :: GLOBX(:,:)
        REAL(KIND(1.0D0)), intent(out)     :: LOCX(:,:)
        TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
        INTEGER, OPTIONAL, intent(in)      :: IROOT, IIGLOBX, IJGLOBX, IILOCX, IJLOCX
        INTEGER, OPTIONAL, intent(inout)   :: WORK(:)
     END SUBROUTINE F90_PSDSCATTERM
     SUBROUTINE  F90_PSDSCATTERMV(GLOBX, LOCX, DECOMP_DATA, IROOT,&
          & IIGLOBX, IILOCX, WORK)
        USE TYPEDESC
        IMPLICIT NONE
        REAL(KIND(1.0D0)), intent(in)      :: GLOBX(:)
        REAL(KIND(1.0D0)), intent(out)     :: LOCX(:)
        TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
        INTEGER, OPTIONAL, intent(in)      :: IROOT, IIGLOBX, IILOCX
        INTEGER, OPTIONAL, intent(inout)   :: WORK(:)
     END SUBROUTINE F90_PSDSCATTERMV      
  END INTERFACE

  INTERFACE F90_PSDGATHERM
     SUBROUTINE  F90_PSDGATHERM(GLOBX, LOCX, DECOMP_DATA, IROOT, IIGLOBX,&
          & IJGLOBX, IILOCX, IJLOCX)
        USE TYPEDESC
        IMPLICIT NONE
        REAL(KIND(1.0D0)), intent(out)     :: GLOBX(:,:)
        REAL(KIND(1.0D0)), intent(in)      :: LOCX(:,:)
        TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
        INTEGER, OPTIONAL, intent(in)      :: IROOT, IIGLOBX, IJGLOBX, IILOCX, IJLOCX
     END SUBROUTINE F90_PSDGATHERM
     SUBROUTINE  F90_PSDGATHERMV(GLOBX, LOCX, DECOMP_DATA, IROOT, IIGLOBX,&
          & IILOCX)
        USE TYPEDESC
        IMPLICIT NONE
        REAL(KIND(1.0D0)), intent(out)     :: GLOBX(:)
        REAL(KIND(1.0D0)), intent(in)      :: LOCX(:)
        TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
        INTEGER, OPTIONAL, intent(in)      :: IROOT, IIGLOBX, IILOCX
     END SUBROUTINE F90_PSDGATHERMV      
     SUBROUTINE  F90_PSZGATHERM(GLOBX, LOCX, DECOMP_DATA, IROOT, IIGLOBX,&
          & IJGLOBX, IILOCX, IJLOCX)
        USE TYPEDESC
        IMPLICIT NONE
        COMPLEX(KIND(1.0D0)), intent(out)     :: GLOBX(:,:)
        COMPLEX(KIND(1.0D0)), intent(in)      :: LOCX(:,:)
        TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
        INTEGER, OPTIONAL, intent(in)      :: IROOT, IIGLOBX, IJGLOBX, IILOCX, IJLOCX
     END SUBROUTINE F90_PSZGATHERM
     SUBROUTINE  F90_PSZGATHERMV(GLOBX, LOCX, DECOMP_DATA, IROOT, IIGLOBX,&
          & IILOCX)
        USE TYPEDESC
        IMPLICIT NONE
        COMPLEX(KIND(1.0D0)), intent(out)     :: GLOBX(:)
        COMPLEX(KIND(1.0D0)), intent(in)      :: LOCX(:)
        TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
        INTEGER, OPTIONAL, intent(in)      :: IROOT, IIGLOBX, IILOCX
     END SUBROUTINE F90_PSZGATHERMV      
  END INTERFACE  
END MODULE F90PSBLAS
