MODULE F90METHD

  INTERFACE F90_CG
     SUBROUTINE F90_DCG(A,L,U,VDIAG,B,X,EPS,DECOMP_DATA,& 
	  & ITMAX,ITER,ERR,IERR,ITRACE)
       USE TYPESP
       USE TYPEDESC
       TYPE (D_SPMAT), intent(in)         :: A, L, U
       TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
       REAL(KIND(1.D0)), intent(in)       :: VDIAG(:), B(:)
       REAL(KIND(1.D0)), intent(inout)    :: X(:)
       REAL(KIND(1.D0)), intent(in)       :: EPS
       INTEGER, OPTIONAL, intent(in)      :: ITMAX, ITRACE
       INTEGER, OPTIONAL, intent(out)     :: ITER, IERR
       REAL(KIND(1.D0)), OPTIONAL, intent(out) :: ERR
     END SUBROUTINE F90_DCG
  END INTERFACE

  INTERFACE F90_BICG
     SUBROUTINE F90_DBICG(A,IPREC,L,U,VDIAG,B,X,EPS,&
	  & DECOMP_DATA,ITMAX,ITER,ERR,IERR,ITRACE)
       USE TYPESP
       USE TYPEDESC
       TYPE (D_SPMAT), intent(in)         :: A, L, U
       TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
       REAL(KIND(1.D0)), intent(in)       :: VDIAG(:), B(:)
       REAL(KIND(1.D0)), intent(inout)    :: X(:)
       REAL(KIND(1.D0)), intent(in)       :: EPS
       INTEGER, OPTIONAL, intent(in)      :: ITMAX, ITRACE
       INTEGER, OPTIONAL, intent(out)     :: ITER, IERR
       REAL(KIND(1.D0)), OPTIONAL, intent(out) :: ERR
     END SUBROUTINE F90_DBICG
  END INTERFACE

  INTERFACE F90_BICGSTAB
     SUBROUTINE F90_DCGSTAB(A,IPREC,L,U,VDIAG,B,X,EPS,&
	  & DECOMP_DATA,ITMAX,ITER,ERR,IERR,ITRACE)
       USE TYPESP
       USE TYPEDESC
       TYPE (D_SPMAT), intent(in)         :: A, L, U
       TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
       REAL(KIND(1.D0)), intent(in)       :: VDIAG(:), B(:)
       REAL(KIND(1.D0)), intent(inout)    :: X(:)
       REAL(KIND(1.D0)), intent(in)       :: EPS
       INTEGER, intent(in)                :: IPREC
       INTEGER, OPTIONAL, intent(in)      :: ITMAX, ITRACE
       INTEGER, OPTIONAL, intent(out)     :: ITER, IERR
       REAL(KIND(1.D0)), OPTIONAL, intent(out) :: ERR
     END SUBROUTINE F90_DCGSTAB
     SUBROUTINE F90_ZCGSTAB(A,IPREC,L,U,VDIAG,B,X,EPS,&
	  & DECOMP_DATA,ITMAX,ITER,ERR,IERR,ITRACE)
       USE TYPESP
       USE TYPEDESC
       TYPE (Z_SPMAT), intent(in)         :: A, L, U
       TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
       COMPLEX(KIND(1.D0)), intent(in)       :: VDIAG(:), B(:)
       COMPLEX(KIND(1.D0)), intent(inout)    :: X(:)
       REAL(KIND(1.D0)), intent(in)       :: EPS
       INTEGER, intent(in)                :: IPREC
       INTEGER, OPTIONAL, intent(in)      :: ITMAX, ITRACE
       INTEGER, OPTIONAL, intent(out)     :: ITER, IERR
       REAL(KIND(1.D0)), OPTIONAL, intent(out) :: ERR
     END SUBROUTINE F90_ZCGSTAB
  END INTERFACE

  INTERFACE F90_BICGSTABL
     SUBROUTINE F90_DCGSTABL(A,IPREC,L,U,VDIAG,B,X,EPS,&
	  & DECOMP_DATA,ITMAX,ITER,ERR,IERR,ITRACE,ML)
       USE TYPESP
       USE TYPEDESC
       TYPE (D_SPMAT), intent(in)         :: A, L, U
       TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
       REAL(KIND(1.D0)), intent(in)       :: VDIAG(:), B(:)
       REAL(KIND(1.D0)), intent(inout)    :: X(:)
       REAL(KIND(1.D0)), intent(in)       :: EPS
       INTEGER, intent(in)                :: IPREC
       INTEGER, OPTIONAL, intent(in)      :: ITMAX, ITRACE, ML
       INTEGER, OPTIONAL, intent(out)     :: ITER, IERR
       REAL(KIND(1.D0)), OPTIONAL, intent(out) :: ERR
     END SUBROUTINE F90_DCGSTABL
  END INTERFACE

  INTERFACE F90_CGS
     SUBROUTINE F90_DCGS(A,IPREC,L,U,VDIAG,B,X,EPS,&
	  & DECOMP_DATA,ITMAX,ITER,ERR,IERR,ITRACE)
       USE TYPESP
       USE TYPEDESC
       TYPE (D_SPMAT), intent(in)         :: A, L, U
       TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
       REAL(KIND(1.D0)), intent(in)       :: VDIAG(:), B(:)
       REAL(KIND(1.D0)), intent(inout)    :: X(:)
       REAL(KIND(1.D0)), intent(in)       :: EPS
       INTEGER, intent(in)                :: IPREC
       INTEGER, OPTIONAL, intent(in)      :: ITMAX, ITRACE
       INTEGER, OPTIONAL, intent(out)     :: ITER, IERR
       REAL(KIND(1.D0)), OPTIONAL, intent(out) :: ERR
     END SUBROUTINE F90_DCGS
  END INTERFACE

  INTERFACE PRECONDITIONER
    Subroutine PRECONDITIONER(METHD,A,L,U,VDIAG,DECOMP_DATA,IERR)
      Use typesp
      Use typedesc      
      Implicit None
      Integer, intent(in)                :: METHD
      Integer, intent(out)               :: IERR
      Type(d_spmat), intent(in)          :: A
      Type(d_spmat), intent(out)         :: L, U
      Real(Kind(1.d0)),pointer           :: VDIAG(:)
      Type(decomp_data_type), intent(in) :: DECOMP_DATA
    end Subroutine PRECONDITIONER
    Subroutine ZPRECONDITIONER(METHD,A,L,U,VDIAG,DECOMP_DATA,IERR)
      Use typesp
      Use typedesc      
      Implicit None
      Integer, intent(in)                :: METHD
      Integer, intent(out)               :: IERR
      Type(z_spmat), intent(in)          :: A
      Type(z_spmat), intent(out)         :: L, U
      Complex(Kind(1.d0)),pointer           :: VDIAG(:)
      Type(decomp_data_type), intent(in) :: DECOMP_DATA
    end Subroutine ZPRECONDITIONER
  END INTERFACE

END MODULE F90METHD

  
