! ---------------------------------------------------------------------
!
!  -- PSSBLAS routine (version 1.0) --
!
!  ---------------------------------------------------------------------
!/
Subroutine PSZSPUPDATE(A, IA, JA, BLCK, IERRV, DECOMP_DATA,IX,JX,UPDFLAG)
  !  Purpose
  !  =======
  !  
  !  insert sparse submatrix to sparse matrix structure for psblas
  !  routines
  !
  ! INPUT
  !======
  ! M        : (Local input) Integer 
  !            rows number of submatrix belonging to BLCK to be inserted.
  !            required.
  ! N        : (Local input) Integer 
  !            cols number of submatrix belonging to BLCK to be inserted.
  !            required.
  !  IA        integer
  !            sparse matrix A global-row corresponding to position at
  !            which blck submatrix  must be inserted
  !            required.
  !  JA        integer
  !            sparse matrix A global-col corresponding to position at
  !            which blck submatrix  must be inserted
  !            required
  !  BLCK      TYPESP
  !            Sparse matrix to be inserted.
  !            required
  !
  !  IX        Integer 
  !            first row of blck submatrix to be inserted
  !            optional, default is 1
  !  IY        Integer 
  !            first col of blck submatrix to be inserted
  !            optional, default is 1
  !
  ! INPUT/OUTPUT
  !==============
  ! DECOMP_DATA TYPEDESC
  !             required
  ! DECOMP_DATA FIELDS
  !
  ! MATRIX_DATA   : Pointer to integer Array 
  !                contains some
  !               local and global information about matrix:
  !
  !  NOTATION        STORED IN		     EXPLANATION
  !  ------------ ---------------------- -------------------------------------
  !  DEC_TYPE        MATRIX_DATA[DEC_TYPE_]   Decomposition type, temporarly is
  !                      setted to 1( matrix not yet assembled)
  !  M 	             MATRIX_DATA[M_]          Total number of equations
  !  N 	             MATRIX_DATA[N_]          Total number of variables
  !  N_ROW           MATRIX_DATA[N_ROW_]      Number of local equations
  !  N_COL           MATRIX_DATA[N_COL_]      Number of local variables
  !                     already inserted.
  !  CTXT_A          MATRIX_DATA[CTXT_]     The BLACS context handle, 
  !                                         indicating
  !	  			            the global context of the operation
  !					    on the matrix.
  !					    The context itself is global.
  !
  !  LOC_TO_GLOB     An integer array of dimension equal to number of local
  !                  cols.
  !                  Element i (if >0) contains global identifier of local
  !                  variable i.
  !                  if < 0 then local identifier i is not yet assigned.
  !  GLOB_TO_LOC     Array of dimension equal to number of global 
  !                  cols (MATRIX_DATA[N_]).
  !                  Element i (if >0) contains local identifier of global
  !                  variable i.
  !                  if glob_to_loc(i)==-1 then global variable is not
  !                  yet inserted as equation(row) and as variable(col).
  !                  if glob_to_loc(i)==-2 then global variable is 
  !                  inserted as variable(col) but not as equation(row).
  ! END DECOMP_DATA FIELDS
  !
  !  A              TYPESP
  !                 required
  !  A FIELDS
  !  FIDA         :  (Global Input)character*5
  !                 Describe some caracteristics of final sparse
  !                 matrix rapresentation
  !
  !  DESCRA       :  (Global Input)character*11 
  !                 Contains some additional informations on 
  !                 sparse matrix rappresentation.
  !  ASPK           pointer to d.p. array of dimension equal NNZ
  !                 contains information about entry matrix yet
  !                 inserted.
  !  IA1            pointer to int array of dimension equal NNZ.
  !                 contains information about entry matrix yet
  !                 inserted.
  !  IA2             pointer to int array of dimension equal NNZ
  !                 contains information about entry matrix yet
  !                 inserted.
  !  INFOA           integer array of dimension 10:
  !  INFOA(LTGPN_) indicates the value of last local index assigned
  !  INFOA(ASPK_)  Number of ASPK element yet inserted
  !  INFOA(IA1_)   Number of IA1 element yet inserted
  !  INFOA(IA2_)   Number of IA2 element yet inserted
  !  INFOA(OVR_DIM_) contains the sum for every my overlap points
  !                number of processes which contains.
  ! END A FIELDS
  !
  ! IERRV         Pointer to integer array of dimension 6
  !               contains possible error encountered in previously
  !               call on this procedure. Set in f90_spall.
  !               Required.
  !

  Use TYPEDESC
  Use TYPESP
!  Implicit None
  
  !....PARAMETERS...
  Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
  Type(Z_SPMAT), intent(inout)       ::  A
  Integer, intent(in)                ::  IA,JA
  Type(Z_SPMAT), intent(in)          ::  BLCK
  Integer                            ::  IERRV(:)
  Integer, Optional, intent(in)      ::  IX,JX
  Integer, Optional, intent(in)      ::  UPDFLAG

  !LOCALS.....
    
  Interface
    Subroutine ZCSUPD(M,N,FIDA,DESCRA,A,IA1,IA2,INFOA,IA,JA,&
         & FIDH,DESCRH,H,IH1,IH2,INFOH,IH,JH,&
         & FLAG,GLOB_TO_LOC,IWORK,LIWORK,IERROR)
      Implicit None
      !      .. SCALAR ARGUMENTS ..
      Integer, intent(in) :: M, N, LIWORK,IA,JA,IH,JH, FLAG
      Integer, intent(out) :: IERROR
      !      .. ARRAY ARGUMENTS ..
      complex(kind(1.d0)), intent(in)    :: H(*)
      complex(kind(1.d0)), intent(inout) :: A(*)
      Integer, intent(in) :: IH1(*), IH2(*), INFOH(10), GLOB_TO_LOC(*)
      Integer, intent(inout) :: IA1(*), IA2(*), INFOA(10), IWORK(*)
      Character, intent(in)  :: FIDA*5, FIDH*5,DESCRA*11, DESCRH*11
      
    End Subroutine ZCSUPD
  End Interface
  
  Integer :: ICONTXT,I,LOC_ROW,PREC_LOC_ROW,NPROCS ,GLOB_ROW,ROW&
       & ,ASPK_POINTER,IA1_POINTER,IA2_POINTER,K ,START_ROW,END_ROW&
       & ,FIRST_LOC_ROW,N_ROW,J, IERROR,LOCIX,LOCJX,IK,LTG_POINTER&
       & ,APP_ASPK_POINTER,INFO,ALLOCATED_PRCV, dectype, FLAG
  Integer,Pointer        :: PRCV(:),GTL(:), LTG(:)
  Integer                :: NPROW,NPCOL, ME ,MYPCOL, LR, LC, NROW,NCOL
  Integer                   ::  M,N, IUPDFLAG
  Character            :: TEMP_DESCRA*11, TEMP_FIDA*5
  Integer,Pointer           ::  IWORKAUX(:)    
   
!!$  If ((.Not.Associated(IERRV)).OR.(Size(IERRV).LT.6)) Then
!!$     Write (0,*) 'ERROR: IERRV IS NOT ASSOCIATED'
!!$     Goto 9999
!!$  Endif

  
  ! CHECK IF THERE WAS ERRORS
  If (IERRV(1).NE.0) Goto 9999

  If (Present(IX)) Then
     LOCIX=IX
  Else
     LOCIX=1
  Endif

  If (Present(UPDFLAG)) Then
    IUPDFLAG = UPDFLAG
  Else
    IUPDFLAG = UPD_GLB
  Endif
  
  If (Present(JX)) Then
     LOCJX=JX
  Else
     LOCJX=1
  Endif
  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)

  ! CHECK ON BLACS GRID 
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  If (NPCOL.NE.1) Then
     IERRV(1)= 2030
     IERRV(2)= NPCOL
     Goto 9999
  Endif
  INFO=0
  GTL => DECOMP_DATA%GLOB_TO_LOC
  LTG => DECOMP_DATA%LOC_TO_GLOB
  NROW = DECOMP_DATA%MATRIX_DATA(N_ROW_)
  NCOL = DECOMP_DATA%MATRIX_DATA(N_COL_)
  DECTYPE = DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)
  ! CHECK IF A IS ALREADY ALLOCATED (CALLED PSDALLOC)
  If (.not.is_upd_dec(DECTYPE)) Then
     IERRV(1) = 290
     ierrv(2) = dectype
     Goto 9999
  Endif
  Allocate(PRCV(NPROW),IWORKAUX(3*NCOL+4),STAT=INFO)
  If (INFO.NE.0) Then
    IERRV(1)=2023
    IERRV(2)=MAX(1,NPROW,3*NCOL+4)
    GOTO 9999
  ENDIF
  
  FLAG = 2

  M = BLCK%M
  N = BLCK%K

  IF (IUPDFLAG == UPD_GLB) THEN 

    ROW = IA
    I   = 1
    Do While (I.LE.M)
      !LOOP OVER ALL BLCK'S ROWS

      ! ROW ACTUAL BLOCK ROW 
      ROW      = LOCIX+I-1
      GLOB_ROW = IA+I-1

      LR = GTL(GLOB_ROW)

      IF ((1 <= LR) .AND. (LR <= NROW)) THEN
        ! At least one row belongs to me 

        START_ROW=ROW
        Do 
          ! LOOP UNTIL ACTUAL ROW BELONG TO ME
          ! AND ALL ACTUAL ROW TO INSERT ARE ORDERED

          PREC_LOC_ROW=LOC_ROW

          ! --IF  LOC_ROW IS != -1 IS ALREADY ASSIGNED
          !   LOCAL INDEX TO GLOBROW WHITH VALUE LOC_ROW
          ! --IF LOC:ROW == -1 IT ISN'T ASSIGNED LOCAL ROW TO
          !   GLOB_ROW
          LOC_ROW=GTL(GLOB_ROW)
          If (START_ROW.EQ.I) FIRST_LOC_ROW=LOC_ROW
          ! NEXT BLCK'S ROW
          I=I+1
          If (I.LE.M) Then
            ROW=LOCIX+I-1
            GLOB_ROW=IA+I-1
            K = GTL(GLOB_ROW)
            If ((.NOT.((1 <= LR) .AND. (LR <= NROW)))&
                 & .OR.((PREC_LOC_ROW+1.NE.LOC_ROW).AND.&
                 & (START_ROW+1.NE.I)).OR.(I.GT.M)) Exit
          Else
            Exit
          Endif
        Enddo

        END_ROW=I-1
        ! INSERT BLCK SUBMATRIX
        IERROR = 0
        Call ZCSUPD(END_ROW-START_ROW+1,N,A%FIDA,A%DESCRA,A%ASPK,&
       	        & A%IA1,A%IA2,A%INFOA,FIRST_LOC_ROW, JA, BLCK%FIDA ,&
		& BLCK%DESCRA,BLCK%ASPK,BLCK&
 		& %IA1,BLCK%IA2,BLCK%INFOA,START_ROW, LOCJX, FLAG,&
		& DECOMP_DATA%GLOB_TO_LOC,&
		& IWORKAUX, Size(IWORKAUX),IERROR)
        
	If (IERROR.NE.0) Then
           IERRV(1) = IERROR
           Goto 9999
        Endif
      Endif
      ! NEXT BLCK'S ROW
      I=I+1
    Enddo
  ELSE IF (IUPDFLAG == UPD_LOC) THEN

    ! INSERT BLCK SUBMATRIX
    IERROR = 0
    Call ZCSUPD(M,N,A%FIDA,A%DESCRA,A%ASPK,&
         & A%IA1,A%IA2,A%INFOA,IA, JA, BLCK%FIDA ,&
         & BLCK%DESCRA,BLCK%ASPK,BLCK&
         & %IA1,BLCK%IA2,BLCK%INFOA,LOCIX,LOCJX, FLAG,&
         & DECOMP_DATA%GLOB_TO_LOC,&
         & IWORKAUX, Size(IWORKAUX),IERROR)
    
    If (IERROR.NE.0) Then
      IERRV(1) = IERROR
      Goto 9999
    Endif
  else
    ! Fix next error code
    ierrv(1) = 999
    goto 9999
  endif
  Deallocate(PRCV,IWORKAUX,STAT=INFO)
  If (INFO.NE.0) IERRV(1)=2040
     
9999 Continue

Return
End Subroutine PSZSPUPDATE








