! ---------------------------------------------------------------------
!
!  -- PSSBLAS routine (version 1.0) --
!
!  ---------------------------------------------------------------------
!/
Subroutine PSZSPREINIT(A,  IERRV, DECOMP_DATA)
  
  !  Purpose
  !  =======
  !  
  !  Reinit sparse matrix structure for psblas routines.....
  !
  !
  ! INPUT
  !======
  !
  ! A            :  TYPE_SP
  ! A INPUT FIELDS:
  ! FIDA         :  (Global Input)character*5
  !                 Describe some caracteristics of final sparse
  !                 matrix rapresentation
  !
  ! DESCRA       :  (Global Input)character*11 
  !                 Contains some additional informations on 
  !                 sparse matrix rappresentation.
  !
  ! END OF A INPUT FIELDS
  !
  !
  ! OUTPUT
  !=========
  ! DECOMP_DATA   : TYPEDESC
  ! DECOMP_DATA OUTPUT FIELDS:
  !
  ! MATRIX_DATA   : Pointer to integer Array 
  !                contains some
  !               local and global information about matrix:
  !
  !  NOTATION        STORED IN		     EXPLANATION
  !  ------------ ---------------------- -------------------------------------
  !  DEC_TYPE        MATRIX_DATA[DEC_TYPE_]   Decomposition type, temporarly is
  !                      setted to 1( matrix not yet assembled)
  !  M 	             MATRIX_DATA[M_]          Total number of equations
  !  N 	             MATRIX_DATA[N_]          Total number of variables
  !  N_ROW           MATRIX_DATA[N_ROW_]      Number of local equations
  !  N_COL           MATRIX_DATA[N_COL_]      Number of local variables,
  !                     temporary setted to 0.
  !  CTXT_A          MATRIX_DATA[CTXT_]     The BLACS context handle, 
  !                                         indicating
  !	  			            the global context of the operation
  !					    on the matrix.
  !					    The context itself is global.
  !
  !  LOC_TO_GLOB     An array of dimension equal to number of local
  !                  cols, its output dimension is MATDATA_A[N_ROW_]*(COLROW_+1)
  !                  (estimation). all element are setted to -1.
  !  GLOB_TO_LOC     Array of dimension equal to number of global 
  !                  cols (MATRIX_DATA[N_])(estime). all element are setted to
  !                  -1.
  !  other fields are not allocated.
  !
  ! END OF DECOMP_DATA OUTPUT FIELDS
  !
  !
  ! A            :  TYPE_SP
  !                 contains informations about local sparse matrix
  !  A OUPUT FIELDS:
  !  ASPK            pointer to d.p. array of dimension equal NNZ (if specified)
  !                  if it is not possible to know No. of locals NNZ element
  !                  its dimension will be a guess.
  !  IA1             pointer to int array of dimension equal NNZ (if specified)
  !                  if it is not possible to know No. of locals NNZ element
  !                  its dimension will be a guess.
  !  IA2             pointer to int array of dimension equal NNZ (if specified)
  !                  if it is not possible to know No. of locals NNZ element
  !                  its dimension will be a guess.
  !  INFOA           integer array of dimension 10:
  !  INFOA(LTGPN_) setted to zero, indicates the value of last local index,
  !                assigned
  !  INFOA(ASPK_)  setted to zero, Pointer to A%aspk array
  !  INFOA(IA1_)   setted to zero, Pointer to A%IA1 array
  !  INFOA(IA2_)   setted to zero, Pointer to A%IA2 array
  !  INFOA(OVR_DIM_) contains the sum for every my overlap points
  !                number of processes which contains it setted to No of local
  !                overlap points
  !
  ! END OF A OUTPUT FIELDS
  !
  !  IERRV         : pointer to integer array of dimension 6
  !                  will contains information about possibles errors
  !                  encounterd in pszspins procedure.
  !                  IERRV(1) are setted to 0 (no errors).
  
  Use TYPEDESC
  Use TYPESP
  Use TOOLS_CONST
!  Implicit None
  !....Parameters...
  Type(DECOMP_DATA_TYPE), intent(inout) :: DECOMP_DATA
  Type(Z_SPMAT), intent(inout)          :: A
  Integer                ::IERRV(:)

  !locals
  Integer             :: ICONTXT
  Integer             :: COUNTER,I,J,NPROW,NPCOL,ME,MYPCOL,INFO,&
       &    LOC_ROW,RES,LENGTH_IA1,LENGTH_IA2,ERR,LOC_COL,NPROCS,OVR_COUNTER
  Integer             :: INT_ERR(5),TEMP(1),EXCH(2)
  Real(Kind(1.d0))    :: REAL_ERR(5)
  Integer, Parameter  :: IONE=1, ITWO=2,ROOT=0
  Integer, Pointer    :: PRC_V(:)
  logical, parameter  :: debug=.false.

  INFO=0
  ICONTXT = DECOMP_DATA%MATRIX_DATA(CTXT_)
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  if (debug) &
       &write(*,*) 'Starting spalloc ',icontxt,nprow,npcol,me
  
!     ....Verify BLACS Grid correctness..
  If (NPCOL.NE.1) Then
     INFO = 2030
     INT_ERR(1) = NPCOL
  Endif
  ERR = INFO
  if (debug) &
       &write(*,*) 'Starting spalloc ',icontxt,nprow,npcol,me
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE, TEMP, TEMP,&
       & -IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999

  if (debug) &
       &write(*,*) 'Got through IGAMX2D '

  ! allocate IERRV vector
!!$  If (Associated(IERRV)) Then
!!$    if (debug) &
!!$         &write(*,*) 'IERRV: ', size(ierrv)
!!$    If (Size(IERRV).LT.6) Then
!!$      deallocate(ierrv)
!!$      Nullify(IERRV)
!!$      Allocate(IERRV(6),STAT=INFO)
!!$      If (INFO.NE.0) Then
!!$        INFO=2023
!!$        INT_ERR(1)=6
!!$      Endif
!!$    End If
!!$  Else
!!$     Allocate(IERRV(6),STAT=INFO)
!!$     If (INFO.NE.0) Then
!!$	INFO=2023
!!$	INT_ERR(1)=6
!!$     Endif
!!$  Endif

  IF (.not.is_asb_dec(DECOMP_DATA%MATRIX_DATA(DEC_TYPE_))) THEN
     INFO=590     
  ENDIF
  
  ERR = INFO
  
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE, TEMP,&
       & TEMP, -IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999

  IERRV(1) = 0
  !
  ! Hmm, Not a good idea. We really need Fortran 95 null() initialization;
  ! for now we just rely on documentation. 
  !
  A%ASPK(:) = (0.0,0.0)
  if (ibits(a%infoa(upd_),1,1)==1) then 
    a%ia2(a%infoa(upd_pnt_)+nnz_) = 0
  endif
  DECOMP_DATA%MATRIX_DATA(DEC_TYPE_) = SP_MAT_UPD
  Return
    
9999 Call PSDERROR( ICONTXT, INFO, 'F90_SPALL\0', INT_ERR, REAL_ERR )

End Subroutine PSZSPREINIT
