! ---------------------------------------------------------------------
!
!  -- PSSBLAS routine (version 1.0) --
!
!  ---------------------------------------------------------------------
!
Subroutine PSZSPCNV(A,B,IERRV,DECOMP_DATA)
  !  Purpose
  !  =======
  !  
  !   Converts sparse matrix A into B
  !
  ! INPUT
  !====== 
  !  IERRV     Pointer to integer array of dimension 6
  !            contains possible error encountered in previously
  !            call on psdspins procedure. Setted in f90_spall.
  !            Required.

  ! INPUT/OUTPUT
  !==============
  ! DECOMP_DATA TYPEDESC
  !             required
  ! DECOMP_DATA FIELDS
  !
  ! MATRIX_DATA   : Pointer to integer Array 
  !                contains some
  !               local and global information about matrix:
  !
  !  NOTATION        STORED IN		     EXPLANATION
  !  ------------ ---------------------- -------------------------------------
  !  DEC_TYPE        MATRIX_DATA[DEC_TYPE_]   Decomposition type, temporarly is
  !                      setted to 1( matrix not yet assembled)
  !  M 	             MATRIX_DATA[M_]          Total number of equations
  !  N 	             MATRIX_DATA[N_]          Total number of variables
  !  N_ROW           MATRIX_DATA[N_ROW_]      Number of local equations
  !  N_COL           MATRIX_DATA[N_COL_]      Number of local variables
  !                     already inserted.
  !  CTXT_A          MATRIX_DATA[CTXT_]     The BLACS context handle, 
  !                                         indicating
  !	  			            the global context of the operation
  !					    on the matrix.
  !					    The context itself is global.
  !
  !  LOC_TO_GLOB     Integer array of dimension equal to local
  !                  cols.
  !                  Element i (if >0) contains global identifier of local
  !                  variable i.
  !                  if < 0 then local identifier i is not yet assigned.
  !  GLOB_TO_LOC     Integer Array of dimension equal to global 
  !                  cols (MATRIX_DATA[N_]).
  !                  Element i (if >0) contains local identifier of global
  !                  variable i.
  !  HALO_INDEX      pointer to integer array
  !             EXPLANATION
  !  Let HALO_INDEX_P be the array DESC_HALO for local process.
  !  This is composed of variable dimension blocks for each process to 
  !  communicate to.
  !  Each block contain indexes of local halo elements to exchange with other 
  !  process.
  !  Let P be the pointer to the first element of a block in HALO_INDEX_P.
  !  This block is stored in HALO_INDEX_P as :
  !
  !  NOTATION        STORED IN		          EXPLANATION
  !  --------------- --------------------------- -----------------------------------
  !  PROCESS_ID      HALO_INDEX_P[P+PROC_ID_]      Identifier of process which exchange
  !						  data with.
  !  N_ELEMENTS_RECV HALO_INDEX_P[P+N_ELEM_RECV_]  Number of elements to receive.
  !  ELEMENTS_RECV   HALO_INDEX_P[P+ELEM_RECV_+i]  Indexes of local elements to
  !					          receive. These are stored in the
  !					          array from location P+ELEM_RECV_ to
  !					          location P+ELEM_RECV_+
  !						  HALO_INDEX_P[P+N_ELEM_RECV_]-1.
  !  N_ELEMENTS_SEND HALO_INDEX_P[P+N_ELEM_SEND_]  Number of elements to send.
  !  ELEMENTS_SEND   HALO_INDEX_P[P+ELEM_SEND_+i]  Indexes of local elements to
  !					          send. These are stored in the
  !					          array from location P+ELEM_SEND_ to
  !					          location P+ELEM_SEND_+
  !						  HALO_INDEX_P[P+N_ELEM_SEND_]-1.
  !  OVRLAP_INDEX      pointer to integer array
  !             EXPLANATION
  !
  !  Let DESCOVRLP_P be the array DESC_OVRLAP for local process.
  !  This is composed of variable dimension blocks for each process to 
  !  communicate to.
  !  Each block contain indexes of local overlap elements to exchange with
  !  other process.
  !  Let P be the pointer to the first element of a block in DESCOVRLP_P.
  !  This block is stored in DESCOVRLP_P as :
  !
  !  NOTATION        STORED IN		            EXPLANATION
  !  ------------- ------------------------------- -----------------------------------
  !  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
  !						   data with.
  !  N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
  !  OVRLAP_RECV   DESCOVRLP_P[P+ELEM_RECV_+i]     Indexes of local elements to
  !					           receive. These are stored in the
  !					           array from location P+OVRLP_ELEM_ to
  !					           location P+OVRLP_ELEM_+
  !						   DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
  !  OVRLAP_SEND   DESCOVRLP_P[P+ELEM_SEND_+i]     Indexes of local elements to
  !					           send.These are stored in the
  !					           array from location P+ELEM_SEND_ to
  !					           location P+ELEM_SEND_+
  !						   DESCOVRLP_P[P+N_ELEM_SEND_]-1.
  !
  !
  !  Let OVR_ELEM_P be the array OVERLAP_ELEM for local process.
  !  This is composed of blocks of two elements. The block
  !  corresponding to the i-th overlapped elements, begin at index 
  !  P = i*2 in array OVR_ELEM_P.
  !  This block is stored in OVR_ELEM_P as :
  !
  !  NOTATION      STORED IN		       EXPLANATION
  !  ------------- -------------------------- ----------------------------------
  !  OVRLAP_ELEM   OVR_ELEM_P[P+OVRLP_ELEM_]  The index of local overlapped 
  !					       element.
  !  N_DOMAINS     OVR_ELEM_P[P+N_DOM_OVR_]   The number of copies of
  !					       local overlapped element.
  ! END DECOMP_DATA FIELDS
  !  A              TYPESP
  !                 required
  !  A FIELDS
  !  FIDA         : character*5
  !                 Describe some caracteristics of final sparse
  !                 matrix rapresentation
  !
  !  DESCRA       : character*11 
  !                 Contains some additional informations on 
  !                 sparse matrix rappresentation.
  !  ASPK           pointer to d.p. array of dimension equal NNZ
  !                 contains information about entry matrix 
  !                 inserted.
  !  IA1            pointer to int array of dimension equal NNZ.
  !                 contains information about entry matrix yet
  !                 inserted.
  !  IA2             pointer to int array of dimension equal NNZ
  !                 contains information about entry matrix yet
  !                 inserted.
  !  PL             Integer pointer to array of dimension 1.
  !                 PL(1) is setted to 0 (No left permutation).
  !  PR             Integer pointer to array of dimension 1.
  !                 PR(1) is setted to 0 (No right permutation).
  !  INFOA          integer array of dimension 10
  !
  ! END A FIELDS
  Use TYPEDESC
  Use TYPESP
  Use TOOLS_CONST
  !  Implicit None
  interface zcsdp

    subroutine zcsdp(CHECK,TRANS,M,N,UNITD,D,&
         & FIDA,DESCRA,A,IA1,IA2,INFOA,&
         & PL,FIDH,DESCRH,H,IH1,IH2,INFOH,PR,LH,LH1,LH2,&
         & WORK,LWORK,IERROR)
      INTEGER, intent(in)   :: LH, LWORK, LH1, LH2, M, N                 
      INTEGER, intent(out)  :: IERROR                 
      CHARACTER, intent(in) :: CHECK, TRANS, UNITD                               
      COMPLEX(KIND(1.D0)), intent(in)  :: D(*), A(*)
      COMPLEX(KIND(1.D0)), intent(out) :: H(*)
      COMPLEX(KIND(1.D0)), intent(inout) :: WORK(*)
      INTEGER, intent(in)  :: IA1(*), IA2(*), INFOA(*)
      INTEGER, intent(out) :: IH1(*), IH2(*), PL(*),PR(*), INFOH(*) 
      CHARACTER, intent(in) ::  FIDA*5, DESCRA*11
      CHARACTER, intent(out) :: FIDH*5, DESCRH*11
    end SUBROUTINE ZCSDP
  END interface


  interface zcsrp

     SUBROUTINE ZCSRP(TRANS,M,N,FIDA,DESCRA,IA1,IA2,&
          & INFOA,P,WORK,LWORK,IERROR)
       INTEGER, intent(in)  :: M, N, LWORK
       INTEGER, intent(out) :: IERROR
       CHARACTER, intent(in) ::       TRANS
       COMPLEX(KIND(1.D0)), intent(inout) :: WORK(*)                     
       INTEGER, intent(in)    :: P(*)
       INTEGER, intent(inout) :: IA1(*), IA2(*), INFOA(*) 
       CHARACTER, intent(in)  :: FIDA*5, DESCRA*11
     end SUBROUTINE ZCSRP
  END interface

  interface zcsprt
    subroutine zcsprt(M,N,FIDA,DESCRA,A,IA1,IA2,INFOA ,IOUT,IERROR)
      INTEGER, intent(in)  ::  IOUT,M, N                 
      INTEGER, intent(out) ::  IERROR                 
      COMPLEX(KIND(1.D0)), intent(in) :: A(*)
      INTEGER, intent(in)   :: IA1(*), IA2(*), INFOA(*)
      CHARACTER, intent(in) :: FIDA*5, DESCRA*11
    end SUBROUTINE ZCSPRT
  END interface

  !...Parameters....
  Type(Z_SPMAT), intent(in)          :: A
  Type(Z_SPMAT), intent(out)         :: B
  Type(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
  Integer           	          :: IERRV(:)
  !....Locals....
  Integer                       ::  INT_ERR(5),P(1),INFOA(10)
  Integer,Pointer      ::  OVRLAP_ELEM(:),OVRLAP_INDEX(:)&
       & ,HALO_INDEX(:)
  Real(Kind(1.d0))              ::  REAL_ERR(5)
  complex(Kind(1.d0))           ::  D(1)
  Integer,Pointer               ::  I_TEMP(:), IA1(:),IA2(:),&
       & WORK_ASBX(:),WORK5(:),PT(:)
  complex(Kind(1.d0)),Pointer   ::  ASPK(:), WORK_ZCSDP(:)
  Integer                       ::  IA1_SIZE,IA2_SIZE,ASPK_SIZE,INFO&
       & ,I,ERR,NPROW,NPCOL,ME,MYPCOL ,SIZE_REQ,SIZE_MTRX_DATA&
       & ,IERROR ,lovrlap,lhalo,nhalo,novrlap,MAX_SIZE,MAX_SIZE1&
       & ,MAX_HALO,lovrlap_elem,size_req1,N_COL,l_zcsdp, iout
  Integer                       :: ALLOCATED_WORK5
  Character                     :: FIDA*5, DESCRA*11
  Integer                       :: LWORK_ZCSDP,LWORK5,LDESC_HALO,&
       &L_ASBX,LDESC_OVRLAP, DECTYPE
  Integer                       :: ICONTXT,TEMP(1),N_ROW,IOVERLAP
  Character                     :: CHECK*1, TRANS*1, UNITD*1
  Integer, Parameter            :: IONE=1
  Character                     :: NAME*20

  Real(Kind(1.d0))              :: TIME(10), MPI_WTIME
  External MPI_WTIME
  logical, parameter :: debug=.false.

  TIME(1) = MPI_WTIME()


  ICONTXT = DECOMP_DATA%MATRIX_DATA(CTXT_)
  DECTYPE = DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)
  N_ROW   = DECOMP_DATA%MATRIX_DATA(N_ROW_)
  N_COL   = DECOMP_DATA%MATRIX_DATA(N_COL_)
     
  INFO=0
  NAME = 'F90_PSSPCNV'
  ! check on BLACS grid 
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  If (NPROW.EQ.-1) Then
     INFO = 2010
     Goto 9999
  Else If (NPCOL.NE.1) Then
     INFO = 2030
     INT_ERR(1) = NPCOL
  Endif

  IF (.not.is_ok_dec((DECTYPE))) then
     INFO = 600
     INT_ERR(1) = dectype
     if (debug) write(0,*) name,' Dectype 1 :',dectype,sp_mat_bld,&
          &sp_mat_asb,sp_mat_upd
  ENDIF

  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,&
       &TEMP ,TEMP,-IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999

  if (debug) Write (0, *) name,'   Begin matrix assembly...'


  
  IA1_SIZE  = SIZE(A%IA1)
  IA2_SIZE  = SIZE(A%IA2)
  ASPK_SIZE = SIZE(A%ASPK)

  If (debug) Write (0, *) name,'  Sizes',ia1_size,ia2_size,aspk_size

  
  
  ! convert only without check
  CHECK='N'
  TRANS='N'
  UNITD='U'
  
  ! L_ZCSDP is the size requested for zcsdp procedure
  L_ZCSDP=(IA1_SIZE+100)
  
  Allocate(b%aspk(aspk_size),b%ia1(ia1_size),b%ia2(ia2_size),&
       &WORK_ZCSDP(L_ZCSDP),STAT=INFO)
  If (INFO.NE.0) Then
    INFO=2025
    INT_ERR(1)=L_ZCSDP
  Endif
  IF (INFO.EQ.0) THEN
    Allocate(B%PL(N_ROW),B%PR(N_COL),STAT=INFO)
    If (INFO.NE.0) Then
      INFO=2025
      INT_ERR(1)=N_ROW
    Endif
  end IF
  ! check on allocation
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,&
       &TEMP,TEMP,-IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999
  
  LWORK_ZCSDP=Size(WORK_ZCSDP)
  ! set INFOA(1) to NNZERO
  B%PL(:)  = 0
  B%PR(:)  = 0
  IERROR   = 0
  If (debug) Write (0, *) name,'  Calling ZCSDP',lwork_zcsdp,&
       &size(work_zcsdp)
  ! convert ASPK,IA1,IA2 in requested representation mode
  if (debug) then
!!$    iout = 30+me
!!$    
!!$    write(*,*) 'IOUT ',iout
!!$    call zcsprt(N_ROW,N_COL,FIDA,DESCRA,ASPK,IA1,&
!!$         & IA2,INFOA,iout,ierror)
  endif
  ! result is put in B
  CALL ZCSDP(CHECK,TRANS,N_ROW,N_COL,UNITD,D,A%FIDA,A%DESCRA,&
       & A%ASPK,A%IA1,A%IA2,A%INFOA,&
       & B%PL,B%FIDA,B%DESCRA,B%ASPK,B%IA1,B%IA2,B%INFOA,B%PR,&
       & SIZE(B%ASPK),SIZE(B%IA1),SIZE(B%IA2),&
       & WORK_ZCSDP,SIZE(WORK_ZCSDP),IERROR)

!
!  Hmmm, have to fix B%PL and B%PR according to A%PL and A%PR!!! 
!  Should work (crossed fingers :-)
  if (a%pr(1).ne.0) then 
    if (b%pr(1).ne.0) then 
      ALLOCATE(I_TEMP(n_col))
      do i=1,  n_col
        i_temp(i) = b%pr(a%pr(i))
      enddo
      deallocate(b%pr)
      b%pr => i_temp
    else
      ALLOCATE(I_TEMP(n_col))
      do i=1,  n_col
        i_temp(i) = a%pr(i)
      enddo
      deallocate(b%pr)
      b%pr => i_temp
    endif
  endif
  if (a%pl(1).ne.0) then 
    if (b%pr(1).ne.0) then 
      ALLOCATE(I_TEMP(n_row))
      do i=1,  n_row
        i_temp(i) = a%pl(b%pl(i))
      enddo
      deallocate(b%pl)
      b%pl => i_temp
    else
      ALLOCATE(I_TEMP(n_row))
      do i=1,  n_row
        i_temp(i) = a%pl(i)
      enddo
      deallocate(b%pl)
      b%pl => i_temp
    endif
  endif


  If (debug) Write (0, *) me,name,'  From ZCSDP',ierror,' ',&
       &B%FIDA,' PL ', b%pl(:),'PR',b%pr(:)
  
  ! check on error retuned by zcsdp
  If (IERROR.NE.0) Then
    INFO=1040
    INT_ERR(1)=IERROR
  Endif
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR,IONE,&
       &TEMP ,TEMP,-IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999
  if (debug) then
!!$        iout = 60+me
!!$
!!$        write(*,*) 'IOUT ',iout
!!$        call zcsprt(N_ROW,N_COL,A%FIDA,A%DESCRA,A%ASPK,A%IA1,&
!!$             & A%IA2,A%INFOA,iout,ierror)
  endif
  
  If (debug) Write (0, *) me,name,'  returning...'
  Return
9999 Call PSDERROR( ICONTXT, INFO, NAME, INT_ERR, REAL_ERR )
End Subroutine PSZSPCNV
