Subroutine PSZGELP(TRANS,IPERM,X,DECOMP_DATA)
  !....Assembly dense matrix X .....
  Use TYPEDESC
  Use TYPESP
  Use TOOLS_CONST
  Use F90PSBLAS
!  Implicit None

  Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
  Complex(Kind(1.D0)), intent(inout) ::  X(:,:)
  Integer, intent(inout)             ::  IPERM(:)
  character, intent(in)              :: trans

  ! Local variables
  Integer :: IERROR, ERR, ICONTXT,NPROW,NPCOL,ME,MYPCOL,TEMP,LWORK,NROW,NCOL
  Complex(Kind(1.D0)),POINTER ::  DTEMP(:)
  Integer :: INT_ERR(5), i1sz, i2sz, dectype, i
  Double Precision :: REAL_ERR(5)
  Character :: NAME*20, itrans
  Integer, Parameter  :: IONE=1
  COMPLEX(KIND(1.d0)),parameter    :: ONE=1
  logical, parameter :: debug=.false.

  interface 
    SUBROUTINE ZGELP(TRANS,M,N,P,B,LDB,WORK,LWORK,IERROR)
      INTEGER, intent(in)  :: LDB, M, N, LWORK
      INTEGER, intent(out) :: IERROR
      CHARACTER, intent(in) :: TRANS
      COMPLEX(KIND(1.D0)), intent(inout) ::  B(LDB,*), WORK(*)
      INTEGER, intent(in)  :: P(*)
    end SUBROUTINE ZGELP
  end interface

  interface isaperm

    logical function isaperm(N,IP)
      INTEGER, intent(in)    :: N   
      INTEGER, intent(inout) :: IP(*)
    end function isaperm
  END interface
  
  IERROR = 0
    
  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
  DECTYPE=DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)
  NROW    = DECOMP_DATA%MATRIX_DATA(N_ROW_)
  NCOL    = DECOMP_DATA%MATRIX_DATA(N_COL_)
  i1sz    = size(x,dim=1)
  i2sz    = size(x,dim=2)
  
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  
  NAME = 'F90_PSGELP'
  if (debug) write(*,*) 'ASB Start: ',nprow,npcol,me,&
       &sp_mat_asb,DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)
  !     ....Verify BLACS Grid correctness..
  If (NPROW.EQ.-1) Then
    IERROR = 2010
    Goto 9999
  Else If (NPCOL.NE.1) Then
    IERROR = 2030
    INT_ERR(1) = NPCOL
  Else If (.NOT.is_asb_dec(DECTYPE)) Then
    if (debug) write(*,*) 'ASB error ',&
         &sp_mat_asb,dectype
    IERROR = 3110
  Endif


  if (.not.isaperm(i1sz,iperm)) then
    INFO = 70
    INT_ERR(1) = 1      
  endif

   

  ERR = IERROR
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,&
       &TEMP, TEMP,-IONE ,-IONE,-IONE)

  If (ERR.NE.0) Goto 9999

  if (debug) write(*,*) 'ASB: ',i1sz,i2sz,nrow,ncol
  allocate(dtemp(i1sz),stat=info)

  call zgelp(trans,i1sz,i2sz,iperm,x,i1sz,dtemp,i1sz,ierror)

  deallocate(dtemp)
  Return
  
9999 Call PSDERROR( ICONTXT, IERROR, NAME, INT_ERR, REAL_ERR )
  
End Subroutine PSZGELP



SUBROUTINE PSZGELPV(TRANS,IPERM,X,DECOMP_DATA)
  !....Assembly dense matrix X .....
  Use TYPEDESC
  Use TYPESP
  Use TOOLS_CONST
  USE F90PSBLAS
  Implicit None

  Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
  Complex(Kind(1.D0)), intent(inout) ::  X(:)
  Integer, intent(inout)             ::  IPERM(:)
  character, intent(in)              :: trans

  ! Local variables
  Integer :: IERROR, ERR, ICONTXT,NPROW,NPCOL,ME,MYPCOL,TEMP,LWORK
  Integer :: INT_ERR(5), i1sz,nrow,ncol,info, dectype, i
  Complex(Kind(1.D0)),POINTER ::  dtemp(:)
  real(kind(1.d0)) :: REAL_ERR(5)
  Character :: NAME*20, itrans
  Integer, Parameter  :: IONE=1  
  COMPLEX(KIND(1.d0)),parameter    :: ONE=1
  logical, parameter :: debug=.false.

  interface 
    SUBROUTINE ZGELP(TRANS,M,N,P,B,LDB,WORK,LWORK,IERROR)
      INTEGER, intent(in)  :: LDB, M, N, LWORK
      INTEGER, intent(out) :: IERROR
      CHARACTER, intent(in) :: TRANS
      COMPLEX(KIND(1.D0)), intent(inout) ::  B(LDB,*), WORK(*)
      INTEGER, intent(in)  :: P(*)
    end SUBROUTINE ZGELP
  end interface

  interface isaperm

    logical function isaperm(N,IP)
      INTEGER, intent(in)    :: N   
      INTEGER, intent(inout) :: IP(*)
    end function isaperm
  END interface
  

  IERROR = 0
  i1sz = size(x)

  NAME = 'F90_GELP'
  if (debug) write(0,*) name,trans,i1sz
  
  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
  DECTYPE=DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)
  NROW=DECOMP_DATA%MATRIX_DATA(N_ROW_)
  NCOL=DECOMP_DATA%MATRIX_DATA(N_COL_)

  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)

  !     ....Verify BLACS Grid correctness..
  If (NPROW.EQ.-1) Then
     IERROR = 2010
     Goto 9999
  Else If (NPCOL.NE.1) Then
     IERROR = 2030
     INT_ERR(1) = NPCOL
  Else If (.not.is_asb_dec(dectype)) Then
     IERROR = 3110
  Endif

  if (debug) write(0,*) 'Calling isaperm ',i1sz,size(iperm),trans
  
  if (.not.isaperm(i1sz,iperm)) then
    INFO = 70
    INT_ERR(1) = 1      
  endif

  ERR = IERROR
  if (debug) write(0,*) name,' Error so far',err
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,&
       &TEMP, TEMP, -IONE ,-IONE,-IONE)
  allocate(dtemp(i1sz),stat=info)

  call zgelp(trans,i1sz,1,iperm,x,i1sz,dtemp,i1sz,ierror)

  deallocate(dtemp)
  Return
  
9999 Call PSDERROR( ICONTXT, IERROR, NAME, INT_ERR, REAL_ERR )
  
End Subroutine PSZGELPV

