! ---------------------------------------------------------------------
!
!  -- PSSBLAS routine (version 1.0) --
!
!  ---------------------------------------------------------------------
!
Subroutine PSZCSRP(TRANS,IPERM,A, DECOMP_DATA)
  !  Purpose
  !  =======
  !  
  !   Apply a right permutation to a sparse matrix, i.e. permute the column 
  !   indices. 
  !
  ! INPUT
  !====== 
  !  TRANS     Whether IPERM or its transpose should be applied            
  !  IPERM     A permutation vector; its size must be either N_ROW or N_COL
  !            (see below)
  !            Required.
  !
  ! INPUT/OUTPUT
  !==============
  ! DECOMP_DATA TYPEDESC
  !             required
  ! DECOMP_DATA FIELDS
  !
  ! MATRIX_DATA   : Pointer to integer Array 
  !                contains some
  !               local and global information about matrix:
  !
  !  NOTATION        STORED IN		     EXPLANATION
  !  ------------ ---------------------- -------------------------------------
  !  DEC_TYPE        MATRIX_DATA[DEC_TYPE_]   Decomposition type, temporarly is
  !                      setted to 1( matrix not yet assembled)
  !  M 	             MATRIX_DATA[M_]          Total number of equations
  !  N 	             MATRIX_DATA[N_]          Total number of variables
  !  N_ROW           MATRIX_DATA[N_ROW_]      Number of local equations
  !  N_COL           MATRIX_DATA[N_COL_]      Number of local variables
  !                     already inserted.
  !  CTXT_A          MATRIX_DATA[CTXT_]     The BLACS context handle, 
  !                                         indicating
  !	  			            the global context of the operation
  !					    on the matrix.
  !					    The context itself is global.
  !
  !  LOC_TO_GLOB     Integer array of dimension equal to local
  !                  cols.
  !                  Element i (if >0) contains global identifier of local
  !                  variable i.
  !                  if < 0 then local identifier i is not yet assigned.
  !  GLOB_TO_LOC     Integer Array of dimension equal to global 
  !                  cols (MATRIX_DATA[N_]).
  !                  Element i (if >0) contains local identifier of global
  !                  variable i.
  !  HALO_INDEX      pointer to integer array
  !             EXPLANATION
  !  Let HALO_INDEX_P be the array DESC_HALO for local process.
  !  This is composed of variable dimension blocks for each process to 
  !  communicate to.
  !  Each block contain indexes of local halo elements to exchange with other 
  !  process.
  !  Let P be the pointer to the first element of a block in HALO_INDEX_P.
  !  This block is stored in HALO_INDEX_P as :
  !
  !  NOTATION        STORED IN		          EXPLANATION
  !  --------------- --------------------------- -----------------------------------
  !  PROCESS_ID      HALO_INDEX_P[P+PROC_ID_]      Identifier of process which exchange
  !						  data with.
  !  N_ELEMENTS_RECV HALO_INDEX_P[P+N_ELEM_RECV_]  Number of elements to receive.
  !  ELEMENTS_RECV   HALO_INDEX_P[P+ELEM_RECV_+i]  Indexes of local elements to
  !					          receive. These are stored in the
  !					          array from location P+ELEM_RECV_ to
  !					          location P+ELEM_RECV_+
  !						  HALO_INDEX_P[P+N_ELEM_RECV_]-1.
  !  N_ELEMENTS_SEND HALO_INDEX_P[P+N_ELEM_SEND_]  Number of elements to send.
  !  ELEMENTS_SEND   HALO_INDEX_P[P+ELEM_SEND_+i]  Indexes of local elements to
  !					          send. These are stored in the
  !					          array from location P+ELEM_SEND_ to
  !					          location P+ELEM_SEND_+
  !						  HALO_INDEX_P[P+N_ELEM_SEND_]-1.
  !  OVRLAP_INDEX      pointer to integer array
  !             EXPLANATION
  !
  !  Let DESCOVRLP_P be the array DESC_OVRLAP for local process.
  !  This is composed of variable dimension blocks for each process to 
  !  communicate to.
  !  Each block contain indexes of local overlap elements to exchange with
  !  other process.
  !  Let P be the pointer to the first element of a block in DESCOVRLP_P.
  !  This block is stored in DESCOVRLP_P as :
  !
  !  NOTATION        STORED IN		            EXPLANATION
  !  ------------- ------------------------------- -----------------------------------
  !  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
  !						   data with.
  !  N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
  !  OVRLAP_RECV   DESCOVRLP_P[P+ELEM_RECV_+i]     Indexes of local elements to
  !					           receive. These are stored in the
  !					           array from location P+OVRLP_ELEM_ to
  !					           location P+OVRLP_ELEM_+
  !						   DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
  !  OVRLAP_SEND   DESCOVRLP_P[P+ELEM_SEND_+i]     Indexes of local elements to
  !					           send.These are stored in the
  !					           array from location P+ELEM_SEND_ to
  !					           location P+ELEM_SEND_+
  !						   DESCOVRLP_P[P+N_ELEM_SEND_]-1.
  !
  !
  !  Let OVR_ELEM_P be the array OVERLAP_ELEM for local process.
  !  This is composed of blocks of two elements. The block
  !  corresponding to the i-th overlapped elements, begin at index 
  !  P = i*2 in array OVR_ELEM_P.
  !  This block is stored in OVR_ELEM_P as :
  !
  !  NOTATION      STORED IN		       EXPLANATION
  !  ------------- -------------------------- ----------------------------------
  !  OVRLAP_ELEM   OVR_ELEM_P[P+OVRLP_ELEM_]  The index of local overlapped 
  !					       element.
  !  N_DOMAINS     OVR_ELEM_P[P+N_DOM_OVR_]   The number of copies of
  !					       local overlapped element.
  ! END DECOMP_DATA FIELDS
  !  A              TYPESP
  !                 required
  !  A FIELDS
  !  FIDA         : character*5
  !                 Describe some caracteristics of final sparse
  !                 matrix rapresentation
  !
  !  DESCRA       : character*11 
  !                 Contains some additional informations on 
  !                 sparse matrix rappresentation.
  !  ASPK           pointer to d.p. array of dimension equal NNZ
  !                 contains information about entry matrix 
  !                 inserted.
  !  IA1            pointer to int array of dimension equal NNZ.
  !                 contains information about entry matrix yet
  !                 inserted.
  !  IA2             pointer to int array of dimension equal NNZ
  !                 contains information about entry matrix yet
  !                 inserted.
  !  PL             Integer pointer to array of dimension 1.
  !                 PL(1) is setted to 0 (No left permutation).
  !  PR             Integer pointer to array of dimension 1.
  !                 PR(1) is setted to 0 (No right permutation).
  !  INFOA          integer array of dimension 10
  !
  ! END A FIELDS
  Use TYPEDESC
  Use TYPESP
  Use TOOLS_CONST
  !  Implicit None

  interface zcsrp

     SUBROUTINE ZCSRP(TRANS,M,N,FIDA,DESCRA,IA1,IA2,&
          & INFOA,P,WORK,LWORK,IERROR)
       INTEGER, intent(in)  :: M, N, LWORK
       INTEGER, intent(out) :: IERROR
       CHARACTER, intent(in) ::       TRANS
       COMPLEX(KIND(1.D0)), intent(inout) :: WORK(*)                     
       INTEGER, intent(in)    :: P(*)
       INTEGER, intent(inout) :: IA1(*), IA2(*), INFOA(*) 
       CHARACTER, intent(in)  :: FIDA*5, DESCRA*11
     end SUBROUTINE ZCSRP
  END interface


  interface isaperm

    logical function isaperm(N,IP)
      INTEGER, intent(in)    :: N   
      INTEGER, intent(inout) :: IP(*)
    end function isaperm
  END interface

  !...Parameters....
  Type(Z_SPMAT), intent(inout)       ::  A
  Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
  integer, intent(inout)             :: iperm(:)
  character, intent(in)              :: trans
  !....Locals....
  Integer                       ::  INT_ERR(5),P(1),INFOA(10)
  Integer,Pointer      ::  OVRLAP_ELEM(:),OVRLAP_INDEX(:)&
       & ,HALO_INDEX(:)
  Real(Kind(1.d0))              ::  REAL_ERR(5)
  complex(Kind(1.d0))              ::  D(1)
  Integer,Pointer               ::  I_TEMP(:), IA1(:),IA2(:),&
       & WORK_ASBX(:),WORK5(:), IPT(:)
  Integer                       ::  INFO,I,ERR,NPROW,NPCOL,ME,&
       & MYPCOL ,IERROR ,N_COL,l_zcsrp, iout, kh, nh, ipsize
  Integer                       :: ALLOCATED_WORK5
  Character                     :: FIDA*5, DESCRA*11, itrans
  Integer                       :: LWORK_ZCSRP,LWORK5,LDESC_HALO,&
       & L_ASBX, LDESC_OVRLAP, DECTYPE
  complex(kind(1.d0)), pointer     :: work_zcsrp(:)
  Integer                       :: ICONTXT,TEMP(1),N_ROW,IOVERLAP
  Integer, Parameter            :: IONE=1
  Character                     :: NAME*20

  Real(Kind(1.d0))              :: TIME(10), MPI_WTIME
  External MPI_WTIME
  logical, parameter :: debug=.false.

  TIME(1) = MPI_WTIME()

  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
  DECTYPE=DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)
  N_ROW = DECOMP_DATA%MATRIX_DATA(N_ROW_)
  N_COL = DECOMP_DATA%MATRIX_DATA(N_COL_)
     
  INFO=0
  NAME = 'F90_PSCSRP'
  ! check on BLACS grid 
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  If (NPROW.EQ.-1) Then
     INFO = 2010
     Goto 9999
  Else If (NPCOL.NE.1) Then
     INFO = 2030
     INT_ERR(1) = NPCOL
  Endif


  IF (.not.is_asb_dec(dectype)) then 
    INFO = 600
    INT_ERR(1) = dectype
    if (debug) write(0,*) 'Dectype 1 :',dectype,sp_mat_bld,&
         &sp_mat_asb,sp_mat_upd
  ENDIF

  ipsize = size(iperm)
  if (.not.((ipsize.eq.n_col).or.(ipsize.eq.n_row) )) then 
    INFO = 35
    INT_ERR(1) = 1
    INT_ERR(2) = ipsize
  else
    if (.not.isaperm(ipsize,iperm)) then
      INFO = 70
      INT_ERR(1) = 1      
    endif
  endif

    
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,&
       &TEMP ,TEMP,-IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999

  l_zcsrp = (n_col)
  
  allocate(work_zcsrp(l_zcsrp),ipt(n_col),STAT=INFO)

  if (ipsize.eq.n_col) then 
    do i=1, n_col
      ipt(i) = iperm(i)
    enddo
  else    
    do i=1, n_row
      ipt(i) = iperm(i)
    enddo
    do i=n_row+1,n_col
      ipt(i) = i
    enddo
  endif
  ! Crossed fingers.....
  ! Fix glob_to_loc/loc_to_glob  mappings, then indices lists
  ! Hmm, maybe we should just move all of this onto a different levpel,
  ! Have a specialized subroutine, and do it in the solver context???? 
  if (debug) write(0,*) 'SPASB: calling zcsrp',size(work_zcsrp)
  call zcsrp(trans,n_row,n_col,A%FIDA,A%DESCRA,A%IA1,A%IA2,A%INFOA,&
       & ipt,work_zcsrp,SIZE(WORK_ZCSRP),IERROR)
  
  deallocate(ipt,work_zcsrp)
  
  
  TIME(4) = MPI_WTIME()
  TIME(4) = TIME(4) - TIME(3)
  if (debug) then 
    Call DGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, TIME(4),&
         & IONE,TEMP ,TEMP,-IONE ,-IONE,-IONE)

    Write (*, *) '         comm structs assembly: ', TIME(4)*1.d-3
  end if

  Return
9999 Call PSDERROR( ICONTXT, INFO, NAME, INT_ERR, REAL_ERR )
End Subroutine PSZCSRP
