Subroutine PSZASB(X, IERRV,  DECOMP_DATA)
  !....Assembly dense matrix X .....
  Use TYPEDESC
  Use TYPESP
  Use TOOLS_CONST
  Use F90PSBLAS
!  Implicit None

  Type(DECOMP_DATA_TYPE), intent(in)   ::  DECOMP_DATA
  Complex(Kind(1.D0)),POINTER          ::  X(:,:)
  Integer                              ::  IERRV(:)

  ! Local variables
  Integer :: IERROR, ERR, ICONTXT,NPROW,NPCOL,ME,MYPCOL,TEMP,LWORK,NROW,NCOL
  Complex(Kind(1.D0)),POINTER ::  DTEMP(:,:)
  Integer :: INT_ERR(5), i1sz, i2sz, dectype, i
  Double Precision :: REAL_ERR(5)
  Character :: NAME*20
  Integer, Parameter  :: IONE=1
  COMPLEX(KIND(1.d0)),parameter    :: ONE=(1.d0,0.d0)
  logical, parameter :: debug=.false.
  
  IERROR = 0
  If ((.Not.Associated(DECOMP_DATA%MATRIX_DATA))) Then
     IERRV(1)=3110
     Return
  endif
  
  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
  DECTYPE=DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)
  
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  
  NAME = 'F90_PSZSASB\0'
  if (debug) write(*,*) 'ASB Start: ',nprow,npcol,me,&
       &sp_mat_asb,DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)
  !     ....Verify BLACS Grid correctness..
  If (NPROW.EQ.-1) Then
    IERROR = 2010
    Goto 9999
  Else If (NPCOL.NE.1) Then
    IERROR = 2030
    INT_ERR(1) = NPCOL
  Else If (.NOT.is_asb_dec(DECTYPE)) Then
    if (debug) write(*,*) 'ASB error ',&
         &sp_mat_asb,dectype
    IERROR = 3110
  Endif
   
  !  If there are errors in IERRV
  If (IERRV(1).NE.0) Then
     NAME = 'PSZINS\0'
     IERROR = IERRV(1)
     INT_ERR(1) = IERRV(2)
     INT_ERR(2) = IERRV(3)
     INT_ERR(3) = IERRV(4)
     INT_ERR(4) = IERRV(5)
     INT_ERR(5) = IERRV(6)
  Endif

  ERR = IERROR
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,&
       &TEMP, TEMP,-IONE ,-IONE,-IONE)

  If (ERR.NE.0) Goto 9999

  ! Check size
  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
  NROW=DECOMP_DATA%MATRIX_DATA(N_ROW_)
  NCOL=DECOMP_DATA%MATRIX_DATA(N_COL_)
  i1sz = size(x,dim=1)
  i2sz = size(x,dim=2)
  if (debug) write(*,*) 'ASB: ',i1sz,i2sz,nrow,ncol
  if (i1sz.lt.ncol) then
     allocate(dtemp(ncol,i2sz),stat=info)
     If (INFO.NE.0) Then
        INFO=2025
        INT_ERR(1)=ncol
        goto 9999
     Endif
     dtemp = x
     deallocate(x)
     x => dtemp
  endif

  ! ..Update Halo elements..
  CALL F90_PSHALO(X,DECOMP_DATA,ALPHA=ONE)

  Return
  
9999 Call PSDERROR( ICONTXT, IERROR, NAME, INT_ERR, REAL_ERR )
  
End Subroutine PSZASB


Subroutine PSZASBV(X, IERRV, DECOMP_DATA)
  !....Assembly dense matrix X .....
  Use TYPEDESC
  Use TYPESP
  Use TOOLS_CONST
  USE F90PSBLAS
  Implicit None

  Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
  Complex(Kind(1.D0)),POINTER        ::  X(:)
  Integer                  ::  IERRV(:)

  ! Local variables
  Integer :: IERROR, ERR, ICONTXT,NPROW,NPCOL,ME,MYPCOL,TEMP,LWORK
  Integer :: INT_ERR(5), i1sz,nrow,ncol,info, dectype, i
  Complex(Kind(1.D0)),POINTER ::  dtemp(:)
  Double Precision :: REAL_ERR(5)
  Character :: NAME*20
  Integer, Parameter  :: IONE=1  
  COMPLEX(KIND(1.d0)),parameter    :: ONE=(1.d0,0.d0)
  logical, parameter :: debug=.false.
  
  IERROR = 0
  
  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
  DECTYPE=DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)

  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)

  NAME = 'F90_ZASB\0'
  if (debug) write(0,*) name
  !     ....Verify BLACS Grid correctness..
  If (NPROW.EQ.-1) Then
     IERROR = 2010
     Goto 9999
  Else If (NPCOL.NE.1) Then
     IERROR = 2030
     INT_ERR(1) = NPCOL
  Else If (.not.is_asb_dec(dectype)) Then
     IERROR = 3110
  Endif
   
  !  If there are errors in IERRV
  If (IERRV(1).NE.0) Then
     if (debug) write(0,*) name,' Delayed errors from INS'
     NAME = 'PSZINS\0'
     IERROR = IERRV(1)
     INT_ERR(1) = IERRV(2)
     INT_ERR(2) = IERRV(3)
     INT_ERR(3) = IERRV(4)
     INT_ERR(4) = IERRV(5)
     INT_ERR(5) = IERRV(6)
  Endif

  ERR = IERROR
  if (debug) write(0,*) name,' Error so far',err
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,&
       &TEMP, TEMP, -IONE ,-IONE,-IONE)

  If (ERR.NE.0) Goto 9999
  NROW=DECOMP_DATA%MATRIX_DATA(N_ROW_)
  NCOL=DECOMP_DATA%MATRIX_DATA(N_COL_)
  if (debug) write(0,*) name,' Sizes: ',nrow,ncol
  i1sz = size(x)
  if (debug) write(0,*) 'DASB: sizes ',i1sz,ncol

  IF (I1SZ.LT.NCOL) THEN
    ALLOCATE(DTEMP(NCOL),STAT=INFO)  
    If (INFO.NE.0) Then           
      INFO=2025
      INT_ERR(1)=ncol
      goto 9999
    Endif
    dtemp(1:nrow) = x(1:nrow)
    deallocate(x)
    x => dtemp
  endif
  
  
  ! ..Update Halo elements..
  CALL f90_PSHALO(X,DECOMP_DATA,ALPHA=ONE)

  Return
  
9999 Call PSDERROR( ICONTXT, IERROR, NAME, INT_ERR, REAL_ERR )
  
End Subroutine PSZASBV

