! ---------------------------------------------------------------------
!
!  -- PSSBLAS routine (version 1.0) --
!
!  ---------------------------------------------------------------------
!
Subroutine PSLOC_TO_GLOB2(X,Y,DESC_A,IACT)
  !  Purpose
  !  =======
  !  
  !   Performs local to global indexes translation
  !   
  !
  ! INPUT
  !====== 
  !  N               Number of element in X to be translated
  !  X               Integer array containig indexes to be translated
  !  DESC_A          The comuunication descriptor of type DECOMP_DATA
  !  ACT             A character defining the behaviour of this subroutine
  !                   when is found an index not belonging to the calling 
  !                   process
  !
  ! OUTPUT
  !=====
  !  Y               Integer array containing translated indexes
  !  IERR            Returns an error code 



  Use TYPEDESC
  Use TOOLS_CONST
  Implicit None

  !...Parameters....
  Type(DECOMP_DATA_TYPE), intent(in) ::  DESC_A
  character, intent(in),optional     ::  IACT
  Integer, intent(in)                ::  X(:)  
  Integer, intent(out)               ::  Y(:)  

  !....Locals....
  Integer                            ::  IER, N, I, TMP
  Character                          ::  NAME*20,STRINGS,ACT
  Integer, Dimension(2)              ::  INT_VAL
  Real(kind(1.d0))                   ::  REAL_VAL
  Integer, parameter                 ::  ZERO=0

  name = 'LOC_TO_GLOB'
  
  if (present(iact)) then
     act=iact
  else
     act='A'
  endif
  
  int_val=0
  real_val = 0.d0
  ier=0
  n=size(x)
  do i=1,n
     if ((x(i).gt.desc_a%matrix_data(n_col_)).or.&
          &  (x(i).le.zero)) then
        ier=140
!       int_val=x(i)
        exit
     else
        tmp=desc_a%loc_to_glob(x(i))
        if((tmp.gt.zero).or.(tmp.le.desc_a%matrix_data(m_))) then
           y(i)=tmp
        else
           ier = 140
           exit
        end if
     end if
  enddo
  
  
  if (ier.ne.0) then
     if (act.eq.'E') then
        call seterr(1)
        call sperror(ier,name,strings,int_val,real_val)
     else if (act.eq.'W') then
        call seterr(2)
        call sperror(ier,name,strings,int_val,real_val)
     else if (act.eq.'A') then
        call seterr(3)
        call sperror(ier,name,strings,int_val,real_val)
     end if
  end if

  
  return
  
  
End Subroutine PSLOC_TO_GLOB2


Subroutine PSLOC_TO_GLOB(X,DESC_A,IACT)
  !  Purpose
  !  =======
  !  
  !   Performs local to global indexes translation
  !   
  !
  ! INPUT
  !====== 
  !  N               Number of element in X to be translated
  !  X               Integer array containig indexes to be translated
  !  DESC_A          The comuunication descriptor of type DECOMP_DATA
  !  ACT             A character defining the behaviour of this subroutine
  !                   when is found an index not belonging to the calling 
  !                   process
  !
  ! OUTPUT
  !=====
  !  Y               Integer array containing translated indexes
  !  IERR            Returns an error code 



  Use TYPEDESC
  Use TOOLS_CONST
  Implicit None

  !...Parameters....
  Type(DECOMP_DATA_TYPE), intent(in) ::  DESC_A
  character, intent(in),optional     ::  IACT
  Integer, intent(inout)     ::  X(:)  


  !....Locals....
  Integer                            ::  IER, N ,I, TMP
  Character                          ::  NAME*20,STRINGS,ACT
  Integer, Dimension(2)              ::  INT_VAL
  Real(kind(1.d0))                   ::  REAL_VAL
  Integer, parameter                 ::  ZERO=0
  
  name = 'LOC_TO_GLOB'

  if (present(iact)) then
     act=iact
  else
     act='A'
  endif

  int_val(:)=0
  real_val = 0.d0
  ier=0
  n=size(x)
  do i=1,n
     if ((x(i).gt.desc_a%matrix_data(n_col_)).or.&
          &  (x(i).le.zero)) then
        ier=140
        int_val(1)=x(i)
        int_val(2)=desc_a%matrix_data(n_col_)  
        exit
     else
        tmp=desc_a%loc_to_glob(x(i))
        if((tmp.gt.zero).or.(tmp.le.desc_a%matrix_data(m_))) then
           x(i)=tmp
        else
           ier = 140
           exit
        end if
     end if
  enddo
  
  
  if (ier.ne.0) then
     if (act.eq.'E') then
        call seterr(1)
        call sperror(ier,name,strings,int_val,real_val)
     else if (act.eq.'W') then
        call seterr(2)
        call sperror(ier,name,strings,int_val,real_val)
     else if (act.eq.'A') then
        call seterr(3)
        call sperror(ier,name,strings,int_val,real_val)
     end if
  end if

  
  return
  
  
End Subroutine PSLOC_TO_GLOB

