Subroutine PSIINS(M, N, X, IX, JX, BLCK, IERRV, DECOMP_DATA,&
     & IBLCK, JBLCK)
  !....insert dense submatrix to dense matrix .....
  Use TYPEDESC
  Use TOOLS_CONST
  !  Implicit None
  
  ! M rows number of submatrix belonging to BLCK to be inserted
  
  ! N cols number of submatrix belonging to BLCK to be inserted
  
  ! IBLCK first row of submatrix belonging to BLCK to be inserted
  
  ! JBLCK first col of submatrix belonging to BLCK to be inserted
  
  ! IX  X global-row corresponding to position at which BLCK submatrix
  !     must be inserted
  
  ! JX  X global-col corresponding to position at which BLCK submatrix
  !     must be inserted
  
  !....Parameters...
  Integer, intent(in)                ::  M,N
  Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
  integer, Pointer           ::  X(:,:)
  Integer, intent(in)                ::  IX,JX
  integer, intent(in)       ::  BLCK(:,:)
  Integer                    ::  IERRV(:)
  Integer, Optional, intent(in)      ::  IBLCK,JBLCK
  
  !locals.....
  
  Integer                :: ICONTXT,I,LOC_ROW,GLOB_ROW,ROW,K,&
       & NPROCS,MODE, LOC_COLS,IERROR,COL,IBLOCK, JBLOCK
  Integer                :: NPROW,NPCOL, ME ,MYPCOL
  Character              :: TEMP_DESCRA*11,TEMP_FIDA*5

  
  If (IERRV(1).NE.0) Return
  If (.Not.Associated(DECOMP_DATA%GLOB_TO_LOC)) Then
     IERRV(1)=3110
     Return
  End If
  If ((.Not.Associated(DECOMP_DATA%MATRIX_DATA))) Then
     IERRV(1)=3110
     Return
  End If
  
  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)

  ! check on BLACS grid 
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  If (NPCOL.NE.1) Then
     IERRV(1) = 2030
     IERRV(2) = NPCOL
     Return
  Endif

  !... check parameters....
  If (M.LT.0) Then
     IERRV(1) = 10
     IERRV(2) = 1
     IERRV(3) = M
     Return
  Else If (N.LT.0) Then
     IERRV(1) = 10
     IERRV(2) = 2
     IERRV(3) = N
     Return
  Else If (IX.LT.1) Then
     IERRV(1) = 20
     IERRV(2) = 6
     IERRV(3) = IX
     Return
  Else If (JX.LT.1) Then
     IERRV(1) = 20
     IERRV(2) = 7
     IERRV(3) = JX
     Return
  Else If (.not.is_ok_dec(DECOMP_DATA%MATRIX_DATA(DEC_TYPE_))) Then
     IERRV(1) = 3110
     IERRV(2) = decomp_data%matrix_data(dec_type_)
     Return
  Else If (Size(X, Dim=1).LT.DECOMP_DATA%MATRIX_DATA(N_ROW_)) Then
     IERRV(1) = 310
     IERRV(2) = 5
     IERRV(3) = 4
     Return
  Else If (Size(X, Dim=2).LT.N) Then
     ! check if dimension of X is greater than dimension of submatrix
     ! to insert
     IERRV(1) = 320
     IERRV(2) = 2
     IERRV(3) = Size(X, Dim=2)
     IERRV(4) = N
     Return
  Endif

  LOC_COLS=DECOMP_DATA%MATRIX_DATA(N_COL_)

  If (Present(IBLCK)) Then
     IBLOCK = IBLCK
  Else
     IBLOCK = 1
  Endif

  If (Present(JBLCK)) Then
     JBLOCK = JBLCK
  Else
     JBLOCK = 1
  Endif

  Do I = 1, M
     !loop over all BLCK's rows
     
     ! ROW actual BLOCK row 
     GLOB_ROW=IX+I-1

     LOC_ROW=DECOMP_DATA%GLOB_TO_LOC(GLOB_ROW)
     If (LOC_ROW.GE.1) Then
     ! this row belongs to me
     ! Copy I-th row of block BLCK in X
	Do COL = 1, N
	   X(LOC_ROW,JX+COL-1) = BLCK(IBLOCK+I-1,JBLOCK+COL-1)
	Enddo
     End If
  Enddo
  
End Subroutine PSIINS





Subroutine PSIINSVM(M, X, IX, JX, BLCK, IERRV, DECOMP_DATA,&
     & IBLCK)
  !....insert dense submatrix to dense matrix .....
  Use TYPEDESC
  Use TOOLS_CONST
  Implicit None
  
  ! M rows number of submatrix belonging to BLCK to be inserted
  
  ! IBLCK first row of submatrix belonging to BLCK to be inserted
  
  ! IX  X global-row corresponding to position at which BLCK submatrix
  !     must be inserted
  
  ! JX  X global-col corresponding to position at which BLCK submatrix
  !     must be inserted
  
  !....Parameters...
  Integer, intent(in)                ::  M
  Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
  integer, Pointer           ::  X(:,:)
  Integer, intent(in)                ::  IX,JX
  integer, intent(in)       ::  BLCK(:)
  Integer                    ::  IERRV(:)
  Integer, Optional, intent(in)      ::  IBLCK
  
  !locals.....
  Integer                :: ICONTXT,I,LOC_ROW,GLOB_ROW,ROW,K,&
       & NPROCS,MODE, LOC_COLS,IERROR,COL,IBLOCK, JBLOCK
  Integer                :: NPROW,NPCOL, ME ,MYPCOL
  Character              :: TEMP_DESCRA*11,TEMP_FIDA*5

  
  If (IERRV(1).NE.0) Return
  
  If (.Not.Associated(DECOMP_DATA%GLOB_TO_LOC)) Then
     IERRV(1)=3110
     Return
  End If
  If ((.Not.Associated(DECOMP_DATA%MATRIX_DATA))) Then
     IERRV(1)=3110
     Return
  End If
  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)

  ! check on BLACS grid 
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  If (NPCOL.NE.1) Then
     IERRV(1) = 2030
     IERRV(2) = NPCOL
     Return
  Endif

  !... check parameters....
  If (M.LT.0) Then
    IERRV(1) = 10
    IERRV(2) = 1
    IERRV(3) = M
    Return
  Else If (IX.LT.1) Then
    IERRV(1) = 20
    IERRV(2) = 6
    IERRV(3) = IX
    Return
  Else If (JX.LT.1) Then
    IERRV(1) = 20
    IERRV(2) = 7
    IERRV(3) = JX
    Return
  Else If (.not.is_ok_dec(DECOMP_DATA%MATRIX_DATA(DEC_TYPE_))) then
    IERRV(1) = 3110
    IERRV(2) = decomp_data%matrix_data(dec_type_)
    Return
  Else If (Size(X, Dim=1).LT.DECOMP_DATA%MATRIX_DATA(N_ROW_)) Then
    IERRV(1) = 310
    IERRV(2) = 5
    IERRV(3) = 4
    Return
  Else If (Size(X, Dim=2).LT.1) Then
    ! check if dimension of X is greater than dimension of submatrix
    ! to insert
    IERRV(1) = 320
    IERRV(2) = 2
    IERRV(3) = Size(X, Dim=2)
    IERRV(4) = 1
    Return
  Endif
   
   LOC_COLS=DECOMP_DATA%MATRIX_DATA(N_COL_)

  If (Present(IBLCK)) Then
     IBLOCK = IBLCK
  Else
     IBLOCK = 1
  Endif

  Do I = 1, M
     !loop over all BLCK's rows
     
     ! ROW actual BLOCK row 
     GLOB_ROW=IX+I-1

     LOC_ROW=DECOMP_DATA%GLOB_TO_LOC(GLOB_ROW)
     If (LOC_ROW.GE.1) Then
     ! this row belongs to me
     ! Copy I-th row of block BLCK in X
	X(LOC_ROW,JX) = BLCK(IBLOCK+I-1)
     End If
  Enddo
  
End Subroutine PSIINSVM



Subroutine PSIINSVV(M, X, IX, BLCK, IERRV, DECOMP_DATA,&
     & IBLCK)
  !....insert dense submatrix to dense matrix .....
  Use TYPEDESC
  Use TOOLS_CONST
  Implicit None
  
  ! M rows number of submatrix belonging to BLCK to be inserted
  
  ! IBLCK first row of submatrix belonging to BLCK to be inserted
  
  ! IX  X global-row corresponding to position at which BLCK submatrix
  !     must be inserted
  
  !....Parameters...
  Integer, intent(in)                ::  M
  Type(DECOMP_DATA_TYPE), intent(in) ::  DECOMP_DATA
  integer,  Pointer           ::  X(:)
  Integer, intent(in)                ::  IX
  integer,  intent(in)       ::  BLCK(:)
  Integer                    ::  IERRV(:)
  Integer, Optional, intent(in)      ::  IBLCK
  
  !locals.....
  Integer                :: ICONTXT,I,LOC_ROW,GLOB_ROW,ROW,K,&
       & NPROCS,MODE, LOC_COLS,IERROR,COL,IBLOCK, JBLOCK
  Integer                :: NPROW,NPCOL, ME ,MYPCOL
  Character              :: TEMP_DESCRA*11,TEMP_FIDA*5

  
  If (IERRV(1).NE.0) Return
  If (.Not.Associated(DECOMP_DATA%GLOB_TO_LOC)) Then
     IERRV(1)=3110
     Return
  End If
  If ((.Not.Associated(DECOMP_DATA%MATRIX_DATA))) Then
     IERRV(1)=3110
     Return
  End If
  
  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)

  ! check on BLACS grid 
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  If (NPCOL.NE.1) Then
     IERRV(1) = 2030
     IERRV(2) = NPCOL
     Return
  Endif

  !... check parameters....
  If (M.LT.0) Then
     IERRV(1) = 10
     IERRV(2) = 1
     IERRV(3) = M
     Return
  Else If (IX.LT.1) Then
     IERRV(1) = 20
     IERRV(2) = 6
     IERRV(3) = IX
     Return
  Else If (.not.is_ok_dec(DECOMP_DATA%MATRIX_DATA(DEC_TYPE_))) Then 
     IERRV(1) = 3110
     IERRV(2) = decomp_data%matrix_data(dec_type_)
     Return
  Else If (Size(X, Dim=1).LT.DECOMP_DATA%MATRIX_DATA(N_ROW_)) Then
     IERRV(1) = 310
     IERRV(2) = 5
     IERRV(3) = 4
     IERRV(4) = Size(X, Dim=1)
     IERRV(5) = DECOMP_DATA%MATRIX_DATA(N_ROW_)
     Return
  Endif

  LOC_COLS=DECOMP_DATA%MATRIX_DATA(N_COL_)

  If (Present(IBLCK)) Then
     IBLOCK = IBLCK
  Else
     IBLOCK = 1
  Endif

  Do I = 1, M
     !loop over all BLCK's rows
     
     ! ROW actual BLOCK row 
     GLOB_ROW=IX+I-1

     LOC_ROW=DECOMP_DATA%GLOB_TO_LOC(GLOB_ROW)
     If (LOC_ROW.GE.1) Then
     ! this row belongs to me
     ! Copy I-th row of block BLCK in X
	X(LOC_ROW) = BLCK(IBLOCK+I-1)
     End If
  Enddo
  
End Subroutine PSIINSVV


