SUBROUTINE PSIFREE(X, DECOMP_DATA)
  !...free dense matrix structure...
  USE TOOLS_CONST
  USE TYPEDESC
!  IMPLICIT NONE
  !....Parameters...
  integer, pointer           :: X(:,:)
  TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
  
  !...Locals....
  INTEGER             :: INT_ERR(5)
  INTEGER             :: TEMP(1)
  REAL(KIND(1.d0))    :: REAL_ERR(5)
  INTEGER             :: INFO,ICONTXT,NPROW,NPCOL,ME,MYPCOL,ERR
  INTEGER,parameter   :: IONE=1
  
  INFO=0
  
  IF (.NOT.ASSOCIATED(DECOMP_DATA%MATRIX_DATA)) INFO=295
  IF (INFO.EQ.0) THEN
     ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
     CALL BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
     !     ....Verify BLACS Grid correctness..
     IF (NPCOL.NE.1) THEN
	INFO = 2030
	INT_ERR(1) = NPCOL
     ENDIF
  ENDIF
 ! check on grid correctness
  ERR = INFO
  CALL IGAMX2D(ICONTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, TEMP, TEMP,&
       & -IONE ,-IONE,-IONE)
  IF (ERR.NE.0) GOTO 9999 

  IF ((INFO.EQ.0).AND.(.NOT.ASSOCIATED(X))) INFO=290
  
  IF (INFO.EQ.0) THEN
     !deallocate X
     DEALLOCATE(X,STAT=INFO)
     IF (INFO.NE.0) THEN
       INFO=2045
     ELSE
       NULLIFY(X)
     ENDIF
  ENDIF
  
  ! check on "X" deallocate 
  ERR = INFO
  CALL IGAMX2D(ICONTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, TEMP, TEMP,&
       & -IONE ,-IONE,-IONE)
  IF (ERR.NE.0) GOTO 9999
  RETURN
9999 CALL PSDERROR( ICONTXT, INFO, 'PSIFREE\0', INT_ERR, REAL_ERR )
END SUBROUTINE PSIFREE



SUBROUTINE PSIFREEV(X, DECOMP_DATA)
  !...free dense matrix structure...
  USE TOOLS_CONST
  USE TYPEDESC
  IMPLICIT NONE
  !....Parameters...
  integer, pointer           :: X(:)
  TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
  
  !...Locals....
  INTEGER             :: INT_ERR(5)
  INTEGER             :: TEMP(1)
  REAL(KIND(1.d0))    :: REAL_ERR(5)
  INTEGER             :: INFO,ICONTXT,NPROW,NPCOL,ME,MYPCOL,ERR
  INTEGER,parameter   :: IONE=1
  
  INFO=0
  
  IF (.NOT.ASSOCIATED(DECOMP_DATA%MATRIX_DATA)) INFO=295
  IF (INFO.EQ.0) THEN
     ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
     CALL BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
     !     ....Verify BLACS Grid correctness..
     IF (NPCOL.NE.1) THEN
	INFO = 2030
	INT_ERR(1) = NPCOL
     ENDIF
  ENDIF
 ! check on grid correctness
  ERR = INFO
  CALL IGAMX2D(ICONTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, TEMP, TEMP,&
       & -IONE ,-IONE,-IONE)
  IF (ERR.NE.0) GOTO 9999 

  IF ((INFO.EQ.0).AND.(.NOT.ASSOCIATED(X))) INFO=290
  
  IF (INFO.EQ.0) THEN
     !deallocate X
     DEALLOCATE(X,STAT=INFO)
     IF (INFO.NE.0) THEN 
       INFO=2045
     ELSE
       NULLIFY(X)
     ENDIF
  ENDIF
  
  ! check on "X" deallocate 
  ERR = INFO
  CALL IGAMX2D(ICONTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, TEMP, TEMP,&
       & -IONE ,-IONE,-IONE)
  IF (ERR.NE.0) GOTO 9999
  RETURN
9999 CALL PSDERROR( ICONTXT, INFO, 'PSIFREE\0', INT_ERR, REAL_ERR )
END SUBROUTINE PSIFREEV
