! ---------------------------------------------------------------------
!
!  -- PSSBLAS routine (version 1.0) --
!
!  ---------------------------------------------------------------------
!/
Subroutine PSDSPINS(A,IA,JA,BLCK,IERRV,DECOMP_DATA,IX,JX)
  !  Purpose
  !  =======
  !  
  !  insert sparse submatrix to sparse matrix structure for psblas
  !  routines
  !
  ! INPUT
  !======
  ! M        : (Local input) Integer 
  !            rows number of submatrix belonging to BLCK to be inserted.
  !            required.
  ! N        : (Local input) Integer 
  !            cols number of submatrix belonging to BLCK to be inserted.
  !            required.
  !  IA        integer
  !            sparse matrix A global-row corresponding to position at
  !            which blck submatrix  must be inserted
  !            required.
  !  JA        integer
  !            sparse matrix A global-col corresponding to position at
  !            which blck submatrix  must be inserted
  !            required
  !  BLCK      TYPESP
  !            Sparse matrix to be inserted.
  !            required
  !
  !  IX        Integer 
  !            first row of blck submatrix to be inserted
  !            optional, default is 1
  !  IY        Integer 
  !            first col of blck submatrix to be inserted
  !            optional, default is 1
  !
  ! INPUT/OUTPUT
  !==============
  ! DECOMP_DATA TYPEDESC
  !             required
  ! DECOMP_DATA FIELDS
  !
  ! MATRIX_DATA   : Pointer to integer Array 
  !                contains some
  !               local and global information about matrix:
  !
  !  NOTATION        STORED IN		     EXPLANATION
  !  ------------ ---------------------- -------------------------------------
  !  DEC_TYPE        MATRIX_DATA[DEC_TYPE_]   Decomposition type, temporarly is
  !                      setted to 1( matrix not yet assembled)
  !  M 	             MATRIX_DATA[M_]          Total number of equations
  !  N 	             MATRIX_DATA[N_]          Total number of variables
  !  N_ROW           MATRIX_DATA[N_ROW_]      Number of local equations
  !  N_COL           MATRIX_DATA[N_COL_]      Number of local variables
  !                     already inserted.
  !  CTXT_A          MATRIX_DATA[CTXT_]     The BLACS context handle, 
  !                                         indicating
  !	  			            the global context of the operation
  !					    on the matrix.
  !					    The context itself is global.
  !
  !  LOC_TO_GLOB     An integer array of dimension equal to number of local
  !                  cols.
  !                  Element i (if >0) contains global identifier of local
  !                  variable i.
  !                  if < 0 then local identifier i is not yet assigned.
  !  GLOB_TO_LOC     Array of dimension equal to number of global 
  !                  cols (MATRIX_DATA[N_]).
  !                  Either: 
  !                  1. Index i belongs to current process: then GTL(i)>0
  !                  2. Index i belongs to process P  0<=P<=NP-1. In this case, 
  !                     corresponding entry was initialized to -(NP+P+1). 
  !                     If, during the insertion, we discover that index i 
  !                     is referenced by the local part of the matrix, we 
  !                     add NP to the corrisponding entry, so that a value
  !                       -NP <= GTL(i) <= -1  marks an index referenced by
  !                     the local matrix, and gives the process owning it,
  !                     whereas a value GTL(i) < -NP marks an index not referenced.
  !                       
  !                     
  !                   
  ! END DECOMP_DATA FIELDS
  !
  !  A              TYPESP
  !                 required
  !  A FIELDS
  !  FIDA         :  (Global Input)character*5
  !                 Describe some caracteristics of final sparse
  !                 matrix rapresentation
  !
  !  DESCRA       :  (Global Input)character*11 
  !                 Contains some additional informations on 
  !                 sparse matrix rappresentation.
  !  ASPK           pointer to d.p. array of dimension equal NNZ
  !                 contains information about entry matrix yet
  !                 inserted.
  !  IA1            pointer to int array of dimension equal NNZ.
  !                 contains information about entry matrix yet
  !                 inserted.
  !  IA2             pointer to int array of dimension equal NNZ
  !                 contains information about entry matrix yet
  !                 inserted.
  !  INFOA           integer array of dimension 10:
  !  INFOA(ASPK_)  Number of ASPK element yet inserted
  !  INFOA(IA1_)   Number of IA1 element yet inserted
  !  INFOA(IA2_)   Number of IA2 element yet inserted
  !  INFOA(OVR_DIM_) contains the sum for every my overlap points
  !                number of processes which contains.
  ! END A FIELDS
  !
  ! IERRV         Pointer to integer array of dimension 6
  !               contains possible error encountered in previously
  !               call on this procedure. Set in f90_spall.
  !               Required.
  !

  Use TYPEDESC
  Use TYPESP
  Use TOOLS_CONST
  Implicit None

  !....PARAMETERS...
  Type(DECOMP_DATA_TYPE), intent(inout) ::  DECOMP_DATA
  Type(D_SPMAT), intent(inout)          ::  A
  Integer, intent(in)                   ::  IA,JA
  Type(D_SPMAT), intent(in)             ::  BLCK
  Integer                               ::  IERRV(:)
  Integer, Optional, intent(in)         ::  IX,JX

  !LOCALS.....

  Interface
    Subroutine DCSINS(M,N,FIDA,DESCRA,A,IA1,IA2,INFOA,&
         & IA,JA,LA,LIA1,LIA2,LATOT,LIA1TOT,LIA2TOT,&
         &FIDH,DESCRH,H,IH1,IH2,INFOH,IH,JH,WORK,LWORK,IERROR)
      Implicit None
      !      .. SCALAR ARGUMENTS ..
      Integer, intent(in) :: M, N, LWORK, LATOT,LIA1TOT,LIA2TOT,IA,JA,IH,JH
      Integer, intent(inout) :: LA, LIA1, LIA2
      Integer, intent(out) :: IERROR
      !      .. ARRAY ARGUMENTS ..
      Double Precision, intent(in)    :: H(*)
      Double Precision, intent(inout) :: A(*), WORK(*)
      Integer, intent(in) :: IH1(*), IH2(*), INFOH(10)                         
      Integer, intent(inout) :: IA1(*), IA2(*), INFOA(10)
      Character, intent(in)  :: FIDA*5, FIDH*5,DESCRA*11, DESCRH*11
    End Subroutine DCSINS
  End Interface

  Integer :: ICONTXT,I,LOC_ROW,PREC_LOC_ROW,NPROCS ,GLOB_ROW,ROW,&
       & ASPK_POINTER,IA1_POINTER,IA2_POINTER,K ,START_ROW,END_ROW,&
       & FIRST_LOC_ROW,N_ROW,J, IERROR,LOCIX,LOCJX,IK,&
       & APP_ASPK_POINTER,INFO,ALLOCATED_PRCV,DECTYPE,MGLOB
  Integer,Pointer        :: PRCV(:), tia1(:),tia2(:), temp(:)
  Integer                :: NPROW,NPCOL, ME ,MYPCOL, iflag, isize, irlc
  Integer                   ::  M,N, pnt_halo,ncol, nh, ip
  Real(Kind(1.D0)),Pointer       :: WORKAREA(:),taspk(:)
  Character            :: TEMP_DESCRA*11, TEMP_FIDA*5
  logical, parameter :: debug=.false.
  integer, parameter :: nrlcthr=3
  integer, save :: irlcmin,nrlc
  data irlcmin/500/,nrlc/0/
  integer geterr
  external geterr


  ! Check if there were  errors
  If (IERRV(1).NE.0) goto 9999

  If (Present(IX)) Then
    LOCIX=IX
  Else
    LOCIX=1
  Endif

  If (Present(JX)) Then
    LOCJX=JX
  Else
    LOCJX=1
  Endif
  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
  DECTYPE=DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)
  MGLOB=DECOMP_DATA%MATRIX_DATA(M_)
  ! CHECK ON BLACS GRID 
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  If (NPCOL.NE.1) Then
    IERRV(1)= 2030
    IERRV(2)= NPCOL
    goto 9999
  Endif
  If (.not.is_bld_dec(DECTYPE)) then 
    IERRV(1)= 3110
    goto 9999
  Endif
  INFO=0

  Allocate(WORKAREA(1),PRCV(NPROW),STAT=INFO)
  ALLOCATED_PRCV=1
  If (INFO.NE.0) Then
    IERRV(1)=2023
    IERRV(2)=NPROW
    goto 9999
  End If
    
  N_ROW        = DECOMP_DATA%MATRIX_DATA(N_ROW_)
  ASPK_POINTER = A%INFOA(ASPK_POINTER_)
  IA1_POINTER  = A%INFOA(IA1_POINTER_)
  IA2_POINTER  = A%INFOA(IA2_POINTER_) 
  M            = BLCK%M
  N            = BLCK%K
  ROW          = IA
  I            = 1
  Do While (I.LE.M)
    !LOOP OVER ALL BLCK'S ROWS

    ! ROW ACTUAL BLOCK ROW 
    ROW=LOCIX+I-1
    GLOB_ROW=IA+I-1
    if (debug) then 
      write(0,*) 'SPINS: Inserting ',glob_row
    endif
    K = DECOMP_DATA%GLOB_TO_LOC(GLOB_ROW)
    IF (K.GT.0) THEN
      START_ROW     = ROW
      FIRST_LOC_ROW = K
      DO WHILE ((I.LT.M).AND.&
           & (DECOMP_DATA%GLOB_TO_LOC(IA+I).GT.0))
         I=I+1
      ENDDO
!!$      I = I - 1
      END_ROW=LOCIX+I-1      
      APP_ASPK_POINTER = ASPK_POINTER
      !Make sure we don't get an error message
      iflag = geterr()
      CALL SETERR(1)
      ! INSERT BLCK SUBMATRIX IN 'COO' FORMAT
      Call DCSINS(END_ROW-START_ROW+1,N,A%FIDA,A%DESCRA,A%ASPK,&
           & A%IA1,A%IA2,A%INFOA,FIRST_LOC_ROW, JA,&
           & ASPK_POINTER, IA1_POINTER, IA2_POINTER, Size(A%ASPK),&
           & Size(A%IA1),Size(A%IA2),&
           & BLCK%FIDA,BLCK%DESCRA,BLCK%ASPK,BLCK%IA1,BLCK%IA2,&
           & BLCK%INFOA,START_ROW,LOCJX,WORKAREA,Size(WORKAREA),&
           & IERROR)
      if (debug) write(0,*) 'SPINS:  Exit from MATINS:',ierror
      CALL SETERR(iflag)	

      If (IERROR.NE.0) Then

        if (ierror.eq.60) then 
          ! Try reallocating
          ierrv(1) = ierror
          irlc = irlcmin
          do while (ierror.eq.60)
            if (debug) write(*,*) "Attempting reallocation with",irlc

            isize = size(a%ia1)                    
            Allocate(tia1(isize+irlc),STAT=INFO)
            if (info.ne.0) goto 9999
            tia1(1:isize) = a%ia1(1:isize)
            deallocate(a%ia1,STAT=INFO)
            if (info.ne.0) goto 9999
            a%ia1 => tia1
            nullify(tia1)

            isize = size(a%ia2)                    
            Allocate(tia2(isize+irlc),STAT=INFO)
            if (info.ne.0) goto 9999
            tia2(1:isize) = a%ia2(1:isize)
            deallocate(a%ia2,STAT=INFO)
            if (info.ne.0) goto 9999
            a%ia2 => tia2
            nullify(tia2)

            isize = size(a%aspk)                    
            Allocate(taspk(isize+irlc),STAT=INFO)
            if (info.ne.0) goto 9999
            taspk(1:isize) = a%aspk(1:isize)
            deallocate(a%aspk,STAT=INFO)
            if (info.ne.0) goto 9999
            a%aspk => taspk
            nullify(taspk)
            CALL SETERR(1)

            ! INSERT BLCK SUBMATRIX IN 'COO' FORMAT
            Call DCSINS(END_ROW-START_ROW+1,N,A%FIDA,A%DESCRA,A%ASPK,&
                 & A%IA1,A%IA2,A%INFOA,FIRST_LOC_ROW, JA,&
                 & ASPK_POINTER, IA1_POINTER, IA2_POINTER, Size(A%ASPK),&
                 & Size(A%IA1),Size(A%IA2),&
                 & BLCK%FIDA,BLCK%DESCRA,BLCK%ASPK,BLCK%IA1,BLCK%IA2,&
                 & BLCK%INFOA,START_ROW, LOCJX,WORKAREA,Size(WORKAREA),&
                 & IERROR)
            CALL SETERR(iflag)                      
            if (ierror.eq.60) irlc = irlc*2                    
          enddo
          ! If we get here, it means we succesfully reallocated. 
          ierrv(1) = 0
          nrlc = nrlc+1
          if (nrlc .ge. nrlcthr) then
            nrlc = 0
            irlcmin = irlcmin * 2
          endif

        else
          IERRV(1) = IERROR
          Goto 9999
        endif
      Endif
   Endif
   ! NEXT BLCK'S ROW
   I=I+1
  Enddo

!!$
!!$  Do I=A%INFOA(IA2_POINTER_)+1,IA2_POINTER
!!$    If (DECOMP_DATA%GLOB_TO_LOC(A%IA2(I)).LT.-NPROW) Then
!!$      ! THIS POINT IS NOT YET ENCOUNTERED, MARK
!!$      ! CORRESPONDENT ELEMENT IN GLOB_TO_LOC
!!$      ! AND INCREMENT LOCAL COLS NUMBER
!!$      DECOMP_DATA%GLOB_TO_LOC(A%IA2(I))=&
!!$           & DECOMP_DATA%GLOB_TO_LOC(A%IA2(I))+NPROW
!!$       
!!$      ! INCREMENT LOCAL COLS NUMBER
!!$      DECOMP_DATA%MATRIX_DATA(N_COL_)=DECOMP_DATA%MATRIX_DATA&
!!$           & (N_COL_)+1
!!$    Endif
!!$  Enddo


  if (.not.associated(decomp_data%halo_index)) then
    allocate(decomp_data%halo_index(irlcmin))
    decomp_data%halo_index(:) = -1
  endif
  pnt_halo=1
  do while (decomp_data%halo_index(pnt_halo) .ne.  -1 )
    pnt_halo = pnt_halo + 1
  end do 
  ncol = decomp_data%matrix_data(n_col_)

  do i = a%infoa(ia2_pointer_)+1,ia2_pointer
    ip = a%ia2(i)
    k  = decomp_data%glob_to_loc(ip)
    if (k.lt.-nprow) then
      k = k + nprow
      k = - k - 1
      ncol = ncol + 1      
      decomp_data%glob_to_loc(ip)   =  ncol
      isize = size(decomp_data%loc_to_glob)
      if (ncol.gt.isize) then 
        nh = ncol + irlcmin
        allocate(temp(nh))
        temp(1:isize) = decomp_data%loc_to_glob(1:isize)
        temp(isize+1:nh)  = -1
        deallocate(decomp_data%loc_to_glob)
        decomp_data%loc_to_glob => temp
      endif
      decomp_data%loc_to_glob(ncol) = ip
      isize = size(decomp_data%halo_index)
      if ((pnt_halo+3).gt.isize) then
        nh = isize + irlcmin
        allocate(temp(nh))
        temp(1:isize) = decomp_data%halo_index(1:isize)
        temp(isize+1:nh) = -1
        deallocate(decomp_data%halo_index)
        decomp_data%halo_index => temp
        isize = nh
      endif
      decomp_data%halo_index(pnt_halo)   = k
      decomp_data%halo_index(pnt_halo+1) = 1
      decomp_data%halo_index(pnt_halo+2) = ncol
      pnt_halo                           = pnt_halo + 3
    Endif
   
    ip       = a%ia2(i) 
    a%ia2(i) = decomp_data%glob_to_loc(ip)
   
  Enddo

  decomp_data%matrix_data(n_col_) = ncol


  ! UPDATE POINTERS IN INFOA FIELDS
  If (ASPK_POINTER.GT.Size(A%ASPK)) Then
    ! INSERTED MORE NNZERO VALES THAN NNZ PARAMETER SPECIFIED IN F90_SPALL
    IERRV(1)=330
    IERRV(2)=ASPK_POINTER
    IERRV(3)=Size(A%ASPK)
    Goto 9999
  End If

  A%INFOA(ASPK_POINTER_)= ASPK_POINTER
  A%INFOA(IA1_POINTER_) = IA1_POINTER
  A%INFOA(IA2_POINTER_) = IA2_POINTER
  if (debug) write(0,*)  'SPINS : Pointers : ', A%INFOA(ASPK_POINTER_),&
       &  A%INFOA(IA1_POINTER_) ,  A%INFOA(IA2_POINTER_)

  If (ALLOCATED_PRCV.EQ.1) Then
    Deallocate(PRCV,WORKAREA,STAT=INFO)
    If (INFO.NE.0) IERRV(1)=2040
  Endif

9999 continue     

  Return
End Subroutine PSDSPINS

