SUBROUTINE PSDSPFREE(A, DECOMP_DATA)
  !...free sparse matrix structure...
  USE TYPEDESC
  USE TYPESP
  USE TOOLS_CONST
!  IMPLICIT NONE
  !....Parameters...
  TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
  TYPE(D_SPMAT), intent(inout)       ::A
  
  !...Locals....
  INTEGER             :: INT_ERR(5)
  INTEGER             :: TEMP(1)
  REAL(KIND(1.d0))    :: REAL_ERR(5)
  INTEGER             :: INFO,ICONTXT,NPROW,NPCOL,ME,MYPCOL,ERR
  INTEGER,parameter   :: IONE=1
  
  INFO=0
  
  IF (.NOT.ASSOCIATED(DECOMP_DATA%MATRIX_DATA)) INFO=295
  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
  ! check on grid correctness
  ERR = INFO
  CALL IGAMX2D(ICONTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, TEMP, TEMP,&
       & -IONE ,-IONE,-IONE)
  IF (ERR.NE.0) GOTO 9999

  !...deallocate A....

  IF ((INFO.EQ.0).AND.(.NOT.ASSOCIATED(A%PR))) INFO=295
  IF (INFO.EQ.0) THEN
    !deallocate PR field
    DEALLOCATE(A%PR,STAT=INFO)
    IF (INFO.NE.0) INFO=2045
  END IF
  IF ((INFO.EQ.0).AND.(.NOT.ASSOCIATED(A%PL))) INFO=295
  !deallocate PL  field
  IF (INFO.EQ.0) THEN 
    DEALLOCATE(A%PL,STAT=INFO)
    IF (INFO.NE.0) INFO=2045
  END IF
  IF ((INFO.EQ.0).AND.(.NOT.ASSOCIATED(A%IA2))) INFO=295
  IF (INFO.EQ.0) THEN
    !deallocate IA2 field
    DEALLOCATE(A%IA2,STAT=INFO)
    IF (INFO.NE.0) INFO=2045
  END IF
  IF ((INFO.EQ.0).AND.(.NOT.ASSOCIATED(A%IA1))) INFO=295
  IF (INFO.EQ.0) THEN
    !deallocate IA1  field
    DEALLOCATE(A%IA1,STAT=INFO)
    IF (INFO.NE.0) INFO=2045
  ENDIF
  IF ((INFO.EQ.0).AND.(.NOT.ASSOCIATED(A%ASPK))) INFO=295
  IF (INFO.EQ.0) THEN
    !deallocate ASPK field
    DEALLOCATE(A%ASPK,STAT=INFO)
    IF (INFO.NE.0) INFO=2045
  ENDIF
  IF (INFO.EQ.0) CALL NULLIFY_SP(A)


  ! check on "A" deallocate 
  ERR = INFO
  CALL IGAMX2D(ICONTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, TEMP, TEMP,&
       & -IONE ,-IONE,-IONE)
  IF (ERR.NE.0) GOTO 9999

  RETURN
9999 CALL PSDERROR( ICONTXT, INFO, 'PSDSPFREE\0', INT_ERR, REAL_ERR )
END SUBROUTINE PSDSPFREE
