! ---------------------------------------------------------------------
!
!  -- PSSBLAS routine (version 1.0) --
!
!  ---------------------------------------------------------------------
!
Subroutine PSDSPASB(A,IERRV,DECOMP_DATA,OVERLAP, AFMT, UP, DUP)
  !  Purpose
  !  =======
  !  
  !   Assembly sparse matrix and set psblas communications
  !   structures.
  !
  ! INPUT
  !====== 
  !  IERRV     Pointer to integer array of dimension 6
  !            contains possible error encountered in previously
  !            call on psdspins procedure. Set in f90_spall.
  !            Required.
  !  OVERLAP   INTEGER
  !            If equal to 0 then decomposition specified by PARTS
  !            subroutine must be without overlap. In this case is
  !            improved psdspasb perfomance.
  !            If not equal to 0  decomposition specified by PARTS
  !            subroutine could be have overlap.
  !            Optional. Default value 1.
  !
  ! AFMT       CHARACTER*5
  !            Requested output format for A. Can be: 'CSR','COO','JAD'.
  !            Default: 'CSR'
  !
  ! INPUT/OUTPUT
  !==============
  ! DECOMP_DATA TYPEDESC
  !             required
  ! DECOMP_DATA FIELDS
  !
  ! MATRIX_DATA   : Pointer to integer Array 
  !                contains some
  !               local and global information about matrix:
  !
  !  NOTATION        STORED IN		     EXPLANATION
  !  ------------ ---------------------- -------------------------------------
  !  DEC_TYPE        MATRIX_DATA[DEC_TYPE_]   Decomposition type, temporarly is
  !                      setted to 1( matrix not yet assembled)
  !  M 	             MATRIX_DATA[M_]          Total number of equations
  !  N 	             MATRIX_DATA[N_]          Total number of variables
  !  N_ROW           MATRIX_DATA[N_ROW_]      Number of local equations
  !  N_COL           MATRIX_DATA[N_COL_]      Number of local variables
  !                     already inserted.
  !  CTXT_A          MATRIX_DATA[CTXT_]     The BLACS context handle, 
  !                                         indicating
  !	  			            the global context of the operation
  !					    on the matrix.
  !					    The context itself is global.
  !
  !  LOC_TO_GLOB     Integer array of dimension equal to local
  !                  cols.
  !                  Element i (if >0) contains global identifier of local
  !                  variable i.
  !                  if < 0 then local identifier i is not yet assigned.
  !  GLOB_TO_LOC     Array of dimension equal to number of global 
  !                  cols (MATRIX_DATA[N_]).
  !                  Either: 
  !                  1. Index i belongs to current process: then GTL(i)>0
  !                  2. Index i belongs to process P  0<=P<=NP-1. In this case, 
  !                     corresponding entry was initialized to -(NP+P+1). 
  !                     If, during the insertion, we found    that index i 
  !                     is referenced by the local part of the matrix, we have
  !                     added NP to the corrisponding entry, so that a value
  !                       -NP <= GTL(i) <= -1  marks an index referenced by
  !                     the local matrix, and gives the process owning it,
  !                     whereas a value GTL(i) < -NP marks an index not referenced.
  !                              
  !  HALO_INDEX      pointer to integer array
  !             EXPLANATION
  !  Let HALO_INDEX_P be the array DESC_HALO for local process.
  !  This is composed of variable dimension blocks for each process to 
  !  communicate to.
  !  Each block contain indexes of local halo elements to exchange with other 
  !  process.
  !  We attempt to optimize the order of communications; BEWARE: do not change 
  !  the organizing code without checking with the matrix multiply internals 
  !  to KEEP THE CODE DEADLOCK FREE. 
  !  Let P be the pointer to the first element of a block in HALO_INDEX_P.
  !  This block is stored in HALO_INDEX_P as :
  !
  !  NOTATION        STORED IN		          EXPLANATION
  !  --------------- --------------------------- -----------------------------------
  !  PROCESS_ID      HALO_INDEX_P[P+PROC_ID_]      Identifier of process with which 
  !                                                data is  exchanged.
  !  N_ELEMENTS_RECV HALO_INDEX_P[P+N_ELEM_RECV_]  Number of elements to receive.
  !  ELEMENTS_RECV   HALO_INDEX_P[P+ELEM_RECV_+i]  Indexes of local elements to
  !					          receive. These are stored in the
  !					          array from location P+ELEM_RECV_ to
  !					          location P+ELEM_RECV_+
  !						  HALO_INDEX_P[P+N_ELEM_RECV_]-1.
  !  N_ELEMENTS_SEND HALO_INDEX_P[P+N_ELEM_SEND_]  Number of elements to send.
  !  ELEMENTS_SEND   HALO_INDEX_P[P+ELEM_SEND_+i]  Indexes of local elements to
  !					          send. These are stored in the
  !					          array from location P+ELEM_SEND_ to
  !					          location P+ELEM_SEND_+
  !						  HALO_INDEX_P[P+N_ELEM_SEND_]-1.
  !
  !  OVRLAP_INDEX      pointer to integer array
  !             EXPLANATION
  !
  !  Let DESCOVRLP_P be the array DESC_OVRLAP for local process.
  !  This is composed of variable dimension blocks for each process to 
  !  communicate to.
  !  Each block contain indexes of local overlap elements to exchange with
  !  other process.
  !  Let P be the pointer to the first element of a block in DESCOVRLP_P.
  !  This block is stored in DESCOVRLP_P as :
  !
  !  NOTATION        STORED IN		            EXPLANATION
  !  ------------- ------------------------------- ---------------------------------
  !  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process with which
  !                                                to exchange data.
  !  N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
  !  OVRLAP_RECV   DESCOVRLP_P[P+ELEM_RECV_+i]     Indexes of local elements to
  !					           receive. These are stored in the
  !					           array from location P+OVRLP_ELEM_
  !                                                to location P+OVRLP_ELEM_+
  !						   DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
  !  OVRLAP_SEND   DESCOVRLP_P[P+ELEM_SEND_+i]     Indices of local elements to
  !					           send.These are stored in the
  !					           array from location P+ELEM_SEND_ 
  !                                                to location P+ELEM_SEND_+
  !						   DESCOVRLP_P[P+N_ELEM_SEND_]-1.
  !
  !
  !  Let OVR_ELEM_P be the array OVERLAP_ELEM for local process.
  !  This is composed of blocks of two elements. The block
  !  corresponding to the i-th overlapped elements, begin at index 
  !  P = i*2 in array OVR_ELEM_P.
  !  This block is stored in OVR_ELEM_P as :
  !
  !  NOTATION      STORED IN		       EXPLANATION
  !  ------------- -------------------------- ----------------------------------
  !  OVRLAP_ELEM   OVR_ELEM_P[P+OVRLP_ELEM_]  The index of local overlapped 
  !					       element.
  !  N_DOMAINS     OVR_ELEM_P[P+N_DOM_OVR_]   The number of copies of
  !					       local overlapped element.
  !
  ! 
  !
  !  BND_ELEM    pointer to INTEGER array
  !               EXPLANATION
  !   Contains indexes for the boundary local elements
  !
  ! END DECOMP_DATA FIELDS
  !
  !
  !  A              TYPESP
  !                 required
  !  A FIELDS
  !  FIDA         : character*5
  !                 Describe some caracteristics of final sparse
  !                 matrix rapresentation
  !
  !  DESCRA       : character*11 
  !                 Contains some additional informations on 
  !                 sparse matrix rappresentation.
  !  ASPK           pointer to d.p. array of dimension equal NNZ
  !                 contains information about entry matrix 
  !                 inserted.
  !  IA1            pointer to int array of dimension equal NNZ.
  !                 contains information about entry matrix yet
  !                 inserted.
  !  IA2             pointer to int array of dimension equal NNZ
  !                 contains information about entry matrix yet
  !                 inserted.
  !  PL             Integer pointer to a permutation vector; 
  !                 PL(1) is set to 0 in case of no left permutation.
  !  PR             Integer pointer to a permutation vector; 
  !                 PR(1) is set to 0 in case of no right permutation.
  !  INFOA          integer array of dimension 10
  !
  ! END A FIELDS
  Use TYPEDESC
  Use TYPESP
  Use TOOLS_CONST
  Implicit None
  interface 
    subroutine PSI_CONVERT_COMM(DESC_DATA, &
         & HALO_IN, OVRLAP_IN,DESC_HALO, LENGTH_DH,&
         & DESC_OVERLAP, LENGTH_DO,OVRLAP_ELEM, LENGTH_OE,&
         & LOC_TO_GLOB,GLOB_TO_LOC, WORK,LWORK)

      Implicit None
      !     .....Array Input Arguments....
      Integer, intent(inout) ::  DESC_DATA(*),OVRLAP_ELEM(*),&
           & DESC_HALO(*),DESC_OVERLAP(*), LOC_TO_GLOB(*),GLOB_TO_LOC(*)
      INTEGER, intent(inout) :: OVRLAP_IN(*),HALO_IN(*), WORK(*)
      !     ...scalar parameters....
      INTEGER, INTENT(in) :: LWORK,LENGTH_DH,LENGTH_DO,LENGTH_OE
    END SUBROUTINE PSI_CONVERT_COMM
  END INTERFACE

  interface dcsdp

    subroutine dcsdp(CHECK,TRANS,M,N,UNITD,D,&
         & FIDA,DESCRA,A,IA1,IA2,INFOA,&
         & PL,FIDH,DESCRH,H,IH1,IH2,INFOH,PR,LH,LH1,LH2,&
         & WORK,LWORK,K,IERROR)
      INTEGER, INTENT(in)   :: LH, LWORK, LH1, LH2, &
         & M, N                 
      INTEGER, INTENT(out)  :: IERROR                 
      INTEGER, INTENT(inout) :: K
      CHARACTER, INTENT(in) :: CHECK, TRANS, UNITD                               
      DOUBLE PRECISION, INTENT(in)  :: D(*), A(*)
      DOUBLE PRECISION, INTENT(out) :: H(*)
      DOUBLE PRECISION, INTENT(inout) :: WORK(*)
      INTEGER, INTENT(in)  :: IA1(*), IA2(*), INFOA(*)
      INTEGER, INTENT(out) :: IH1(*), IH2(*), PL(*),PR(*), INFOH(*) 
      CHARACTER, INTENT(in) ::  FIDA*5, DESCRA*11
      CHARACTER, INTENT(out) :: FIDH*5, DESCRH*11
    END SUBROUTINE DCSDP
  END INTERFACE

  INTERFACE CEST
      SUBROUTINE CEST(AFMT, NNZ, LIA1, LIA2, LAR, UP)
        INTEGER, INTENT(in) ::  NNZ 
        INTEGER, INTENT(out) :: LIA1, LIA2, LAR
        CHARACTER, INTENT(in) :: AFMT*5, UP
      END SUBROUTINE CEST
  END INTERFACE

  interface dcsrp

     SUBROUTINE DCSRP(TRANS,M,N,FIDA,DESCRA,IA1,IA2,&
          & INFOA,P,WORK,LWORK,IERROR)
       INTEGER, intent(in)  :: M, N, LWORK
       INTEGER, intent(out) :: IERROR
       CHARACTER, intent(in) ::       TRANS
       DOUBLE PRECISION, intent(inout) :: WORK(*)                     
       INTEGER, intent(in)    :: P(*)
       INTEGER, intent(inout) :: IA1(*), IA2(*), INFOA(*) 
       CHARACTER, intent(in)  :: FIDA*5, DESCRA*11
     end SUBROUTINE DCSRP
  END interface

  interface dcsprt
    subroutine dcsprt(M,N,FIDA,DESCRA,A,IA1,IA2,INFOA ,IOUT,IERROR)
      INTEGER, intent(in)  ::  IOUT,M, N                 
      INTEGER, intent(out) ::  IERROR                 
      DOUBLE PRECISION, intent(in) :: A(*)
      INTEGER, intent(in)   :: IA1(*), IA2(*), INFOA(*)
      CHARACTER, intent(in) :: FIDA*5, DESCRA*11
    end SUBROUTINE DCSPRT
  END interface

  interface isaperm

    logical function isaperm(N,IP)
      INTEGER, intent(in)    :: N   
      INTEGER, intent(inout) :: IP(*)
    end function isaperm
  END interface

  !...Parameters....
  TYPE(D_SPMAT), INTENT (inout)         :: A
  TYPE(DECOMP_DATA_TYPE), INTENT(inout) :: DECOMP_DATA
  INTEGER   	             :: IERRV(:)
  INTEGER,OPTIONAL, INTENT(in)          :: overlap, DUP
  CHARACTER, OPTIONAL, INTENT(in)       :: AFMT*5, UP
  !....Locals....
  Integer                       ::  INT_ERR(5),P(1),INFOA(10)
  Integer,Pointer      ::  OVRLAP_ELEM(:),OVRLAP_INDEX(:)&
       & ,HALO_INDEX(:)
  Real(Kind(1.d0))              ::  REAL_ERR(5),D(1)
  Integer,Pointer               ::  I_TEMP(:), IA1(:),IA2(:),&
       & WORK_ASBX(:),WORK5(:)
  Real(Kind(1.d0)),Pointer      ::  ASPK(:), WORK_DCSDP(:), R_TEMP(:)
  Integer                       ::  IA1_SIZE,IA2_SIZE,ASPK_SIZE,INFO&
       & ,I,ERR,NPROW,NPCOL,ME,MYPCOL ,SIZE_REQ,SIZE_MTRX_DATA,idup&
       & ,IERROR ,lovrlap,lhalo,nhalo,novrlap,MAX_SIZE,MAX_SIZE1,irv&
       & ,MAX_HALO,lovrlap_elem,size_req1,N_COL,l_dcsdp, iout, kh, nh
  Integer                       :: ALLOCATED_WORK5, iupdup
  Character                     :: FIDA*5, DESCRA*11
  Integer                       :: LWORK_DCSDP,LWORK5,LDESC_HALO,&
       &L_ASBX,LDESC_OVRLAP, DECTYPE, NR,NS,k,j
  Integer                       :: ICONTXT,TEMP(1),N_ROW,IOVERLAP
  Character                     :: CHECK*1, TRANS*1, UNITD*1
  Integer, Parameter            :: IONE=1
  Character                     :: NAME*20,iup

  Real(Kind(1.d0))              :: TIME(10), MPI_WTIME
  External MPI_WTIME
  logical, parameter :: debug=.false., debugwrt=.false.

  TIME(1) = MPI_WTIME()

  IF (PRESENT(OVERLAP)) THEN
    IOVERLAP=OVERLAP
  ELSE
    IOVERLAP=1
  ENDIF

  IUPDUP=0
  IF (PRESENT(UP)) THEN
     IF(UP.EQ.'Y') THEN
        IUPDUP=4
        IUP=UP
     ELSE IF (UP.NE.'N') THEN
        WRITE(0,*)'Wrong value for update input in ASB...'
        WRITE(0,*)'Changing to default'
        IUP='N'
     ELSE
        IUP='N'
     ENDIF
  ELSE
     IUP='N'
  ENDIF

  IF (PRESENT(DUP)) THEN
     IF((DUP.LT.1).OR.(DUP.GT.3)) THEN
        WRITE(0,*)'Wrong value for duplicate input in ASB...'
        WRITE(0,*)'Changing to default'
        IDUP=1
     ELSE  
        IDUP=DUP
     ENDIF
  ELSE
     IDUP=1
  ENDIF
  IUPDUP=IEOR(IUPDUP,IDUP)
  
  A%INFOA(UPD_)=IUPDUP
  if (debug) write(0,*)'in ASB',upd_,iupdup

  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
  DECTYPE=DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)
  N_ROW = DECOMP_DATA%MATRIX_DATA(N_ROW_)
  N_COL = DECOMP_DATA%MATRIX_DATA(N_COL_)

  INFO=0
  NAME = 'F90_PSSPASB'
  ! check on BLACS grid 
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  If (NPROW.EQ.-1) Then
    INFO = 2010
    Goto 9999
  Else If (NPCOL.NE.1) Then
    INFO = 2030
    INT_ERR(1) = NPCOL
  Endif

  IF (.not.is_ok_dec(dectype)) then 
    INFO = 600
    INT_ERR(1) = dectype
    if (debug) write(0,*) 'Dectype 1 :',dectype,sp_mat_bld,&
         &sp_mat_asb,sp_mat_upd
  ENDIF

  ERR = INFO
  If (ERR.NE.0) then 
    Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,&
         &TEMP ,TEMP,-IONE ,-IONE,-IONE)

    Goto 9999

  ENDIF

  if (debug) Write (*, *) '   Begin matrix assembly...'

  !check on errors encountered in psdspins
  If (IERRV(1).NE.0) Then
    NAME = 'PSDSPINS'
    INFO=IERRV(1)
    Do I=1,5
      INT_ERR(I)=IERRV(I+1)
    Enddo
  Endif
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,&
       &TEMP ,TEMP,-IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999

  IF (is_bld_dec(DECTYPE)) THEN 
    IF (debug) WRITE(*,*) 'SPASB: Checking rows insertion'
    ! check if all local row are inserted
    Do I=1,DECOMP_DATA%MATRIX_DATA(N_ROW_)
      If (DECOMP_DATA%LOC_TO_GLOB(I).LT.0) Then
        write(0,*) 'Error on index: ',i,decomp_data%loc_to_glob(I)
        INFO=3100
        Exit
      Endif
    Enddo
    ERR = INFO
    If (ERR.NE.0) then    
      Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,&
           &TEMP ,TEMP,-IONE ,-IONE,-IONE)
      Goto 9999
    ENDIF


    ! convert only without check
    CHECK='N'
    TRANS='N'
    UNITD='U'
    ! convert to user requested format
    FIDA   = A%FIDA
    DESCRA = A%DESCRA
    IF (PRESENT(AFMT)) THEN
      A%FIDA = AFMT
    ELSE 
      A%FIDA = '???'
    ENDIF


    IA1_SIZE=(A%INFOA(IA1_POINTER_)+1)
    IA2_SIZE=(A%INFOA(IA2_POINTER_)+1)
    ASPK_SIZE=A%INFOA(ASPK_POINTER_)

    ! work area requested must be fixed to
    ! No of Grid'd processes and NNZ+2
    SIZE_REQ=MAX(ASPK_SIZE,IA1_SIZE,IA2_SIZE)+2

    CALL CEST(A%FIDA, SIZE_REQ, IA1_SIZE, IA2_SIZE, ASPK_SIZE, IUP)
    ALLOCATE(ASPK(ASPK_SIZE),IA1(IA1_SIZE),&
         &IA2(IA2_SIZE),STAT=INFO)
    
    IF (INFO.NE.0) THEN
      INFO=2025
      INT_ERR(1)=ASPK_SIZE
    Endif
    ERR = INFO
    If (ERR.NE.0) then    
      Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,&
           &TEMP,TEMP,-IONE ,-IONE,-IONE)
      GOTO 9999
    ENDIF
!!$    ASPK(1:ASPK_SIZE) = A%ASPK(1:ASPK_SIZE)
    IF (debug) THEN 
!!$       do i=1,aspk_size
!!$         write(*,*) 'ASB90 ',i,aspk(i)
!!$       enddo
    ENDIF
!!$    IA1(1:IA1_SIZE-1) = A%IA1(1:IA1_SIZE-1)

!!$     IA2(1:IA2_SIZE-1) = A%IA2(1:IA2_SIZE-1)     
    ! Trick to leave room for indices in A%IA2, to speed up 
    ! rebuilding the matrix later on .......
    R_TEMP   => A%ASPK
    A%ASPK   => ASPK
    ASPK     => R_TEMP


    I_TEMP   => A%IA1
    A%IA1    => IA1
    IA1      => I_TEMP

    I_TEMP   => A%IA2
    A%IA2    => IA2
    IA2      => I_TEMP

    INFOA(1:10)       = A%INFOA(1:10)
    ! comm desc_size is size requested for temporary comm descriptors
    ! (expressed in No of dble element)
    LDESC_HALO   = (((3*(N_COL-N_ROW)+1)+1))
    !    LDESC_OVRLAP = (((3*A%INFOA(OVR_DIM_)+1)+1))
    OVRLAP_INDEX => DECOMP_DATA%OVRLAP_INDEX
    NULLIFY(DECOMP_DATA%OVRLAP_INDEX)
    halo_index => decomp_data%halo_index
    NULLIFY(decomp_data%halo_index)
    IF (DEBUG) WRITE(*,*) me,' LDESC_HALO ',ldesc_halo,&
         & n_row,n_col
    lhalo = 1
    DO WHILE (halo_index(lhalo).NE.-1)
      lhalo = lhalo + 1 
    ENDDO
    nhalo = (lhalo-1)/3
    lovrlap=1
    DO WHILE (ovrlap_index(lovrlap).NE.-1) 
      lovrlap=lovrlap+1
    ENDDO
    novrlap = (lovrlap-1)/3

    ! L_DCSDP is the size requested for dcsdp procedure
    L_DCSDP=(A%INFOA(IA1_POINTER_)+N_ROW+100)

    ALLOCATE(WORK_DCSDP(L_DCSDP),STAT=INFO)
    IF (INFO.NE.0) THEN
      INFO=2025
      INT_ERR(1)=L_DCSDP
    ENDIF
    IF (INFO.EQ.0) THEN
      DEAllocate(A%PL,A%PR,STAT=INFO)
      IF (INFO.EQ.0) THEN
        Allocate(A%PL(N_ROW),A%PR(N_COL),STAT=INFO)
        If (INFO.NE.0) Then
          INFO=2025
          INT_ERR(1)=N_ROW
        Endif
      else
        info=2040
      ENDIF
    end IF
    ! check on allocation
    ERR = INFO
    If (ERR.NE.0) then    
      Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,&
           &TEMP,TEMP,-IONE ,-IONE,-IONE)
      If (ERR.NE.0) Goto 9999
    endif

    LWORK_DCSDP=Size(WORK_DCSDP)
    ! set INFOA(1) to NNZERO
    INFOA(1) = A%INFOA(IA1_POINTER_)
    A%PL(:)  = 0
    A%PR(:)  = 0
    IERROR   = 0
    If (debug) Write (0, *) '   ASB:  Calling DCSDP',lwork_dcsdp,&
         &size(work_dcsdp),infoa(1)
    ! convert ASPK,IA1,IA2 in requested representation mode
    if (debugwrt) then
      iout = 30+me
      open(iout)
!!$        write(*,*) 'IOUT ',iout
      call dcsprt(N_ROW,N_COL,FIDA,DESCRA,ASPK,IA1,&
           & IA2,INFOA,iout,ierror)
      close(iout)
    endif
    ! result is put in A


    CALL DCSDP(CHECK,TRANS,N_ROW,N_COL,UNITD,D,FIDA,DESCRA,&
         & ASPK,IA1,IA2,INFOA,&
         & A%PL,A%FIDA,A%DESCRA,A%ASPK,A%IA1,A%IA2,A%INFOA,A%PR,&
         & SIZE(A%ASPK),SIZE(A%IA1),SIZE(A%IA2),&
         & WORK_DCSDP,SIZE(WORK_DCSDP),SIZE_REQ,IERROR)
    write(0,*)'dopo DCSDP',infoa(upd_),a%infoa(upd_)
    IF (SIZE_REQ.NE.0) THEN
       DEALLOCATE(A%IA1,A%IA2,A%ASPK,STAT=INFO)
       IF (INFO.EQ.0) THEN
          ALLOCATE(A%IA1(2*SIZE_REQ+100),A%IA2(SIZE_REQ),&
          & A%ASPK(SIZE_REQ),STAT=INFO)
          IF (INFO.NE.0) THEN
             INFO=2025
             INT_ERR(1)=SIZE_REQ
          ENDIF
       ELSE
          info=2040
       ENDIF
       CALL DCSDP(CHECK,TRANS,N_ROW,N_COL,UNITD,D,FIDA,DESCRA,&
       & ASPK,IA1,IA2,INFOA,&
       & A%PL,A%FIDA,A%DESCRA,A%ASPK,A%IA1,A%IA2,A%INFOA,A%PR,&
       & SIZE(A%ASPK),SIZE(A%IA1),SIZE(A%IA2),&
       & WORK_DCSDP,SIZE(WORK_DCSDP),SIZE_REQ,IERROR)
    ENDIF
      
      A%M = N_ROW
      A%K = N_COL
      
      
    IF (debug) WRITE (*, *) me,'   ASB:  From DCSDP',ierror,' ',A%FIDA
      
                                ! check on error retuned by dcsdp
    IF (IERROR.NE.0) THEN
      INFO=1040
      INT_ERR(1)=IERROR
    ENDIF
    ERR = INFO
    Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR,IONE,&
         &TEMP ,TEMP,-IONE ,-IONE,-IONE)
    If (ERR.NE.0) Goto 9999
    if (debugwrt) then
      iout = 60+me
      open(iout)
!!$        write(*,*) 'IOUT ',iout
      call dcsprt(N_ROW,N_COL,A%FIDA,A%DESCRA,A%ASPK,A%IA1,&
           & A%IA2,A%INFOA,iout,ierror)
      close(iout)
    endif

    TIME(2) = MPI_WTIME()
    TIME(2) = TIME(2) - TIME(1)
    if (debug) then 
      Call DGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, TIME(2),&
           & IONE,TEMP ,TEMP,-IONE ,-IONE,-IONE)

      Write (*, *) '      matrix assembly: ', TIME(2)*1.d-3
    end if

    TIME(3) = MPI_WTIME()

    If (debug) Write (*, *) '   Begin comm structs assembly: '

    ! Allocate final comm PSBLAS descriptors

    ! compute necessary dimension of halo index
    MAX_HALO=NHALO
    MAX_SIZE= Min(3*DECOMP_DATA%MATRIX_DATA(N_ROW_),NOVRLAP*3)
    MAX_SIZE1=MAX_SIZE

    Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, MAX_SIZE,&
         & IONE,TEMP ,TEMP,-IONE ,-IONE,-IONE)
    Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE,MAX_HALO,&
         & IONE,TEMP ,TEMP,-IONE ,-IONE,-IONE)

    LDESC_HALO=3*MAX_HALO+3*NHALO+1

    ! allocate HALO_INDEX field
    Allocate(DECOMP_DATA%HALO_INDEX(LDESC_HALO),STAT=INFO)
    ! check on ALLOCATE
    If (INFO.NE.0) Then
      INFO=2023
      INT_ERR(1)=LDESC_HALO
    Endif

    if (info.eq.0) then 
      ! compute necessary dimension of ovrlap index
      LDESC_OVRLAP=2*LOVRLAP+1

      ! allocate OVRLAP_INDEX field
      Allocate(DECOMP_DATA%OVRLAP_INDEX(LDESC_OVRLAP),STAT=INFO)
      ! check on ALLOCATE
      If (INFO.NE.0) Then
        INFO=2023
        INT_ERR(1)=LDESC_OVRLAP
      Endif
    endif
!!$    if (info.eq.0) then 
!!$      LOVRLAP_ELEM=3*NOVRLAP+10
!!$      ! allocate OVRLAP_ELEM field
!!$      Allocate(DECOMP_DATA%OVRLAP_ELEM(LOVRLAP_ELEM),STAT=INFO)
!!$      ! check on ALLOCATE
!!$      If (INFO.NE.0) Then
!!$        INFO=2023
!!$        INT_ERR(1)=LOVRLAP_ELEM
!!$      Endif
!!$    endif
    ERR = INFO
    If (ERR.NE.0) then    
      Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR,&
           & IONE,TEMP ,TEMP,-IONE ,-IONE,-IONE)
      Goto 9999
    endif

    SIZE_REQ1=MAX((MAX_SIZE+MAX_SIZE1),4*NPROW*(NPROW+1)*5)

    SIZE_REQ=(4*NPROW*(NPROW+1)*5)+(NPROW+1)+(Max&
         & (NHALO,SIZE_REQ1)+1)
    SIZE_REQ = MAX(SIZE_REQ,2*LWORK_DCSDP)
    DEALLOCATE(WORK_DCSDP,STAT=INFO)
    IF (INFO.NE.0)  INFO =2040
    ALLOCATE(WORK5(SIZE_REQ),STAT=INFO)
    IF (INFO.NE.0) THEN
      INFO=2025
      INT_ERR(1)=SIZE_REQ
    Endif
    LWORK5=Size(WORK5)

    ERR = INFO
    Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR,&
         & IONE,TEMP ,TEMP,-IONE ,-IONE,-IONE)
    If (ERR.NE.0) Goto 9999
    if (debug) write(*,*) 'SPASB: Calling convert_comm',&
         & nhalo,lhalo,halo_index(lhalo)
    !.... convert comunication stuctures....
    Call PSI_CONVERT_COMM(DECOMP_DATA%MATRIX_DATA,&
         & HALO_INDEX, OVRLAP_INDEX,&
         & DECOMP_DATA%HALO_INDEX,Size(DECOMP_DATA%HALO_INDEX),&
         & DECOMP_DATA%OVRLAP_INDEX,Size(DECOMP_DATA%OVRLAP_INDEX),&
         & DECOMP_DATA%OVRLAP_ELEM,Size(DECOMP_DATA%OVRLAP_ELEM),&
         & DECOMP_DATA%LOC_TO_GLOB,DECOMP_DATA%GLOB_TO_LOC,&
         & WORK5,LWORK5)

    ! Now compute and store BND_ELEM
    ALLOCATE(i_temp(2*max_halo+1))
    i=0
    j=1
    do while(decomp_data%halo_index(j) /=  -1) 
      nr = decomp_data%halo_index(j+1)
      ns = decomp_data%halo_index(j+1+nr+1)
      do k=1, ns
        i = i + 1
        i_temp(i) = decomp_data%halo_index(j+1+nr+1+k)
      enddo
      j  = j + 1 + ns + 1 + nr + 1
    enddo
    if (i>0) then 
      call isr(i,i_temp)
      j=1
      irv = i_temp(1)
      do k=2, i
        if (i_temp(k) /= irv) then
          irv = i_temp(k)
          j = j + 1 
          i_temp(j) = i_temp(k)
        endif
      enddo
    else
      j = 0
    endif
    allocate(decomp_data%bnd_elem(j+1))
    if (.false.) then 
      decomp_data%bnd_elem(1) = j 
      decomp_data%bnd_elem(2:j+1) = i_temp(1:j)
    else
      decomp_data%bnd_elem(1:j) = i_temp(1:j)
      decomp_data%bnd_elem(j+1) = -1
    endif
      if (debug) then 
      write(0,*)'BND:',j,' : ',decomp_data%bnd_elem(1:j+1) 
      k=size(decomp_data%halo_index)
      write(0,*)'HIDX: ',decomp_data%halo_index(1:k)
    endif

!!$     if ((a%pl(1) /= 0).and.(a%pr(1)==0))   then 
!!$       if (isaperm(n_row,a%pl)) then
!!$         write(0,*) 'Check OK on permutation'
!!$       else
!!$         write(0,*) 'Check Failed ??'
!!$       endif
!!$       
!!$       if (debug) write(0,*) 'SPASB: Here we go with ',A%PL(1) 
!!$       allocate(decomp_data%lprm(n_col))
!!$       do i=1, n_row
!!$         decomp_data%lprm(a%pl(i)) = i
!!$       enddo
!!$       do i=n_row+1,n_col
!!$         decomp_data%lprm(i) = i
!!$       enddo
!!$       ! Crossed fingers.....
!!$       ! Fix glob_to_loc/loc_to_glob  mappings, then indices lists
!!$       ! Hmm, maybe we should just moe all of this onto a different level,
!!$       ! Have a specialized subroutine, and do it in the solver context???? 
!!$       if (debug) write(0,*) 'SPASB: Renumbering glob_to_loc'
!!$       do i=1, n_col
!!$         decomp_data%glob_to_loc(decomp_data%loc_to_glob(decomp_data%lprm(i))) = i  
!!$       enddo
!!$       if (debug) write(0,*) 'SPASB: Renumbering loc_to_glob'
!!$       do i=1,decomp_data%matrix_data(m_) 
!!$         j = decomp_data%glob_to_loc(i)
!!$         if (j>0) then 
!!$           decomp_data%loc_to_glob(j) = i
!!$         endif
!!$       enddo
!!$       if (debug) write(0,*) 'SPASB: calling dcsrp',size(work_dcsdp)
!!$       call dcsrp('N',n_row,n_col,A%FIDA,A%DESCRA,A%IA1,A%IA2,A%INFOA,&
!!$            &a%pl,work_dcsdp,SIZE(WORK_DCSDP),IERROR)
!!$       if (debug) write(0,*) 'SPASB: renumbering halo_index'
!!$       i=1
!!$       kh=decomp_data%halo_index(i)
!!$       do while (kh /= -1) 
!!$         i = i+1
!!$         nh = decomp_data%halo_index(i)
!!$         do j = i+1, i+nh
!!$           decomp_data%Halo_index(j) = &
!!$                &decomp_data%lprm(decomp_data%halo_index(j))
!!$         enddo
!!$         i = i + nh + 1
!!$         nh = decomp_data%halo_index(i)
!!$         do j= i+1, i+nh
!!$           decomp_data%Halo_index(j) = &
!!$                &decomp_data%lprm(decomp_data%halo_index(j))
!!$         enddo
!!$         i = i + nh + 1
!!$         kh=decomp_data%halo_index(i)
!!$       enddo
!!$       if (debug) write(0,*) 'SPASB: renumbering ovrlap_index'
!!$       i=1
!!$       kh=decomp_data%ovrlap_index(i)
!!$       do while (kh /= -1) 
!!$         i = i + 1
!!$         nh = decomp_data%ovrlap_index(i)
!!$         do j= i+1, i+nh
!!$           decomp_data%Ovrlap_index(j) = &
!!$                &decomp_data%lprm(decomp_data%ovrlap_index(j))
!!$         enddo
!!$         i = i + nh + 1
!!$         kh=decomp_data%ovrlap_index(i)
!!$       enddo
!!$       if (debug) write(0,*) 'SPASB: renumbering ovrlap_elem'
!!$       i = 1
!!$       kh=decomp_data%ovrlap_elem(i)
!!$       do while (kh /= -1)          
!!$         decomp_data%ovrlap_elem(i) = &
!!$                &decomp_data%lprm(decomp_data%ovrlap_elem(i))
!!$         i = i+2
!!$         kh=decomp_data%ovrlap_elem(i)         
!!$       enddo
!!$       if (debug) write(0,*) 'SPASB: done renumbering'
!!$
!!$       a%pl(1) = 0
!!$     else 
!!$       allocate(decomp_data%lprm(1))
!!$       decomp_data%lprm(1) = 0       
!!$     endif

    ! Ok, register into MATRIX_DATA
    DECOMP_DATA%MATRIX_DATA(DEC_TYPE_) = SP_MAT_ASB

    ! free temporary work areas
    DEALLOCATE(ASPK,IA1,IA2,HALO_INDEX,OVRLAP_INDEX,&
         &WORK5,i_temp, STAT=INFO)
    IF (INFO.NE.0)  INFO =2040

    ! check on free
    ERR = INFO
    CALL IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR,&
         & IONE,TEMP ,TEMP,-IONE ,-IONE,-IONE)
    IF (ERR.NE.0) GOTO 9999

  ELSE IF (is_upd_dec(DECTYPE)) THEN
    ! Right now, nothing to be done, but this may change in the future
    ! as we revise the implementation of the UPDATE routine. 
    L_DCSDP=SIZE(A%ASPK)+1000     
    ALLOCATE(WORK_DCSDP(L_DCSDP),ASPK(1),IA1(1),&
         &IA2(1), STAT=INFO)
    If (INFO.NE.0) Then
      INFO=2025
      INT_ERR(1)=L_DCSDP
    Endif
    ! check on allocation
    ERR = INFO
    If (ERR.NE.0) then    

      Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,&
           &TEMP,TEMP,-IONE ,-IONE,-IONE)
      Goto 9999
    else 

      LWORK_DCSDP=Size(WORK_DCSDP)
      CHECK='R'
      TRANS='N'
      UNITD='U'
      Call DCSDP(CHECK,TRANS,N_ROW,N_COL,UNITD,D,FIDA,DESCRA,&
           & ASPK,IA1,IA2,INFOA,&
           & A%PL,A%FIDA,A%DESCRA,A%ASPK,A%IA1,A%IA2,A%INFOA,A%PR,&
           & SIZE(A%ASPK),SIZE(A%IA1),SIZE(A%IA2),&
           & WORK_DCSDP,SIZE(WORK_DCSDP),SIZE_REQ,IERROR)

      ! check on error retuned by dcsdp
      IF (IERROR.NE.0) THEN
        INFO=1040
        INT_ERR(1)=IERROR
      ELSE
        Deallocate(WORK_DCSDP,ASPK,IA1,IA2,STAT=INFO)
        If (INFO.NE.0)  INFO =2040
      ENDIF
    endif
    ! check on free
    ERR = INFO
    Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR,&
         & IONE,TEMP ,TEMP,-IONE ,-IONE,-IONE)
    If (ERR.NE.0) Goto 9999           

    DECOMP_DATA%MATRIX_DATA(DEC_TYPE_) = SP_MAT_UPD_ASB

  ELSE
    INFO = 600
    if (debug) write(0,*) 'Dectype 2 :',dectype,sp_mat_bld,&
         &sp_mat_asb,sp_mat_upd
  ENDIF


  TIME(4) = MPI_WTIME()
  TIME(4) = TIME(4) - TIME(3)
  if (debug) then 
    Call DGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, TIME(4),&
         & IONE,TEMP ,TEMP,-IONE ,-IONE,-IONE)

    Write (*, *) '         comm structs assembly: ', TIME(4)*1.d-3
  end if

  Return
9999 Call PSDERROR( ICONTXT, INFO, NAME, INT_ERR, REAL_ERR )
End Subroutine PSDSPASB
