! ---------------------------------------------------------------------
!
!  -- PSSBLAS routine (version 1.0) --
!
!  ---------------------------------------------------------------------
!/
Subroutine PSDSPALLOC(A,  IERRV, DECOMP_DATA, NNZ)
  
  !  Purpose
  !  =======
  !  
  !  Allocate sparse matrix structure for psblas routines.....
  !
  !
  ! INPUT
  !======
  ! M                 :(Global Input) Integer 
  !                    Total number of  equations
  !                    required.
  ! N                 :(Global Input) Integer 
  !                    Total number of variables
  !                    required.
  !
  ! A            :  TYPE_SP
  ! A INPUT FIELDS:
  ! FIDA         :  (Global Input)character*5
  !                 Describe some caracteristics of final sparse
  !                 matrix rapresentation
  !
  ! DESCRA       :  (Global Input)character*11
  !                 Contains some additional informations on 
  !                 sparse matrix rappresentation.
  !
  ! END OF A INPUT FIELDS
  !
  !
  ! NNZ          : (Local Input)Integer.
  !                contains number of local nnzero elements  
  !                optional.    
  ! OUTPUT
  !=========
  ! DECOMP_DATA   : TYPEDESC
  ! DECOMP_DATA OUTPUT FIELDS:
  !
  ! MATRIX_DATA   : Pointer to integer Array 
  !                contains some
  !               local and global information about matrix:
  !
  !  NOTATION        STORED IN		     EXPLANATION
  !  ------------ ---------------------- -------------------------------------
  !  DEC_TYPE        MATRIX_DATA[DEC_TYPE_]   Decomposition type, temporarly is
  !  M 	             MATRIX_DATA[M_]          Total number of equations
  !  N 	             MATRIX_DATA[N_]          Total number of variables
  !  N_ROW           MATRIX_DATA[N_ROW_]      Number of local equations
  !  N_COL           MATRIX_DATA[N_COL_]      Number of local variables,
  !                     temporary setted to 0.
  !  CTXT_A          MATRIX_DATA[CTXT_]     The BLACS context handle, 
  !                                         indicating
  !	  			            the global context of the operation
  !					    on the matrix.
  !					    The context itself is global.
  !
  !  LOC_TO_GLOB     An array of dimension equal to number of local
  !                  cols, its output dimension is MATDATA_A[N_ROW_]*(COLROW_+1)
  !                  (estimation). all element are setted to -1.
  !  GLOB_TO_LOC     Array of dimension equal to number of global 
  !                  cols (MATRIX_DATA[N_])(estime). all element are setted to
  !                  -1.
  !  other fields are not allocated.
  !
  ! END OF DECOMP_DATA OUTPUT FIELDS
  !
  !
  ! A            :  TYPE_SP
  !                 contains informations about local sparse matrix
  !  A OUPUT FIELDS:
  !  ASPK            pointer to d.p. array of dimension equal NNZ (if specified)
  !  IA1             pointer to int array of dimension equal NNZ (if specified)
  !  IA2             pointer to int array of dimension equal NNZ (if specified)
  !  INFOA           integer array of dimension 10:
  !  INFOA(LTGPN_) setted to zero, indicates the value of last local index,
  !                assigned
  !  INFOA(ASPK_)  setted to zero, Pointer to A%aspk array
  !  INFOA(IA1_)   setted to zero, Pointer to A%IA1 array
  !  INFOA(IA2_)   setted to zero, Pointer to A%IA2 array
  !  INFOA(OVR_DIM_) contains the sum for every my overlap points
  !                number of processes which contains it setted to No of local
  !                overlap points
  !
  ! END OF A OUTPUT FIELDS
  !
  !  IERRV         : pointer to integer array of dimension 6
  !                  will contains information about possibles errors
  !                  encounterd in psdspins procedure.
  !                  IERRV(1) are setted to 0 (no errors).
  
  Use TYPEDESC
  Use TYPESP
  Use TOOLS_CONST
!  Implicit None
  !....Parameters...
  Type(DECOMP_DATA_TYPE), intent(inout) :: DECOMP_DATA
  Type(D_SPMAT), intent(out)            :: A
  Integer                       :: IERRV(:)
  Integer, Optional, intent(in)         :: NNZ

  !locals
  Integer                ::ICONTXT, dectype
  Integer             ::COUNTER,I,J,NPROW,NPCOL,ME,MYPCOL,INFO,LOC_ROW&
       & ,RES,LENGTH_IA1,LENGTH_IA2,ERR,LOC_COL,NPROCS,OVR_COUNTER
  Integer             :: INT_ERR(5),TEMP(1),EXCH(2)
  Real(Kind(1.d0))    :: REAL_ERR(5)
  Integer, Parameter  :: IONE=1, ITWO=2,ROOT=0
  Integer, Pointer    :: PRC_V(:)
  logical, parameter  :: debug=.false.

  INFO=0
  ICONTXT = DECOMP_DATA%MATRIX_DATA(CTXT_)
  DECTYPE=DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  if (debug) &
       &write(*,*) 'Starting spalloc ',icontxt,nprow,npcol,me
  
!     ....Verify BLACS Grid correctness..
  If (NPCOL.NE.1) Then
     INFO = 2030
     INT_ERR(1) = NPCOL
  Endif
  ERR = INFO
  if (debug) &
       &write(*,*) 'Starting spalloc ',icontxt,nprow,npcol,me
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE, TEMP, TEMP,&
       & -IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999

  if (debug) &
       &write(*,*) 'Got through IGAMX2D '


  IERRV(1) = 0
  !
  ! Hmm, Not a good idea, not all compilers can rely on any given
  ! value for non initialized pointers. Let's avoid this,
  ! and just rely on documentation. 
  ! check if psdalloc is already called for this matrix

  ! set fields in DECOMP_DATA%MATRIX_DATA....
  LOC_ROW = DECOMP_DATA%MATRIX_DATA(N_ROW_)
  M       = DECOMP_DATA%MATRIX_DATA(M_)
  N       =  DECOMP_DATA%MATRIX_DATA(N_)

  if (debug) &
       &write(*,*) 'Got through init '

  
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE, TEMP,&
       & TEMP,-IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999

  
  !...allocate matrix data...
  If (present(nnz))then 
    If (NNZ.LT.0) Then
	INFO=45
	INT_ERR(1)=7
	INT_ERR(2)=NNZ
     Endif
     LENGTH_IA1=NNZ
     LENGTH_IA2=NNZ
  Else 
     LENGTH_IA1=9*LOC_ROW
     LENGTH_IA2=9*LOC_ROW
  Endif
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE, TEMP,&
       & TEMP,-IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999
  if (debug) write(*,*) 'Allocating size:',length_ia1
  !....allocate APSK, IA1, IA2.....
  Allocate(A%ASPK(LENGTH_IA1),STAT=INFO)
  If (INFO.EQ.0) Then
     Allocate(A%IA1(LENGTH_IA1),STAT=INFO)
     If (INFO.EQ.0) Then
	Allocate(A%IA2(LENGTH_IA2),STAT=INFO)
	If (INFO.NE.0) Then
	   INFO=2023
	   INT_ERR(1)=LENGTH_IA2
	Endif
     Else
	INFO=2023
	INT_ERR(1)=LENGTH_IA1
     Endif
  Else
     INFO=2025
     INT_ERR(1)=LENGTH_IA1
  Endif
     
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE, TEMP,&
       & TEMP,-IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999
  
  !alloc temp permutation fields
  Allocate(A%PL(1),A%PR(1),STAT=INFO)
  If (INFO.NE.0) Then
     INFO=2023
     INT_ERR(1)=1
  Endif
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE, TEMP,&
       & TEMP,-IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999
  
  ! set permutation matrices
  A%PL(1)=0
  A%PR(1)=0
  ! set INFOA fields
  A%FIDA   = 'COI'
  A%DESCRA = 'GUN'
  A%INFOA(ASPK_POINTER_) = 0
  A%INFOA(IA1_POINTER_)  = 0
  A%INFOA(IA2_POINTER_)  = 0
  A%INFOA(OVR_DIM_)=DECOMP_DATA%MATRIX_DATA(OVR_CNT_)
  if (debug) write(0,*) 'SPALL: ',  &
       &DECOMP_DATA%MATRIX_DATA(DEC_TYPE_),SP_MAT_BLD
  DECOMP_DATA%MATRIX_DATA(DEC_TYPE_) = SP_MAT_BLD
  Return
  
9999 Call PSDERROR( ICONTXT, INFO, 'F90_SPALL\0', INT_ERR, REAL_ERR )

End Subroutine PSDSPALLOC
