! ---------------------------------------------------------------------
!
!  -- PSSBLAS routine (version 1.0) --
!
!  ---------------------------------------------------------------------
!
Subroutine PSDSCREN(TRANS,IPERM,DECOMP_DATA)
  !  Purpose
  !  =======
  !  
  !   Assembly sparse matrix and set psblas communications
  !   structures.
  !
  ! INPUT
  !====== 
  !
  ! INPUT/OUTPUT
  !==============
  ! DECOMP_DATA TYPEDESC
  !             required
  ! DECOMP_DATA FIELDS
  !
  ! MATRIX_DATA   : Pointer to integer Array 
  !                contains some
  !               local and global information about matrix:
  !
  !  NOTATION        STORED IN		     EXPLANATION
  !  ------------ ---------------------- -------------------------------------
  !  DEC_TYPE        MATRIX_DATA[DEC_TYPE_]   Decomposition type, temporarly is
  !                      setted to 1( matrix not yet assembled)
  !  M 	             MATRIX_DATA[M_]          Total number of equations
  !  N 	             MATRIX_DATA[N_]          Total number of variables
  !  N_ROW           MATRIX_DATA[N_ROW_]      Number of local equations
  !  N_COL           MATRIX_DATA[N_COL_]      Number of local variables
  !                     already inserted.
  !  CTXT_A          MATRIX_DATA[CTXT_]     The BLACS context handle, 
  !                                         indicating
  !	  			            the global context of the operation
  !					    on the matrix.
  !					    The context itself is global.
  !
  !  LOC_TO_GLOB     Integer array of dimension equal to local
  !                  cols.
  !                  Element i (if >0) contains global identifier of local
  !                  variable i.
  !                  if < 0 then local identifier i is not yet assigned.
  !  GLOB_TO_LOC     Integer Array of dimension equal to global 
  !                  cols (MATRIX_DATA[N_]).
  !                  Element i (if >0) contains local identifier of global
  !                  variable i.
  !  HALO_INDEX      pointer to integer array
  !             EXPLANATION
  !  Let HALO_INDEX_P be the array DESC_HALO for local process.
  !  This is composed of variable dimension blocks for each process to 
  !  communicate to.
  !  Each block contain indexes of local halo elements to exchange with other 
  !  process.
  !  Let P be the pointer to the first element of a block in HALO_INDEX_P.
  !  This block is stored in HALO_INDEX_P as :
  !
  !  NOTATION        STORED IN		          EXPLANATION
  !  --------------- --------------------------- -----------------------------------
  !  PROCESS_ID      HALO_INDEX_P[P+PROC_ID_]      Identifier of process which exchange
  !						  data with.
  !  N_ELEMENTS_RECV HALO_INDEX_P[P+N_ELEM_RECV_]  Number of elements to receive.
  !  ELEMENTS_RECV   HALO_INDEX_P[P+ELEM_RECV_+i]  Indexes of local elements to
  !					          receive. These are stored in the
  !					          array from location P+ELEM_RECV_ to
  !					          location P+ELEM_RECV_+
  !						  HALO_INDEX_P[P+N_ELEM_RECV_]-1.
  !  N_ELEMENTS_SEND HALO_INDEX_P[P+N_ELEM_SEND_]  Number of elements to send.
  !  ELEMENTS_SEND   HALO_INDEX_P[P+ELEM_SEND_+i]  Indexes of local elements to
  !					          send. These are stored in the
  !					          array from location P+ELEM_SEND_ to
  !					          location P+ELEM_SEND_+
  !						  HALO_INDEX_P[P+N_ELEM_SEND_]-1.
  !  OVRLAP_INDEX      pointer to integer array
  !             EXPLANATION
  !
  !  Let DESCOVRLP_P be the array DESC_OVRLAP for local process.
  !  This is composed of variable dimension blocks for each process to 
  !  communicate to.
  !  Each block contain indexes of local overlap elements to exchange with
  !  other process.
  !  Let P be the pointer to the first element of a block in DESCOVRLP_P.
  !  This block is stored in DESCOVRLP_P as :
  !
  !  NOTATION        STORED IN		            EXPLANATION
  !  ------------- ------------------------------- -----------------------------------
  !  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
  !						   data with.
  !  N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
  !  OVRLAP_RECV   DESCOVRLP_P[P+ELEM_RECV_+i]     Indexes of local elements to
  !					           receive. These are stored in the
  !					           array from location P+OVRLP_ELEM_ to
  !					           location P+OVRLP_ELEM_+
  !						   DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
  !  OVRLAP_SEND   DESCOVRLP_P[P+ELEM_SEND_+i]     Indexes of local elements to
  !					           send.These are stored in the
  !					           array from location P+ELEM_SEND_ to
  !					           location P+ELEM_SEND_+
  !						   DESCOVRLP_P[P+N_ELEM_SEND_]-1.
  !
  !
  !  Let OVR_ELEM_P be the array OVERLAP_ELEM for local process.
  !  This is composed of blocks of two elements. The block
  !  corresponding to the i-th overlapped elements, begin at index 
  !  P = i*2 in array OVR_ELEM_P.
  !  This block is stored in OVR_ELEM_P as :
  !
  !  NOTATION      STORED IN		       EXPLANATION
  !  ------------- -------------------------- ----------------------------------
  !  OVRLAP_ELEM   OVR_ELEM_P[P+OVRLP_ELEM_]  The index of local overlapped 
  !					       element.
  !  N_DOMAINS     OVR_ELEM_P[P+N_DOM_OVR_]   The number of copies of
  !					       local overlapped element.
  ! END DECOMP_DATA FIELDS
  Use TYPEDESC
  Use TOOLS_CONST

  interface isaperm

    logical function isaperm(N,IP)
      INTEGER, intent(in)    :: N   
      INTEGER, intent(inout) :: IP(*)
    end function isaperm
  END interface

  !...Parameters....
  Type(DECOMP_DATA_TYPE), intent(inout) ::  DECOMP_DATA
  Integer, intent(inout)                ::  IPERM(:)
  character, intent(in)                 :: trans
  !....Locals....
  Integer                       ::  IA1_SIZE,IA2_SIZE,ASPK_SIZE,INFO&
       & ,I,ERR,NPROW,NPCOL,ME,MYPCOL ,SIZE_REQ,SIZE_MTRX_DATA&
       & ,IERROR ,lovrlap,lhalo,nhalo,novrlap,MAX_SIZE,MAX_SIZE1&
       & ,MAX_HALO,lovrlap_elem,size_req1,N_COL,l_dcsdp, iout, kh, nh
  Integer                       :: ALLOCATED_WORK5
  Integer                       :: LWORK_DCSDP,LWORK5,LDESC_HALO,&
       &L_ASBX,LDESC_OVRLAP, DECTYPE
  Integer                       :: ICONTXT,TEMP(1),N_ROW,IOVERLAP, int_err(5)
  Character                     :: ITRANS*1 
  Integer, Parameter            :: IONE=1
  Character                     :: NAME*20
  Real(Kind(1.d0))              :: TIME(10), MPI_WTIME, real_err(6)
  External MPI_WTIME
  logical, parameter :: debug=.false.

  TIME(1) = MPI_WTIME()


  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
  DECTYPE=DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)
  N_ROW = DECOMP_DATA%MATRIX_DATA(N_ROW_)
  N_COL = DECOMP_DATA%MATRIX_DATA(N_COL_)
     
  INFO=0
  NAME = 'F90_PSDSCREN'
  ! check on BLACS grid 
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  If (NPROW.EQ.-1) Then
     INFO = 2010
     Goto 9999
  Else If (NPCOL.NE.1) Then
     INFO = 2030
     INT_ERR(1) = NPCOL
  Endif

  IF (.not.is_asb_dec(dectype)) then 
    INFO = 600
    INT_ERR(1) = dectype
    if (debug) write(0,*) 'Dectype 1 :',dectype,sp_mat_bld,&
         &sp_mat_asb,sp_mat_upd
  ENDIF

  if (iperm(1) /= 0) then 
    if (.not.isaperm(n_row,iperm)) then
      INFO = 610
      INT_ERR(1) = iperm(1)
      if (debug) write(0,*) 'Dectype 1 :',dectype,sp_mat_bld,&
           &sp_mat_asb,sp_mat_upd
      write(0,*) 'Check Failed on permutation ??'
    endif
  endif


  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,&
       &TEMP ,TEMP,-IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999

  if (debug) Write (*, *) '   Begin matrix assembly...'

  !check on errors encountered in psdspins
  
  if ((iperm(1) /= 0))   then 

    if (debug) write(0,*) 'SPASB: Here we go with ',IPERM(1) 
    deallocate(decomp_data%lprm)
    allocate(decomp_data%lprm(n_col))
    if (trans.eq.'N') then 
      do i=1, n_row
        decomp_data%lprm(iperm(i)) = i
      enddo
      do i=n_row+1,n_col
        decomp_data%lprm(i) = i
      enddo
    else if (trans.eq.'T') then 
      do i=1, n_row
        decomp_data%lprm(i) = iperm(i)
      enddo
      do i=n_row+1,n_col
        decomp_data%lprm(i) = i
      enddo
    endif
    ! Crossed fingers.....
    ! Fix glob_to_loc/loc_to_glob  mappings, then indices lists
    ! Hmm, maybe we should just moe all of this onto a different level,
    ! Have a specialized subroutine, and do it in the solver context???? 
    if (debug) write(0,*) 'SPASB: Renumbering glob_to_loc'
    do i=1, n_col
      decomp_data%glob_to_loc(decomp_data%loc_to_glob(decomp_data%lprm(i))) = i  
    enddo
    if (debug) write(0,*) 'SPASB: Renumbering loc_to_glob'
    do i=1,decomp_data%matrix_data(m_) 
      j = decomp_data%glob_to_loc(i)
      if (j>0) then 
        decomp_data%loc_to_glob(j) = i
      endif
    enddo
    if (debug) write(0,*) 'SPASB: renumbering halo_index'
    i=1
    kh=decomp_data%halo_index(i)
    do while (kh /= -1) 
      i = i+1
      nh = decomp_data%halo_index(i)
      do j = i+1, i+nh
        decomp_data%Halo_index(j) = &
             &decomp_data%lprm(decomp_data%halo_index(j))
      enddo
      i = i + nh + 1
      nh = decomp_data%halo_index(i)
      do j= i+1, i+nh
        decomp_data%Halo_index(j) = &
             &decomp_data%lprm(decomp_data%halo_index(j))
      enddo
      i = i + nh + 1
      kh=decomp_data%halo_index(i)
    enddo
    if (debug) write(0,*) 'SPASB: renumbering ovrlap_index'
    i=1
    kh=decomp_data%ovrlap_index(i)
    do while (kh /= -1) 
      i = i + 1
      nh = decomp_data%ovrlap_index(i)
      do j= i+1, i+nh
        decomp_data%Ovrlap_index(j) = &
             &decomp_data%lprm(decomp_data%ovrlap_index(j))
      enddo
      i = i + nh + 1
      kh=decomp_data%ovrlap_index(i)
    enddo
    if (debug) write(0,*) 'SPASB: renumbering ovrlap_elem'
    i = 1
    kh=decomp_data%ovrlap_elem(i)
    do while (kh /= -1)          
      decomp_data%ovrlap_elem(i) = &
           &decomp_data%lprm(decomp_data%ovrlap_elem(i))
      i = i+2
      kh=decomp_data%ovrlap_elem(i)         
    enddo
    if (debug) write(0,*) 'SPASB: done renumbering'
    if (debug) then
      write(60+me,*) 'n_row ',n_row,' n_col',n_col, ' TRANS: ',trans
      do i=1,n_col
        write(60+me,*)i, ' LPRM ', decomp_data%lprm(i), ' IPERM',iperm(i)
      enddo
      i=1
      kh = decomp_data%halo_index(i)
      do while (kh /= -1) 
        write(60+me,*) i, kh 
        i = i+1
        kh = decomp_data%halo_index(i)
      enddo
      close(60+me)
    end if
    
!!$    iperm(1) = 0
  else 
!!$    allocate(decomp_data%lprm(1))
!!$    decomp_data%lprm(1) = 0       
  endif    


  TIME(4) = MPI_WTIME()
  TIME(4) = TIME(4) - TIME(3)
  if (debug) then 
    Call DGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, TIME(4),&
         & IONE,TEMP ,TEMP,-IONE ,-IONE,-IONE)

    Write (*, *) '         comm structs assembly: ', TIME(4)*1.d-3
  end if

  Return
9999 Call PSDERROR( ICONTXT, INFO, NAME, INT_ERR, REAL_ERR )
End Subroutine PSDSCREN
