SUBROUTINE PSDSCFREE(DECOMP_DATA)
  !...free sparse matrix structure...
  USE TYPEDESC
  USE TYPESP
  USE TOOLS_CONST
!  IMPLICIT NONE
  !....Parameters...
  TYPE(DECOMP_DATA_TYPE), intent(inout) :: DECOMP_DATA
  
  !...Locals....
  INTEGER             :: INT_ERR(5)
  INTEGER             :: TEMP(1)
  REAL(KIND(1.d0))    :: REAL_ERR(5)
  INTEGER             :: INFO,ICONTXT,NPROW,NPCOL,ME,MYPCOL,ERR
  INTEGER,parameter   :: IONE=1
  
  INFO=0
  
  IF (.NOT.ASSOCIATED(DECOMP_DATA%MATRIX_DATA)) INFO=295
  IF (INFO.EQ.0) THEN
     ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
     DEALLOCATE(DECOMP_DATA%MATRIX_DATA)
     CALL BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
     !     ....Verify BLACS Grid correctness..
     IF (NPCOL.NE.1) THEN
	INFO = 2030
	INT_ERR(1) = NPCOL
     ENDIF
  ENDIF
  ! check on grid correctness
  ERR = INFO
  CALL IGAMX2D(ICONTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, TEMP, TEMP,&
       & -IONE ,-IONE,-IONE)
  IF (ERR.NE.0) GOTO 9999

  !...deallocate DECOMP_DATA....
  IF ((INFO.EQ.0).AND.(.NOT.ASSOCIATED(DECOMP_DATA%LOC_TO_GLOB)))&
       & INFO=295
  IF (INFO.EQ.0) THEN
     !deallocate LOC_TO_GLOB  field
     DEALLOCATE(DECOMP_DATA%LOC_TO_GLOB,STAT=INFO)
     IF (INFO.NE.0) INFO=2045
   endif
   IF ((INFO.EQ.0).AND.(.NOT.ASSOCIATED(DECOMP_DATA%GLOB_TO_LOC)))&
        & INFO=295
   IF (INFO.EQ.0) THEN
     !deallocate GLOB_TO_LOC field
     DEALLOCATE(DECOMP_DATA%GLOB_TO_LOC,STAT=INFO)
     IF (INFO.NE.0) INFO=2045
   endif
   IF ((INFO.EQ.0).AND.(.NOT.ASSOCIATED(DECOMP_DATA%HALO_INDEX)&
        & )) INFO=295
   IF (INFO.EQ.0) THEN
     !deallocate HALO_INDEX field
     DEALLOCATE(DECOMP_DATA%HALO_INDEX,STAT=INFO)
     IF (INFO.NE.0) INFO=2045
   endif
   IF ((INFO.EQ.0).AND.(.NOT.ASSOCIATED(DECOMP_DATA%BND_ELEM)&
        & )) INFO=295
   IF (INFO.EQ.0) THEN
     !deallocate HALO_INDEX field
     DEALLOCATE(DECOMP_DATA%BND_ELEM,STAT=INFO)
     IF (INFO.NE.0) INFO=2045
   endif
   IF ((INFO.EQ.0).AND.(.NOT.ASSOCIATED(DECOMP_DATA&
        & %OVRLAP_INDEX))) INFO=295
   IF (INFO.EQ.0) THEN
     !deallocate OVRLAP_INDEX  field
     DEALLOCATE(DECOMP_DATA%OVRLAP_INDEX,STAT=INFO)
     IF (INFO.NE.0) INFO=2045
   end IF
   IF ((INFO.EQ.0).AND.(.NOT.ASSOCIATED(DECOMP_DATA&
        & %OVRLAP_ELEM))) INFO=295
   !deallocate OVRLAP_ELEM  field
   IF (INFO.EQ.0)DEALLOCATE(DECOMP_DATA%OVRLAP_ELEM,STAT&
        & =INFO)
   IF (INFO.NE.0) INFO=2045
   IF (INFO.EQ.0) THEN
     !deallocate OVRLAP_INDEX  field
     DEALLOCATE(decomp_data%lprm,STAT=INFO)
     IF (INFO.NE.0) INFO=2045
   end IF
   CALL NULLIFY_DESC(DECOMP_DATA)
   
  ! check on "DECOMP_DATA" deallocate 
  ERR = INFO
  CALL IGAMX2D(ICONTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, TEMP, TEMP,&
       & -IONE ,-IONE,-IONE)
  IF (ERR.NE.0) GOTO 9999

  RETURN
9999 CALL PSDERROR( ICONTXT, INFO, 'F90_PSDSCFREE\0', INT_ERR, REAL_ERR )
END SUBROUTINE PSDSCFREE
