! ---------------------------------------------------------------------
!
!  -- PSSBLAS routine (version 1.0) --
!
!  ---------------------------------------------------------------------
!/
Subroutine PSDDSCCPY(DECOMP1, DECOMP_DATA)

  !  Purpose
  !  =======
  !  
  !  Clone descriptor
  !  
  !
  !
  ! INPUT
  !======
  ! DECOMP_DATA   : TYPEDESC
  !
  ! OUTPUT
  !=========
  ! DECOMP1   : TYPEDESC
  !
  !

  Use TYPEDESC
  Use TYPESP
  Use TOOLS_CONST
  !  Implicit None
  !....Parameters...

  Type(DECOMP_DATA_TYPE), intent(out) :: DECOMP1
  Type(DECOMP_DATA_TYPE), intent(in)  :: DECOMP_DATA

  Integer             :: I,J,NPROW,NPCOL,ME,MYPCOL,INFO,&
       & NPROCS,IDX, icontxt, isz, dectype
  Integer             :: INT_ERR(5),TEMP(1),EXCH(2)
  Real(Kind(1.d0))    :: REAL_ERR(5)
  Integer, Parameter  :: IONE=1, ITWO=2,ROOT=0
  Integer, Pointer    :: PRC_V(:), TEMP_OVRLAP(:), OV_IDX(:),OV_EL(:)
  logical, parameter  :: debug=.false.
  character   :: name*20


  !locals

  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
  DECTYPE=DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)
  N_ROW = DECOMP_DATA%MATRIX_DATA(N_ROW_)
  N_COL = DECOMP_DATA%MATRIX_DATA(N_COL_)

  INFO=0
  NAME = 'F90_PSDSCCPY'
  
  ! check on BLACS grid 
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  If (NPROW.EQ.-1) Then
    INFO = 2010
    Goto 9999
  Else If (NPCOL.NE.1) Then
    INFO = 2030
    INT_ERR(1) = NPCOL
  Endif

  IF (.NOT.IS_ASB_DEC(DECTYPE)) THEN
    INFO = 600
    INT_ERR(1) = dectype
    if (debug) write(0,*) 'Dectype 1 :',dectype,sp_mat_bld,&
         &sp_mat_asb,sp_mat_upd
  ENDIF

  ERR = INFO
  If (ERR.NE.0) then 
    Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,&
         &TEMP ,TEMP,-IONE ,-IONE,-IONE)

    Goto 9999

  ENDIF
  call nullify_desc(decomp1)

  if (associated(decomp_data%matrix_data)) then 
    isz = size(decomp_data%matrix_data)
    allocate(decomp1%matrix_data(isz),stat=info)
    if(debug) write(0,*) 'DSCCPY: m_data',isz,':',decomp_data%matrix_data(:)
    if (info.eq.0) then 
      decomp1%matrix_data(:) = decomp_data%matrix_data(:)
    else
      goto 9999
    endif
  endif    

    
  if (associated(decomp_data%halo_index)) then 
    isz = size(decomp_data%halo_index)
    allocate(decomp1%halo_index(isz),stat=info)
    if (info.eq.0) then 
      decomp1%halo_index(:) = decomp_data%halo_index(:)
      if(debug) write(0,*) 'DSCCPY: h_idx',isz,':',decomp_data%halo_index(1:10),&
           &decomp1%halo_index(1:10)
    else
      goto 9999
    endif
  end if

  if (associated(decomp_data%bnd_elem)) then 
    isz = size(decomp_data%bnd_elem)
    allocate(decomp1%bnd_elem(isz),stat=info)
    if (info.eq.0) then 
      decomp1%bnd_elem(:) = decomp_data%bnd_elem(:)
    else
      goto 9999
    endif
  end if

  if (associated(decomp_data%ovrlap_elem)) then 
    isz = size(decomp_data%ovrlap_elem)
    allocate(decomp1%ovrlap_elem(isz),stat=info)
    if (info.eq.0) then 
      decomp1%ovrlap_elem(:) = decomp_data%ovrlap_elem(:)
    else
      goto 9999
    endif
  end if

  if (associated(decomp_data%ovrlap_index)) then 
    isz = size(decomp_data%ovrlap_index)
    allocate(decomp1%ovrlap_index(isz),stat=info)
    if (info.eq.0) then 
      decomp1%ovrlap_index(:) = decomp_data%ovrlap_index(:)
    else
      goto 9999
    endif
  end if

  if (associated(decomp_data%loc_to_glob)) then 
    isz = size(decomp_data%loc_to_glob)
    allocate(decomp1%loc_to_glob(isz),stat=info)
    if (info.eq.0) then 
      decomp1%loc_to_glob(:) = decomp_data%loc_to_glob(:)
    else
      goto 9999
    endif
  end if

  if (associated(decomp_data%glob_to_loc)) then 
    isz = size(decomp_data%glob_to_loc)
    allocate(decomp1%glob_to_loc(isz),stat=info)
    if (info.eq.0) then 
      decomp1%glob_to_loc(:) = decomp_data%glob_to_loc(:)
    else
      goto 9999
    endif
  end if

  if (associated(decomp_data%lprm)) then 
    isz = size(decomp_data%lprm)
    allocate(decomp1%lprm(isz),stat=info)
    if (info.eq.0) then 
      decomp1%lprm(:) = decomp_data%lprm(:)
    else
      goto 9999
    endif
  end if


  Return

9999 Call PSDERROR(ICONTXT,INFO,NAME,INT_ERR,REAL_ERR)

End Subroutine PSDDSCCPY
