! ---------------------------------------------------------------------
!
!  -- PSSBLAS routine (version 1.0) --
!
!  ---------------------------------------------------------------------
!/
Subroutine PSDDSCALLC(M, N, PARTS, ICONTXT, IERRV, DECOMP_DATA)

  !  Purpose
  !  =======
  !  
  !  Allocate sparse matrix structure for psblas routines.....
  !  and checks correctness of PARTS subroutine
  !
  !
  ! INPUT
  !======
  ! M                 :(Global Input) Integer 
  !                    Total number of  equations
  !                    required.
  ! N                 :(Global Input) Integer 
  !                    Total number of variables
  !                    required. 
  !                   NOTE: We keep M and N for possible future extensions even
  !                         though all other routines really work with M=N
  ! PARTS     : (Global Input) User defined  partition subroutine
  !            it must be defined with this interface
  !            INTERFACE PARTS
  !               SUBROUTINE PARTS(GLOB_INDEX,N,NP,PV,NV)
  !                  INTEGER  GLOB_INDEX,N,NP,NV
  !                  INTEGER  PROCS(*)
  !               END SUBROUTINE PARTS
  !            END INTERFACE
  !            This procedure must return for 1<=GLOB_INDX<=N passed
  !            as input, a list of process identifiers between 0 and NP-1 to which
  !            it is assigned (PV) and the length of this list (NV). 
  !            required.
  !
  ! ICONTXT      : (Global Input)Integer BLACS context for an NPx1 grid 
  !                required.
  !
  ! OUTPUT
  !=========
  ! DECOMP_DATA   : TYPEDESC
  ! DECOMP_DATA OUTPUT FIELDS:
  !
  ! MATRIX_DATA   : Pointer to integer Array 
  !                contains some
  !               local and global information about matrix:
  !
  !  NOTATION        STORED IN		     EXPLANATION
  !  ------------ ---------------------- -------------------------------------
  !  DEC_TYPE        MATRIX_DATA[DEC_TYPE_]   Decomposition type, temporarly is
  !                      setted to 1( matrix not yet assembled)
  !  M 	             MATRIX_DATA[M_]          Total number of equations
  !  N 	             MATRIX_DATA[N_]          Total number of variables
  !  N_ROW           MATRIX_DATA[N_ROW_]      Number of local equations
  !  N_COL           MATRIX_DATA[N_COL_]      Number of local columns (see below)
  !  CTXT_A          MATRIX_DATA[CTXT_]     The BLACS context handle, 
  !                                         indicating
  !	  			            the global context of the operation
  !					    on the matrix.
  !					    The context itself is global.
  !
  !  GLOB_TO_LOC     Array of dimension equal to number of global 
  !                  rows/cols (MATRIX_DATA[M_]). On exit,
  !                  for all global indices either:
  !                  1. The index belongs to the current process; the entry
  !                     is set to the next free local row index.
  !                  2. The index belongs to process P (0<=P<=NP-1); the entry 
  !                     is set to 
  !                     -(NP+P+1)
  !
  !  LOC_TO_GLOB     An array of dimension equal to number of local cols N_COL
  !                  i.e. all columns of the matrix such that there is at least
  !                  one nonzero entry within the local row range. At the time 
  !                  this routine is called N_COL cannot be know, so we set 
  !                  N_COL=N_ROW, and dimension this vector on N_ROW plus an 
  !                  estimate. On exit the vector elements are set
  !                  to the index of the corresponding entry in GLOB_TO_LOC, or  
  !                  to -1 for indices I>N_ROW.
  !
  !
  !  HALO_INDEX      Not touched here, as it depends on the matrix pattern
  !
  !  OVRLAP_INDEX    On exit from this routine, the overlap indices are stored in
  !                  triples (Proc, 1, Index), similar to the assembled format 
  !                  but neither optimized, nor deadlock free. 
  !                  List is terminated with -1
  !
  !  OVRLAP_ELEM     On exit from this routine, just a list of pairs (index,#p).
  !                  List is terminated with -1.
  !                  
  !
  ! END OF DECOMP_DATA OUTPUT FIELDS
  !
  !
  !
  !  IERRV         : pointer to integer array of dimension 6
  !                  will contains information about possibles errors
  !                  encounterd in psdspins procedure.
  !                  IERRV(1) are set to 0 (no errors).

  Use TYPEDESC
  Use TYPESP
  Use TOOLS_CONST
  !  Implicit None
  !....Parameters...
  include 'parts.f90'
  Integer, intent(in)                 :: M,N,ICONTXT
  Type(DECOMP_DATA_TYPE), intent(out) :: DECOMP_DATA
  Integer                             :: IERRV(:)

  !locals
  Integer             :: COUNTER,I,J,NPROW,NPCOL,ME,MYPCOL,INFO,&
       & LOC_ROW,RES,ERR,LOC_COL,NPROCS,OVR_COUNTER,&
       & L_OV_IX,L_OV_EL,IDX
  Integer             :: INT_ERR(5),TEMP(1),EXCH(2)
  Real(Kind(1.d0))    :: REAL_ERR(5)
  Integer, Parameter  :: IONE=1, ITWO=2,ROOT=0
  Integer, Pointer    :: PRC_V(:), TEMP_OVRLAP(:), OV_IDX(:),OV_EL(:)
  logical, parameter  :: debug=.false.

  INFO=0

  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  if (debug) write(*,*) 'DSCALL: ',nprow,npcol,me,mypcol
  !     ....Verify BLACS Grid correctness..
  If (NPCOL.NE.1) Then
     INFO = 2030
     INT_ERR(1) = NPCOL
  Endif
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE, TEMP, TEMP,&
       & -IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999

  IERRV(:) = 0

  !... check M and N parameters....
  If (M.LT.1) Then
     INFO = 10
     INT_ERR(1) = 1
     INT_ERR(2) = M
  Else If (N.LT.1) Then
     INFO = 10
     INT_ERR(1) = 2
     INT_ERR(2) = N
  Endif
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,TEMP, TEMP,&
       & -IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999

  if (debug) write(*,*) 'DSCALL:  Doing global checks'  
  !global check on M and N parameters
  If (ME.EQ.ROOT) Then
     EXCH(1)=M
     EXCH(2)=N
     Call IGEBS2D(ICONTXT,All,TOPDEF, ITWO,IONE, EXCH, ITWO)
  Else
     Call IGEBR2D(ICONTXT,All,TOPDEF, ITWO,IONE, EXCH, ITWO, ROOT,&
          & 0)
     If (EXCH(1).NE.M) Then
        ERR=550
        INT_ERR(1)=1
     Else If (EXCH(2).NE.N) Then
        ERR=550
        INT_ERR(1)=2
     Endif
  Endif
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,TEMP, TEMP&
       & , -IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999


  !OVR_COUNTER contains the sum for all of  my overlap points
  !            number of processes which contains it 
  OVR_COUNTER=0

  !count local rows number
  ! allocate WORK vector
  Allocate(PRC_V(NPROW),DECOMP_DATA%GLOB_TO_LOC(M),&
       &DECOMP_DATA%MATRIX_DATA(10),TEMP_OVRLAP(M),STAT=INFO)
  If (INFO.NE.0) Then     
    INFO=2025
    INT_ERR(1)=M
  endif


  ! check on allocation
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,TEMP,&
       & TEMP,-IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999

  if (debug) write(*,*) 'DSCALL:  Starting main loop' ,info
  COUNTER = 0
  ITMPOV  = 0
  TEMP_OVRLAP(:) = -1
  Do I=1,M
     IF (INFO.EQ.0) THEN
        Call PARTS(I,M,NPROW,PRC_V,NPROCS)
        If (NPROCS.GT.NPROW) Then
           INFO=570
           INT_ERR(1)=3
           INT_ERR(2)=NPROW
           INT_ERR(3)=NPROCS
           INT_ERR(4)=I
           Exit
        Else If (NPROCS.LE.0) Then
           INFO=575
           INT_ERR(1)=3
           INT_ERR(2)=NPROCS
           INT_ERR(3)=I
           Exit
        Else
           Do J=1,NPROCS
              If ((PRC_V(J).GT.NPROW-1).OR.(PRC_V(J).LT.0)) Then
                 INFO=580
                 INT_ERR(1)=3
                 INT_ERR(2)=PRC_V(J)
                 INT_ERR(3)=I
                 Exit
              End If
           End Do
        Endif
        J=1
        Do While ((J.LE.NPROCS).AND.(PRC_V(J).NE.ME))
           J=J+1
        Enddo
        If ((J.LE.NPROCS) .and. (PRC_V(J).EQ.ME)) Then
       ! this point belongs to me
           COUNTER=COUNTER+1
           DECOMP_DATA%GLOB_TO_LOC(I) = COUNTER
           IF (NPROCS.GT.1)  THEN
              IF ((ITMPOV+2+NPROCS).GT.M)  Then
                INFO=2025
                INT_ERR(1)=M
              else
                ITMPOV = ITMPOV + 1
                TEMP_OVRLAP(ITMPOV) = I
                ITMPOV = ITMPOV + 1
                TEMP_OVRLAP(ITMPOV) = NPROCS
                TEMP_OVRLAP(ITMPOV+1:ITMPOV+NPROCS) = PRC_V(1:NPROCS)
                ITMPOV = ITMPOV + NPROCS
              endif
           ENDIF
        ELSE
           DECOMP_DATA%GLOB_TO_LOC(I) = -(NPROW+PRC_V(1)+1)
        END IF
     ENDIF
  ENDDO

  LOC_ROW=COUNTER
  ! check on parts function
  if (debug) write(*,*) 'DSCALL:  End main loop:' ,loc_row,itmpov,info
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,&
       &TEMP,TEMP,-IONE,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999
  if (debug) write(*,*) 'DSCALL:  error check:' ,err

  L_OV_IX=0
  L_OV_EL=0
  I = 1
  DO WHILE (TEMP_OVRLAP(I).NE.-1) 
     IDX = TEMP_OVRLAP(I)
     I=I+1
     NPROCS = TEMP_OVRLAP(I)
     I = I + 1
     L_OV_IX = L_OV_IX+3*(NPROCS-1)
     L_OV_EL = L_OV_EL + 2
     I = I + NPROCS     
  ENDDO
  
  L_OV_IX = L_OV_IX+3  
  L_OV_EL = L_OV_EL+3

  if (debug) write(*,*) 'DSCALL: Ov len',l_ov_ix,l_ov_el
  Allocate(OV_IDX(L_OV_IX),OV_EL(L_OV_EL), STAT=INFO)
  If (INFO.NE.0) Then
     INFO=2025
     INT_ERR(1)=LOC_COL
  End If

  !... check allocation error....
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE, TEMP,&
       & TEMP,-IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999

  L_OV_IX=0
  L_OV_EL=0
  I = 1
  DO WHILE (TEMP_OVRLAP(I).NE.-1) 
     IDX = TEMP_OVRLAP(I)
     I   = I+1
     NPROCS = TEMP_OVRLAP(I)
     OV_EL(L_OV_EL+1)  = IDX
     OV_EL(L_OV_EL+2)  = NPROCS
     L_OV_EL           = L_OV_EL+2
     DO J=1, NPROCS
        IF (TEMP_OVRLAP(I+J).NE.ME) THEN
           OV_IDX(L_OV_IX+1) = TEMP_OVRLAP(I+J)
           OV_IDX(L_OV_IX+2) = 1
           OV_IDX(L_OV_IX+3) = IDX
           L_OV_IX = L_OV_IX+3
        ENDIF
     ENDDO                
     I = I + NPROCS +1
  ENDDO
  L_OV_EL         = L_OV_EL + 1
  OV_EL(L_OV_EL)  = -1
  L_OV_IX         = L_OV_IX + 1
  OV_IDX(L_OV_IX) = -1

  DECOMP_DATA%OVRLAP_INDEX => OV_IDX
  DECOMP_DATA%OVRLAP_ELEM  => OV_EL
  DEALLOCATE(TEMP_OVRLAP,STAT=INFO)
  if (info.ne.0) then 
    write(*,*) ' Deallocate failure !?!?!?!? '
  endif
  ! estimate local cols number 
  LOC_COL=Int((COLROW_+1.d0)*LOC_ROW)+1  
  Allocate(DECOMP_DATA%LOC_TO_GLOB(LOC_COL),&
       &DECOMP_DATA%LPRM(1),STAT=INFO)  
  If (INFO.NE.0) Then
     INFO=2025
     INT_ERR(1)=LOC_COL
  End If

  !... check allocation error....
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE, TEMP,&
       & TEMP,-IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999

  ! set LOC_TO_GLOB array to all "-1" values
  DECOMP_DATA%LPRM(1) = 0
  DECOMP_DATA%LOC_TO_GLOB(:) = -1
  Do I=1,M
     K = DECOMP_DATA%GLOB_TO_LOC(I) 
     IF (K.GT.0) THEN 
        DECOMP_DATA%LOC_TO_GLOB(K) = I
     ENDIF
  Enddo
  NULLIFY(DECOMP_DATA%BND_ELEM,DECOMP_DATA%HALO_INDEX)

!!$  if (debug) write(*,*) 'DSCALL:  Last bits in decomp_data', loc_row,k
  ! set fields in DECOMP_DATA%MATRIX_DATA....
  DECOMP_DATA%MATRIX_DATA(N_ROW_)    = LOC_ROW
  DECOMP_DATA%MATRIX_DATA(N_COL_)    = LOC_ROW
  DECOMP_DATA%MATRIX_DATA(M_)        = M
  DECOMP_DATA%MATRIX_DATA(N_)        = N
  DECOMP_DATA%MATRIX_DATA(DEC_TYPE_) = SP_MAT_BLD
  DECOMP_DATA%MATRIX_DATA(CTXT_)     = ICONTXT
  DECOMP_DATA%MATRIX_DATA(OVR_CNT_)  = OVR_COUNTER

  Return

9999 Call PSDERROR(ICONTXT,INFO,'F90_SPALL\0',INT_ERR,REAL_ERR)

End Subroutine PSDDSCALLC
