Subroutine PSDALLOC(M, N, X, IERRV, DECOMP_DATA, JS)
  !....allocate dense  matrix for psblas routines.....
  Use TYPEDESC
  Use TOOLS_CONST

!  Implicit None
  
  !....Parameters...
  Integer, intent(in)                   :: M,N
  Real(Kind(1.D0)), Pointer             :: X(:,:)
  Type(DECOMP_DATA_TYPE), intent(inout) :: DECOMP_DATA
  Integer                      :: IERRV(:)
  Integer, Optional, intent(in)         :: JS

  !locals
  Integer             ::COUNTER,I,J,NPROW,NPCOL,ME,MYPCOL,INFO&
       & ,LOC_ROW ,RES,ERR,LOC_COL,NPROCS&
       & ,OVR_COUNTER,N_COL,N_ROW
  Integer             :: ICONTXT,DECTYPE
  Integer             :: INT_ERR(5),TEMP(1),EXCH(3)
  Real(Kind(1.d0))    :: REAL_ERR(5)
  Integer, Parameter  :: IONE=1, ITWO=2, ITHREE=3,ROOT=0
  Integer, Allocatable:: PRC_V(:)

  INFO=0
  
  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
  
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  !     ....Verify BLACS Grid correctness..
  If (NPROW.EQ.-1) Then
     INFO = 2010
     Goto 9999
  Else If (NPCOL.NE.1) Then
     INFO = 2030
     INT_ERR(1) = NPCOL
  Endif
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE, TEMP,&
       & TEMP, -IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999
  
  DECTYPE=DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)
  !... check M and N parameters....
  If (M.LT.0) Then
    INFO = 10
    INT_ERR(1) = 1
    INT_ERR(2) = M
  Else If (N.LT.0) Then
    INFO = 10
    INT_ERR(1) = 2
    INT_ERR(2) = N
  Else If (.not.is_ok_dec(DECTYPE)) then 
    INFO = 3110
  Else If (M.NE.DECOMP_DATA%MATRIX_DATA(N_)) Then
    INFO = 300
    INT_ERR(1) = 1
    INT_ERR(2) = M
    INT_ERR(3) = 4
    INT_ERR(4) = N_
    INT_ERR(5) = DECOMP_DATA%MATRIX_DATA(N_)
  Endif
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,TEMP, TEMP&
       & , -IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999
  
  If (PRESENT(JS)) Then 
    J=JS
  Else
    J=1
  Endif
  !global check on M and N parameters
  If (ME.EQ.ROOT) Then
     EXCH(1)=M
     EXCH(2)=N
     EXCH(3)=j
     Call IGEBS2D(ICONTXT,All,TOPDEF, ITHREE,IONE, EXCH, ITHREE)
  Else
     Call IGEBR2D(ICONTXT,All,TOPDEF, ITHREE,IONE, EXCH, ITHREE, ROOT, 0)
     If (EXCH(1).NE.M) Then
	ERR=550
	INT_ERR(1)=1
     Else If (EXCH(2).NE.N) Then
	ERR=550
	INT_ERR(1)=2
     Else If (EXCH(3).NE.J) Then
	ERR=550
	INT_ERR(1)=3
     Endif
  Endif
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,TEMP, TEMP&
       & , -IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999

  !....allocate X .....
  if (is_asb_dec(dectype).or.is_upd_dec(dectype)) then
     N_COL = DECOMP_DATA%MATRIX_DATA(N_COL_)
     Allocate(X(N_COL,J:J+N-1),STAT=INFO)
     If (INFO.NE.0) Then
        INFO=2025
        INT_ERR(1)=N_COL
     Endif
  else if (is_bld_dec(dectype)) then
     N_ROW = DECOMP_DATA%MATRIX_DATA(N_ROW_)
     Allocate(X(N_ROW,J:J+N-1),STAT=INFO)
     If (INFO.NE.0) Then
        INFO=2025
        INT_ERR(1)=N_ROW
     Endif
  endif
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE, TEMP,&
       & TEMP,-IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999
   ! allocate IERRV vector
!!$  IF (ASSOCIATED(IERRV)) THEN
!!$     IF (SIZE(IERRV).LT.6) THEN
!!$	NULLIFY(IERRV)
!!$	ALLOCATE(IERRV(6),STAT=INFO)
!!$	IF (INFO.NE.0) THEN
!!$	   INFO=2023
!!$	   INT_ERR(1)=6
!!$	ENDIF
!!$     END IF
!!$  ELSE
!!$     ALLOCATE(IERRV(6),STAT=INFO)
!!$     IF (INFO.NE.0) THEN
!!$	INFO=2023
!!$	INT_ERR(1)=6
!!$     ENDIF
!!$  ENDIF
!!$  
!!$  ERR = INFO
!!$  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE, TEMP,&
!!$       & TEMP,-IONE ,-IONE,-IONE)
!!$  If (ERR.NE.0) Goto 9999
  ! set error array
  IERRV(1)=0
  Return
  
9999 Call PSDERROR( ICONTXT, INFO, 'PSDALLOC\0', INT_ERR, REAL_ERR )

End Subroutine PSDALLOC



Subroutine PSDALLOCV(M, X, IERRV, DECOMP_DATA)
  !....allocate sparse matrix structure for psblas routines.....
  Use TYPEDESC
  Use TOOLS_CONST

  Implicit None
  
  !....Parameters...
  Integer, intent(in)                :: M
  Real(Kind(1.D0)), Pointer          :: X(:)
  Type(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
  Integer                      :: IERRV(:)

  !locals
  Integer             ::COUNTER,I,J,NPROW,NPCOL,ME,MYPCOL,INFO&
       & ,LOC_ROW ,RES,ERR,LOC_COL,NPROCS&
       & ,OVR_COUNTER,N_COL,N_ROW,DECTYPE
  Integer             :: ICONTXT
  Integer             :: INT_ERR(5),TEMP(1),EXCH(2)
  Real(Kind(1.d0))    :: REAL_ERR(5)
  Integer, Parameter  :: IONE=1, ITWO=2,ROOT=0
  Integer, Allocatable:: PRC_V(:)
  logical, parameter  :: debug=.false. 

  INFO=0
  
  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
  
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  !     ....Verify BLACS Grid correctness..
  If (NPROW.EQ.-1) Then
     INFO = 2010
     Goto 9999
  Else If (NPCOL.NE.1) Then
     INFO = 2030
     INT_ERR(1) = NPCOL
  Endif
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE, TEMP,&
       & TEMP, -IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999
  
  DECTYPE=DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)
  if (debug) write(0,*) 'DALL: dectype',dectype
  if (debug) write(0,*) 'DALL: is_ok? dectype',is_ok_dec(dectype)
  !... check M and N parameters....
  If (M.LT.0) Then
     INFO = 10
     INT_ERR(1) = 1
     INT_ERR(2) = M
  Else If (.not.is_ok_dec(DECTYPE)) then 
     INFO = 3110
  Else If (M.NE.DECOMP_DATA%MATRIX_DATA(N_)) Then
     INFO = 300
     INT_ERR(1) = 1
     INT_ERR(2) = M
     INT_ERR(3) = 4
     INT_ERR(4) = N_
     INT_ERR(5) = DECOMP_DATA%MATRIX_DATA(N_)
  Endif
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,TEMP, TEMP&
       & , -IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999
  
  !global check on M and N parameters
  If (ME.EQ.ROOT) Then
     EXCH(1) = M
     Call IGEBS2D(ICONTXT,All,TOPDEF, IONE,IONE, EXCH, IONE)
  Else
     Call IGEBR2D(ICONTXT,All,TOPDEF, IONE,IONE, EXCH, IONE, ROOT, 0)
     If (EXCH(1) .NE. M) Then
	ERR = 550
	INT_ERR(1) = 1
     Endif
  Endif
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,TEMP, TEMP&
       & , -IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999

  !....allocate X .....
  if (is_asb_dec(dectype).or.is_upd_dec(dectype)) then
     N_COL = DECOMP_DATA%MATRIX_DATA(N_COL_)
     Allocate(X(N_COL),STAT=INFO)
     If (INFO.NE.0) Then
        INFO=2025
        INT_ERR(1)=N_COL
     Endif
  else if (is_bld_dec(dectype)) then
     N_ROW = DECOMP_DATA%MATRIX_DATA(N_ROW_)
     Allocate(X(N_ROW),STAT=INFO)
     If (INFO.NE.0) Then
        INFO=2025
        INT_ERR(1)=N_ROW
     Endif
  ENDIF
     
  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE, TEMP,&
       & TEMP,-IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999
  
   ! allocate IERRV vector
!!$  IF (ASSOCIATED(IERRV)) THEN
!!$     IF (SIZE(IERRV).LT.6) THEN
!!$	NULLIFY(IERRV)
!!$	ALLOCATE(IERRV(6),STAT=INFO)
!!$	IF (INFO.NE.0) THEN
!!$	   INFO=2023
!!$	   INT_ERR(1)=6
!!$	ENDIF
!!$     END IF
!!$  ELSE
!!$     ALLOCATE(IERRV(6),STAT=INFO)
!!$     IF (INFO.NE.0) THEN
!!$	INFO=2023
!!$	INT_ERR(1)=6
!!$     ENDIF
!!$   ENDIF
!!$  
!!$  ERR = INFO
!!$  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE, TEMP,&
!!$       & TEMP,-IONE ,-IONE,-IONE)
!!$  If (ERR.NE.0) Goto 9999
  ! set error array
  IERRV(1)=0
  Return
  
9999 Call PSDERROR( ICONTXT, INFO, 'PSDALLOC\0', INT_ERR, REAL_ERR )

End Subroutine PSDALLOCV

