! ---------------------------------------------------------------------
!
!  -- PSSBLAS routine (version 1.0) --
!
!  ---------------------------------------------------------------------
!
LOGICAL FUNCTION IS_OWNED(INDX,DECOMP_DATA)
  !  Purpose
  !  =======
  !  
  !   Does global index INDX belong to the current process? 
  !
  ! INPUT
  !====== 
  !  INDX    Global index to test.
  !            Required.
  ! INPUT
  !==============
  ! DECOMP_DATA TYPEDESC
  !             required
  ! DECOMP_DATA FIELDS
  !
  ! MATRIX_DATA   : Pointer to integer Array 
  !                contains some
  !               local and global information about matrix:
  !
  !  NOTATION        STORED IN		     EXPLANATION
  !  ------------ ---------------------- -------------------------------------
  !  DEC_TYPE        MATRIX_DATA[DEC_TYPE_]   Decomposition type, temporarly is
  !                      setted to 1( matrix not yet assembled)
  !  M 	             MATRIX_DATA[M_]          Total number of equations
  !  N 	             MATRIX_DATA[N_]          Total number of variables
  !  N_ROW           MATRIX_DATA[N_ROW_]      Number of local equations
  !  N_COL           MATRIX_DATA[N_COL_]      Number of local variables
  !                     already inserted.
  !  CTXT_A          MATRIX_DATA[CTXT_]     The BLACS context handle, 
  !                                         indicating
  !	  			            the global context of the operation
  !					    on the matrix.
  !					    The context itself is global.
  !
  !  LOC_TO_GLOB     Integer array of dimension equal to local
  !                  cols.
  !                  Element i (if >0) contains global identifier of local
  !                  variable i.
  !                  if < 0 then local identifier i is not yet assigned.
  !  GLOB_TO_LOC     Integer Array of dimension equal to global 
  !                  cols (MATRIX_DATA[N_]).
  !                  Element i (if >0) contains local identifier of global
  !                  variable i.
  !  HALO_INDEX      pointer to integer array
  !             EXPLANATION
  !  Let HALO_INDEX_P be the array DESC_HALO for local process.
  !  This is composed of variable dimension blocks for each process to 
  !  communicate to.
  !  Each block contain indexes of local halo elements to exchange with other 
  !  process.
  !  Let P be the pointer to the first element of a block in HALO_INDEX_P.
  !  This block is stored in HALO_INDEX_P as :
  !
  !  NOTATION        STORED IN		          EXPLANATION
  !  --------------- --------------------------- -----------------------------------
  !  PROCESS_ID      HALO_INDEX_P[P+PROC_ID_]      Identifier of process which exchange
  !						  data with.
  !  N_ELEMENTS_RECV HALO_INDEX_P[P+N_ELEM_RECV_]  Number of elements to receive.
  !  ELEMENTS_RECV   HALO_INDEX_P[P+ELEM_RECV_+i]  Indexes of local elements to
  !					          receive. These are stored in the
  !					          array from location P+ELEM_RECV_ to
  !					          location P+ELEM_RECV_+
  !						  HALO_INDEX_P[P+N_ELEM_RECV_]-1.
  !  N_ELEMENTS_SEND HALO_INDEX_P[P+N_ELEM_SEND_]  Number of elements to send.
  !  ELEMENTS_SEND   HALO_INDEX_P[P+ELEM_SEND_+i]  Indexes of local elements to
  !					          send. These are stored in the
  !					          array from location P+ELEM_SEND_ to
  !					          location P+ELEM_SEND_+
  !						  HALO_INDEX_P[P+N_ELEM_SEND_]-1.
  !  OVRLAP_INDEX      pointer to integer array
  !             EXPLANATION
  !
  !  Let DESCOVRLP_P be the array DESC_OVRLAP for local process.
  !  This is composed of variable dimension blocks for each process to 
  !  communicate to.
  !  Each block contain indexes of local overlap elements to exchange with
  !  other process.
  !  Let P be the pointer to the first element of a block in DESCOVRLP_P.
  !  This block is stored in DESCOVRLP_P as :
  !
  !  NOTATION        STORED IN		            EXPLANATION
  !  ------------- ------------------------------- -----------------------------------
  !  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
  !						   data with.
  !  N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
  !  OVRLAP_RECV   DESCOVRLP_P[P+ELEM_RECV_+i]     Indexes of local elements to
  !					           receive. These are stored in the
  !					           array from location P+OVRLP_ELEM_ to
  !					           location P+OVRLP_ELEM_+
  !						   DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
  !  OVRLAP_SEND   DESCOVRLP_P[P+ELEM_SEND_+i]     Indexes of local elements to
  !					           send.These are stored in the
  !					           array from location P+ELEM_SEND_ to
  !					           location P+ELEM_SEND_+
  !						   DESCOVRLP_P[P+N_ELEM_SEND_]-1.
  !
  !
  !  Let OVR_ELEM_P be the array OVERLAP_ELEM for local process.
  !  This is composed of blocks of two elements. The block
  !  corresponding to the i-th overlapped elements, begin at index 
  !  P = i*2 in array OVR_ELEM_P.
  !  This block is stored in OVR_ELEM_P as :
  !
  !  NOTATION      STORED IN		       EXPLANATION
  !  ------------- -------------------------- ----------------------------------
  !  OVRLAP_ELEM   OVR_ELEM_P[P+OVRLP_ELEM_]  The index of local overlapped 
  !					       element.
  !  N_DOMAINS     OVR_ELEM_P[P+N_DOM_OVR_]   The number of copies of
  !					       local overlapped element.
  ! END DECOMP_DATA FIELDS
  Use TYPEDESC
  Type(DECOMP_DATA_TYPE)        ::  DECOMP_DATA
  Integer                       ::  INDX
  integer                       :: lix, ICONTXT,TEMP(1),N_ROW,IOVERLAP,&
       &info, dectype, err
  Integer, Parameter            :: IONE=1
  logical, parameter            :: debug=.false.
  Integer                       ::  INT_ERR(5)  
  Real(Kind(1.d0))              ::  REAL_ERR(5),D(1)
  Character                     :: NAME*20


  ICONTXT=DECOMP_DATA%MATRIX_DATA(CTXT_)
  DECTYPE=DECOMP_DATA%MATRIX_DATA(DEC_TYPE_)
  
  INFO=0
  NAME = 'IS_OWNED'
  if (debug) write(*,*) name,' ',icontxt,dectype,indx
  ! check on BLACS grid 
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYPCOL)
  if (debug) write(*,*) name, ' After gridinfo',me
  If (NPROW.EQ.-1) Then
     INFO = 2010
     Goto 9999
  Else If (NPCOL.NE.1) Then
     INFO = 2030
     INT_ERR(1) = NPCOL
     Goto 9999
  Endif

  IF (.NOT.is_ok_dec(DECTYPE)) THEN
     INFO = 600
     INT_ERR(1) = dectype
     if (debug) write(0,*) 'Dectype 1 :',dectype,sp_mat_bld,&
          &sp_mat_asb,sp_mat_upd
  ENDIF

  ERR = INFO
  Call IGAMX2D(ICONTXT, All, TOPDEF, IONE, IONE, ERR, IONE,TEMP ,TEMP&
       & ,-IONE ,-IONE,-IONE)
  If (ERR.NE.0) Goto 9999
  IF ((INDX.LT.0).OR.(INDX.GT.DECOMP_DATA%MATRIX_DATA(M_))) THEN
    if (debug) write(*,*) name,' Exit 1 false '
    IS_OWNED = .FALSE.
  ELSE 
    N_ROW = DECOMP_DATA%MATRIX_DATA(N_ROW_)
    LIX   = DECOMP_DATA%GLOB_TO_LOC(INDX)
    IS_OWNED = ((LIX.GE.1).AND.(LIX.LE.N_ROW))
    if (debug) write(*,*) name,' Exit 2: ',is_owned
  END IF

  Return
9999 Call PSDERROR( ICONTXT, INFO, NAME, INT_ERR, REAL_ERR )
End function is_owned
