* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*
      SUBROUTINE PSI_Convert_Comm(DESC_DATA, HALO_IN, OVRLAP_IN,
     +   DESC_HALO, LENGTH_DH,
     +   DESC_OVERLAP, LENGTH_DO,
     +   OVRLAP_ELEM, LENGTH_OE,
     +   LOC_TO_GLOB,GLOB_TO_LOC,
     +   WORK,LWORK)
C
C  Internal routine called by psdspass
C     
C    
C   Purpose
C   =======
C
C  Convert communication structure from internal rappresenation to final mode.
C
C
C  Notes
C  =====
C
C  Some description vectors are associated with each distributed sparse
C  matrix. These vectors stores the information required to the
C  communication needed to perform distributed operations.
C
C  They are:
C
C  NAME		 EXPLANATION
C  ------------------ -------------------------------------------------------
C  DESC_DATA	 Array of INTEGER that contains some local and global
C		 information of matrix.
C
C
C  Now we explain each of the above vectors.
C
C  Let A be a generic sparse matrix. We denote with MATDATA_A the MATRIX_DATA
C  array for matrix A.
C  Data stored in MATRIX_DATA array are:
C
C  NOTATION        STORED IN		     EXPLANATION
C  --------------- ---------------------- -------------------------------------
C  DEC_TYPE        MATDATA_A[DEC_TYPE_]   Decomposition type
C  M 	           MATDATA_A[M_]          Total number of equations
C  N 	           MATDATA_A[N_]          Total number of variables
C  N_ROW           MATDATA_A[N_ROW_]      Number of local equations
C  N_COL           MATDATA_A[N_COL_]      Number of local variables
C  CTXT_A          MATDATA_A[CTXT_]       The BLACS context handle, indicating
C		   	                     the global context of the operation
C					     on the matrix.
C					     The context itself is global.
C  
C  Let DESCHALO_P be the array HALO_IN for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local halo elements to exchange with other 
C  process.
C  Let P be the pointer to the first element of a block in DESCHALO_P.
C  This block is stored in DESCHALO_P as :
C
C  NOTATION        STORED IN		          EXPLANATION
C  --------------- --------------------------- -----------------------------------
C  PROCESS_ID      DESCHALO_P[P+PROC_ID_]      Identifier of process which exchange 
C						  data with.
C  N_ELEMENTS_RECV DESCHALO_P[P+N_ELEM_RECV_]  Number of elements to receive.
C  ELEMENTS_RECV   DESCHALO_P[P+ELEM_RECV_+i]  Indexes of local elements to
C					          receive. These are stored in the
C					          array from location P+ELEM_RECV_ to
C					          location P+ELEM_RECV_+
C						  DESCHALO_P[P+N_ELEM_RECV_]-1.
C
C  Let DESCOVRLP_P be the array OVRLAP_IN for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local overlap elements to exchange with
C  other process.
C  Let P be the pointer to the first element of a block in DESCOVRLP_P.
C  This block is stored in DESCOVRLP_P as :
C
C  NOTATION        STORED IN		            EXPLANATION
C  ------------- ------------------------------- -----------------------------------
C  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
C						    data with.
C  N_OVRLAP_ELEM DESCOVRLP_P[P+N_ELEM_RECV]    Number of elements to recv.
C  OVRLAP_ELEM   DESCOVRLP_P[P+ELEM_RECV_+i]   global Indexes of ovrlap elements to
C					       recv. These are stored in the
C					       array from location P+OVRLP_ELEM_ to
C					       location P+OVRLP_ELEM_+
C					       DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
C  Let HALO_INDEX_P be the array DESC_HALO for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local halo elements to exchange with other 
C  process.
C  Let P be the pointer to the first element of a block in HALO_INDEX_P.
C  This block is stored in HALO_INDEX_P as :
C
C  NOTATION        STORED IN		          EXPLANATION
C  --------------- --------------------------- -----------------------------------
C  PROCESS_ID      HALO_INDEX_P[P+PROC_ID_]      Identifier of process which exchange
C						  data with.
C  N_ELEMENTS_RECV HALO_INDEX_P[P+N_ELEM_RECV_]  Number of elements to receive.
C  ELEMENTS_RECV   HALO_INDEX_P[P+ELEM_RECV_+i]  Indexes of local elements to
C					          receive. These are stored in the
C					          array from location P+ELEM_RECV_ to
C					          location P+ELEM_RECV_+
C						  HALO_INDEX_P[P+N_ELEM_RECV_]-1.
C  N_ELEMENTS_SEND HALO_INDEX_P[P+N_ELEM_SEND_]  Number of elements to send.
C  ELEMENTS_SEND   HALO_INDEX_P[P+ELEM_SEND_+i]  Indexes of local elements to
C					          send. These are stored in the
C					          array from location P+ELEM_SEND_ to
C					          location P+ELEM_SEND_+
C						  HALO_INDEX_P[P+N_ELEM_SEND_]-1.
C  List is ended by -1 character
C
C  OVRLAP_INDEX      pointer to integer array
C             EXPLANATION
C
C  Let DESCOVRLP_P be the array DESC_OVRLAP for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local overlap elements to exchange with
C  other process.
C  Let P be the pointer to the first element of a block in DESCOVRLP_P.
C  This block is stored in DESCOVRLP_P as :
C
C  NOTATION        STORED IN		            EXPLANATION
C  ------------- ------------------------------- -----------------------------------
C  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
C						   data with.
C  N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
C  OVRLAP_RECV   DESCOVRLP_P[P+ELEM_RECV_+i]     Indexes of local elements to
C					           receive. These are stored in the
C					           array from location P+OVRLP_ELEM_ to
C					           location P+OVRLP_ELEM_+
C						   DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
C  OVRLAP_SEND   DESCOVRLP_P[P+ELEM_SEND_+i]     Indexes of local elements to
C					           send.These are stored in the
C					           array from location P+ELEM_SEND_ to
C					           location P+ELEM_SEND_+
C						   DESCOVRLP_P[P+N_ELEM_SEND_]-1.
C  List is ended by -1 character
C
C
C  Let OVR_ELEM_P be the array OVERLAP_ELEM for local process.
C  This is composed of blocks of two elements. The block
C  corresponding to the i-th overlapped elements, begin at index 
C  P = i*2 in array OVR_ELEM_P.
C  This block is stored in OVR_ELEM_P as :
C
C  NOTATION      STORED IN		       EXPLANATION
C  ------------- -------------------------- ----------------------------------
C  OVRLAP_ELEM   OVR_ELEM_P[P+OVRLP_ELEM_]  The index of local overlapped 
C					       element.
C  N_DOMAINS     OVR_ELEM_P[P+N_DOM_OVR_]   The number of copies of
C					       local overlapped element.
C  List is ended by -1 character
C
C   Input Data
C   ==========
C
C  DESC_DATA     (global and local input) INTEGER array. Is the MATRIX_DATA
C           array.
C
C  HALO_IN       (local input) INTEGER array. See Prevoius notes.
C
C  OVRLAP_IN     (local input) INTEGER array. See Prevoius notes.
C
C  LOC_TO_GLOB   (local input) INTEGER array. Element "i" contains global index
C                of local element with index "i", (associated to i-th column
C                of local matrix). 
C  GLOB_TO_LOC   (local input) INTEGER array. Element "i" contains local index
C                of global element with index "i".
C                If global element not belong to my internal point
C                and to my halo points, correspondent element is setted
C                to -1 value.
C
C  LENGTH_OEO  (Local input) Scalar integer. Length OVERLAP_ELEM_OUT array.
C
C  LENGTH_DO   (Local input) Scalar integer. Length of DESC_OVERLAP array.
C                     
C
C  LENGTH_DH   (Local Input) Scalar integer. Length of DESC_HALO array.
C               
C  WORK       (local input) INTEGER array. 
C             Work area.
C
C  LWORK      (local input) INTEGER. Dimension of Work area.
C            
C
C
C   Output Data
C   ==========
C  
C   
C  DESC_HALO       INTEGER array. See Prevoius notes.
C  DESC_OVRLAP     INTEGER array. See Prevoius notes.
C  OVRLAP_ELEM     INTEGER array. See Previous notes.

      IMPLICIT NONE
      INCLUDE 'psblas.fh'      
C     .....Array Input Arguments....
      INTEGER DESC_DATA(*),
     +   HALO_IN(*),OVRLAP_IN(*),
     +   WORK(*),LOC_TO_GLOB(*),GLOB_TO_LOC(*)


C    ...Output arrays....      
      INTEGER OVRLAP_ELEM(*),DESC_HALO(*),DESC_OVERLAP(*)

      INTEGER ITWO,IONE
      PARAMETER (ITWO=2,IONE=1)

C     ...scalar parameters....
      INTEGER LWORK,LENGTH_DH,
     +   LENGTH_DO,LENGTH_OE,IH1(1)


C     ...Local Scalars...
      INTEGER LWORK1,LWORK2,MYROW,NP,NPCOL,MYCOL,LWORK3,I
      INTEGER DL_LDA_HALO,DL_LDA_OVRLAP,LWORK4,LWORK_TOT,
     +   MAX_HALO,MAX_OVRLAP,MAX_SIZE1,MAX_SIZE2,
     +   ERR, INFO, ICTXT,j

C     ...Local Array...
      INTEGER          INT_ERR(7)
      DOUBLE PRECISION REAL_ERR(5)
      logical debug
      parameter (debug=.false.)

      INFO = 0
      ICTXT = DESC_DATA(CTXT_)
C
      CALL BLACS_GRIDINFO(ICTXT,NP,NPCOL,MYROW,MYCOL)


      IF (LWORK.LT.2*NP) INFO = 4100

      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +   IH1, IH1, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999
      if (debug) write(*,*) 'Convert_comm: calling COMPUTE_SIZE'
C     This subroutine  compute sizes necessary for work
C     area utilized in successive procedures...................
      CALL PSI_COMPUTE_SIZE(NP,DESC_DATA,HALO_IN,OVRLAP_IN,
     +   MAX_HALO,MAX_OVRLAP,DL_LDA_HALO,DL_LDA_OVRLAP,
     +   WORK,WORK(NP+1))


C     ....sizing work areas....
      LWORK1=MAX(DL_LDA_HALO*NP,1)
      LWORK2=NP
      LWORK3=MAX_HALO

      IF (LWORK1+LWORK2+LWORK3+1.GT.LWORK) THEN
         INFO = 90
         INT_ERR(1) = LWORK1+LWORK2+LWORK3+1
         INT_ERR(2) = LWORK
      ENDIF
      if (debug) write(*,*) 'Convert_comm: LWORK:',
     +   lwork1+lwork2+lwork3
      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +   IH1, IH1, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999
      if (debug) write(*,*) 'Convert_comm: calling Crea_Halo',
     +   (halo_in(j),j=1,15)
C     .....Create DESC_HALO-PSBLAS list.......
      CALL PSI_CREA_HALO(DESC_DATA,HALO_IN,NP,
     +   DESC_HALO,LENGTH_DH,
     +   WORK,DL_LDA_HALO,WORK(LWORK1+1),
     +   LOC_TO_GLOB,GLOB_TO_LOC,
     +   WORK(LWORK1+LWORK2+1),LWORK-(LWORK1+LWORK2))

C     ....sizing work areas....
      DL_LDA_OVRLAP=MAX(DL_LDA_OVRLAP,1)
      LWORK1=DL_LDA_OVRLAP*NP
      LWORK2=NP
      MAX_SIZE1=MIN(3*DESC_DATA(N_ROW_),MAX_OVRLAP*3)+1
      MAX_SIZE2=MAX_SIZE1

      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, MAX_SIZE2, IONE, 
     +   IH1, IH1, -IONE ,-IONE,-IONE)
 
      LWORK4=MAX((MAX_SIZE1+MAX_SIZE2),
     +   NP*NP)

      LWORK_TOT=LWORK1+LWORK2+LWORK4
      IF (LWORK_TOT.GT.LWORK) INFO = 4100

      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +   IH1, IH1, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999
C     .....Create DESC_OVRLAP-PSBLAS list.......
      if (debug) write(*,*) 'Convert_comm: calling Crea_Ovrlap'
      CALL PSI_CREA_OVRLAP(DESC_DATA,OVRLAP_IN,NP,
     +   DESC_OVERLAP,LENGTH_DO,WORK,DL_LDA_OVRLAP,WORK(LWORK1+1),
     +   LOC_TO_GLOB,GLOB_TO_LOC,
     +   MAX_SIZE1,MAX_SIZE2,
     +   WORK(LWORK1+LWORK2+1),LWORK-LWORK1-LWORK2)

C     .....Create OVRLAP_ELEM-PSBLAS list from DESC_OVRLAP array....      
      CALL PSI_CREA_OVR_ELEM(DESC_OVERLAP,OVRLAP_ELEM,LENGTH_OE)

      RETURN

 9999 CALL PSDERROR( ICTXT, INFO, 'PSDSPASB\0', INT_ERR, REAL_ERR )
      END

 
