subroutine  f90_pszspsm(alpha,t,x,beta,y,decomp_data,&
     & trans, unitd, choice, d, n, jx, jy, work)   
  use typesp
  use typedesc
  complex(kind(1.D0)), intent(in) :: alpha, beta
  complex(kind(1.d0)), intent(in) :: x(:,:)
  complex(kind(1.d0)), intent(inout) :: y(:,:)
  type (z_spmat), intent(in) :: t
  type(decomp_data_type), intent(in)  :: decomp_data
  complex(kind(1.d0)), intent(in), optional :: d(:)
  complex(kind(1.d0)), intent(inout), optional :: work(:)
  character, intent(in), optional :: trans, unitd
  logical, intent(in), optional :: choice
  integer, intent(in), optional :: n, jx, jy

  logical :: lchoice
  integer  :: iix, iiy, ijx, ijy, im, in, ik, iit, ijt, llwork, lld,&
       & lldx,lldy
  complex(kind(1.d0)), pointer :: wwork(:), wd(:)
  character :: ltrans, lunitd

  interface  
    subroutine pszspsm(trans,m,n,alpha,unitd,dv,&
         & tpl,t,it1,it2,fidt,descrt,infot,tpr,it,jt,&
         & x,ix,jx,ldx,beta,y,iy,jy,ldy,choice,&
         & matrix_data,halo_index,ovrlap_index,ovrlap_elem,&
         & work,lw)
      integer, intent(in)   :: m,n,it,jt,ix,jx,ldx,iy,jy,ldy,lw
      character, intent(in) :: fidt*5, descrt*11, trans, unitd
      integer, intent(in)   :: matrix_data(*), halo_index(*),&
           & ovrlap_index(*), ovrlap_elem(*)
      integer, intent(in)   :: tpr(*), tpl(*), it1(*), it2(*), infot(*)
      complex(kind(1.d0)), intent(in) :: alpha, beta, t(*), x(ldx,*),dv(*)
      complex(kind(1.d0)), intent(inout) ::  y(ldy,*),work(*)
      logical, intent(in)   :: choice
    end subroutine pszspsm
  end interface
  
  iix = 1
  if (present(jx)) then
     ijx = jx
  else
     ijx = 1
  endif
  
  iiy = 1
  if (present(jy)) then       
     ijy = jy
  else
     ijy = 1
  endif
  
  iit = 1
  ijt = 1
  im = decomp_data%matrix_data(m_)

  if (present(n)) then
     in = n
  else
     in = min(size(x,2)-ijx+1,size(y,2)-ijy+1)
  endif
  
  if (present(choice)) then     
     lchoice = choice
  else
     lchoice = .true.
  endif

  if (present(trans)) then     
     ltrans = trans
  else
     ltrans = 'N'
  endif

  if (present(unitd)) then     
     lunitd = unitd
  else
     lunitd = 'U'
  endif
  
  lldx = size(x,1)  
  lldy = size(y,1) 
  

  if (present(d)) then     
     if (present(work)) then     
	llwork=size(work)
	call pszspsm( ltrans, im, in, alpha, lunitd, d, &
	     & t%pl, t%aspk, t%ia1, t%ia2,&
	     & t%fida, t%descra, t%infoa, t%pr,&
	     & iit, ijt, X, iix, ijx, lldx,&
	     & beta, Y, iiy, ijy, lldy, lchoice,&
	     & decomp_data%matrix_data, decomp_data%halo_index,&
	     & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	     & work, llwork)
     else
	llwork= 1
	allocate(wwork(llwork))
	call pszspsm( ltrans, im, in, alpha, lunitd, d, &
	     & t%pl, t%aspk, t%ia1, t%ia2,&
	     & t%fida, t%descra, t%infoa, t%pr,&
	     & iit, ijt, X, iix, ijx, lldx,&
	     & beta, Y, iiy, ijy, lldy, lchoice,&
	     & decomp_data%matrix_data, decomp_data%halo_index,&
	     & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	     & wwork, llwork)
	deallocate(wwork)
     endif
  else     
     lld= 1
     allocate(wd(lld))
     wd = 1.d0
     if (present(work)) then     
	llwork=size(work)
	call pszspsm( ltrans, im, in, alpha, lunitd, wd, &
	     & t%pl, t%aspk, t%ia1, t%ia2,&
	     & t%fida, t%descra, t%infoa, t%pr,&
	     & iit, ijt, X, iix, ijx, lldx,&
	     & beta, Y, iiy, ijy, lldy, lchoice,&
	     & decomp_data%matrix_data, decomp_data%halo_index,&
	     & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	     & work, llwork)
     else
	llwork= 1
	allocate(wwork(llwork))
	call pszspsm( ltrans, im, in, alpha, lunitd, wd, &
	     & t%pl, t%aspk, t%ia1, t%ia2,&
	     & t%fida, t%descra, t%infoa, t%pr,&
	     & iit, ijt, X, iix, ijx, lldx,&
	     & beta, Y, iiy, ijy, lldy, lchoice,&
	     & decomp_data%matrix_data, decomp_data%halo_index,&
	     & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	     & wwork, llwork)
	deallocate(wwork)
     endif
     deallocate(wd)
  endif   
  
  return
end subroutine f90_pszspsm
subroutine  f90_pszspsv(alpha,t,x,beta,y,decomp_data,&
     & trans, unitd, choice, d, work)   
  use typesp
  use typedesc
  complex(kind(1.D0)), intent(in) :: alpha, beta
  complex(kind(1.d0)), intent(in) :: x(:)
  complex(kind(1.d0)), intent(inout) :: y(:)
  type(z_spmat), intent(in) :: t
  type(decomp_data_type), intent(in)  :: decomp_data
  complex(kind(1.d0)), intent(inout), optional :: work(:)
  complex(kind(1.d0)), intent(in), optional :: d(:)
  character, intent(in), optional :: trans, unitd
  logical, intent(in), optional :: choice

  logical :: lchoice
  integer  :: iix, iiy, ijx, ijy, im, in, ik, iit, ijt,&
       & llwork, lld, lldx, lldy
  complex(kind(1.d0)), pointer  :: wwork(:), wd(:)
  character :: ltrans, lunitd

  interface  
    subroutine pszspsm(trans,m,n,alpha,unitd,dv,&
         & tpl,t,it1,it2,fidt,descrt,infot,tpr,it,jt,&
         & x,ix,jx,ldx,beta,y,iy,jy,ldy,choice,&
         & matrix_data,halo_index,ovrlap_index,ovrlap_elem,&
         & work,lw)
      integer, intent(in)   :: m,n,it,jt,ix,jx,ldx,iy,jy,ldy,lw
      character, intent(in) :: fidt*5, descrt*11, trans, unitd
      integer, intent(in)   :: matrix_data(*), halo_index(*),&
           & ovrlap_index(*), ovrlap_elem(*)
      integer, intent(in)   :: tpr(*), tpl(*), it1(*), it2(*), infot(*)
      complex(kind(1.d0)), intent(in) :: alpha, beta, t(*), x(ldx,*),dv(*)
      complex(kind(1.d0)), intent(inout) ::  y(ldy,*),work(*)
      logical, intent(in)   :: choice
    end subroutine pszspsm
  end interface
  
  iix = 1
  ijx = 1
  iiy = 1
  ijy = 1
  iit = 1
  ijt = 1
  im = decomp_data%matrix_data(m_)
  in = 1
  
  if (present(choice)) then     
     lchoice = choice
  else
     lchoice = .true.
  endif

  if (present(trans)) then     
     ltrans = trans
  else
     ltrans = 'N'
  endif

  if (present(unitd)) then     
     lunitd = unitd
  else
     lunitd = 'U'
  endif

  lldx = size(x,1)
  lldy = size(y,1) 
 

  if (present(d)) then     
     if (present(work)) then     
	llwork=size(work)
	call pszspsm( ltrans, im, in, alpha, lunitd, d, &
	     & t%pl, t%aspk, t%ia1, t%ia2,&
	     & t%fida, t%descra, t%infoa, t%pr,&
	     & iit, ijt, X, iix, ijx, lldx,&
	     & beta, Y, iiy, ijy, lldy, lchoice,&
	     & decomp_data%matrix_data, decomp_data%halo_index,&
	     & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	     & work, llwork)
     else
	llwork= max(lldx,lldy,1)
	allocate(wwork(llwork))
	call pszspsm( ltrans, im, in, alpha, lunitd, d, &
	     & t%pl, t%aspk, t%ia1, t%ia2,&
	     & t%fida, t%descra, t%infoa, t%pr,&
	     & iit, ijt, X, iix, ijx, lldx,&
	     & beta, Y, iiy, ijy, lldy, lchoice,&
	     & decomp_data%matrix_data, decomp_data%halo_index,&
	     & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	     & wwork, llwork)
	deallocate(wwork)
     endif
  else     
     lld= max(lldx,lldy,1)
     allocate(wd(lld))
     wd(1) = 1.d0
     if (present(work)) then     
	llwork=size(work)
	call pszspsm( ltrans, im, in, alpha, lunitd, wd, &
	     & t%pl, t%aspk, t%ia1, t%ia2,&
	     & t%fida, t%descra, t%infoa, t%pr,&
	     & iit, ijt, X, iix, ijx, lldx,&
	     & beta, Y, iiy, ijy, lldy, lchoice,&
	     & decomp_data%matrix_data, decomp_data%halo_index,&
	     & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	     & work, llwork)
     else
	llwork= max(lldx,lldy,1)
	allocate(wwork(llwork))
	call pszspsm( ltrans, im, in, alpha, lunitd, wd, &
	     & t%pl, t%aspk, t%ia1, t%ia2,&
	     & t%fida, t%descra, t%infoa, t%pr,&
	     & iit, ijt, X, iix, ijx, lldx,&
	     & beta, Y, iiy, ijy, lldy, lchoice,&
	     & decomp_data%matrix_data, decomp_data%halo_index,&
	     & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	     & wwork, llwork)
	deallocate(wwork)
     endif
     deallocate(wd)
  endif   

  return
end subroutine f90_pszspsv



