subroutine  f90_pszovrl(x,decomp_data,&
     & update_type, choice, work)
  use typedesc
  complex(kind(1.d0)), intent(inout) :: x(:,:)
  type(decomp_data_type), intent(in)  :: decomp_data
  complex(kind(1.d0)), intent(inout), optional :: work(:)
  logical, intent(in), optional :: choice
  integer, intent(in), optional :: update_type

  complex(kind(1.d0)), pointer :: wwork(:)
  integer  :: iix, ijx, lldx, m, n, llwork, lupdate_type
  logical :: lchoice
  complex(kind(1.d0)) :: talpha
  
  interface
     subroutine pszovrl(m,n,x,ix,jx,ldx,update_type,choice,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem,&
	  & work,lw)
       integer, intent(in) :: m,n,ix,jx,ldx,lw,update_type
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       complex(kind(1.d0)), intent(inout) :: x(ldx,*),work(*)
       logical, intent(in)  :: choice
     end subroutine pszovrl
  end interface 
  
  iix = 1
  ijx = 1

  lldx = size(x,1)
  n =  size(x,2)
  m = decomp_data%matrix_data(m_)
  

  if (present(update_type)) then
     lupdate_type=update_type
  else
     lupdate_type=normal
  endif

  if (present(choice)) then
     lchoice=choice
  else
     lchoice=.true.
  endif
  
  if (present(work)) then
     llwork = size(work)
     call pszovrl( m, n, X, iix, ijx, lldx, lupdate_type, lchoice,&
	  & decomp_data%matrix_data, decomp_data%halo_index,&
	  & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	  & work, llwork)
  else
     llwork=2*decomp_data%matrix_data(n_col_)
     allocate(wwork(llwork))
     call pszovrl( m, n, X, iix, ijx, lldx, lupdate_type, lchoice,&
	  & decomp_data%matrix_data, decomp_data%halo_index,&
	  & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	  & wwork, llwork)
     deallocate(wwork)
  endif

  
  return
end subroutine f90_pszovrl
subroutine  f90_pszovrlv(x,decomp_data,&
     & update_type, choice, work)
  use typedesc
  complex(kind(1.d0)), intent(inout) :: x(:)
  type(decomp_data_type), intent(in)  :: decomp_data
  complex(kind(1.d0)), intent(inout), optional :: work(:)
  logical, intent(in), optional :: choice
  integer, intent(in), optional :: update_type

  complex(kind(1.d0)), pointer :: wwork(:)
  integer :: iix, ijx, lldx, m, n, llwork, lupdate_type
  logical :: lchoice
  
  interface
     subroutine pszovrl(m,n,x,ix,jx,ldx,update_type,choice,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem,&
	  & work,lw)
       integer, intent(in) :: m,n,ix,jx,ldx,lw,update_type
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       complex(kind(1.d0)), intent(inout) :: x(ldx,*),work(*)
       logical, intent(in)  :: choice
     end subroutine pszovrl
  end interface 
  
  iix = 1
  ijx = 1

  lldx = size(x,1)
  m = decomp_data%matrix_data(m_)
  n = 1

  if (present(update_type)) then
     lupdate_type=update_type
  else
     lupdate_type=normal
  endif

  if (present(choice)) then
     lchoice=choice
  else
     lchoice=.true.
  endif
  
  
  if (present(work)) then
     llwork = size(work)
     call pszovrl( m, n, X, iix, ijx, lldx, lupdate_type, lchoice,&
	  & decomp_data%matrix_data, decomp_data%halo_index,&
	  & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	  & work, llwork)
  else
     llwork=2*decomp_data%matrix_data(n_col_)
     allocate(wwork(llwork))
     call pszovrl( m, n, X, iix, ijx, lldx, lupdate_type, lchoice,&
	  & decomp_data%matrix_data, decomp_data%halo_index,&
	  & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	  & wwork, llwork)
     deallocate(wwork)
  endif
  
  return
end subroutine f90_pszovrlv




