subroutine  f90_pszdotcvs(res,x, y,decomp_data)  
  use typedesc
  complex(kind(1.d0)), intent(in) :: x(:), y(:)
  type(decomp_data_type), intent(in)  :: decomp_data
  complex(kind(1.D0)), intent(out) :: res
  complex(kind(1.D0)) :: dot_local
  integer  :: iix, iiy, ijx, ijy, lldx, lldy, n, k

  interface 
     subroutine pszdotc(m,dot,x,ix,jx,ldx,y,iy,jy,ldy,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: m,ix,jx,iy,jy,ldx,ldy
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       complex (kind(1.d0)), intent(in) :: x(*),y(*)
       complex(kind(1.d0)), intent(out) :: dot
     end subroutine pszdotc
  end interface
  
  iix = 1
  ijx = 1
  iiy = 1
  ijy = 1
  lldx = size(x,1)
  lldy = size(y,1) 
  n = decomp_data%matrix_data(m_)
  call pszdotc( n, dot_local, X, iix, ijx, lldx,  Y, iiy, ijy, lldy,& 
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem)
!!$   write(0,*) dot_local
  res = dot_local
  return
end subroutine f90_pszdotcvs

SUBROUTINE  F90_PSZMDOT(RES,X, Y, DECOMP_DATA) 
  USE TYPESP
  USE TYPEDESC
  COMPLEX(KIND(1.D0)), intent(out)   :: RES(:)
  COMPLEX(KIND(1.D0)), intent(in) :: X(:,:), Y(:,:)
  TYPE(DECOMP_DATA_TYPE), intent(in)  :: DECOMP_DATA
  integer  :: iix, iiy, ijx, ijy, lldx, lldy, n, k

  interface 
     subroutine pszmdotc(m,n,dot,x,ix,jx,ldx,y,iy,jy,ldy,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: m,n,ix,jx,iy,jy,ldx,ldy
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       complex(kind(1.d0)), intent(in) :: x(ldx,*),y(ldy,*)
       complex(kind(1.d0)), intent(out) :: dot(*)
     end subroutine pszmdotc
  end interface
  
  iix = 1
  ijx = 1
  iiy = 1
  ijy = 1
  lldx = size(x,1)
  lldy = size(y,1) 
  k    = min(size(x,2),size(y,2),size(res,1))
  n = decomp_data%matrix_data(m_)
  call pszmdot( n, k, res, X, iix, ijx, lldx,  Y, iiy, ijy, lldy,& 
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem)
  return

END SUBROUTINE F90_PSZMDOT


