subroutine  f90_pszaxpby(alpha, x, beta,y,decomp_data,&
     & n, jx, jy)  
  use typedesc
  integer, intent(in), optional :: n, jx, jy
  type(decomp_data_type), intent(in)  :: decomp_data
  complex(kind(1.D0)), intent(in) :: alpha, beta
  complex(kind(1.D0)), intent(in) :: x(:,:)
  complex(kind(1.D0)), intent(inout) :: y(:,:)
  integer  :: iix, iiy, ijx, ijy, lldx, lldy, im, in
  
  interface 
     subroutine pszaxpby(m,n,alpha,x,ix,jx,ldx,&
	  & beta,y,iy,jy,ldy,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: m,n,ix,jx,iy,jy,ldx,ldy
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       complex(kind(1.d0)), intent(in) :: alpha,beta,x(ldx,*)
       complex(kind(1.d0)), intent(inout) :: y(ldy,*)
     end subroutine pszaxpby
  end interface
  
  iix = 1
  if (present(jx)) then
     ijx = jx
  else
     ijx = 1
  endif
  
  iiy = 1
  if (present(jy)) then
     ijy = jy
  else
     ijy = 1
  endif

  im = decomp_data%matrix_data(m_)

  if (present(n)) then
     in = n
  else
     in = min(size(x,2),size(y,2))
  endif

  lldx = size(x,1)
  lldy = size(y,1)
  
  call pszaxpby( im, in, alpha, X, iix, ijx,lldx,&
       & beta, Y, iiy, ijy, lldy,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 
  return
end subroutine f90_pszaxpby
subroutine  f90_pszaxpbyv(alpha, x, beta, y,decomp_data)  
  use typedesc
  type(decomp_data_type), intent(in)  :: decomp_data
  complex(kind(1.D0)), intent(in) :: alpha, beta
  complex(kind(1.D0)), intent(in) :: x(:)
  complex(kind(1.D0)), intent(inout) :: y(:)
  integer  :: iix, iiy, lldx, ijx, ijy, lldy, im, in
  
  interface 
     subroutine pszaxpby(m,n,alpha,x,ix,jx,ldx,&
	  & beta,y,iy,jy,ldy,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: m,n,ix,jx,iy,jy,ldx,ldy
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       complex(kind(1.d0)), intent(in) :: alpha,beta,x(ldx,*)
       complex(kind(1.d0)), intent(inout) :: y(ldy,*)
     end subroutine pszaxpby
  end interface

  iix = 1
  ijx = 1
  iiy = 1
  ijy = 1
  im = decomp_data%matrix_data(m_)
  in = 1
  lldx = size(x,1)
  lldy = size(y,1) 
  
  call pszaxpby( im, in, alpha, X, iix, ijx,lldx,&
       & beta, Y, iiy, ijy,lldy,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 

  return
end subroutine f90_pszaxpbyv



