function f90_pszasum(x,decomp_data, jx)  
  use typedesc
  complex(kind(1.d0)), intent(in) :: x(:,:)
  type(decomp_data_type), intent(in)  :: decomp_data
  integer, intent(in),  optional :: jx
  integer ::  iix, ijx, lldx, in
  real(kind(1.D0)) :: f90_pszasum, asum_local

  interface 
     subroutine pszasum(n,alpha,x,ix,jx,ldx,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: n,ix,jx,ldx
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       real(kind(1.d0)), intent(out) :: alpha
       COMPLEX (kind(1.d0)), intent(in) :: x(ldx,*)
     end subroutine pszasum
  end interface

  
  iix = 1
  if (present(jx)) then
     ijx = jx
  else
     ijx = 1
  endif
  in = decomp_data%matrix_data(m_)
  lldx = size(x,1)
  if (f90_func_bug) then 
    lldx = decomp_data%matrix_data(n_col_)
  endif  
  
  call pszasum( in, asum_local, X, iix, ijx, lldx,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 
  f90_pszasum = asum_local
  return
end function f90_pszasum

function f90_pszasumv(x,decomp_data)  
  use typedesc
  complex(kind(1.d0)), intent(in) :: x(:)
  type(decomp_data_type), intent(in)  :: decomp_data
  real(kind(1.D0)) :: f90_pszasumv, asum_local
  integer   :: iix, ijx, lldx, in

  interface 
     subroutine pszasum(n,alpha,x,ix,jx,ldx,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: n,ix,jx,ldx
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       real(kind(1.d0)), intent(out) :: alpha
       COMPLEX (kind(1.d0)), intent(in) :: x(ldx,*)
     end subroutine pszasum
  end interface

  iix = 1
  ijx = 1
  in = decomp_data%matrix_data(m_)

  lldx=size(x,1)
  if (f90_func_bug) then 
    lldx = decomp_data%matrix_data(n_col_)
  endif

  call pszasum( in, asum_local, X, iix, ijx,lldx,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 
  f90_pszasumv = asum_local
  return
end function f90_pszasumv

subroutine  f90_pszasumvs(res,x,decomp_data)  
  use typedesc
  COMPLEX(kind(1.d0)), intent(in) :: x(:)
  type(decomp_data_type), intent(in)  :: decomp_data
  real(kind(1.D0)), intent(out) :: res
  integer   :: iix, ijx, lldx, in
  real(kind(1.D0)) :: asum_local

  interface 
     subroutine pszasum(n,alpha,x,ix,jx,ldx,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: n,ix,jx,ldx
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       real(kind(1.d0)), intent(out) :: alpha
       COMPLEX (kind(1.d0)), intent(in) :: x(ldx,*)
     end subroutine pszasum
  end interface
  
  iix = 1
  ijx = 1
  in = decomp_data%matrix_data(m_)
  
  lldx=size(x,1)
  
  call pszasum( in, asum_local, X, iix, ijx,lldx,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 
  res = asum_local
  return
end subroutine f90_pszasumvs



