function f90_pszamax(x,decomp_data, jx)
  use typesp
  use typedesc
  complex(kind(1.d0)), intent(in)        :: x(:,:)
  type(decomp_data_type), intent(in)  :: decomp_data
  integer, optional, intent(in)       :: jx
  integer   :: iix, ijx, lldx, in
  real(kind(1.D0)) :: f90_pszamax, amax_local
  
  interface 
     subroutine pszamax(n,amax,x,ix,jx,ldx,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       integer, intent(in) :: n, ix, jx, ldx
       complex(kind(1.d0)), intent(in) ::  x(ldx,*)
       real(kind(1.d0)), intent(out) ::  amax
     end subroutine pszamax
  end interface

  
  iix = 1
  if (present(jx)) then
     ijx = jx
  else
     ijx = 1
  endif
  in = decomp_data%matrix_data(m_)
  lldx = size(x,1)
  if (f90_func_bug) then 
    lldx = decomp_data%matrix_data(n_col_)
  endif  
  
  call pszamax( in, amax_local, X, iix, ijx, lldx,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 

  f90_pszamax = amax_local
  return
end function f90_pszamax

function f90_pszamaxv(x,decomp_data)  
  use typesp
  use typedesc

  complex(kind(1.d0)), intent(in) :: x(:)
  type(decomp_data_type), intent(in) :: decomp_data
  integer ::  iix, ijx, lldx, in
  real(kind(1.D0)) :: f90_pszamaxv, amax_local

  interface 
     subroutine pszamax(n,amax,x,ix,jx,ldx,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       integer, intent(in) :: n, ix, jx, ldx
       complex(kind(1.d0)), intent(in) ::  x(ldx,*)
       real(kind(1.d0)), intent(out) ::  amax
     end subroutine pszamax
  end interface

  logical, parameter :: debug=.false.

  iix = 1
  ijx = 1
  in = decomp_data%matrix_data(m_)
  lldx = size(x,1)
  if (f90_func_bug) then 
    lldx = decomp_data%matrix_data(n_col_)
  endif

  if  (debug) write(*,*)'in F90AMAX',lldx, size(x(:))
  call pszamax( in, amax_local, X, iix, ijx, lldx,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 
  f90_pszamaxv = amax_local
  if  (debug) write(*,*)'On exit from  F90AMAX',amax_local
  return
end function f90_pszamaxv


subroutine  f90_pszamaxvs(res,x,decomp_data)  
  use typesp
  use typedesc
  complex(kind(1.d0)), intent(in) :: x(:)
  type(decomp_data_type), intent(in)  :: decomp_data
  integer ::  iix, ijx, lldx, in
  real(kind(1.D0)) :: res, amax_local

  interface 
     subroutine pszamax(n,amax,x,ix,jx,ldx,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       integer, intent(in) :: n, ix, jx, ldx
       complex(kind(1.d0)), intent(in) ::  x(ldx,*)
       real(kind(1.d0)), intent(out) ::  amax
     end subroutine pszamax
  end interface
  
  logical, parameter :: debug=.false.


  iix = 1
  ijx = 1
  in = decomp_data%matrix_data(m_)

  lldx = size(x,1)
  if  (debug) write(*,*)'in F90AMAX',lldx, size(x(:))
  call pszamax( in, amax_local, X, iix, ijx, lldx,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 
  res = amax_local
  if  (debug) write(*,*)'On exit from  F90AMAX',amax_local
  return
end subroutine f90_pszamaxvs

subroutine  f90_pszmamax(res,x,decomp_data)  
  use typesp
  use typedesc
  real(kind(1.d0)), intent(out) :: res(:)
  complex(kind(1.d0)), intent(in) :: x(:,:)
  type(decomp_data_type), intent(in)  :: decomp_data
  integer ::  iix, ijx, lldx, in

  interface 
    subroutine pszmamax(n,k,amax,x,ix,jx,ldx,&
         & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
      integer, intent(in) :: n,k,ix,jx,ldx
      integer, intent(in) :: matrix_data(*), halo_index(*),&
           & ovrlap_index(*), ovrlap_elem(*)
      complex(kind(1.d0)), intent(in) :: x(*)
      real(kind(1.d0)), intent(out) :: amax(*)
    end subroutine pszmamax
  end interface
  logical, parameter :: debug=.false.
  integer   k

  iix = 1
  ijx = 1
  in = decomp_data%matrix_data(m_)
  if  (debug) write(*,*) 'Start F90_AMAX',in,size(x,1)
  lldx = size(x,1)
  k  = min(size(x,2),size(res,1))

  if  (debug) write(*,*) 'in F90AMAX',lldx, size(x,1),k,&
       &size(x,2),size(res,1),size(res)
  call pszmamax( in, k, res, X, iix, ijx, lldx,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 
  if  (debug) write(*,*) 'On exit from  F90AMAX',res(:)
  return
end subroutine f90_pszmamax

