subroutine  f90_psihalo(x,decomp_data,alpha,work,tran)
  use typedesc
  integer, intent(inout) :: x(:,:)
  type(decomp_data_type), intent(in)  :: decomp_data
  real(kind(1.d0)), intent(in), optional :: alpha
  integer, intent(inout), optional :: work(:)
  integer, pointer :: wwork(:)
  real(kind(1.d0)) aa
  integer   iix, ijx, lldx, m, n, llwork
  logical,  parameter :: debug=.false.
  character, intent(in), optional :: tran
  character :: ltran

  interface 
     subroutine psihalo(tran,m,n,alpha,x,ix,jx,ldx,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem,&
	  & work,lwork) 
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       integer, intent(in) :: m,n,ix,jx,ldx,lwork
       real(kind(1.d0)), intent(in) :: alpha
       integer, intent(inout) :: x(ldx,*), work(*)
       character, intent(in) :: tran
     end subroutine psihalo
  end interface
    
  iix = 1
  ijx = 1
  lldx = size(x,1)

  m = decomp_data%matrix_data(m_)
  n = size(x,2)

  if (present(alpha)) then
     aa = alpha
  else
     aa = 1.d0
  endif

  if (present(tran)) then     
    ltran = tran
  else
    ltran = 'N'
  endif

  if (present(work)) then
     llwork = size(work)     
     if (debug)  write(*,*) 'Calling psihalo ',m,n,alpha,llwork
     call psihalo( ltran, m, n, aa, X, iix, ijx, lldx,  &
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
       & work, llwork)
  else
     llwork = decomp_data%matrix_data(n_col_)
     if (debug)  write(*,*) 'Calling psihalo ',m,n,alpha,llwork
     allocate(wwork(llwork))
     call psihalo( ltran, m, n, aa, X, iix, ijx, lldx,  &
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
       & wwork, llwork)
     deallocate(wwork)
  endif
  
  return
end subroutine f90_psihalo
subroutine  f90_psihalov(x,decomp_data,alpha,work,tran)
  use typedesc
  integer, intent(inout) :: x(:)
  type(decomp_data_type), intent(in)  :: decomp_data
  integer, intent(inout), optional :: work(:)
  real(kind(1.d0)), intent(in), optional :: alpha
  integer, pointer :: wwork(:)
  real(kind(1.d0)) :: aa
  integer   :: iix, ijx, lldx, m, n, llwork  
  character, intent(in), optional :: tran
  character :: ltran
  
  interface 
     subroutine psihalo(tran,m,n,alpha,x,ix,jx,ldx,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem,&
	  & work,lwork) 
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       integer, intent(in) :: m,n,ix,jx,ldx,lwork
       real(kind(1.d0)), intent(in) :: alpha
       integer, intent(inout) :: x(ldx,*), work(*)
       character, intent(in) :: tran
     end subroutine psihalo
  end interface

    
  iix = 1
  ijx = 1
  lldx = size(x,1)

  m = decomp_data%matrix_data(m_)
  n = 1

  if (present(alpha)) then     
     aa = alpha
  else
     aa = 1.d0
  endif

 if (present(tran)) then     
    ltran = tran
  else
    ltran = 'N'
  endif

  if (present(work)) then
     llwork = size(work)          
     call psihalo( ltran, m, n, aa, X, iix, ijx, lldx,  &
	  & decomp_data%matrix_data, decomp_data%halo_index,&
	  & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	  & work, llwork)
  else
     llwork = decomp_data%matrix_data(n_col_)
     allocate(wwork(llwork))
     call psihalo( ltran, m, n, aa, X, iix, ijx, lldx,  &
	  & decomp_data%matrix_data, decomp_data%halo_index,&
	  & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	  & wwork, llwork)
     deallocate(wwork)
  endif
   
  return
end subroutine f90_psihalov




