subroutine  f90_psdspmm(alpha,a,x,beta,y,decomp_data,&
     & trans, k, jx, jy, work)   
  use typesp
  use typedesc
  real(kind(1.D0)), intent(in)    :: alpha, beta
  real(kind(1.d0)), intent(in)    :: x(:,:)
  real(kind(1.d0)), intent(inout) :: y(:,:)
  type (d_spmat), intent(in)      :: a
  type(decomp_data_type), intent(in)  :: decomp_data
  real(kind(1.d0)), intent(inout), optional :: work(:)
  character, intent(in), optional :: trans
  integer, intent(in), optional :: k, jx, jy

  integer :: iix, iiy, ijx, ijy, lldx, lldy, im, in, ik, iia, ija,&
       & llwork 
  real(kind(1.d0)), pointer :: wwork(:)
  character :: ltrans 
  logical, parameter :: debug=.false.

  interface 
    subroutine psdspmm(trans,m,n,k,alpha,&
         & apr,a,ia1,ia2,fida,descra,infoa,apc,ia,ja,&
         & x,ix,jx,ldx,beta,y,iy,jy,ldy,&
         & matrix_data,halo_index,ovrlap_index,ovrlap_elem,&
         & work,lw) 
      integer, intent(in) :: matrix_data(*), halo_index(*),&	
           & ovrlap_index(*), ovrlap_elem(*)       
      integer, intent(in) :: m,n,k,ia,ja,ix,jx,ldx,iy,jy,ldy,lw
      integer, intent(in) :: apr(*), apc(*), ia1(*), ia2(*), infoa(*)
      character, intent(in) :: fida*5, descra*11, trans
      real(kind(1.d0)), intent(in) :: alpha, beta, a(*), x(ldx,*)
      real(kind(1.d0)), intent(inout) :: y(ldy,*),work(*)
    end subroutine psdspmm
  end interface

  iia = 1
  ija = 1
  iix = 1
  if (present(jx)) then
    ijx = jx
  else
    ijx = 1
  endif

  iiy = 1
  if (present(jy)) then
    ijy = jy
  else
    ijy = 1
  endif

  im = decomp_data%matrix_data(m_)
  in = decomp_data%matrix_data(n_)

  if (present(k)) then     
    ik = k
  else
    ik = min(size(x,2)-ijx+1,size(y,2)-ijy+1)
  endif

  if (present(trans)) then     
    ltrans = trans
  else
    ltrans = 'N'
  endif

  lldx = size(x,1)
  lldy = size(y,1) 

  if (present(work)) then     
    llwork=size(work)
    if (debug) write(0,*) 'f90_spmv: check 2',&
         &decomp_data%matrix_data(1:ctxt_),llwork
    call psdspmm( ltrans, im, in, ik, alpha,&
         & a%pl, a%aspk, a%ia1, a%ia2,&
         & a%fida, a%descra, a%infoa, a%pr,&
         & iia, ija, X, iix, ijx, lldx,&
         & beta, Y, iiy, ijy, lldy,&
         & decomp_data%matrix_data, decomp_data%halo_index,&
         & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
         & work, llwork)      
  else
    llwork= 2*decomp_data%matrix_data(n_col_)

    allocate(wwork(llwork))
    call psdspmm( ltrans, im, in, ik, alpha,&
         & a%pl, a%aspk, a%ia1, a%ia2,&
         & a%fida, a%descra, a%infoa, a%pr,&
         & iia, ija, X, iix, ijx, lldx,&
         & beta, Y, iiy, ijy, lldy,&
         & decomp_data%matrix_data, decomp_data%halo_index,&
         & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
         & wwork, llwork)     
    deallocate(wwork)
  endif

  return
end subroutine f90_psdspmm
subroutine  f90_psdspmv(alpha,a,x,beta,y,decomp_data,&
     & trans,work)
  use typesp
  use typedesc
  real(kind(1.D0)), intent(in)    :: alpha, beta
  real(kind(1.d0)), intent(in)    :: x(:)
  real(kind(1.d0)), intent(inout) :: y(:)
  type (d_spmat), intent(in)      :: a
  type(decomp_data_type), intent(in)  :: decomp_data
  real(kind(1.d0)), intent(inout), optional :: work(:)
  character, intent(in), optional :: trans
  integer   :: iix, iiy, ijx, ijy, lldx, lldy, im, in, ik, iia, ija, llwork,info
  logical, parameter :: debug=.false.
  real(kind(1.d0)), pointer  :: wwork(:)
  character :: ltrans
  
  interface 
    subroutine psdspmm(trans,m,n,k,alpha,&
         & apr,a,ia1,ia2,fida,descra,infoa,apc,ia,ja,&
         & x,ix,jx,ldx,beta,y,iy,jy,ldy,&
         & matrix_data,halo_index,ovrlap_index,ovrlap_elem,&
         & work,lw) 
      integer, intent(in) :: matrix_data(*), halo_index(*),&	
           & ovrlap_index(*), ovrlap_elem(*)       
      integer, intent(in) :: m,n,k,ia,ja,ix,jx,ldx,iy,jy,ldy,lw
      integer, intent(in) :: apr(*), apc(*), ia1(*), ia2(*), infoa(*)
      character, intent(in) :: fida*5, descra*11, trans
      real(kind(1.d0)), intent(in) :: alpha, beta, a(*), x(ldx,*)
      real(kind(1.d0)), intent(inout) :: y(ldy,*),work(*)
    end subroutine psdspmm
  end interface

  iia = 1
  ija = 1
  iix = 1
  ijx = 1
  iiy = 1
  ijy = 1
  im = decomp_data%matrix_data(m_)
  in = decomp_data%matrix_data(n_)
  ik = 1

  if (present(trans)) then     
     ltrans = trans
  else
     ltrans = 'N'
  endif
  
  lldx = size(x,1)
  lldy = size(y,1) 

  if (debug) write(0,*) 'f90_spmv: check ',decomp_data%matrix_data(ctxt_)

  if (present(work)) then     
     llwork=size(work)
     if (debug) write(0,*) 'f90_spmv: check 2',&
          &decomp_data%matrix_data(1:ctxt_),llwork
     call psdspmm( ltrans, im, in, ik, alpha,&
	  & a%pl, a%aspk, a%ia1, a%ia2,&
	  & a%fida, a%descra, a%infoa, a%pr,&
	  & iia, ija, X, iix, ijx, lldx,&
	  & beta, Y, iiy, ijy, lldy,&
	  & decomp_data%matrix_data, decomp_data%halo_index,&
	  & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	  & work, llwork)      
  else
     llwork= 2*decomp_data%matrix_data(n_col_)
     allocate(wwork(llwork),stat=info)
     if (info.ne.0) write(0,*) 'f90_spmv: error on allocate',info
     call psdspmm( ltrans, im, in, ik, alpha,&
	  & a%pl, a%aspk, a%ia1, a%ia2,&
	  & a%fida, a%descra, a%infoa, a%pr,&
	  & iia, ija, X, iix, ijx, lldx,&
	  & beta, Y, iiy, ijy, lldy,&
	  & decomp_data%matrix_data, decomp_data%halo_index,&
	  & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	  & wwork, llwork)     
     deallocate(wwork)
  endif

  return
end subroutine f90_psdspmv



