subroutine  f90_psdscatterm(globX, locX, decomp_data, iroot, iiglobX,&
     & ijglobX, iilocX, ijlocX, work)
  use typedesc
  implicit none
  real(kind(1.d0)), intent(out) :: locX(:,:)
  real(kind(1.d0)), intent(in) :: globX(:,:)
  type(decomp_data_type), intent(in)  :: decomp_data
  integer, intent(in), optional :: iroot, iiglobX, ijglobX, iilocX, ijlocX
  integer, intent(inout), optional :: work(:)
  
  integer, pointer        :: wwork(:)
  integer                 :: root, iglobX, jglobX, lda_globX, ilocX,&
       & jlocX, lda_locX, m, n, llwork
  integer                 :: ictxt, nprow, npcol, myprow, mypcol,&
       & max_size, proc, worksize, aux, itmp
  integer, allocatable, dimension(:) :: aux_vect

  interface 
     subroutine psdscatterm(m, n, globX, iglobX, jglobX, lda_globX, &
          & locX, ilocX, jlocX, lda_locX, root, desc_data, desc_halo,&
          & desc_overlap, overlap_elem, loc_to_glob, work, lwork)
        Integer, intent(in) :: iglobX, jglobX, lda_globX, n, m, lwork, &
	     &     ilocX, jlocX, lda_locX, root     
        Integer, intent(in)  :: desc_data(*), desc_halo(*), desc_overlap(*), &
	     &     overlap_elem(*), loc_to_glob(*)
        Integer, intent(inout)  :: work(*)
        real(kind(1.d0)), intent(out) :: locX(lda_locX,*)
        real(kind(1.d0)), intent(in) :: globX(lda_globX,*)
     end subroutine psdscatterm
  end interface

  if (present(iroot)) then
     root = iroot
  else
     root = iroot
  end if
  
  if (present(iiglobX)) then
     iglobX = iiglobX
  else
     iglobX = 1
  end if
  
  if (present(ijglobX)) then
     jglobX = ijglobX
  else
     jglobX = 1
  end if

  if (present(iilocX)) then
     ilocX = iilocX
  else
     ilocX = 1
  end if
  
  if (present(ijlocX)) then
     jlocX = ijlocX
  else
     jlocX = 1
  end if

  lda_globX = size(globX,1)
  lda_locX  = size(locX, 1)

  ictxt = decomp_data%matrix_data(CTXT_)
  call BLACS_GRIDINFO(ictxt, nprow, npcol, myprow, mypcol)
  
  m = decomp_data%matrix_data(m_)
  if (myprow == root) then
     n = size(globX, 2)
     call IGEBS2D(ictxt, 'ALL', ' ', 1, 1, n, 1)
  else
     call IGEBR2D(ictxt, 'ALL', ' ', 1, 1, n, 1, root, 0)
  end if
  
  if (present(work)) then
     llwork = size(work)     
     call psdscatterm(m, n, globX, iglobX, jglobX, lda_globX, &
	  & locX, ilocX, jlocX, lda_locX, root, &
          & decomp_data%matrix_data, decomp_data%halo_index,&
          & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
          & decomp_data%loc_to_glob, work, llwork)
  else

    max_size = decomp_data%matrix_data(N_ROW_)
    call IGAMX2D(ictxt, 'All', ' ',1, 1, max_size, 1, itmp,itmp,-1,-1,-1)

    if (root == myprow) then
      WorkSize= ((nprow + 1) * kind(1)+(max_size + 1) * kind(1.0d0) + &
           &     max_size * kind(1)) / kind(1)
      Allocate(wwork(Worksize), STAT = AUX)
      llwork = Worksize
      if (AUX /= 0) call BLACS_ABORT(ictxt, 1)
    else
      llwork = 1
      Allocate(wwork(llwork), STAT = AUX)
      if (AUX /= 0) call BLACS_ABORT(ictxt, 1)	
    end if
    call psdscatterm(m, n, globX, iglobX, jglobX, lda_globX, &
         & locX, ilocX, jlocX, lda_locX, root, &
         & decomp_data%matrix_data, decomp_data%halo_index,&
         & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
         & decomp_data%loc_to_glob, wwork, llwork)
    deallocate(wwork)     
  end if
  return
end subroutine f90_psdscatterm


subroutine  f90_psdscattermv(globX, locX, decomp_data, iroot, iiglobX,&
     & iilocX, work)
  use typedesc
  implicit none
  real(kind(1.d0)), intent(out) :: locX(:)
  real(kind(1.d0)), intent(in) :: globX(:)
  type(decomp_data_type), intent(in)  :: decomp_data
  integer, intent(in), optional       :: iroot, iiglobX, iilocX
  integer, intent(inout), optional :: work(:)

  integer, pointer        :: wwork(:)
  integer                 :: root, iglobX, jglobX, lda_globX, ilocX,&
       & jlocX, lda_locX, m, n, llwork
  integer                 :: ictxt, nprow, npcol, myprow, mypcol,&
       & max_size, proc, worksize, aux, itmp
  integer, allocatable, dimension(:) :: aux_vect

  interface 
    subroutine psdscatterm(m, n, globX, iglobX, jglobX, lda_globX, &
         & locX, ilocX, jlocX, lda_locX, root, desc_data, desc_halo,&
         & desc_overlap, overlap_elem, loc_to_glob, work, lwork)
      Integer, intent(in) :: iglobX, jglobX, lda_globX, n, m, lwork, &
           &     ilocX, jlocX, lda_locX, root     
      Integer, intent(in)  :: desc_data(*), desc_halo(*), desc_overlap(*), &
           &     overlap_elem(*), loc_to_glob(*)
      Integer, intent(inout)  :: work(*)
      real(kind(1.d0)), intent(out) :: locX(lda_locX,*)
      real(kind(1.d0)), intent(in) :: globX(lda_globX,*)
    end subroutine psdscatterm
  end interface

  if (present(iroot)) then
    root = iroot
  else
    root = iroot
  end if

  if (present(iiglobX)) then
    iglobX = iiglobX
  else
    iglobX = 1
  end if

  jglobX = 1

  if (present(iilocX)) then
    ilocX = iilocX
  else
    ilocX = 1
  end if

  jlocX = 1

  lda_globX = size(globX, 1)
  lda_locX  = size(locX, 1)

  ictxt = decomp_data%matrix_data(CTXT_)
  call BLACS_GRIDINFO(ictxt, nprow, npcol, myprow, mypcol)

  m = decomp_data%matrix_data(m_)
  n = 1

  if (present(work)) then
    llwork = size(work)     
    call psdscatterm(m, n, globX, iglobX, jglobX, lda_globX, &
         & locX, ilocX, jlocX, lda_locX, root, &
         & decomp_data%matrix_data, decomp_data%halo_index,&
         & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
         & decomp_data%loc_to_glob, work, llwork)
  else
    max_size = decomp_data%matrix_data(N_ROW_)
    call IGAMX2D(ictxt, 'All', ' ',1, 1, max_size, 1, itmp,itmp,-1,-1,-1)
    if (root == myprow) then
      WorkSize= ((nprow + 1) * kind(1)+(max_size + 1) * kind(1.0d0) + &
           &     max_size * kind(1)) / kind(1)
      Allocate(wwork(Worksize), STAT = AUX)
      llwork = Worksize
      if (AUX /= 0) call BLACS_ABORT(ictxt, 1)
    else
      llwork = 1
      Allocate(wwork(llwork), STAT = AUX)
      if (AUX /= 0) call BLACS_ABORT(ictxt, 1)	
    end if
    call psdscatterm(m, n, globX, iglobX, jglobX, lda_globX, &
         & locX, ilocX, jlocX, lda_locX, root, &
         & decomp_data%matrix_data, decomp_data%halo_index,&
         & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
         & decomp_data%loc_to_glob, wwork, llwork)
    deallocate(wwork)     
  end if
  return
end subroutine f90_psdscattermv


