subroutine  f90_psdovrl(x,decomp_data,&
     & update_type, choice, work)
  use typedesc
  real(kind(1.d0)), intent(inout) :: x(:,:)
  type(decomp_data_type), intent(in)  :: decomp_data
  real(kind(1.d0)), intent(inout), optional :: work(:)
  logical, intent(in), optional :: choice
  integer, intent(in), optional :: update_type
  real(kind(1.d0)), pointer :: wwork(:)
  integer  :: iix, ijx, lldx, m, n, llwork, lupdate_type
  logical :: lchoice
  real(kind(1.d0)) :: talpha
  
  interface 
     subroutine psdovrl(m,n,x,ix,jx,ldx,update_type,choice,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem,&
	  & work,lw)
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       integer, intent(in) :: m,n,ix,jx,ldx,lw,update_type
       real(kind(1.d0)), intent(inout) :: x(ldx,*),work(*)
       logical, intent(in) :: choice
     end subroutine psdovrl
  end interface 
  
  iix = 1
  ijx = 1

  lldx = size(x,1)
  n =  size(x,2)
  m = decomp_data%matrix_data(m_)
  

  if (present(update_type)) then
     lupdate_type=update_type
  else
     lupdate_type=normal
  endif

  if (present(choice)) then
     lchoice=choice
  else
     lchoice=.true.
  endif
  
  if (present(work)) then
     llwork = size(work)
     call psdovrl( m, n, X, iix, ijx, lldx, lupdate_type, lchoice,&
	  & decomp_data%matrix_data, decomp_data%halo_index,&
	  & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	  & work, llwork)
  else
     llwork=2*decomp_data%matrix_data(n_col_)
     allocate(wwork(llwork))
     call psdovrl( m, n, X, iix, ijx, lldx, lupdate_type, lchoice,&
	  & decomp_data%matrix_data, decomp_data%halo_index,&
	  & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	  & wwork, llwork)
     deallocate(wwork)
  endif

  
  return
end subroutine f90_psdovrl
subroutine  f90_psdovrlv(x,decomp_data,&
     & update_type, choice, work)
  use typedesc
  real(kind(1.d0)), intent(inout) :: x(:)
  type(decomp_data_type), intent(in)  :: decomp_data
  real(kind(1.d0)), intent(inout), optional :: work(:)
  integer, intent(in), optional :: update_type
  logical, intent(in), optional :: choice
  real(kind(1.d0)), pointer :: wwork(:)
  integer :: iix, ijx, lldx, m, n, llwork, lupdate_type
  logical :: lchoice
  
  interface 
     subroutine psdovrl(m,n,x,ix,jx,ldx,update_type,choice,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem,&
	  & work,lw)
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       integer, intent(in) :: m,n,ix,jx,ldx,lw,update_type
       real(kind(1.d0)), intent(inout) :: x(ldx,*),work(*)
       logical, intent(in) :: choice
     end subroutine psdovrl
  end interface 
  
  iix = 1
  ijx = 1

  lldx = size(x,1)
  m = decomp_data%matrix_data(m_)
  n = 1

  if (present(update_type)) then
     lupdate_type=update_type
  else
     lupdate_type=normal
  endif

  if (present(choice)) then
     lchoice=choice
  else
     lchoice=.true.
  endif
  
  
  if (present(work)) then
     llwork = size(work)
     call psdovrl( m, n, X, iix, ijx, lldx, lupdate_type, lchoice,&
	  & decomp_data%matrix_data, decomp_data%halo_index,&
	  & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	  & work, llwork)
  else
     llwork=2*decomp_data%matrix_data(n_col_)
     allocate(wwork(llwork))
     call psdovrl( m, n, X, iix, ijx, lldx, lupdate_type, lchoice,&
	  & decomp_data%matrix_data, decomp_data%halo_index,&
	  & decomp_data%ovrlap_index,decomp_data%ovrlap_elem,&
	  & wwork, llwork)
     deallocate(wwork)
  endif
  
  return
end subroutine f90_psdovrlv




