function f90_psddot(x, y,decomp_data, jx, jy)  
  use typedesc
  real(kind(1.d0)), intent(in) :: x(:,:), y(:,:)
  type(decomp_data_type), intent(in)  :: decomp_data
  integer, intent(in), optional :: jx, jy
  real(kind(1.D0))              :: f90_psddot
  real(kind(1.D0))  :: dot_local
  integer   iix, iiy, ijx, ijy, lldx, lldy, n

  interface 
     subroutine psddot(n,dot,x,ix,jx,ldx,y,iy,jy,ldy,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       integer, intent(in) :: n,ix,jx,iy,jy,ldx,ldy
       real(kind(1.d0)), intent(in) ::  x(ldx,*),y(ldy,*)
       real(kind(1.d0)), intent(out) ::  dot
     end subroutine psddot
  end interface

  
  iix = 1
  if (present(jx)) then
     ijx = jx
  else
     ijx = 1
  endif
  
  iiy = 1
  if (present(jy)) then
     ijy = jy
  else
     ijy = 1
  endif

  lldx = size(x,1)
  lldy = size(y,1) 
  if (f90_func_bug) then 
    lldx = decomp_data%matrix_data(n_col_)
    lldy = decomp_data%matrix_data(n_col_)
  endif  
  n = decomp_data%matrix_data(m_)
  call psddot( n, dot_local, X, iix, ijx, lldx, Y, iiy, ijy,lldy,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 
  f90_psddot = dot_local
  return
end function f90_psddot

function f90_psddotv(x, y,decomp_data)  
  use typedesc
  real(kind(1.d0)), intent(in) :: x(:), y(:)
  type(decomp_data_type), intent(in)  :: decomp_data
  real(kind(1.D0))              :: f90_psddotv
  real(kind(1.D0))              :: dot_local
  integer  :: iix, iiy, ijx, ijy, lldx, lldy, n

 interface 
     subroutine psddot(n,dot,x,ix,jx,ldx,y,iy,jy,ldy,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       integer, intent(in) :: n,ix,jx,iy,jy,ldx,ldy
       real(kind(1.d0)), intent(in) ::  x(ldx,*),y(ldy,*)
       real(kind(1.d0)), intent(out) ::  dot
     end subroutine psddot
  end interface
   
  iix = 1
  ijx = 1
  iiy = iy
  iiy = 1
  ijy = 1
  lldx = size(x,1)
  lldy = size(y,1) 
  if (f90_func_bug) then 
    lldx = decomp_data%matrix_data(n_col_)
    lldy = decomp_data%matrix_data(n_col_)
  endif  
  n = decomp_data%matrix_data(m_)
  call psddot( n, dot_local, X, iix, ijx, lldx,  Y, iiy, ijy, lldy,& 
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem)
!!$   write(0,*) dot_local
  f90_psddotv = dot_local
  return
end function f90_psddotv


subroutine  f90_psddotvs(res,x, y,decomp_data)  
  use typedesc
  real(kind(1.d0)), intent(in) :: x(:), y(:)
  type(decomp_data_type), intent(in)  :: decomp_data
  real(kind(1.D0)), intent(out) :: res
  real(kind(1.D0)) :: dot_local
  integer  :: iix, iiy, ijx, ijy, lldx, lldy, n, k

 interface 
     subroutine psddot(n,dot,x,ix,jx,ldx,y,iy,jy,ldy,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       integer, intent(in) :: n,ix,jx,iy,jy,ldx,ldy
       real(kind(1.d0)), intent(in) ::  x(ldx,*),y(ldy,*)
       real(kind(1.d0)), intent(out) ::  dot
     end subroutine psddot
  end interface
  
  iix = 1
  ijx = 1
  iiy = 1
  ijy = 1
  lldx = size(x,1)
  lldy = size(y,1) 
  n = decomp_data%matrix_data(m_)
  call psddot( n, dot_local, X, iix, ijx, lldx,  Y, iiy, ijy, lldy,& 
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem)
!!$   write(0,*) dot_local
  res = dot_local
  return
end subroutine f90_psddotvs

SUBROUTINE  F90_PSDMDOT(RES,X, Y, DECOMP_DATA) 
  USE TYPESP
  USE TYPEDESC
  REAL(KIND(1.D0)), intent(out) :: RES(:)
  REAL(KIND(1.D0)), intent(in) :: X(:,:), Y(:,:)
  TYPE(DECOMP_DATA_TYPE), intent(in)  :: DECOMP_DATA
  integer  :: iix, iiy, ijx, ijy, lldx, lldy, n, k
  
  
  interface 
    subroutine psdmdot(m,n,dot,x,ix,jx,ldx,y,iy,jy,ldy,&
         & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
      integer, intent(in) :: matrix_data(*), halo_index(*),&
           & ovrlap_index(*), ovrlap_elem(*)
      integer, intent(in) :: m,n,ix,jx,iy,jy,ldx,ldy
      real(kind(1.d0)), intent(in) ::  x(ldx,*),y(ldy,*)
      real(kind(1.d0)), intent(out) ::  dot(*)
    end subroutine psdmdot
  end interface
  
  iix = 1
  ijx = 1
  iiy = 1
  ijy = 1
  lldx = size(x,1)
  lldy = size(y,1) 
  k    = min(size(x,2),size(y,2),size(res,1))
  n = decomp_data%matrix_data(m_)
  call psdmdot( n, k, res, X, iix, ijx, lldx,  Y, iiy, ijy, lldy,& 
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem)
  return

END SUBROUTINE F90_PSDMDOT


