function f90_psdasum(x,decomp_data, jx)  
  use typedesc
  real(kind(1.d0)), intent(in) :: x(:,:)
  type(decomp_data_type), intent(in)  :: decomp_data
  integer, intent(in),  optional :: jx
  integer ::  iix, ijx, lldx, in
  real(kind(1.D0)) :: f90_psdasum, asum_local

  interface 
     subroutine psdasum(n,alpha,x,ix,jx,ldx,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       integer, intent(in) ::  n,ix,jx,ldx
       real(kind(1.d0)), intent(in)  :: x(ldx,*)
       real(kind(1.d0)), intent(out) :: alpha
     end subroutine psdasum
  end interface

  
  iix = 1
  if (present(jx)) then
     ijx = jx
  else
     ijx = 1
  endif
  in = decomp_data%matrix_data(m_)
  lldx = size(x,1)
  if (f90_func_bug) then 
    lldx = decomp_data%matrix_data(n_col_)
  endif  
  
  call psdasum( in, asum_local, X, iix, ijx, lldx,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 
  f90_psdasum = asum_local
  return
end function f90_psdasum

function f90_psdasumv(x,decomp_data)  
  use typedesc
  real(kind(1.d0)), intent(in) :: x(:)
  type(decomp_data_type), intent(in)  :: decomp_data
  integer   :: iix, ijx, lldx, in
  real(kind(1.D0)) :: f90_psdasumv, asum_local

  interface 
     subroutine psdasum(n,alpha,x,ix,jx,ldx,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       integer, intent(in) ::  n,ix,jx,ldx
       real(kind(1.d0)), intent(in)  :: x(ldx,*)
       real(kind(1.d0)), intent(out) :: alpha
     end subroutine psdasum
  end interface
  
  iix = 1
  ijx = 1
  in = decomp_data%matrix_data(m_)
  
  lldx=size(x,1)
  if (f90_func_bug) then 
    lldx = decomp_data%matrix_data(n_col_)
  endif  
  
  call psdasum( in, asum_local, X, iix, ijx,lldx,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 
  f90_psdasumv = asum_local
  return
end function f90_psdasumv

subroutine  f90_psdasumvs(res,x,decomp_data)  
  use typedesc
  real(kind(1.d0)), intent(in) :: x(:)
  type(decomp_data_type), intent(in)  :: decomp_data
  real(kind(1.D0)), intent(out) :: res
  integer   :: iix, ijx, lldx, in
  real(kind(1.D0)) :: asum_local

  interface 
     subroutine psdasum(n,alpha,x,ix,jx,ldx,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       integer, intent(in) ::  n,ix,jx,ldx
       real(kind(1.d0)), intent(in)  :: x(ldx,*)
       real(kind(1.d0)), intent(out) :: alpha
     end subroutine psdasum
  end interface

  
  iix = 1
  ijx = 1
  in = decomp_data%matrix_data(m_)
  
  lldx=size(x,1)
  
  call psdasum( in, asum_local, X, iix, ijx,lldx,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 
  res = asum_local
  return
end subroutine f90_psdasumvs



