function f90_psdamax(x,decomp_data, jx)
  use typesp
  use typedesc
  real(kind(1.d0)), intent(in)        :: x(:,:)
  type(decomp_data_type), intent(in)  :: decomp_data
  integer, optional, intent(in)       :: jx
  integer   :: iix, ijx, lldx, in
  real(kind(1.D0)) :: f90_psdamax, amax_local

  interface 
     subroutine psdamax(n,amax,x,ix,jx,ldx,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       integer, intent(in) :: n, ix, jx, ldx
       real(kind(1.d0)), intent(in) ::  x(ldx,*)
       real(kind(1.d0)), intent(out) ::  amax
     end subroutine psdamax
  end interface

  
  iix = 1
  if (present(jx)) then
     ijx = jx
  else
     ijx = 1
  endif
  in = decomp_data%matrix_data(m_)
  lldx = size(x,1)
  if (f90_func_bug) then 
    lldx = decomp_data%matrix_data(n_col_)
  endif  
  
  call psdamax( in, amax_local, X, iix, ijx, lldx,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 

  f90_psdamax = amax_local
  return
end function f90_psdamax

function f90_psdamaxv(x,decomp_data)  
  use typesp
  use typedesc
  real(kind(1.d0)), intent(in) :: x(:)
  type(decomp_data_type), intent(in) :: decomp_data
  integer ::  iix, ijx, lldx, in
  real(kind(1.D0)) :: f90_psdamaxv, amax_local

  interface 
     subroutine psdamax(n,amax,x,ix,jx,ldx,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       integer, intent(in) :: n, ix, jx, ldx
       real(kind(1.d0)), intent(in) ::  x(*)
       real(kind(1.d0)), intent(out) ::  amax
     end subroutine psdamax
  end interface
  logical, parameter :: debug=.false.

  iix = 1
  ijx = 1
  in = decomp_data%matrix_data(m_)
  lldx = size(x,1)
  if (f90_func_bug) then 
    lldx = decomp_data%matrix_data(n_col_)
  endif

  if  (debug) write(*,*)'in F90AMAX',lldx, size(x(:))
  call psdamax( in, amax_local, X, iix, ijx, lldx,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 
  f90_psdamaxv = amax_local
  if  (debug) write(*,*)'On exit from  F90AMAX',amax_local
  return
end function f90_psdamaxv


subroutine  f90_psdamaxvs(res,x,decomp_data)  
  use typesp
  use typedesc
  real(kind(1.d0)), intent(in) :: x(:)
  type(decomp_data_type), intent(in)  :: decomp_data
  integer ::  iix, ijx, lldx, in
  real(kind(1.D0)), intent(out) :: res
  real(kind(1.D0)) :: amax_local

  interface psdamax
     subroutine psdamax(n,amax,x,ix,jx,ldx,&
	  & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
       integer, intent(in) :: matrix_data(*), halo_index(*),&
	    & ovrlap_index(*), ovrlap_elem(*)
       integer, intent(in) :: n, ix, jx, ldx
       real(kind(1.d0)), intent(in) ::  x(*)
       real(kind(1.d0)), intent(out) ::  amax
     end subroutine psdamax
  end interface

  logical, parameter :: debug=.false.


  iix = 1
  ijx = 1
  in = decomp_data%matrix_data(m_)

  lldx = size(x,1)
  if  (debug) write(*,*)'in F90AMAX',lldx, size(x(:))
  call psdamax( in, amax_local, X, iix, ijx, lldx,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 
  res = amax_local
  if  (debug) write(*,*)'On exit from  F90AMAX',amax_local
  return
end subroutine f90_psdamaxvs

subroutine  f90_psdmamax(res,x,decomp_data)  
  use typesp
  use typedesc
  real(kind(1.d0)), intent(out) :: res(:)
  real(kind(1.d0)), intent(in) :: x(:,:)
  type(decomp_data_type), intent(in)  :: decomp_data
  integer ::  iix, ijx, lldx, in
  real(kind(1.D0)) :: amax_local

  interface 
    subroutine psdmamax(n,k,amax,x,ix,jx,ldx,&
         & matrix_data,halo_index,ovrlap_index,ovrlap_elem) 
      integer, intent(in) :: matrix_data(*), halo_index(*),&
           & ovrlap_index(*), ovrlap_elem(*)
      integer, intent(in) ::  n,k,ix,jx,ldx
      real(kind(1.d0)), intent(out) :: amax(*)
      real(kind(1.d0)), intent(in)  :: x(ldx,*)
    end subroutine psdmamax
  end interface
  logical, parameter :: debug=.false.
  integer   k

  iix = 1
  ijx = 1
  in = decomp_data%matrix_data(m_)
  if  (debug) write(*,*) 'Start F90_AMAX',in,size(x,1)
  lldx = size(x,1)
  k  = min(size(x,2),size(res,1))

  if  (debug) write(*,*) 'in F90AMAX',lldx, size(x,1),k,&
       &size(x,2),size(res,1),size(res)
  call psdmamax( in, k, res, X, iix, ijx, lldx,&
       & decomp_data%matrix_data, decomp_data%halo_index,&
       & decomp_data%ovrlap_index,decomp_data%ovrlap_elem) 
  if  (debug) write(*,*) 'On exit from  F90AMAX',res(:)
  return
end subroutine f90_psdmamax

