Subroutine ZPRECONDITIONER(METHD,A,L,U,VDIAG,DECOMP_DATA,IERR)
  Use typesp
  Use typedesc
  use f90psblas
  Implicit None
  Integer, intent(in)                :: METHD
  Integer, intent(out)               :: IERR
  Type(z_spmat), intent(in)          :: A
  Type(z_spmat), intent(out)         :: L, U
  Complex(Kind(1.d0)),pointer           :: VDIAG(:)
  Type(decomp_data_type), intent(in) :: DECOMP_DATA

  Interface zcslu
     Subroutine zcslu(m,fida,descra,a,ja,ia,infoa,iperm,&
          &fidlo,descrlo,alo,jlo,ilo,lp1,lp2,infolo,larlo,lia1lo,lia2lo,&
          &fidup,descrup,aup,jup,iup,up1,up2,infoup,larup,lia1up,lia2up,&
          & fidh,descrh,h,jh,ih,hp1,hp2,infoh,lhr,lih1,lih2, &
          &diag, methd,work,lwork,ier)
      ! .. scalar arguments ..
       Integer, intent(in) :: ier, m, methd, lwork
      ! .. array arguments ..
       Complex*16, intent(in) :: a(*),h(*)
       Complex*16, intent(out) :: alo(*), aup(*), diag(*),work(*)
       Integer, intent(in)          :: ia(*), ja(*), infoa(*), infoh(*),ih(*), &
            &   jh(*), hp1(*), hp2(*),iperm(*)
       integer, intent(inout) ::  lhr,lih1,lih2, larup,&
            &   lia1up,lia2up,larlo,lia1lo,lia2lo       
       Integer, intent(out)       :: ilo(*), iup(*), jlo(*), &
            &      jup(*), infolo(*), infoup(*), lp1(*), lp2(*), up1(*), up2(*)
       Character, intent(in)        :: descra*11, fida*5, descrh*11, fidh*5
       Character, intent(out)       :: descrlo*11,descrup*11, fidlo*5,fidup*5
     End Subroutine zcslu
  End Interface


  Interface zcsrws
     SUBROUTINE  ZCSRWS(TRANS,M,N,FIDA,DESCRA,A,IA1,IA2,&
          &                INFOA,ROWSUM,IERROR)
       Integer, intent(in)        :: m,n
       Integer, intent(out)       :: ierror
       Complex*16, intent(in) :: a(*)
       Complex*16, intent(out) :: rowsum(*)
       Integer, intent(in)          :: ia1(*), ia2(*), infoa(*)
       Character, intent(in)        :: descra*11,fida*5,trans*1
     end SUBROUTINE ZCSRWS
  end Interface
       
  interface
     SUBROUTINE ZGELP(TRANS,M,N,P,B,LDB,WORK,LWORK,IERROR)
       character, intent(in) :: trans*1
       integer, intent(in)   :: m,n,ldb,lwork
       integer, intent(out)  :: ierror
       integer, intent(in)   :: p(*)
       Complex(kind(1.d0)), intent(inout) :: b(ldb,*), work(*)
     end SUBROUTINE ZGELP
  end interface
  
  ! Local scalars
  Integer      ::ier, nnzero, n_row, n_col,INFO,I,j,icontxt,&
       & me,mycol,nprow,npcol,mglob,lw
  real(kind(1.d0))         :: real_err(5)
  complex(kind(1.d0)),pointer :: gd(:), work(:)
  character*20, parameter:: rname='Preconditioner\0'
  integer :: int_err(5)
  Type(z_spmat)          :: H  
  integer  ::  lhr,lih1,lih2, larup, lia1up,lia2up,larlo,lia1lo,lia2lo
  
  logical, parameter :: debug=.false.
  integer,parameter  :: iroot=0,iout=60,ilout=40

  ier = 0
  icontxt = decomp_data%matrix_data(CTXT_)
  n_row   = decomp_data%matrix_data(n_row_)
  n_col   = decomp_data%matrix_data(n_col_)
  mglob   = decomp_data%matrix_data(m_)
  Call BLACS_GRIDINFO(ICONTXT, NPROW, NPCOL, ME, MYCOL)

  ! Next line depend on representation method
  if (METHD.GE.2) THEN
     nnzero = size(a%aspk)
     lw=1+max(n_row,n_col)
     Allocate(l%aspk(nnzero),l%ia1(nnzero),l%ia2(max(nnzero,n_row+1)),&
          & u%aspk(nnzero),u%ia1(nnzero),u%ia2(max(nnzero,n_row+1)),&
          & u%pl(n_row),u%pr(n_col),l%pl(n_row),l%pr(n_col),&
          & h%aspk(nnzero),h%ia1(nnzero),h%ia2(nnzero),h%pl(n_row),h%pr(n_col),&
          & vdiag(n_col),work(2*nnzero),STAT=INFO)
     if (info.ne.0) then
        write(0,*) 'Allocation error for preconditioner'
        call blacs_abort(icontxt,-1)
     end if
     lhr=nnzero
     lih1=nnzero
     lih2=nnzero
     larup=nnzero 
     lia1up=nnzero 
     lia2up=max(nnzero,n_row+1)
     larlo=nnzero
     lia1lo=nnzero
     lia2lo=max(nnzero,n_row+1)
     u%pl(1)=0
     u%pr(1)=0
     l%pl(1)=0
     l%pr(1)=0

     if (debug) write(0,*) 'Precond: Calling ZCSLU',&
          &decomp_data%matrix_data(N_ROW_),nnzero,a%infoa(1),a%pl(1)
     CALL zcslu(decomp_data%matrix_data(N_ROW_),&
          & a%fida, a%descra, a%aspk, a%ia1, a%ia2, a%infoa,a%pl,&
          & l%fida, l%descra, l%aspk, l%ia1, l%ia2, l%pl, l%pr,&
          & l%infoa,larlo,lia1lo,lia2lo,&
          & u%fida, u%descra, u%aspk, u%ia1, u%ia2, u%pl, u%pr, &
          & u%infoa,larup, lia1up,lia2up,&
          & h%fida, h%descra, h%aspk, h%ia1, h%ia2, h%pl, h%pr, &
          & h%infoa,lhr,lih1,lih2, &
          & vdiag, methd, work,size(work),ier)
     if (debug) write(0,*) 'Precond:  ZCSLU output',ier

     deallocate(work,h%aspk,h%ia1,h%ia2,h%pl,h%pr)

  else if (METHD.EQ.1) THEN 

     if (debug) write(0,*) 'Precond: Diagonal scaling'
      ! diagonal scaling
      
     nnzero = 1
     Allocate(vdiag(n_col),STAT=INFO)
     if (info.ne.0) then
        write(0,*) 'Allocation error for preconditioner'
        call blacs_abort(icontxt,-1)
     end if
     
     CALL  ZCSRWS('N',N_ROW,N_ROW,A%FIDA,A%DESCRA,&
          & A%ASPK,A%IA1,A%IA2,A%INFOA,VDIAG,IER)
     if (debug) write(ilout+me,*) 'VDIAG ',n_row
     do i=1,n_row
        if (real(vdiag(i)).eq.0.0d0) then
           vdiag(i)=(1.0d0,0.0d0)
        else
           vdiag(i) =  cmplx(1.0d0/(real(vdiag(i))), 0.0d0)
        endif
        
        if (debug) write(ilout+me,*) i,decomp_data%loc_to_glob(i),&
             & vdiag(i)
        if (real(vdiag(i)).lt.0.0d0) then
           write(0,*) me,'Negative RWS? ',i,vdiag(i)
        endif
     end do
     if (a%pl(1).ne.0) then
        allocate(work(n_row),stat=info)
        if (info.ne.0) then
           write(0,*) 'Allocation error for preconditioner'
           call blacs_abort(icontxt,-1)
        end if
        call  ZGELP('n',n_row,1,a%Pl,vdiag,n_col,WORK,n_row,info)
        if (info.ne.0) then
           write(0,*) 'Error for preconditioner in DGELP'
           call blacs_abort(icontxt,-1)
        end if
        deallocate(work)
     endif
     
!!$     if (debug) then
!!$       allocate(gd(mglob))       
!!$       call   F90_PSZGATHERM(gd, vdiag, DECOMP_DATA, IROOT=iroot)
!!$       
!!$       if (me.eq.iroot) then
!!$         write(iout+nprow,*) 'VDIAG CHECK ',mglob
!!$         do i=1,mglob
!!$           write(iout+nprow,*) i,gd(i)
!!$         enddo
!!$       endif
!!$       deallocate(gd)
!!$     endif
     if (debug) write(*,*) 'Preconditioner DIAG computed OK'
          
  else if (METHD.EQ.0) THEN !no preconditioning

  else 
     write(0,*) 'Preconditioner: Unknown prec',methd
     ierr = 600
  endif
  ierr=ier

  If (ier.eq.0) Then
    return
  End If
  ier=600
  ierr=ier
9999 Call PSDERROR( ICONTXT, IER, RNAME, INT_ERR, REAL_ERR )
  
End Subroutine ZPRECONDITIONER
