!!$ CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!!$ C                                                                      C
!!$ C  References:                                                         C
!!$ C          [1] Duff, I., Marrone, M., Radicati, G., and Vittoli, C.    C
!!$ C              Level 3 basic linear algebra subprograms for sparse     C
!!$ C              matrices: a user level interface                        C
!!$ C              ACM Trans. Math. Softw., 23(3), 379-401, 1997.          C
!!$ C                                                                      C
!!$ C                                                                      C
!!$ C         [2]  S. Filippone, M. Colajanni                              C
!!$ C              PSBLAS: A library for parallel linear algebra           C
!!$ C              computation on sparse matrices                          C
!!$ C              ACM Trans. on Math. Softw., 26(4), 527-550, Dec. 2000.  C
!!$ C                                                                      C
!!$ C         [3] M. Arioli, I. Duff, M. Ruiz                              C
!!$ C             Stopping criteria for iterative solvers                  C
!!$ C             SIAM J. Matrix Anal. Appl., Vol. 13, pp. 138-144, 1992   C
!!$ C                                                                      C
!!$ C                                                                      C
!!$ C         [4] R. Barrett et al                                         C
!!$ C             Templates for the solution of linear systems             C
!!$ C             SIAM, 1993                                          
!!$ C                                                                      C
!!$ C                                                                      C
!!$ CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
SUBROUTINE F90_ZCGSTAB(A,IPREC,L,U,VDIAG,B,X,EPS,DECOMP_DATA,&
     &ITMAX,ITER,ERR,IERR, ITRACE)
  USE TYPESP
  USE TYPEDESC
  USE F90PSBLAS  
  USE F90TOOLS
!!$  Parameters 
  TYPE (Z_SPMAT), intent(in)         :: A, L, U
  TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
  COMPLEX(KIND(1.D0)), intent(in)       :: VDIAG(:), B(:)
  COMPLEX(KIND(1.D0)), intent(inout)    :: X(:)
  REAL(KIND(1.D0)), intent(in)       :: EPS
  INTEGER, intent(in)                :: IPREC
  INTEGER, OPTIONAL, intent(in)      :: ITMAX, ITRACE
  INTEGER, OPTIONAL, intent(out)     :: ITER, IERR
  REAL(KIND(1.D0)), OPTIONAL, intent(out) :: ERR
!!$   Local data
  COMPLEX(KIND(1.D0)), POINTER  :: AUX(:),WWRK(:,:)
  COMPLEX(KIND(1.D0)), POINTER  :: WW(:), Q(:),&
       & R(:), P(:), V(:), S(:), T(:), Z(:), F(:)
  integer, pointer           :: IPERM(:), IPNULL(:), IPSAVE(:),IERRV(:)
  REAL(KIND(1.D0)) ::RERR
  INTEGER       ::LITMAX, LITER, NAUX, M, MGLOB, IT,INFO, ITRAC,&
       & NPROWS,NPCOLS,ME,MECOL, N_ROW, N_COL
  CHARACTER     ::DIAGL, DIAGU
  LOGICAL, PARAMETER :: UPDATE=.TRUE., NOUPDATE=.FALSE., debug = .true.
  LOGICAL, PARAMETER :: EXCHANGE=.TRUE., NOEXCHANGE=.FALSE., debug1 = .false.
  INTEGER, PARAMETER :: IONE=1
  integer, parameter :: irmax = 8
  integer            :: itx, i
  logical            :: do_renum_left
  COMPLEX(KIND(1.D0)), PARAMETER :: ONE=(1.D0,0.D0), ZERO=(0.D0,0.D0)
  REAL(KIND(1.D0)), PARAMETER :: EPSTOL=1.D-35        
  COMPLEX(KIND(1.D0)) :: ALPHA, BETA, RHO, RHO_OLD, SIGMA, OMEGA, TAU 
  REAL(KIND(1.D0)) :: RNI, XNI, BNI, ANI

  if (debug) write(0,*) 'Entering F90_ZCGSTAB'
  CALL BLACS_GRIDINFO(DECOMP_DATA%MATRIX_DATA(CTXT_),NPROWS,NPCOLS,ME&
       & ,MECOL)
  if (debug) write(0,*) 'F90_ZCGSTAB: From GRIDINFO',nprows,npcols,me

  MGLOB = DECOMP_DATA%MATRIX_DATA(M_)
  N_ROW = DECOMP_DATA%MATRIX_DATA(N_ROW_)
  N_COL = DECOMP_DATA%MATRIX_DATA(N_COL_)

 
  if ((iprec.lt.0).or.(iprec.gt.2) ) then
     write(0,*) 'F90_CGSTAB: Invalid IPREC',iprec
     if (present(ierr)) ierr=-1
     return
  endif
  NAUX=4*N_COL 
  if (debug) write(0,*) 'Parameters',mglob,n_row,n_col,naux
  ALLOCATE(AUX(NAUX),IERRV(6),STAT=INFO)
  IF (INFO.NE.0) THEN 
    write(0,*) me,'Memory allocation error!!! ',M,info
    call blacs_abort(DECOMP_DATA%MATRIX_DATA(CTXT_),-1)
    return
  end IF
  Call F90_PSDSALL(MGLOB,9,WWRK,IERRV,DECOMP_DATA)
  Call F90_PSDSASB(WWRK,IERRV,DECOMP_DATA)  
  Q => WWRK(:,1)
  R => WWRK(:,2)
  P => WWRK(:,3)
  V => WWRK(:,4)
  F => WWRK(:,5)
  S => WWRK(:,6)
  T => WWRK(:,7)
  Z => WWRK(:,8)
  WW => WWRK(:,9)


  IF (PRESENT(ITMAX)) THEN 
    LITMAX = ITMAX
  ELSE
    LITMAX = 1000
  ENDIF

  IF (PRESENT(ITRACE)) THEN
     ITRAC = ITRACE
  ELSE
     ITRAC = -1
  END IF
  if (present(ierr)) ierr=0
  
  DIAGL = 'U'
  DIAGU = 'U'
!!$  if ((iprec==2).and.(u%pr(1)/=0)) then 
!!$    DIAGU  = 'U'
!!$  else
!!$    DIAGU  = 'R'
!!$  endif
  ITX   = 0
  ANI = F90_PSNRMI(A,DECOMP_DATA)
  BNI = F90_PSAMAX(B,DECOMP_DATA)
  RESTART: DO 
!!$   
!!$   r0 = b-Ax0
!!$ 
    IF (ITX.GE.ITMAX) EXIT RESTART  
    IT = 0      
    CALL F90_PSAXPBY(ONE,B,ZERO,R,DECOMP_DATA)
    CALL F90_PSSPMM(-ONE,A,X,ONE,R,DECOMP_DATA,WORK=AUX)
    CALL F90_PSAXPBY(ONE,R,ZERO,Q,DECOMP_DATA)
    
    RHO = ZERO
    if (debug) write(*,*) 'On entry to AMAX: B: ',size(b)
    RNI = F90_PSAMAX(R,DECOMP_DATA)
    XNI = F90_PSAMAX(X,DECOMP_DATA)
    RERR =  RNI/(ANI*XNI+BNI)
    IF (RERR<=EPS) THEN 
      EXIT RESTART
    END IF
    ITERATION:  DO 
      IT   = IT + 1
      ITX = ITX + 1
      if (debug) write(*,*) 'Iteration: ',itx
      RHO_OLD = RHO    
      CALL F90_DOT(RHO,Q,R,DECOMP_DATA)
      IF (RHO==ZERO) THEN
         if (debug) WRITE(0,*) 'Bi-CGSTAB Itxation breakdown R',rho
        EXIT ITERATION
      ENDIF

      IF (IT==1) THEN
        CALL F90_PSAXPBY(ONE,R,ZERO,P,DECOMP_DATA)
      ELSE
        BETA = (RHO/RHO_OLD)*(ALPHA/OMEGA)
        CALL F90_PSAXPBY(-OMEGA,V,ONE,P,DECOMP_DATA)
        CALL F90_PSAXPBY(ONE,R,BETA,P,DECOMP_DATA)
      END IF

      IF (IPREC.EQ.0) THEN
        F(1:N_ROW) = P(1:N_ROW)
      ELSE IF (IPREC.EQ.1) THEN
        F(1:N_ROW) = P(1:N_ROW)*VDIAG(1:N_ROW)
      ELSE IF (IPREC.EQ.2) THEN
!        if (debug) write(0,*)' VDIAG: ',vdiag(:)
         IF (DEBUG) WRITE(0,*) 'Bi-CGSTAB with ILU prec' 
!         if (debug) write(0,*)' P: ',p(:)
         CALL F90_PSSPSM(ONE,L,P,ZERO,WW,DECOMP_DATA,&
              & TRANS='N',UNIT=DIAGL,CHOICE=NOUPDATE,WORK=AUX)
!         if (debug) write(0,*)' WW: ',ww(:)
         WW(1:N_ROW) = WW(1:N_ROW)*VDIAG(1:N_ROW)
!         if (debug) write(0,*)' WW2: ',ww(:)
         CALL F90_PSSPSM(ONE,U,WW,ZERO,F,DECOMP_DATA,&
              & TRANS='N',UNIT=DIAGU,CHOICE=UPDATE, WORK=AUX)
!         if (debug) write(0,*)' F: ',F(:)
      ENDIF
      CALL F90_PSSPMM(ONE,A,F,ZERO,V,DECOMP_DATA,&
           & WORK=AUX)
      CALL F90_DOT(SIGMA, Q,V,DECOMP_DATA)
      IF (SIGMA==ZERO) THEN
         if (debug) WRITE(0,*) 'Bi-CGSTAB Iteration breakdown S1', sigma
         EXIT ITERATION
      ENDIF
      
      ALPHA = RHO/SIGMA
      CALL F90_PSAXPBY(ONE,R,ZERO,S,DECOMP_DATA)
      CALL F90_PSAXPBY(-ALPHA,V,ONE,S,DECOMP_DATA)
      
      
      IF (IPREC.EQ.0) THEN
        Z(1:N_ROW) = S(1:N_ROW)
      ELSE IF (IPREC.EQ.1) THEN
        Z(1:N_ROW) = S(1:N_ROW)*VDIAG(1:N_ROW)
      ELSE IF (IPREC.EQ.2) THEN
        CALL F90_PSSPSM(ONE,L,S,ZERO,WW,DECOMP_DATA,&
             & TRANS='N',UNIT=DIAGL,CHOICE=NOUPDATE,WORK=AUX)
        WW(1:N_ROW) = WW(1:N_ROW)*VDIAG(1:N_ROW)
        CALL F90_PSSPSM(ONE,U,WW,ZERO,Z,DECOMP_DATA,&
             & TRANS='N',UNIT=DIAGU,CHOICE=UPDATE, WORK=AUX)
      ENDIF
      
      CALL F90_PSSPMM(ONE,A,Z,ZERO,T,DECOMP_DATA,&
           & WORK=AUX)
      
      
      CALL F90_DOT(SIGMA,T,T,DECOMP_DATA)
      IF (SIGMA==ZERO) THEN
         IF (DEBUG) WRITE(0,*) 'BI-CGSTAB ITERATION BREAKDOWN S2', SIGMA
!!$        WRITE(0,*) 'BI-CGSTAB ITERATION BREAKDOWN'
        EXIT ITERATION
      ENDIF
      
      CALL F90_DOT(TAU,T,S,DECOMP_DATA)
      OMEGA = TAU/SIGMA
      
      IF (OMEGA==ZERO) THEN
         IF (DEBUG) WRITE(0,*) 'BI-CGSTAB ITERATION BREAKDOWN O',OMEGA
!!$        WRITE(0,*) 'BI-CGSTAB ITERATION BREAKDOWN'
        EXIT ITERATION
      ENDIF
      
      CALL F90_PSAXPBY(ALPHA,F,ONE,X,DECOMP_DATA)
      CALL F90_PSAXPBY(OMEGA,Z,ONE,X,DECOMP_DATA)
      CALL F90_PSAXPBY(ONE,S,ZERO,R,DECOMP_DATA)
      CALL F90_PSAXPBY(-OMEGA,T,ONE,R,DECOMP_DATA)
      
      
      RNI = F90_PSAMAX(R,DECOMP_DATA)
      XNI = F90_PSAMAX(X,DECOMP_DATA)

      RERR =  RNI/(ANI*XNI+BNI)
      IF (ITRAC.NE.-1) THEN 
        IF (ME.EQ.0) WRITE(ITRAC,*) 'BiCGSTAB: ',ITX,RERR,RNI,BNI,&
             &XNI,ANI
      ENDIF
      IF (RERR<=EPS) THEN 
        EXIT RESTART
      END IF
      IF (ITX.GE.ITMAX) EXIT RESTART
    END DO ITERATION
  END DO RESTART

  IF (PRESENT(ERR)) ERR=RERR
  IF (PRESENT(ITER)) ITER = ITX
  IF (RERR>EPS) THEN
    WRITE(0,*) 'BI-CGSTAB FAILED TO CONVERGE TO ',EPS,&
         & ' IN ',ITX,' ITERATIONS  '
    IF (PRESENT(IERR)) IERR=ITX 
  END IF

  DEALLOCATE(AUX,IERRV)
  CALL F90_PSDSFREE(WWRK,DECOMP_DATA)

  RETURN
END SUBROUTINE F90_ZCGSTAB


