!!$ CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!!$ C                                                                      C
!!$ C  References:                                                         C
!!$ C          [1] Duff, I., Marrone, M., Radicati, G., and Vittoli, C.    C
!!$ C              Level 3 basic linear algebra subprograms for sparse     C
!!$ C              matrices: a user level interface                        C
!!$ C              ACM Trans. Math. Softw., 23(3), 379-401, 1997.          C
!!$ C                                                                      C
!!$ C                                                                      C
!!$ C         [2]  S. Filippone, M. Colajanni                              C
!!$ C              PSBLAS: A library for parallel linear algebra           C
!!$ C              computation on sparse matrices                          C
!!$ C              ACM Trans. on Math. Softw., 26(4), 527-550, Dec. 2000.  C
!!$ C                                                                      C
!!$ C         [3] M. Arioli, I. Duff, M. Ruiz                              C
!!$ C             Stopping criteria for iterative solvers                  C
!!$ C             SIAM J. Matrix Anal. Appl., Vol. 13, pp. 138-144, 1992   C
!!$ C                                                                      C
!!$ C                                                                      C
!!$ C         [4] R. Barrett et al                                         C
!!$ C             Templates for the solution of linear systems             C
!!$ C             SIAM, 1993                                               C
!!$ C                                                                      C
!!$ C                                                                      C
!!$ C         [5] G. Sleijpen, D. Fokkema                                  C
!!$ C             BICGSTAB(L) for linear equations involving unsymmetric   C
!!$ C             matrices with complex spectrum                           C
!!$ C             Electronic Trans. on Numer. Analysis, Vol. 1, pp. 11-32, C
!!$ C             Sep. 1993                                                C
!!$ C                                                                      C
!!$ C                                                                      C
!!$ CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
SUBROUTINE F90_DCGSTABL(A,IPREC,L,U,VDIAG,B,X,EPS,DECOMP_DATA,&
     &ITMAX,ITER,ERR,IERR, ITRACE,ML)
  USE TYPESP
  USE TYPEDESC
  USE F90PSBLAS  
  USE F90TOOLS
!!$  Parameters 
  TYPE (D_SPMAT), intent(in)         :: A, L, U
  TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
  REAL(KIND(1.D0)), intent(in)       :: VDIAG(:), B(:)
  REAL(KIND(1.D0)), intent(inout)    :: X(:)
  REAL(KIND(1.D0)), intent(in)       :: EPS
  INTEGER, intent(in)                :: IPREC
  INTEGER, OPTIONAL, intent(in)      :: ITMAX, ITRACE, ML
  INTEGER, OPTIONAL, intent(out)     :: ITER, IERR
  REAL(KIND(1.D0)), OPTIONAL, intent(out) :: ERR
!!$   Local data
  REAL(KIND(1.D0)), POINTER  :: AUX(:),WWRK(:,:)
  REAL(KIND(1.D0)), POINTER  :: WW(:), Q(:), R(:), RT0(:), P(:), V(:), &
       & S(:), T(:), Z(:), F(:), UH(:,:), RH(:,:), &
       & GAMMA(:), GAMMA1(:), GAMMA2(:), TAUM(:,:), SIGMA(:),&
       &PV1(:),  PV2(:), PM1(:,:), PM2(:,:)
  integer, pointer           :: IPERM(:), IPNULL(:), IPSAVE(:), IERRV(:)
  REAL(KIND(1.D0)) ::RERR
  INTEGER       ::LITMAX, LITER, NAUX, M, MGLOB, IT,INFO, ITRAC,&
       & NPROWS,NPCOLS,ME,MECOL, N_ROW, N_COL, NL
  CHARACTER     ::DIAGL, DIAGU
  LOGICAL, PARAMETER :: UPDATE=.TRUE., NOUPDATE=.FALSE., debug = .false.
  LOGICAL, PARAMETER :: EXCHANGE=.TRUE., NOEXCHANGE=.FALSE.  
  INTEGER, PARAMETER :: IONE=1
  integer, parameter :: irmax = 8
  integer            :: itx, i
  logical            :: do_renum_left
  REAL(KIND(1.D0)), PARAMETER :: ONE=1.D0, ZERO=0.D0, EPSTOL=1.D-35
  REAL(KIND(1.D0)) :: ALPHA, BETA, RHO, RHO_OLD, RNI, XNI, BNI, ANI,& 
       & OMEGA, TAU 

  if (debug) write(0,*) 'Entering F90_DBICGSTABL'
  CALL BLACS_GRIDINFO(DECOMP_DATA%MATRIX_DATA(CTXT_),&
       &NPROWS,NPCOLS,ME,MECOL)
  if (debug) write(0,*) 'F90_DBICGSTABL: From GRIDINFO',nprows,npcols,me

  MGLOB = DECOMP_DATA%MATRIX_DATA(M_)
  N_ROW = DECOMP_DATA%MATRIX_DATA(N_ROW_)
  N_COL = DECOMP_DATA%MATRIX_DATA(N_COL_)


  if ((iprec.lt.0).or.(iprec.gt.2) ) then
     write(0,*) 'F90_BICGSTABL: Invalid IPREC',iprec
     if (present(ierr)) ierr=-1
     return
  endif

  IF (PRESENT(ITMAX)) THEN 
    LITMAX = ITMAX
  ELSE
    LITMAX = 1000
  ENDIF

  IF (PRESENT(ITRACE)) THEN
     ITRAC = ITRACE
  ELSE
     ITRAC = -1
  END IF
  
  if (present(ml)) then
    nl = ml
    if (debug) write(0,*) 'Present: ml: ',ml,nl
  else
    nl = 1 
    if (debug) write(0,*) 'Not Present: ml: ',ml,nl
  endif

  if (present(ierr)) ierr=0


  NAUX=4*N_COL 
  ALLOCATE(AUX(NAUX),IERRV(6),GAMMA(0:NL),GAMMA1(NL),&
       &GAMMA2(NL),TAUM(NL,NL),SIGMA(NL), STAT=INFO)

  IF (INFO.NE.0) THEN 
    write(0,*) me,'Memory allocation error!!! ',N_COL,info
    call blacs_abort(DECOMP_DATA%MATRIX_DATA(CTXT_),-1)
    return
  end IF
  CALL F90_PSDSALL(MGLOB,10,WWRK,IERRV,DECOMP_DATA)
  CALL F90_PSDSALL(MGLOB,NL+1,UH,IERRV,DECOMP_DATA,JS=0)
  CALL F90_PSDSALL(MGLOB,NL+1,RH,IERRV,DECOMP_DATA,JS=0)
  Call F90_PSDSASB(WWRK,IERRV,DECOMP_DATA)  
  Call F90_PSDSASB(UH,IERRV,DECOMP_DATA)  
  Call F90_PSDSASB(RH,IERRV,DECOMP_DATA)  

  Q   => WWRK(:,1)
  R   => WWRK(:,2)
  P   => WWRK(:,3)
  V   => WWRK(:,4)
  F   => WWRK(:,5)
  S   => WWRK(:,6)
  T   => WWRK(:,7)
  Z   => WWRK(:,8)
  WW  => WWRK(:,9)
  RT0 => WWRK(:,10)
  
  
  DIAGL  = 'U'
  DIAGU  = 'U'
  ITX   = 0
  RESTART: DO 
!!$   
!!$   r0 = b-Ax0
!!$ 
    if (debug) write(0,*) 'Restart: ',itx,it
    IF (ITX.GE.ITMAX) EXIT RESTART  
    IT = 0      
    CALL F90_PSAXPBY(ONE,B,ZERO,R,DECOMP_DATA)
    CALL F90_PSSPMM(-ONE,A,X,ONE,R,DECOMP_DATA,WORK=AUX)
    IF (IPREC.EQ.0) THEN
    ELSE IF (IPREC.EQ.1) THEN
      R(1:N_ROW) = R(1:N_ROW)*VDIAG(1:N_ROW)
    ELSE IF (IPREC.EQ.2) THEN
      if (debug) WRITE(0,*) 'Bi-CGSTAB with ILU prec' 
      CALL F90_PSSPSM(ONE,L,R,ZERO,WW,DECOMP_DATA,&
           & TRANS='N',UNIT=DIAGL,CHOICE=NOUPDATE,WORK=AUX)
      WW(1:N_ROW) = WW(1:N_ROW)*VDIAG(1:N_ROW)
      CALL F90_PSSPSM(ONE,U,WW,ZERO,R,DECOMP_DATA,&
           & TRANS='N',UNIT=DIAGU,CHOICE=UPDATE, WORK=AUX)
    ENDIF

    CALL F90_PSAXPBY(ONE,R,ZERO,RT0,DECOMP_DATA)
    CALL F90_PSAXPBY(ONE,R,ZERO,RH(:,0),DECOMP_DATA)
    CALL F90_PSAXPBY(ZERO,R,ZERO,UH(:,0),DECOMP_DATA)
   
    RHO   = ONE
    ALPHA = ZERO
    OMEGA = ONE 

    if (debug) write(0,*) 'On entry to AMAX: B: ',size(b)

    ANI = F90_PSNRMI(A,DECOMP_DATA)
    BNI = F90_PSAMAX(B,DECOMP_DATA)
    RNI = F90_PSAMAX(R,DECOMP_DATA)
    XNI = F90_PSAMAX(X,DECOMP_DATA)
    RERR =  RNI/(ANI*XNI+BNI)
    IF (RERR<=EPS) THEN 
      EXIT RESTART
    END IF
     

    ITERATION:  DO 
      IT   = IT + NL
      ITX  = ITX + NL
      RHO = -OMEGA*RHO 
      if (debug) write(0,*) 'Iteration: ',itx, rho,rh(1,0)

      DO J = 0, NL -1 
        if (debug) write(0,*) 'BiCG Part:  ',J, nl
        RHO_OLD = RHO
        RHO = F90_PSDOT(RH(:,J),RT0,DECOMP_DATA)
        IF (RHO==ZERO) THEN
          if (debug) WRITE(0,*) 'Bi-CGSTAB Itxation breakdown R',rho
          EXIT ITERATION
        ENDIF
        BETA = ALPHA*RHO/RHO_OLD 
        if (debug) write(0,*) 'BiCG Part:  ',alpha,beta,rho,rho_old
        RHO_OLD = RHO
        CALL F90_PSAXPBY(ONE,RH(:,0:J),-BETA,UH(:,0:J),DECOMP_DATA)
        if (debug) write(0,*) 'BiCG Part:  ',rh(1,0),beta
        CALL F90_PSSPMM(ONE,A,UH(:,J),ZERO,UH(:,J+1),DECOMP_DATA,WORK=AUX)

        IF (IPREC.EQ.0) THEN
        ELSE IF (IPREC.EQ.1) THEN
          UH(1:N_ROW,J+1) = UH(1:N_ROW,J+1)*VDIAG(1:N_ROW)
        ELSE IF (IPREC.EQ.2) THEN
          if (debug) WRITE(0,*) 'Bi-CGSTAB with ILU prec' 
          CALL F90_PSSPSM(ONE,L,UH(:,J+1),ZERO,WW,DECOMP_DATA,&
               & TRANS='N',UNIT=DIAGL,CHOICE=NOUPDATE,WORK=AUX)
          WW(1:N_ROW) = WW(1:N_ROW)*VDIAG(1:N_ROW)
          CALL F90_PSSPSM(ONE,U,WW,ZERO,UH(:,J+1),DECOMP_DATA,&
               & TRANS='N',UNIT=DIAGU,CHOICE=UPDATE, WORK=AUX)
        ENDIF

        GAMMA(J) = F90_PSDOT(UH(:,J+1),RT0,DECOMP_DATA)
        IF (GAMMA(J)==ZERO) THEN
          if (debug) WRITE(0,*) 'Bi-CGSTAB Iteration breakdown S2',GAMMA(J)
          EXIT ITERATION
        ENDIF
        ALPHA = RHO/GAMMA(J)
        if (debug) write(0,*) 'BiCG Part: alpha=r/g ',alpha,rho,gamma(j)

        CALL F90_PSAXPBY(-ALPHA,UH(:,1:J+1),ONE,RH(:,0:J),DECOMP_DATA)        
        CALL F90_PSAXPBY(ALPHA,UH(:,0),ONE,X,DECOMP_DATA)        
        CALL F90_PSSPMM(ONE,A,RH(:,J),ZERO,RH(:,J+1),DECOMP_DATA,WORK=AUX)

        IF (IPREC.EQ.0) THEN
        ELSE IF (IPREC.EQ.1) THEN
          RH(1:N_ROW,J+1) = RH(1:N_ROW,J+1)*VDIAG(1:N_ROW)
        ELSE IF (IPREC.EQ.2) THEN
          if (debug) WRITE(0,*) 'Bi-CGSTAB with ILU prec' 
          CALL F90_PSSPSM(ONE,L,RH(:,J+1),ZERO,WW,DECOMP_DATA,&
               & TRANS='N',UNIT=DIAGL,CHOICE=NOUPDATE,WORK=AUX)
          WW(1:N_ROW) = WW(1:N_ROW)*VDIAG(1:N_ROW)
          CALL F90_PSSPSM(ONE,U,WW,ZERO,RH(:,J+1),DECOMP_DATA,&
               & TRANS='N',UNIT=DIAGU,CHOICE=UPDATE, WORK=AUX)
        ENDIF
                
      ENDDO

      
      DO J=1, NL 
        if (debug) write(0,*) 'MOD G-S Part:  ',J, nl,rh(1,0)
        DO I=1, J-1 
          TAUM(I,J) = F90_PSDOT(RH(:,I),RH(:,J),DECOMP_DATA)
          TAUM(I,J) = TAUM(I,J)/SIGMA(I) 
          CALL F90_PSAXPBY(-TAUM(I,J),RH(:,I),ONE,RH(:,J),DECOMP_DATA)        
        ENDDO        
        if (debug) write(0,*) 'MOD G-S Part:  Dot Prod '
        SIGMA(J) = F90_PSDOT(RH(:,J),RH(:,J),DECOMP_DATA)
        GAMMA1(J) = F90_PSDOT(RH(:,0),RH(:,J),DECOMP_DATA)
        if (debug) write(0,*) 'MOD G-S Part: Gamma1 ', &
             &gamma1(j), sigma(j)
        GAMMA1(J) = GAMMA1(J)/SIGMA(J)
      ENDDO
      
      GAMMA(NL) = GAMMA1(NL) 
      OMEGA     = GAMMA(NL) 

      DO J=NL-1,1,-1
        GAMMA(J) = GAMMA1(J)
        DO I=J+1,NL
          GAMMA(J) = GAMMA(J) - TAUM(J,I) * GAMMA(I) 
        ENDDO
      ENDDO
      if (debug) write(0,*) 'First Solve: ', gamma(:)
      
      DO J=1,NL-1
        GAMMA2(J) = GAMMA(J+1)
        DO I=J+1,NL-1
          GAMMA2(J) = GAMMA2(J) + TAUM(J,I) * GAMMA(I+1) 
        ENDDO
      ENDDO
      if (debug) write(0,*) 'Second Solve: ', gamma(:)
      
      CALL F90_PSAXPBY(GAMMA(1),RH(:,0),ONE,X,DECOMP_DATA)        
      CALL F90_PSAXPBY(-GAMMA1(NL),RH(:,NL),ONE,RH(:,0),DECOMP_DATA)        
      CALL F90_PSAXPBY(-GAMMA(NL),UH(:,NL),ONE,UH(:,0),DECOMP_DATA)        

      DO J=1, NL-1
        CALL F90_PSAXPBY(-GAMMA(J),UH(:,J),ONE,UH(:,0),DECOMP_DATA)        
        CALL F90_PSAXPBY(GAMMA2(J),RH(:,J),ONE,X,DECOMP_DATA)        
        CALL F90_PSAXPBY(-GAMMA1(J),RH(:,J),ONE,RH(:,0),DECOMP_DATA)        
      ENDDO
      
      RNI = F90_PSAMAX(RH(:,0),DECOMP_DATA)
      XNI = F90_PSAMAX(X,DECOMP_DATA)
      RERR =  RNI/(ANI*XNI+BNI)
      IF (ITRAC.NE.-1) THEN 
        IF (ME.EQ.0) WRITE(ITRAC,*) 'BiCGSTAB(L): ',ITX,RERR,RNI,BNI,&
             &XNI,ANI
      ENDIF
      IF (RERR<=EPS) THEN 
        EXIT RESTART
      END IF
      
      IF (ITX.GE.ITMAX) EXIT RESTART
    END DO ITERATION
  END DO RESTART

  IF (PRESENT(ERR)) ERR=RERR
  IF (PRESENT(ITER)) ITER = ITX
  IF (RERR>EPS) THEN
    WRITE(0,*) 'BI-CGSTABL FAILED TO CONVERGE TO ',EPS,&
         & ' IN ',ITX,' ITERATIONS  '
    IF (PRESENT(IERR)) IERR=ITX 
  END IF


  DEALLOCATE(AUX,IERRV)
  CALL F90_PSDSFREE(WWRK,DECOMP_DATA)
  CALL F90_PSDSFREE(UH,DECOMP_DATA)
  CALL F90_PSDSFREE(RH,DECOMP_DATA)

  RETURN
END SUBROUTINE F90_DCGSTABL


