!!$ CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!!$ C                                                                      C
!!$ C  References:                                                         C
!!$ C          [1] Duff, I., Marrone, M., Radicati, G., and Vittoli, C.    C
!!$ C              Level 3 basic linear algebra subprograms for sparse     C
!!$ C              matrices: a user level interface                        C
!!$ C              ACM Trans. Math. Softw., 23(3), 379-401, 1997.          C
!!$ C                                                                      C
!!$ C                                                                      C
!!$ C         [2]  S. Filippone, M. Colajanni                              C
!!$ C              PSBLAS: A library for parallel linear algebra           C
!!$ C              computation on sparse matrices                          C
!!$ C              ACM Trans. on Math. Softw., 26(4), 527-550, Dec. 2000.  C
!!$ C                                                                      C
!!$ C         [3] M. Arioli, I. Duff, M. Ruiz                              C
!!$ C             Stopping criteria for iterative solvers                  C
!!$ C             SIAM J. Matrix Anal. Appl., Vol. 13, pp. 138-144, 1992   C
!!$ C                                                                      C
!!$ C                                                                      C
!!$ C         [4] R. Barrett et al                                         C
!!$ C             Templates for the solution of linear systems             C
!!$ C             SIAM, 1993                                          
!!$ C                                                                      C
!!$ C                                                                      C
!!$ CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
SUBROUTINE F90_DCG(A,L,U,VDIAG,B,X,EPS,DECOMP_DATA,ITMAX,ITER,ERR&
     & ,IERR,ITRACE)
  USE TYPESP
  USE TYPEDESC
  USE F90PSBLAS
  USE F90TOOLS
!!$  Parameters 
  TYPE (D_SPMAT), intent(in)         :: A, L, U
  TYPE(DECOMP_DATA_TYPE), intent(in) :: DECOMP_DATA
  REAL(KIND(1.D0)), intent(in)       :: VDIAG(:), B(:)
  REAL(KIND(1.D0)), intent(inout)    :: X(:)
  REAL(KIND(1.D0)), intent(in)       :: EPS
  INTEGER, OPTIONAL, intent(in)      :: ITMAX, ITRACE
  INTEGER, OPTIONAL, intent(out)     :: ITER, IERR
  REAL(KIND(1.D0)), OPTIONAL, intent(out) :: ERR
!!$   Local data
  integer, pointer          :: ierrv(:)
  REAL(KIND(1.D0)), POINTER  :: AUX(:), Q(:), P(:),&
       & R(:), Z(:), W(:), WWRK(:,:)
  REAL(KIND(1.D0))    ::RERR
  REAL(KIND(1.D0))    ::ALPHA, BETA, RHO, RHO_OLD, RNI, XNI, BNI, ANI,& 
       & SIGMA
  INTEGER         :: LITMAX, LITER, LISTOP, NAUX, M, MGLOB, IT, ITRAC,&
       & NPROWS,NPCOLS,ME,MECOL, N_COL
  CHARACTER          ::DIAGL, DIAGU
  LOGICAL, PARAMETER :: UPDATE=.TRUE., NOUPDATE=.FALSE.
  LOGICAL, PARAMETER :: EXCHANGE=.TRUE., NOEXCHANGE=.FALSE.  
  INTEGER, PARAMETER :: IONE=1
  REAL(KIND(1.D0)), PARAMETER :: ONE=1.D0, ZERO=0.D0, EPSTOL=1.D-35

  
  CALL BLACS_GRIDINFO(DECOMP_DATA%MATRIX_DATA(CTXT_),NPROWS,NPCOLS,ME&
       & ,MECOL)
  
  MGLOB = DECOMP_DATA%MATRIX_DATA(M_)
  N_COL     = DECOMP_DATA%MATRIX_DATA(N_COL_)
  
  NAUX=4*N_COL
  ALLOCATE(AUX(NAUX), IERRV(6),STAT=INFO)
  Call F90_PSDSALL(MGLOB,5,WWRK,IERRV,DECOMP_DATA)
  Call F90_PSDSASB(WWRK,IERRV,DECOMP_DATA)  
  IF (INFO.NE.0) THEN 
    write(0,*) me,'Memory allocation error!!! ',N_COL,info
    call blacs_abort(DECOMP_DATA%MATRIX_DATA(CTXT_),-1)
    IF (PRESENT(IERR)) IERR=-1
    return
  end IF
  P  => WWRK(:,1)
  Q  => WWRK(:,2)
  R  => WWRK(:,3)
  Z  => WWRK(:,4) 
  W  => WWRK(:,5)
  

  IF (PRESENT(ITMAX)) THEN 
     LITMAX = ITMAX
  ELSE
     LITMAX = 1000
  ENDIF
    
  IF (PRESENT(ITRACE)) THEN
     ITRAC = ITRACE
  ELSE
     ITRAC = -1
  end IF
  IF (PRESENT(IERR)) IERR=0
    
  DIAGL  = 'U'
  DIAGU  = 'R'

!!$   
!!$    r0 = b-Ax0
!!$   
  CALL F90_PSAXPBY(ONE,B,ZERO,R,DECOMP_DATA)
  CALL F90_PSSPMM(-ONE,A,X,ONE,R,DECOMP_DATA,WORK=AUX)
  RHO = ZERO
  BNI = F90_PSAMAX(B,DECOMP_DATA)
  ANI = F90_PSNRMI(A,DECOMP_DATA)

  
  ITERATION:  DO IT = 1, ITMAX

!!$ 
!!$  Solve Mz = r
!!$  Note: the overlapped preconditioner (if overlap is non empty)
!!$  is non-symmetric:   M^{-1} = \Lambda P^T K^{-1} P  
!!$  For CG we use instead
!!$       M^{-1} = \sqrt{\Lambda} P^T K^{-1} P \sqrt{\Lambda}
!!$
     CALL F90_PSAXPBY(ONE,R,ZERO,Z,DECOMP_DATA)
     CALL F90_PSOVRL(Z,DECOMP_DATA,&
	  & UPDATE_TYPE=SQUARE_ROOT,CHOICE=NOEXCHANGE)     
     CALL F90_PSSPSM(ONE,L,Z,ZERO,W,DECOMP_DATA,&
	  & TRANS='N',UNIT=DIAGL,CHOICE=NOUPDATE,WORK=AUX)
     CALL F90_PSSPSM(ONE,U,W,ZERO,Z,DECOMP_DATA,&
  	  & TRANS='N',UNIT=DIAGU,CHOICE=NOUPDATE,DIAG=VDIAG,WORK=AUX)     
     CALL F90_PSOVRL(Z,DECOMP_DATA,&
	  & UPDATE_TYPE=SQUARE_ROOT)
     CALL F90_PSHALO(Z,DECOMP_DATA)
     RHO_OLD = RHO
     RHO     = F90_PSDOT(R,Z,DECOMP_DATA)

     IF (IT==1) THEN
	CALL F90_PSAXPBY(ONE,Z,ZERO,P,DECOMP_DATA)
     ELSE
	IF (RHO_OLD==ZERO) THEN
	   WRITE(0,*) 'CG Iteration breakdown'
	   EXIT ITERATION
	ENDIF
	BETA = RHO/RHO_OLD
	CALL F90_PSAXPBY(ONE,Z,BETA,P,DECOMP_DATA)
     END IF

     CALL F90_PSSPMM(ONE,A,P,ZERO,Q,DECOMP_DATA,WORK=AUX)
     SIGMA = F90_PSDOT(P,Q,DECOMP_DATA)
     IF (SIGMA==ZERO) THEN
	WRITE(0,*) 'CG Iteration breakdown'
	EXIT ITERATION
     ENDIF

     ALPHA = RHO/SIGMA
     CALL F90_PSAXPBY(ALPHA,P,ONE,X,DECOMP_DATA)
     CALL F90_PSAXPBY(-ALPHA,Q,ONE,R,DECOMP_DATA)

     RNI = F90_PSAMAX(R,DECOMP_DATA)
     XNI = F90_PSAMAX(X,DECOMP_DATA)

     RERR =  RNI/(ANI*XNI+BNI)
     
     IF (ITRAC.NE.-1) THEN 
        IF (ME.EQ.0) WRITE(ITRAC,*) 'CGF90: ',IT,RERR,RNI,BNI
     ENDIF
     
     IF (RERR<=EPS) THEN 
	EXIT ITERATION
     END IF
  END DO ITERATION
     
  IF (PRESENT(ERR)) ERR=RERR
  IF (PRESENT(ITER)) ITER = IT
  IF (RERR>EPS) THEN
     WRITE(0,*) 'CG Failed to converge to ',EPS,&
	  & ' in ',LITMAX,' iterations '
     IF (PRESENT(IERR)) IERR=ITX 
  END IF
  
  DEALLOCATE(AUX,IERRV)
  CALL F90_PSDSFREE(WWRK,DECOMP_DATA)

  RETURN
END SUBROUTINE F90_DCG


