/*
 * seqout.c  $Revision: 1.3 $
 *
 * This routine outputs the sequencing data needed by
 * the automatic code generation utility.
 *
 */

/*
 * The .seq format:
 *
 * <int>           ; dimension of the system
 *
 * {0|x}  {0|x} .. ; system structure
 *  ....           ; (sparsity pattern)
 *  ..
 *
 * <int> <int>
 * <int> <int>     ;  theese are <row> and <column>
 *  ..    ..       ;  orderings
 *  .     .   
 *
 * 1 3 2           ; squash element 1,3 with 1,2
 * 2 5 2           ; squash element 2,5 with 2,2
 * ...
 * .
 *
 */

#include "optimqr.h"
#include <stdio.h>
#include <assert.h>

/* The seqout() routine takes two arguments:
 * The filename in which to write the sequence and
 * ordering information, and the system for which
 * we wish to write this information.
 */
void seqout(char* fname, Tsolution* sys)
{
  FILE* file;
  int i,j;

  file = fopen(fname,"w");
  if(!file) fatal("Unable to create output sequence file!");

  /* Save system size */
  fprintf(file, "%i\n", dim1);

  /* Save sparsity Structure */
  for(i = 0; i < dim1; i++) {
    for(j = 0; j < dim2; j++) 
      fprintf(file, "%c ", matrixA->elements[i][j] ? 'x' : '0');
    fprintf(file, "\n");
  }

  /* Save row-/column orderings */
  for(i = 0; i < dim1; i++)
    fprintf(file, "%i %i\n", sys->row_ordering[i], sys->column_ordering[i]);

  /* Save Givens Rotation Sequence */
  find_sequence(sys, 1, file);

  fclose(file);
}
