/* NOTICE:
 *
 * This file is not an active part of the OptimQR software.  It was
 * used during the research that produced the OptimQR package, but
 * was discarded.
 *
 * The file is left here in order to perhaps inspire further work.
 *
 */



/*
 * relaxorder.c: $Revision: 1.3 $
 *
 * This is a row-ordering routine which uses relaxation
 * to generate some usable ordering in polynomial time.
 *
 */

#include "optimqr.h"
#include <assert.h>

#define DIAGONAL_ZERO_LIMIT (dim1/5)

int roworder(Tsolution* sys)
{
  int i;
  int perfect_ordering;
  int retries = dim1;
  int dzeros;

  /*
   * The strategy is, to go thru all the rows, seeking for
   * rows with a zero diagonal element s, but has a non-zero in 
   * column t.
   * For each of theese, we search for another row that holds
   * a non-zero in both s and t.  If such a row is found, we can
   * exchange the two rows.
   *
   * We need O(g!) operations if an average column has g nonzeros,
   * and we require all rows to have non-zero diagonal elements.
   * However, this is just going to be used for an estimate, so
   * any reasonable number of relaxations will probably do.
   *
   * It is perfectly legal behaviour from roworder() to return 
   * failure (nonzero), if we fail to create a non-zero diagonal.
   * However, if we return success (zero) the diagonal must be
   * strictly non-zero.
   */



  /* To improve the ordering ability, we should perhaps re-order
   * allready well-positioned rows, just to give new opportunities
   * for the rows still missing a non-zero diagonal element.
   */



  /* Traverse thru the rows, until we find one which has non-zero diagonal 
   * element */

  do {
    perfect_ordering = 1;
    dzeros = 0;
    for(i = sys->ordered_pairs; i < dim1; i++) {
      if(!MATRIX(sys,i,i)) {
	/* We should now traverse all rows that have a non-zero in
	 * our diagonal-element, and where we have a non-zero in their
	 * diagonal-element */
	int mended_order = 0;
	int k;
	for(k = sys->ordered_pairs; k < dim1; k++) {
	  /* do we have a non-zero in the diagonal element of
	   * the k'th row ?  (meaning, just in our k'th column)  */
	  if(MATRIX(sys,i,k)) {
	    /* Well, does this row have a non-zero in our
	     * diagonal element ?  */
	    if(MATRIX(sys,k,i)) {
	      /* Ok, the k'th row will fullfill our needs for a
	       * nonzero in the diagonal element of the i'th row,
	       * and the i'th row has a non-zero in the k'th column.
	       * Thus, if we exchange rows i and k, we have gained
	       * a non-zero diagonal element in row i, and row k is
	       * still just as happy.
	       */
	      int tmprow;
	      tmprow = sys->row_ordering[k];
	      sys->row_ordering[k] = sys->row_ordering[i];
	      sys->row_ordering[i] = tmprow;
	      mended_order = 1;
	    }
	  }
	}
	dzeros++;
	if(!mended_order) perfect_ordering = 0;
      }
    }
  } while (!perfect_ordering && retries--);

  if(dzeros > DIAGONAL_ZERO_LIMIT) return -2;

  if(perfect_ordering) return 0;
  else return -1;
}
