/*
   Authors: Florin Dobrian & Alex Pothen
   Date: July, 1998
*/

#include <iostream.h>

#include "Timer.h"

void Timer::start()
{
  beginWall = times(&beginCpu);
}

void Timer::stop()
{
  endWall = times(&endCpu);
}

float Timer::getWallTime()
{
  return (float)(endWall - beginWall) / CLK_TCK;
}

float Timer::getCpuTime()
{
  return (float)(endCpu.tms_utime - beginCpu.tms_utime) / CLK_TCK +
         (float)(endCpu.tms_stime - beginCpu.tms_stime) / CLK_TCK;
}

float Timer::getUserCpuTime()
{
  return (float)(endCpu.tms_utime - beginCpu.tms_utime) / CLK_TCK;
}

float Timer::getSystemCpuTime()
{
  return (float)(endCpu.tms_stime - beginCpu.tms_stime) / CLK_TCK;
}
