#include "Symbolic.h"

#undef __FUNC__
#define __FUNC__ "allocate"
void Symbolic::allocate(void)
{
  BEGIN_FUNCTION();

  try
  {
    frontPointer_ = new Array<int>(numberOfFronts_ + 1);
    rowIndex_ = new Array<int>(numberOfRowIndices_);
  }
  catch (...)
  {
    SET_ERROR1(MemoryAllocation);
  }

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "free"
void Symbolic::free(void)
{
  BEGIN_FUNCTION();

  delete frontPointer_;
  frontPointer_ = 0;
  delete rowIndex_;
  rowIndex_ = 0;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "Symbolic"
Symbolic::Symbolic():
  numberOfFronts_(0),
  numberOfRowIndices_(0),
  frontPointer_(0),
  rowIndex_(0)
{
  BEGIN_FUNCTION();

  allocate();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "Symbolic"
Symbolic::Symbolic(int numberOfFronts, int numberOfRowIndices):
  numberOfFronts_(numberOfFronts),
  numberOfRowIndices_(numberOfRowIndices),
  frontPointer_(0),
  rowIndex_(0)
{
  BEGIN_FUNCTION();

  allocate();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "~Symbolic"
Symbolic::~Symbolic()
{
  BEGIN_FUNCTION();

  free();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "resize"
void Symbolic::resize(int numberOfFronts, int numberOfRowIndices)
{
  BEGIN_FUNCTION();

  free();
  numberOfFronts_ = numberOfFronts;
  numberOfRowIndices_ = numberOfRowIndices;
  allocate();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "getHeapSize"
int Symbolic::getHeapSize(void) const
{
  BEGIN_FUNCTION();

  int heapSize = frontPointer_->getHeapSize() +
                 rowIndex_->getHeapSize();

  END_FUNCTION();

  return heapSize;
}

#undef __FUNC__
#define __FUNC__ "check"
bool Symbolic::check(void) const
{
  BEGIN_FUNCTION();

  END_FUNCTION();

  if (numberOfFronts_ < 0)
    return false;
  if (numberOfRowIndices_ < 0)
    return false;
  return true;
}

#undef __FUNC__
#define __FUNC__ "print"
void Symbolic::print(void) const
{
  BEGIN_FUNCTION();

  const int* frontPointerItem = frontPointer_->getItem();
  const int* rowIndexItem = rowIndex_->getItem();

  cout << "SYMBOLIC object" << endl
       << "Number of fronts: " << numberOfFronts_ << endl
       << "Number of row indices: " << numberOfRowIndices_ << endl;

  cout << "Front pointers:";
  {for (int i = 0; i <= numberOfFronts_; i++)
    cout << " " << frontPointerItem[i] + 1;}
  cout << endl;

  cout << "Row indices:";
  for (int i = 0; i < numberOfRowIndices_; i++)
    cout << " " << rowIndexItem[i] + 1;
  cout << endl;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "save"
void Symbolic::save(const char* fileName) const
{
  BEGIN_FUNCTION();

  ofstream fout(fileName);
  if (!fout)
    SET_ERROR1(FileOpen);

  int* frontPointerItem = frontPointer_->getItem();
  int* rowIndexItem = rowIndex_->getItem();

  {for (int i = 0; i <= numberOfFronts_; i++)
    fout << " " << frontPointerItem[i] + 1;}
  fout << endl;

  for (int i = 0; i < numberOfRowIndices_; i++)
    fout << " " << rowIndexItem[i] + 1;
  fout << endl;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "initialize"
void Symbolic::initialize(const SparseMatrix<double>& a,
                          const Permutation& p,
                          const EliminationForest& f)
{
  BEGIN_FUNCTION();

  if (a.getOrder() != p.getOrder())
    SET_ERROR1(InvalidInput);

  if (a.getOrder() != f.getOrder())
    SET_ERROR1(InvalidInput);

  if (numberOfFronts_ != f.getNumberOfNodes())
    SET_ERROR1(InvalidInput);

  initialize(a.getColumnPointer(), a.getRowIndex(), p, f);

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "initialize"
void Symbolic::initialize(const SparseMatrix<Complex>& a,
                          const Permutation& p,
                          const EliminationForest& f)
{
  BEGIN_FUNCTION();

  if (a.getOrder() != p.getOrder())
    SET_ERROR1(InvalidInput);

  if (a.getOrder() != f.getOrder())
    SET_ERROR1(InvalidInput);

  if (numberOfFronts_ != f.getNumberOfNodes())
    SET_ERROR1(InvalidInput);

  initialize(a.getColumnPointer(), a.getRowIndex(), p, f);

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "initialize"
void Symbolic::initialize(const Array<int>* aColumnPointer,
                          const Array<int>* aRowIndex,
                          const Permutation& p,
                          const EliminationForest& f)
{
  BEGIN_FUNCTION();

  int* frontPointerItem = frontPointer_->getItem();
  int* rowIndexItem = rowIndex_->getItem();

  const int* aColumnPointerItem = aColumnPointer->getItem();
  const int* aRowIndexItem = aRowIndex->getItem();
  const int* pNewToOldItem = p.getNewToOld()->getItem();
  const int* pOldToNewItem = p.getOldToNew()->getItem();
  const int* fFirstChildItem = f.getFirstChild()->getItem();
  const int* fNextSiblingItem = f.getNextSibling()->getItem();
  const int* fFrontPointerItem = f.getFrontPointer()->getItem();
  const int* fBorderSizeItem = f.getBorderSize()->getItem();

  /* Compute the front pointers. For every node (front): */
  frontPointerItem[0] = 0;
  {for (int u = 1; u <= f.getNumberOfNodes(); u++)
    frontPointerItem[u] = frontPointerItem[u - 1] +
                          fFrontPointerItem[u] -
                          fFrontPointerItem[u - 1] +
                          fBorderSizeItem[u - 1];}

  /* Compute the row indices. For every node (front): */
  for (int u = 0; u < f.getNumberOfNodes(); u++)
  {
    /* Pointer to one past the end of the current index list. */
    int frontEndPointer = frontPointerItem[u];

    /* Get the contribution from <u>. */
    int lj = fFrontPointerItem[u],
        aj = pNewToOldItem[lj];
    for (int ap = aColumnPointerItem[aj];
         ap < aColumnPointerItem[aj + 1];
         ap++)
    {
      int li = pOldToNewItem[aRowIndexItem[ap]];
      if (li >= lj)
      /* Select indices in the lower triangle. */
        rowIndexItem[frontEndPointer++] = li;
    }

    /* Get the contribution from the children of <u>. */
    for (int v = fFirstChildItem[u]; v != -1; v = fNextSiblingItem[v])
      for (int sp = frontPointerItem[v] +
                    fFrontPointerItem[v + 1] -
                    fFrontPointerItem[v] + 1;
           sp < frontPointerItem[v + 1];
           sp++)
      {
        int li = rowIndexItem[sp];
        if (!Find(rowIndexItem, frontPointerItem[u],
                  frontEndPointer, li))
        /* Select the indices that are already in the list. */
          rowIndexItem[frontEndPointer++] = li;
      }

    /* Sort the indices. */
    Sort(rowIndexItem, frontPointerItem[u], frontPointerItem[u + 1]);
  }

  END_FUNCTION();
}
