#include "Queue.h"

#undef __FUNC__
#define __FUNC__ "allocate"
void Queue::allocate(void)
{
  BEGIN_FUNCTION();

  try
  {
    entry_ = new Array<int>(maximumSize_);
    nextPointer_ = new Array<int>(maximumSize_);
  }
  catch (...)
  {
    SET_ERROR1(MemoryAllocation);
  }

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "free"
void Queue::free(void)
{
  BEGIN_FUNCTION();

  delete entry_;
  entry_ = 0;
  delete nextPointer_;
  nextPointer_ = 0;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "Queue"
Queue::Queue():
  maximumSize_(0),
  currentSize_(0),
  firstUsedPointer_(-1),
  lastUsedPointer_(-1),
  firstEmptyPointer_(-1),
  entry_(0),
  nextPointer_(0)
{
  BEGIN_FUNCTION();

  allocate();
  initializeNextPointer();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "Queue"
Queue::Queue(int maximumSize):
  maximumSize_(maximumSize),
  currentSize_(0),
  firstUsedPointer_(-1),
  lastUsedPointer_(-1),
  firstEmptyPointer_(0),
  entry_(0),
  nextPointer_(0)
{
  BEGIN_FUNCTION();

  allocate();
  initializeNextPointer();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "~Queue"
Queue::~Queue()
{
  BEGIN_FUNCTION();

  free();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "resize"
void Queue::resize(int maximumSize)
{
  BEGIN_FUNCTION();

  free();
  maximumSize_ = maximumSize;
  currentSize_ = 0;
  allocate();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "getHeapSize"
int Queue::getHeapSize(void) const
{
  BEGIN_FUNCTION();

  int heapSize = entry_->getHeapSize() +
                 nextPointer_->getHeapSize();

  END_FUNCTION();

  return heapSize;
}

#undef __FUNC__
#define __FUNC__ "check"
bool Queue::check(void) const
{
  BEGIN_FUNCTION();

  END_FUNCTION();

  if (maximumSize_ < 0)
    return false;
  if (currentSize_ < 0)
    return false;
  if (maximumSize_ < currentSize_)
    return false;
  return true;
}

#undef __FUNC__
#define __FUNC__ "enqueue"
void Queue::enqueue(int value)
{
  BEGIN_FUNCTION();

  if (full())
    SET_ERROR1(FullQueue);

  int* entryItem = entry_->getItem();
  int* nextPointerItem = nextPointer_->getItem();

  if (currentSize_ == 0)
    firstUsedPointer_ = lastUsedPointer_ = firstEmptyPointer_;
  else
  {
    nextPointerItem[lastUsedPointer_] = firstEmptyPointer_;
    lastUsedPointer_ = firstEmptyPointer_;
  }
  firstEmptyPointer_ = nextPointerItem[firstEmptyPointer_];
  nextPointerItem[lastUsedPointer_] = -1;

  entryItem[lastUsedPointer_] = value;

  currentSize_++;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "dequeue"
int Queue::dequeue(void)
{
  BEGIN_FUNCTION();

  if (empty())
    SET_ERROR2(EmptyQueue, -1);

  int* entryItem = entry_->getItem();
  int* nextPointerItem = nextPointer_->getItem();

  int tmp = firstUsedPointer_;
  if (currentSize_ == 1)
    firstUsedPointer_ = lastUsedPointer_ = -1;
  else
    firstUsedPointer_ = nextPointerItem[firstUsedPointer_];
  nextPointerItem[tmp] = firstEmptyPointer_;
  firstEmptyPointer_ = tmp;

  currentSize_--;

  END_FUNCTION();

  return entryItem[tmp];
}

#undef __FUNC__
#define __FUNC__ "remove"
void Queue::remove(int value)
{
  BEGIN_FUNCTION();

  int* entryItem = entry_->getItem();
  int* nextPointerItem = nextPointer_->getItem();

  int i, j;

  for (i = firstUsedPointer_, j = -1;
       i != -1;
       j = i, i = nextPointerItem[i])
    if (entryItem[i] == value)
      break;

  if (i == -1)
    return;

  if (j == -1)
  {
    if (currentSize_ == 1)
      firstUsedPointer_ = lastUsedPointer_ = -1;
    else
      firstUsedPointer_ = nextPointerItem[firstUsedPointer_];
  }
  else
  {
    nextPointerItem[j] = nextPointerItem[i];
    if (i == lastUsedPointer_)
      lastUsedPointer_ = j;
  }
  nextPointerItem[i] = firstEmptyPointer_;
  firstEmptyPointer_ = i;

  currentSize_--;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "initializeNextPointer"
void Queue::initializeNextPointer()
{
  BEGIN_FUNCTION();

  int* entryItem = entry_->getItem();
  int* nextPointerItem = nextPointer_->getItem();

  {for (int j = 0; j < maximumSize_; j++)
    entryItem[j] = -1;}
  {for (int j = 0; j < maximumSize_ - 1; j++)
    nextPointerItem[j] = j + 1;}
  nextPointerItem[maximumSize_ - 1] = -1;

  END_FUNCTION();
}
