#include "Permutation.h"

#undef __FUNC__
#define __FUNC__ "allocate"
void Permutation::allocate(void)
{
  BEGIN_FUNCTION();

  try
  {
    oldToNew_ = new Array<int>(order_);
    newToOld_ = new Array<int>(order_);
  }
  catch (...)
  {
    SET_ERROR1(MemoryAllocation);
  }

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "free"
void Permutation::free(void)
{
  BEGIN_FUNCTION();

  delete oldToNew_;
  oldToNew_ = 0;
  delete newToOld_;
  newToOld_ = 0;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "Permutation"
Permutation::Permutation():
  order_(0),
  oldToNew_(0),
  newToOld_(0)
{
  BEGIN_FUNCTION();

  allocate();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "Permutation"
Permutation::Permutation(int order):
  order_(order),
  oldToNew_(0),
  newToOld_(0)
{
  BEGIN_FUNCTION();

  allocate();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "~Permutation"
Permutation::~Permutation()
{
  BEGIN_FUNCTION();

  free();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "resize"
void Permutation::resize(int order)
{
  BEGIN_FUNCTION();

  free();
  order_ = order;
  allocate();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "getHeapSize"
int Permutation::getHeapSize(void) const
{
  BEGIN_FUNCTION();

  int heapSize = oldToNew_->getHeapSize() +
                 newToOld_->getHeapSize();

  END_FUNCTION();

  return heapSize;
}

#undef __FUNC__
#define __FUNC__ "check"
bool Permutation::check(void) const
{
  BEGIN_FUNCTION();

  END_FUNCTION();

  if (order_ < 0)
    return false;
  return true;
}

#undef __FUNC__
#define __FUNC__ "print"
void Permutation::print(void) const
{
  BEGIN_FUNCTION();

  const int* oldToNewItem = oldToNew_->getItem();
  const int* newToOldItem = newToOld_->getItem();

  cout << "PERMUTATION object" << endl
       << "Order: " << order_ << endl;

  cout << "Old to new:";
  {for (int i = 0; i < order_; i++)
    cout << " " << oldToNewItem[i] + 1;}
  cout << endl;

  cout << "New to old:";
  for (int i = 0; i < order_; i++)
    cout << " " << newToOldItem[i] + 1;
  cout << endl;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "load"
void Permutation::load(const char* fileName)
{
  BEGIN_FUNCTION();

  ifstream fin(fileName);
  if (!fin)
    SET_ERROR1(FileOpen);

  int order;
  fin >> order;
  resize(order);
  CHECK_ERROR1();

  int* oldToNewItem = oldToNew_->getItem();
  int* newToOldItem = newToOld_->getItem();

  {for (int i = 0; i < order_; i++)
  {
    fin >> oldToNewItem[i];
    oldToNewItem[i]--;
  }}

  for (int i = 0; i < order_; i++)
    newToOldItem[oldToNewItem[i]] = i;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "save"
void Permutation::save(const char* fileName) const
{
  BEGIN_FUNCTION();

  ofstream fout(fileName);
  if (!fout)
    SET_ERROR1(FileOpen);

  int* oldToNewItem = oldToNew_->getItem();

  fout << order_ << endl;

  for (int i = 0; i < order_; i++)
    fout << " " << oldToNewItem[i] + 1;
  fout << endl;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "initialize"
void Permutation::initialize(void)
{
  BEGIN_FUNCTION();

  int* oldToNewItem = oldToNew_->getItem();
  int* newToOldItem = newToOld_->getItem();

  for (int i = 0; i < order_; i++)
    newToOldItem[i] = oldToNewItem[i] = i;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "compose"
void Permutation::compose(const Permutation& p)
{
  BEGIN_FUNCTION();

  if (order_ != p.getOrder())
    SET_ERROR1(InvalidInput);

  int* oldToNewItem = oldToNew_->getItem();
  int* newToOldItem = newToOld_->getItem();

  const int* pOldToNewItem = p.getOldToNew()->getItem();

  for (int i = 0; i < order_; i++)
  {
    oldToNewItem[i] = pOldToNewItem[oldToNewItem[i]];
    newToOldItem[oldToNewItem[i]] = i;
  }

  END_FUNCTION();
}
