      subroutine rcopy(size, x, y)
      integer size
      double precision x(*), y(*)

      integer i

      do 10 i = 1, size
        y(i) = x(i)
 10   continue

      return
      end

      subroutine raxpy(size, a, x, y)
      integer size
      double precision a, x(*), y(*)

      integer i

      do 20 i = 1, size
        y(i) = y(i) + a * x(i)
 20   continue

      return
      end

      subroutine rscal1(size, a, x)
      integer size
      double precision a, x(*)

      integer i

      do 30 i = 1, size
        x(i) = a * x(i)
 30   continue

      return
      end

      subroutine rscal2(size, a, b, c, d, x1, x2)
      integer size
      double precision a, b, c, d, x1(*), x2(*)

      integer i
      double precision t1, t2

      do 40 i = 1, size
        t1 = x1(i)
        t2 = x2(i)
        x1(i) = d * t1 - b * t2
        x2(i) = a * t2 - c * t1
 40   continue

      return
      end

      subroutine rdot(size, a, x, y)
      integer size
      double precision a, x(*), y(*)

      integer i

      a = 0
      do 50 i = 1, size
        a = a + x(i) * y(i)
 50   continue

      return
      end

      subroutine ccopy(size, x, y)
      integer size
      double complex x(*), y(*)

      integer i

      do 15 i = 1, size
        y(i) = x(i)
 15   continue

      return
      end

      subroutine caxpy(size, a, x, y)
      integer size
      double complex a, x(*), y(*)

      integer i

      do 25 i = 1, size
        y(i) = y(i) + a * x(i)
 25   continue

      return
      end

      subroutine cscal1(size, a, x)
      integer size
      double complex a, x(*)

      integer i

      do 35 i = 1, size
        x(i) = a * x(i)
 35   continue

      return
      end

      subroutine cscal2(size, a, b, c, d, x1, x2)
      integer size
      double complex a, b, c, d, x1(*), x2(*)

      integer i
      double complex t1, t2

      do 45 i = 1, size
        t1 = x1(i)
        t2 = x2(i)
        x1(i) = d * t1 - b * t2
        x2(i) = a * t2 - c * t1
 45   continue

      return
      end

      subroutine cdot(size, a, x, y)
      integer size
      double complex a, x(*), y(*)

      integer i

      a = 0
      do 55 i = 1, size
        a = a + x(i) * y(i)
 55   continue

      return
      end
