#include "Forest.h"

#undef __FUNC__
#define __FUNC__ "allocate"
void Forest::allocate(void)
{
  BEGIN_FUNCTION();

  try
  {
    parent_ = new Array<int>(numberOfNodes_);
    firstChild_ = new Array<int>(numberOfNodes_);
    nextSibling_ = new Array<int>(numberOfNodes_);
  }
  catch (...)
  {
    SET_ERROR1(MemoryAllocation);
  }

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "free"
void Forest::free(void)
{
  BEGIN_FUNCTION();

  delete parent_;
  parent_ = 0;
  delete firstChild_;
  firstChild_ = 0;
  delete nextSibling_;
  nextSibling_ = 0;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "Forest"
Forest::Forest():
  numberOfNodes_(0),
  numberOfTrees_(0),
  root_(-1),
  parent_(0),
  firstChild_(0),
  nextSibling_(0)
{
  BEGIN_FUNCTION();

  allocate();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "Forest"
Forest::Forest(int numberOfNodes):
  numberOfNodes_(numberOfNodes),
  numberOfTrees_(0),
  root_(-1),
  parent_(0),
  firstChild_(0),
  nextSibling_(0)
{
  BEGIN_FUNCTION();

  allocate();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "~Forest"
Forest::~Forest()
{
  BEGIN_FUNCTION();

  free();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "resize"
void Forest::resize(int numberOfNodes)
{
  BEGIN_FUNCTION();

  free();
  numberOfNodes_ = numberOfNodes;
  allocate();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "getHeapSize"
int Forest::getHeapSize(void) const
{
  BEGIN_FUNCTION();

  int heapSize = parent_->getHeapSize() +
                 firstChild_->getHeapSize() + 
                 nextSibling_->getHeapSize();

  END_FUNCTION();

  return heapSize;
}

#undef __FUNC__
#define __FUNC__ "check"
bool Forest::check(void) const
{
  BEGIN_FUNCTION();

  END_FUNCTION();

  if (numberOfNodes_ < 0)
    return false;
  return true;
}

#undef __FUNC__
#define __FUNC__ "print"
void Forest::print(void) const
{
  BEGIN_FUNCTION();

  const int* parentItem = parent_->getItem();
  const int* firstChildItem = firstChild_->getItem();
  const int* nextSiblingItem = nextSibling_->getItem();

  cout << "FOREST object" << endl
       << "Number of nodes: " << numberOfNodes_ << endl
       << "Root: " << root_ + 1 << endl;

  cout << "Parents:";
  {for (int i = 0; i < numberOfNodes_; i++)
    cout << " " << parentItem[i] + 1;}
  cout << endl;

  cout << "First children:";
  {for (int i = 0; i < numberOfNodes_; i++)
    cout << " " << firstChildItem[i] + 1;}
  cout << endl;

  cout << "Next siblings:";
  for (int i = 0; i < numberOfNodes_; i++)
    cout << " " << nextSiblingItem[i] + 1;
  cout << endl;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "getFirstPostorderNode"
int Forest::getFirstPostorderNode(void) const
{
  BEGIN_FUNCTION();

  const int* firstChildItem = firstChild_->getItem();

  int u = root_;
  if (u != -1)
    while (firstChildItem[u] != -1)
      u = firstChildItem[u];

  END_FUNCTION();

  return u;
}

#undef __FUNC__
#define __FUNC__ "getNextPostorderNode"
int Forest::getNextPostorderNode(int node) const
{
  BEGIN_FUNCTION();

  const int* parentItem = parent_->getItem();
  const int* firstChildItem = firstChild_->getItem();
  const int* nextSiblingItem = nextSibling_->getItem();

  int u = node;
  if (nextSiblingItem[u] != -1)
  {
    u = nextSiblingItem[u];
    while (firstChildItem[u] != -1)
      u = firstChildItem[u];
  }
  else
    u = parentItem[u];

  END_FUNCTION();

  return u;
}

#undef __FUNC__
#define __FUNC__ "getFirstPreorderNode"
int Forest::getFirstPreorderNode(void) const
{
  BEGIN_FUNCTION();

  END_FUNCTION();

  return root_;
}

#undef __FUNC__
#define __FUNC__ "getNextPreorderNode"
int Forest::getNextPreorderNode(int node) const
{
  BEGIN_FUNCTION();

  const int* parentItem = parent_->getItem();
  const int* firstChildItem = firstChild_->getItem();
  const int* nextSiblingItem = nextSibling_->getItem();

  int u = node;
  if (firstChildItem[u] != -1)
    u = firstChildItem[u];
  else
  {
    while ((nextSiblingItem[u] == -1) && (parentItem[u] != -1))
      u = parentItem[u];
    u = nextSiblingItem[u];
  }

  END_FUNCTION();

  return u;
}
